/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.lib.graphics;

import com.cisco.nm.esper.lib.ObjectPool;
import com.cisco.nm.esper.lib.graphics.Polygon;
import com.cisco.nm.lib.Debug;

public class PolygonPool
implements ObjectPool {
    public static final int DEFAULT_CAPACITY = 8;
    public static final int MAX_VERTEX_COUNT = 36;
    private int vertexCount;
    private int size;
    private Polygon[] pool;
    private static PolygonPool[] _pool;

    public PolygonPool(int n) {
        if (n < 3) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Vertex count ").append(n).append(" < 3"))));
        }
        this.vertexCount = n;
        this.size = 0;
        this.pool = new Polygon[8];
    }

    public static PolygonPool getSharedInstance(int n) {
        if (n < 0 || n > 36) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("No shared pool with ").append(n).append(" vertices"))));
        }
        PolygonPool polygonPool = _pool[n];
        if (polygonPool == null) {
            polygonPool = PolygonPool._pool[n] = new PolygonPool(n);
        }
        return polygonPool;
    }

    public Object checkOut() {
        return this.checkPolygonOut();
    }

    public void checkIn(Object object) {
        this.checkPolygonIn((Polygon)object);
    }

    public Polygon checkPolygonOut() {
        Polygon polygon;
        if (this.size > 0) {
            --this.size;
            polygon = this.pool[this.size];
            this.pool[this.size] = null;
        } else {
            polygon = this.createPolygon();
        }
        if (polygon.xpoints == null || polygon.xpoints.length != this.getVertexCount()) {
            polygon.xpoints = new int[this.getVertexCount()];
            polygon.ypoints = new int[this.getVertexCount()];
        }
        polygon.npoints = this.getVertexCount();
        return polygon;
    }

    public void checkPolygonIn(Polygon polygon) {
        if (this.size >= this.pool.length) {
            Polygon[] polygonArray = new Polygon[this.size + 5];
            System.arraycopy(this.pool, 0, polygonArray, 0, this.size);
            this.pool = polygonArray;
        }
        this.pool[this.size++] = polygon;
    }

    public Polygon createPolygon() {
        Debug.println(String.valueOf(String.valueOf(new StringBuffer("Creating a new polygon(").append(this.getVertexCount()).append(")"))));
        return new Polygon();
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public static void updateBounds(Polygon polygon) {
        polygon.updateBounds();
    }

    static {
        DEFAULT_CAPACITY = 8;
        MAX_VERTEX_COUNT = 36;
        _pool = new PolygonPool[36];
    }
}

