/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.lib.graphics;

import com.cisco.nm.esper.lib.ObjectPool;
import com.cisco.nm.esper.lib.graphics.RectClip;
import com.cisco.nm.lib.Debug;

public class RectClipPool
implements ObjectPool {
    public static final RectClipPool INSTANCE = new RectClipPool();
    public static final int DEFAULT_CAPACITY = 8;
    private RectClip[] pool;
    private int size;

    public RectClipPool() {
        this(8);
    }

    public RectClipPool(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Unable to allocate a pool of capacity ".concat(String.valueOf(String.valueOf(n))));
        }
        this.pool = new RectClip[n];
        this.size = 0;
    }

    public Object checkOut() {
        return this.checkRectClipOut();
    }

    public void checkIn(Object object) {
        this.checkRectClipIn((RectClip)object);
    }

    public RectClip checkRectClipOut() {
        RectClip rectClip;
        if (this.size > 0) {
            --this.size;
            rectClip = this.pool[this.size];
            this.pool[this.size] = null;
        } else {
            rectClip = this.createRectClip();
        }
        return rectClip;
    }

    public void checkRectClipIn(RectClip rectClip) {
        if (this.size >= this.pool.length) {
            RectClip[] rectClipArray = new RectClip[this.size + 5];
            System.arraycopy(this.pool, 0, rectClipArray, 0, this.size);
            this.pool = rectClipArray;
        }
        this.pool[this.size++] = rectClip;
    }

    public RectClip createRectClip() {
        Debug.println("Creating rect clip");
        return new RectClip();
    }

    static {
        DEFAULT_CAPACITY = 8;
    }
}

