/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.lib.graphics;

import com.cisco.nm.lib.Debug;
import java.awt.BasicStroke;

public class StrokePool {
    public static final StrokePool INSTANCE = new StrokePool();
    public static final int DEFAULT_CAPACITY = 50;
    private BasicStroke[] pool;

    public StrokePool() {
        this(50);
    }

    public StrokePool(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Unable to allocate a pool of capacity ".concat(String.valueOf(String.valueOf(n))));
        }
        this.pool = new BasicStroke[n];
    }

    public BasicStroke getStroke(int n) {
        BasicStroke basicStroke;
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal stroke width: ".concat(String.valueOf(String.valueOf(n))));
        }
        if (n >= this.pool.length) {
            Debug.println(5, "Creating dynamic stroke");
            basicStroke = new BasicStroke(n);
        } else {
            basicStroke = this.pool[n];
            if (basicStroke == null) {
                basicStroke = this.pool[n] = new BasicStroke(n);
                Debug.println(5, "Creating new stroke ".concat(String.valueOf(String.valueOf(n))));
            }
        }
        return basicStroke;
    }

    static {
        DEFAULT_CAPACITY = 50;
    }
}

