/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.Bend;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.GraphSubset;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.shape.Point2D;
import com.cisco.nm.lib.algs.EmptyList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DragHelper {
    public static final int IDLE = 1;
    public static final int ACTIVE = 2;
    private int state;
    private double startX;
    private double startY;
    private List nodes = EmptyList.INSTANCE;
    private List bends = EmptyList.INSTANCE;
    private List edgeLabels = EmptyList.INSTANCE;
    private List nodeLabels = EmptyList.INSTANCE;
    private List graphs = EmptyList.INSTANCE;
    private List edges = EmptyList.INSTANCE;
    private Point2D[] graphCenter;
    private Point2D[] nodeCenter;
    private Point2D[] bendCenter;
    private Point2D[] labelCenter;
    private Graph graph;

    public DragHelper(Graph graph) {
        if (graph == null) {
            EsperStrings.illegalArgument(45);
        }
        this.state = 1;
        this.graph = graph;
    }

    protected void setState(int n) {
        this.state = n;
    }

    public int getState() {
        return this.state;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void init(GraphSubset graphSubset) {
        Object object;
        BaseObject baseObject;
        Iterator iterator;
        this.clear();
        if (graphSubset.graphs().size() > 0) {
            iterator = graphSubset.graphs().iterator();
            while (iterator.hasNext()) {
                this.unmark((Graph)iterator.next());
            }
        }
        if (graphSubset.nodes().size() > 0) {
            iterator = graphSubset.nodes().iterator();
            while (iterator.hasNext()) {
                baseObject = (Node)iterator.next();
                object = ((Node)baseObject).inedges();
                while (object.hasNext()) {
                    ((Edge)object.next()).setMarked(false);
                }
                object = ((Node)baseObject).outedges();
                while (object.hasNext()) {
                    ((Edge)object.next()).setMarked(false);
                }
            }
        }
        if (graphSubset.bends().size() > 0) {
            iterator = graphSubset.bends().iterator();
            while (iterator.hasNext()) {
                baseObject = (Bend)iterator.next();
                baseObject.setMarked(false);
                ((Bend)baseObject).getOwner().setMarked(false);
            }
        }
        if (graphSubset.edgeLabels().size() > 0) {
            iterator = graphSubset.edgeLabels().iterator();
            while (iterator.hasNext()) {
                baseObject = (EdgeLabel)iterator.next();
                ((EdgeLabel)baseObject).getOwner().setMarked(false);
            }
        }
        if (graphSubset.graphs().size() > 0) {
            this.graphs = new ArrayList(graphSubset.graphs().size());
            iterator = graphSubset.graphs().iterator();
            while (iterator.hasNext()) {
                baseObject = (Graph)iterator.next();
                this.graphs.add(baseObject);
                this.addExternal((Graph)baseObject);
            }
        }
        if (graphSubset.nodes().size() > 0) {
            this.nodes = new ArrayList(graphSubset.nodes().size());
            iterator = graphSubset.nodes().iterator();
            while (iterator.hasNext()) {
                baseObject = (Node)iterator.next();
                this.nodes.add(baseObject);
                baseObject.setMarked(true);
                object = ((Node)baseObject).outedges();
                while (object.hasNext()) {
                    Edge edge = (Edge)object.next();
                    if (edge.getTargetNode() == baseObject && edge.bends().size() > 0) {
                        if (this.bends == EmptyList.INSTANCE) {
                            this.bends = new ArrayList(20);
                        }
                        Iterator iterator2 = edge.bends().iterator();
                        while (iterator2.hasNext()) {
                            Bend bend = (Bend)iterator2.next();
                            this.bends.add(bend);
                            bend.setMarked(true);
                        }
                    }
                    this.addEdge(edge);
                }
                object = ((Node)baseObject).inedges();
                while (object.hasNext()) {
                    this.addEdge((Edge)object.next());
                }
            }
        }
        if (graphSubset.bends().size() > 0) {
            if (this.bends == EmptyList.INSTANCE) {
                this.bends = new ArrayList(graphSubset.bends().size());
            }
            iterator = graphSubset.bends().iterator();
            while (iterator.hasNext()) {
                baseObject = (Bend)iterator.next();
                if (!baseObject.isMarked()) {
                    this.bends.add(baseObject);
                }
                this.addEdge(((Bend)baseObject).getOwner());
            }
        }
        if (graphSubset.edgeLabels().size() > 0) {
            this.edgeLabels = new ArrayList(graphSubset.edgeLabels().size());
            iterator = graphSubset.edgeLabels().iterator();
            while (iterator.hasNext()) {
                baseObject = (EdgeLabel)iterator.next();
                object = ((EdgeLabel)baseObject).getOwner();
                if (object == null || ((BaseObject)object).isMarked()) continue;
                this.edgeLabels.add(baseObject);
            }
        }
    }

    private void unmark(Graph graph) {
        Iterator iterator = graph.edges(3).iterator();
        while (iterator.hasNext()) {
            ((Edge)iterator.next()).setMarked(false);
        }
        iterator = graph.graphs().iterator();
        while (iterator.hasNext()) {
            this.unmark((Graph)iterator.next());
        }
    }

    private void addExternal(Graph graph) {
        Iterator iterator = graph.edges(3).iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (!edge.isBound() || edge.getOwner().getDepth() > this.getGraph().getDepth()) continue;
            this.addEdge(edge);
        }
        iterator = graph.graphs().iterator();
        while (iterator.hasNext()) {
            this.addExternal((Graph)iterator.next());
        }
    }

    private void addEdge(Edge edge) {
        if (!edge.isMarked()) {
            if (this.edges == EmptyList.INSTANCE) {
                this.edges = new ArrayList(20);
            }
            this.edges.add(edge);
            edge.setMarked(true);
        }
    }

    public void doSnapToGrid(Transform transform) {
        if (this.getState() == 2) {
            double d;
            double d2;
            BaseObject baseObject;
            int n;
            for (n = 0; n < this.graphs.size(); ++n) {
                baseObject = (Graph)this.graphs.get(n);
                d2 = ((Graph)baseObject).getCenterX();
                d = ((Graph)baseObject).getCenterY();
                this.graphCenter[n].moveBy(transform.getNearestGridX(d2) - d2, transform.getNearestGridY(d) - d);
            }
            for (n = 0; n < this.nodes.size(); ++n) {
                baseObject = (Node)this.nodes.get(n);
                d2 = ((Node)baseObject).getIconCenterX();
                d = ((Node)baseObject).getIconCenterY();
                this.nodeCenter[n].moveBy(transform.getNearestGridX(d2) - d2, transform.getNearestGridY(d) - d);
            }
            for (n = 0; n < this.bends.size(); ++n) {
                baseObject = (Bend)this.bends.get(n);
                d2 = baseObject.getCenterX();
                d = baseObject.getCenterY();
                this.bendCenter[n].moveBy(transform.getNearestGridX(d2) - d2, transform.getNearestGridY(d) - d);
            }
            for (n = 0; n < this.edgeLabels.size(); ++n) {
                baseObject = (EdgeLabel)this.edgeLabels.get(n);
                d2 = baseObject.getCenterX();
                d = baseObject.getCenterY();
                this.labelCenter[n].moveBy(transform.getNearestGridX(d2) - d2, transform.getNearestGridY(d) - d);
            }
        }
    }

    public void onStartAt(double d, double d2) {
        if (this.getState() == 1) {
            int n;
            this.startX = d;
            this.startY = d2;
            if (this.nodes.size() > 0) {
                this.nodeCenter = new Point2D[this.nodes.size()];
                for (n = 0; n < this.nodes.size(); ++n) {
                    this.nodeCenter[n] = ((Node)this.nodes.get(n)).getIconCenter();
                }
            }
            if (this.bends.size() > 0) {
                this.bendCenter = new Point2D[this.bends.size()];
                for (n = 0; n < this.bends.size(); ++n) {
                    this.bendCenter[n] = ((Bend)this.bends.get(n)).getLocation();
                }
            }
            if (this.graphs.size() > 0) {
                this.graphCenter = new Point2D[this.graphs.size()];
                for (n = 0; n < this.graphs.size(); ++n) {
                    this.graphCenter[n] = ((Graph)this.graphs.get(n)).getCenter();
                }
            }
            if (this.edgeLabels.size() > 0) {
                this.labelCenter = new Point2D[this.edgeLabels.size()];
                for (n = 0; n < this.edgeLabels.size(); ++n) {
                    this.labelCenter[n] = ((EdgeLabel)this.edgeLabels.get(n)).getCenter();
                }
            }
            this.setState(2);
        }
    }

    public void onDragTo(double d, double d2) {
        if (this.getState() == 2) {
            Point2D point2D;
            BaseObject baseObject;
            int n;
            double d3 = d - this.startX;
            double d4 = d2 - this.startY;
            for (n = 0; n < this.graphs.size(); ++n) {
                baseObject = (Graph)this.graphs.get(n);
                point2D = this.graphCenter[n];
                ((Graph)baseObject).moveTo(point2D.getX() + d3, point2D.getY() + d4);
            }
            for (n = 0; n < this.nodes.size(); ++n) {
                baseObject = (Node)this.nodes.get(n);
                point2D = this.nodeCenter[n];
                ((Node)baseObject).moveTo(point2D.getX() + d3, point2D.getY() + d4);
            }
            for (n = 0; n < this.bends.size(); ++n) {
                baseObject = (Bend)this.bends.get(n);
                point2D = this.bendCenter[n];
                ((Bend)baseObject).moveTo(point2D.getX() + d3, point2D.getY() + d4);
            }
            for (n = 0; n < this.edgeLabels.size(); ++n) {
                baseObject = (EdgeLabel)this.edgeLabels.get(n);
                point2D = this.labelCenter[n];
                ((EdgeLabel)baseObject).moveTo(point2D.getX() + d3, point2D.getY() + d4);
            }
        }
    }

    public void onDropAt(double d, double d2) {
        if (this.getState() == 2) {
            Point2D point2D;
            BaseObject baseObject;
            int n;
            double d3 = d - this.startX;
            double d4 = d2 - this.startY;
            for (n = 0; n < this.graphs.size(); ++n) {
                baseObject = (Graph)this.graphs.get(n);
                point2D = this.graphCenter[n];
                ((Graph)baseObject).setCenter(point2D.getX() + d3, point2D.getY() + d4);
            }
            for (n = 0; n < this.nodes.size(); ++n) {
                baseObject = (Node)this.nodes.get(n);
                point2D = this.nodeCenter[n];
                ((Node)baseObject).setIconCenter(point2D.getX() + d3, point2D.getY() + d4);
            }
            for (n = 0; n < this.bends.size(); ++n) {
                baseObject = (Bend)this.bends.get(n);
                point2D = this.bendCenter[n];
                ((Bend)baseObject).setCenter(point2D.getX() + d3, point2D.getY() + d4);
            }
            for (n = 0; n < this.edgeLabels.size(); ++n) {
                baseObject = (EdgeLabel)this.edgeLabels.get(n);
                point2D = this.labelCenter[n];
                ((EdgeLabel)baseObject).setCenter(point2D.getX() + d3, point2D.getY() + d4);
            }
        }
    }

    public void onCancel() {
        if (this.getState() == 2) {
            this.onDragTo(this.startX, this.startY);
        }
    }

    public void clear() {
        this.nodes.clear();
        this.edges.clear();
        this.bends.clear();
        this.edgeLabels.clear();
        this.nodeLabels.clear();
        this.graphs.clear();
        this.nodeLabels = this.graphs = EmptyList.INSTANCE;
        this.edgeLabels = this.graphs;
        this.bends = this.graphs;
        this.edges = this.graphs;
        this.nodes = this.graphs;
        this.labelCenter = null;
        this.bendCenter = null;
        this.graphCenter = null;
        this.nodeCenter = null;
        this.state = 1;
    }

    public Iterator nodes() {
        return this.nodes.iterator();
    }

    public Iterator edges() {
        return this.edges.iterator();
    }

    public Iterator nodeLabels() {
        return this.nodeLabels.iterator();
    }

    public Iterator edgeLabels() {
        return this.edgeLabels.iterator();
    }

    public Iterator graphs() {
        return this.graphs.iterator();
    }

    static {
        IDLE = 1;
        ACTIVE = 2;
    }
}

