/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.event.ObjectChangeManager;
import com.cisco.nm.esper.shape.FixedBounds;

public abstract class GraphObject
extends BaseObject {
    private int searchID;
    private int index;
    private String name;
    private Graph owner;
    private Object usrObj;

    public GraphObject() {
        this((String)null);
    }

    public GraphObject(String string) {
        this.name = string;
    }

    public Object getUserObject() {
        return this.usrObj;
    }

    public void setUserObject(Object object) {
        this.usrObj = object;
    }

    public String getName() {
        return this.getText();
    }

    public void setName(String string) {
        if (!BaseObject.equal(this.name, string)) {
            this.firePropertyChanging("name");
            this.setText(string);
            this.firePropertyChanged("name");
        }
    }

    public String getText() {
        return this.name;
    }

    public void setText(String string) {
        if (!BaseObject.equal(this.name, string)) {
            this.firePropertyChanging("text");
            this.name = string;
            this.firePropertyChanged("text");
        }
    }

    public int getSearchID() {
        return this.searchID;
    }

    public void setSearchID(int n) {
        this.searchID = n;
    }

    public int getIndex() {
        return this.index;
    }

    protected void setIndex(int n) {
        this.index = n;
    }

    public Graph getOwner() {
        return this.owner;
    }

    protected void setOwner(Graph graph) {
        if (this.owner != graph) {
            this.owner = graph;
        }
    }

    public BaseObject getContainer() {
        return this.getOwner();
    }

    protected void onInsert(Graph graph) {
        this.setOwner(graph);
        this.setOwned(true);
    }

    protected void onRemove(Graph graph) {
        if (graph == null || graph != this.owner) {
            EsperStrings.illegalArgument(43);
        }
        this.setOwned(false);
        this.setOwner(null);
    }

    protected void onChildBoundsLost(FixedBounds fixedBounds) {
        if (this.getContactSides(fixedBounds) != 0) {
            this.updateBounds();
        }
    }

    protected void onChildBoundsGained(FixedBounds fixedBounds) {
        double d = Math.min(this.getLeft(), fixedBounds.getLeft());
        double d2 = Math.max(this.getRight(), fixedBounds.getRight());
        double d3 = Math.min(this.getBottom(), fixedBounds.getBottom());
        double d4 = Math.max(this.getTop(), fixedBounds.getTop());
        this.setBounds(d, d3, d2, d4);
    }

    protected void onChildBoundsAltered(int n, FixedBounds fixedBounds) {
        if (n != 0) {
            this.updateBounds();
        } else {
            this.onChildBoundsGained(fixedBounds);
        }
    }

    protected void setBounds(double d, double d2, double d3, double d4) {
        if (d != this.getLeft() || d3 != this.getRight() || d2 != this.getBottom() || d4 != this.getTop()) {
            this.firePropertyChanging("bounds");
            if (!this.isOwned()) {
                this.reshape(d, d2, d3, d4);
            } else {
                int n = this.getOwner().getContactSides(this);
                this.reshape(d, d2, d3, d4);
                this.getOwner().onChildBoundsAltered(n, this);
            }
            this.firePropertyChanged("bounds");
        }
    }

    public ObjectChangeManager getObjectChangeManager() {
        return this.isOwned() ? this.getOwner().getObjectChangeManager() : null;
    }

    public Object clone() {
        GraphObject graphObject = (GraphObject)super.clone();
        graphObject.index = -1;
        graphObject.usrObj = null;
        graphObject.owner = null;
        this.setUtilityObject(graphObject);
        return graphObject;
    }
}

