/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.BaseObjectPainter;
import com.cisco.nm.esper.model.GraphMember;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.TextDecoration;
import com.cisco.nm.esper.model.event.ObjectChangeManager;
import com.cisco.nm.esper.model.palette.LabelPalette;
import com.cisco.nm.esper.model.palette.NodeLabelPalette;
import com.cisco.nm.esper.model.palette.Palette;
import com.cisco.nm.esper.shape.FixedPoint2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;

public class NodeLabel
extends TextDecoration {
    public static final int CENTER = 0;
    public static final int NORTH = -1;
    public static final int SOUTH = 1;
    private int location;
    private double xOff;
    private double yOff;
    private Node owner;
    private LabelPalette palette;
    private static Map resources;

    public NodeLabel() {
        this((String)null);
    }

    public NodeLabel(String string) {
        super(string);
        if (this.getWidth() == 0.0 && this.getHeight() == 0.0) {
            this.resize(30.0, 15.0);
        }
    }

    public static Object getClassResource(String string) {
        if (resources == null) {
            return null;
        }
        return resources.get(string);
    }

    public static Object putClassResource(String string, Object object) {
        if (object == null) {
            if (resources == null) {
                return null;
            }
            return resources.remove(string);
        }
        if (resources == null) {
            resources = new HashMap(17, 0.85f);
        }
        return resources.put(string, object);
    }

    public static boolean hasClassResource(String string) {
        return resources != null && resources.containsKey(string);
    }

    public Object getResource(String string) {
        String string2 = String.valueOf(String.valueOf(this.hashCode())).concat(String.valueOf(String.valueOf(string)));
        if (NodeLabel.hasClassResource(string2)) {
            return NodeLabel.getClassResource(string2);
        }
        return NodeLabel.getClassResource(string);
    }

    public Object putResource(String string, Object object) {
        return NodeLabel.putClassResource(String.valueOf(String.valueOf(this.hashCode())).concat(String.valueOf(String.valueOf(string))), object);
    }

    public boolean hasResource(String string) {
        return NodeLabel.hasClassResource(string) || NodeLabel.hasClassResource(String.valueOf(String.valueOf(this.hashCode())).concat(String.valueOf(String.valueOf(string))));
    }

    public Node getOwner() {
        return this.owner;
    }

    public BaseObject getContainer() {
        return this.getOwner();
    }

    protected void setOwner(Node node) {
        if (this.owner != node) {
            this.firePropertyChanging("owner");
            this.owner = node;
            this.firePropertyChanged("owner");
        }
    }

    public GraphMember.Type getType() {
        return GraphMember.NODE_LABEL;
    }

    public final int getClassCode() {
        return 32;
    }

    public LabelPalette getLabelPalette() {
        return this.palette == null ? NodeLabelPalette.INSTANCE : this.palette;
    }

    public void setLabelPalette(LabelPalette labelPalette) {
        this.firePropertyChanging("palette");
        this.palette = labelPalette;
        this.getPainter().init(this);
        this.firePropertyChanged("palette");
    }

    public boolean isPaletteSet() {
        return this.palette != null;
    }

    public Palette getPalette() {
        return this.getLabelPalette();
    }

    public void setPalette(Palette palette) {
        this.setLabelPalette((LabelPalette)palette);
    }

    public Color getStrokeColor() {
        if (this.isDragged()) {
            return this.getLabelPalette().getGhostedStrokeColor();
        }
        if (this.isSelected()) {
            return this.getLabelPalette().getSelectedStrokeColor();
        }
        return this.getLabelPalette().getPlainStrokeColor();
    }

    public Color getFillColor() {
        if (this.isSelected()) {
            return this.getLabelPalette().getSelectedFillColor();
        }
        return this.getLabelPalette().getPlainFillColor();
    }

    public Color getTextColor() {
        if (this.isSelected()) {
            return this.getLabelPalette().getSelectedTextColor();
        }
        return this.getLabelPalette().getPlainTextColor();
    }

    public Font getFont() {
        return this.getLabelPalette().getFont();
    }

    public Insets getInsets() {
        return this.getLabelPalette().getInsets();
    }

    public int getTextAlignment() {
        return this.getLabelPalette().getTextAlignment();
    }

    public boolean isStroked() {
        return this.getLabelPalette().isStroked();
    }

    public boolean isFilled() {
        return this.getLabelPalette().isFilled();
    }

    public int getStrokeWidth() {
        return this.getLabelPalette().getStrokeWidth();
    }

    public ObjectChangeManager getObjectChangeManager() {
        return this.isOwned() ? this.getOwner().getObjectChangeManager() : null;
    }

    public int getLocation() {
        return this.location;
    }

    public double getOffsetX() {
        return this.xOff;
    }

    public double getOffsetY() {
        return this.yOff;
    }

    public void setLocation(int n) {
        this.check(n);
        if (n != this.location) {
            this.firePropertyChanging("location");
            this.location = n;
            if (this.isOwned()) {
                int n2 = this.getOwner().getContactSides(this);
                this.correctBounds();
                this.getOwner().onChildBoundsAltered(n2, this);
            }
            this.firePropertyChanged("location");
        }
    }

    public void setOffsetX(double d) {
        double d2 = d - this.xOff;
        if (d2 != 0.0) {
            this.firePropertyChanging("offsetX");
            this.xOff = d;
            if (!this.isOwned()) {
                this.translate(d2, 0.0);
            } else {
                int n = this.getOwner().getContactSides(this);
                this.translate(d2, 0.0);
                this.getOwner().onChildBoundsAltered(n, this);
            }
            this.firePropertyChanged("offsetX");
        }
    }

    public void setOffsetY(double d) {
        double d2 = d - this.yOff;
        if (d2 != 0.0) {
            this.firePropertyChanging("offsetY");
            this.yOff = d;
            if (!this.isOwned()) {
                this.translate(0.0, d2);
            } else {
                int n = this.getOwner().getContactSides(this);
                this.translate(0.0, d2);
                this.getOwner().onChildBoundsAltered(n, this);
            }
            this.firePropertyChanged("offsetY");
        }
    }

    public void setSize(double d, double d2) {
        if (d != this.getWidth() || d2 != this.getHeight()) {
            if (!this.isOwned()) {
                this.resize(d, d2);
            } else {
                int n = this.getOwner().getContactSides(this);
                this.resize(d, d2);
                if (this.getLocation() == -1) {
                    this.translate(0.0, (d2 - this.getHeight()) / 2.0);
                } else if (this.getLocation() == 1) {
                    this.translate(0.0, (this.getHeight() - d2) / 2.0);
                }
                this.getOwner().onChildBoundsAltered(n, this);
            }
        }
    }

    public void setCenter(FixedPoint2D fixedPoint2D) {
        this.setCenter(fixedPoint2D.getX(), fixedPoint2D.getY());
    }

    public void setCenter(double d, double d2) {
        if (d != this.getCenterX() || d2 != this.getCenterY()) {
            if (!this.isOwned()) {
                this.moveTo(d, d2);
            } else {
                int n = this.getOwner().getContactSides(this);
                this.moveTo(d, d2);
                this.getOwner().onChildBoundsAltered(n, this);
            }
        }
    }

    protected void moveTo(double d, double d2) {
        if (d != this.getCenterX() || d2 != this.getCenterY()) {
            double d3;
            double d4;
            if (this.isOwned()) {
                d4 = this.getOwner().getIconHeight() / 3.0;
                d3 = this.getOwner().getIconCenterY();
                this.location = d2 > d3 + d4 ? -1 : (d2 < d3 - d4 ? 1 : 0);
            }
            this.placeAt(d, d2);
            if (this.isOwned()) {
                d4 = this.getOwner().getIconCenterX();
                d3 = this.location == -1 ? this.getOwner().getIconTop() + this.getHeight() / 2.0 : (this.location == 1 ? this.getOwner().getIconBottom() - this.getHeight() / 2.0 : this.getOwner().getIconCenterY());
                this.xOff = d - d4;
                this.yOff = d2 - d3;
            }
        }
    }

    public void updateBounds() {
        if (this.isOwned()) {
            int n = this.owner.getContactSides(this);
            if (this.correctBounds(true)) {
                this.owner.onChildBoundsAltered(n, this);
            }
        }
    }

    protected boolean correctBounds() {
        return this.correctBounds(false);
    }

    protected boolean correctBounds(boolean bl) {
        if (!this.isOwned()) {
            return false;
        }
        double d = this.getOwner().getIconCenterX();
        double d2 = this.getLocation() == -1 ? this.getOwner().getIconTop() + this.getHeight() / 2.0 : (this.getLocation() == 1 ? this.getOwner().getIconBottom() - this.getHeight() / 2.0 : this.getOwner().getIconCenterY());
        if ((d += this.getOffsetX()) == this.getCenterX() && (d2 += this.getOffsetY()) == this.getCenterY()) {
            return false;
        }
        if (bl) {
            this.firePropertyChanging("bounds");
        }
        this.placeAt(d, d2);
        if (bl) {
            this.firePropertyChanged("bounds");
        }
        return true;
    }

    protected void onInsert(Node node) {
        this.setOwner(node);
        this.setOwned(true);
    }

    protected void onRemove(Node node) {
        this.setOwned(false);
        this.setOwner(null);
    }

    public Object clone() {
        NodeLabel nodeLabel = (NodeLabel)super.clone();
        nodeLabel.owner = null;
        return nodeLabel;
    }

    public String toString() {
        return this.getText() != null ? this.getText() : String.valueOf(String.valueOf(EsperStrings.string(57))).concat(String.valueOf(String.valueOf(this.hashCode())));
    }

    private void check(int n) {
        if (n != 0 && n != -1 && n != 1) {
            EsperStrings.illegalArgument(46);
        }
    }

    public void setLabelPainter(BaseObjectPainter baseObjectPainter) {
        this.setPainter(baseObjectPainter);
    }

    static {
        CENTER = 0;
        NORTH = -1;
        SOUTH = 1;
    }
}

