/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model;

import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.Decoration;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.StringTokenizer;

public abstract class TextDecoration
extends Decoration {
    private String text;
    private String[] fragment;
    private TextMetrics metrics;

    public TextDecoration() {
        this("");
    }

    public TextDecoration(String string) {
        this.setText(string);
    }

    public String getText() {
        return this.text;
    }

    public String getFragment(int n) {
        return this.fragment[n];
    }

    public int getFragmentCount() {
        return this.fragment == null ? 0 : this.fragment.length;
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        if (!BaseObject.equal(this.text, string)) {
            this.firePropertyChanging("text");
            this.text = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            this.fragment = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.fragment[n++] = stringTokenizer.nextToken();
            }
            this.metrics = null;
            this.getPainter().init(this);
            this.firePropertyChanged("text");
        }
    }

    public TextMetrics getTextMetrics() {
        return this.metrics;
    }

    public void updateTextMetrics(FontMetrics fontMetrics, double d) {
        boolean bl = false;
        if (this.metrics == null) {
            bl = fontMetrics != null;
        } else if (fontMetrics == null) {
            bl = true;
        } else {
            boolean bl2 = bl = this.metrics.size != fontMetrics.getFont().getSize();
        }
        if (bl) {
            int n;
            TextMetrics textMetrics;
            if (fontMetrics != null) {
                textMetrics = new TextMetrics(this, fontMetrics);
            } else {
                int n2;
                float f = (float)((double)this.getFont().getSize() * d);
                float f2 = (float)((double)f * d);
                LineMetrics[] lineMetricsArray = new LineMetrics[this.getFragmentCount()];
                int n3 = 0;
                for (n2 = 0; n2 < lineMetricsArray.length; ++n2) {
                    lineMetricsArray[n2] = new LineMetrics(Math.round((float)this.getFragment(n2).length() * f2));
                    n3 = Math.max(n3, lineMetricsArray[n2].width);
                }
                n2 = (int)((double)f * d * (double)lineMetricsArray.length);
                n = (int)f;
                textMetrics = new TextMetrics(n, 1, n2, n3, n, lineMetricsArray);
            }
            boolean bl3 = this.isOwned();
            double d2 = Math.ceil((double)textMetrics.width / d);
            double d3 = Math.ceil((double)textMetrics.height / d);
            if (this.metrics != null) {
                d2 = Math.max(this.getWidth(), d2);
                d3 = Math.max(this.getHeight(), d3);
            }
            int n4 = n = d2 != this.getWidth() || d3 != this.getHeight() ? 1 : 0;
            if (n != 0 && bl3) {
                this.firePropertyChanging("bounds");
            }
            this.metrics = textMetrics;
            if (n != 0) {
                this.resize(d2, d3);
                this.correctBounds();
            }
            if (bl3) {
                this.firePropertyChanged("bounds");
            }
        }
    }

    public abstract void setSize(double var1, double var3);

    public abstract Font getFont();

    protected abstract boolean correctBounds();

    public void init(BaseObject baseObject) {
        TextDecoration textDecoration = (TextDecoration)baseObject;
        textDecoration.updateTextMetrics(Toolkit.getDefaultToolkit().getFontMetrics(textDecoration.getFont()), 1.0);
    }

    public static class TextMetrics {
        public final int size;
        public final int advance;
        public final int ascent;
        public final int width;
        public final int height;
        public final LineMetrics[] line;

        public TextMetrics(TextDecoration textDecoration, FontMetrics fontMetrics) {
            int n = 0;
            this.line = new LineMetrics[textDecoration.getFragmentCount()];
            for (int i = 0; i < textDecoration.getFragmentCount(); ++i) {
                LineMetrics lineMetrics = new LineMetrics(fontMetrics.stringWidth(textDecoration.getFragment(i)));
                n = Math.max(n, lineMetrics.width);
                this.line[i] = lineMetrics;
            }
            this.ascent = fontMetrics.getMaxAscent();
            this.advance = fontMetrics.getHeight();
            this.height = fontMetrics.getHeight() * this.line.length;
            this.width = n;
            this.size = fontMetrics.getFont().getSize();
        }

        public TextMetrics(int n, int n2, int n3, int n4, int n5, LineMetrics[] lineMetricsArray) {
            this.ascent = n;
            this.advance = n2;
            this.height = n3;
            this.width = n4;
            this.size = n5;
            this.line = lineMetricsArray;
        }
    }

    public static class LineMetrics {
        public final int width;

        public LineMetrics(int n) {
            this.width = n;
        }
    }
}

