/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.event;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.model.event.ObjectChangeListener;
import java.util.AbstractCollection;
import java.util.ArrayList;

public class ObjectChangeManager
implements Cloneable {
    private ArrayList listeners;

    public void addObjectChangeListener(ObjectChangeListener objectChangeListener) {
        if (objectChangeListener != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList(5);
            }
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.add(objectChangeListener);
            }
        }
    }

    public void removeObjectChangeListener(ObjectChangeListener objectChangeListener) {
        if (objectChangeListener != null && this.listeners != null && this.listeners.size() > 0) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                ((AbstractCollection)this.listeners).remove(objectChangeListener);
            }
        }
    }

    public int getObjectChangeListenerCount() {
        return this.listeners == null ? 0 : this.listeners.size();
    }

    public void firePropertyChanging(Object object, String string) {
        if (this.getObjectChangeListenerCount() > 0) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ObjectChangeListener)this.listeners.get(i)).propertyChanging(object, string);
                }
            }
        }
    }

    public void firePropertyChanged(Object object, String string) {
        if (this.getObjectChangeListenerCount() > 0) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ObjectChangeListener)this.listeners.get(i)).propertyChanged(object, string);
                }
            }
        }
    }

    public void fireChildInserting(Object object, Object object2) {
        if (this.getObjectChangeListenerCount() > 0) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ObjectChangeListener)this.listeners.get(i)).childInserting(object, object2);
                }
            }
        }
    }

    public void fireChildInserted(Object object, Object object2) {
        if (this.getObjectChangeListenerCount() > 0) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ObjectChangeListener)this.listeners.get(i)).childInserted(object, object2);
                }
            }
        }
    }

    public void fireChildRemoving(Object object, Object object2) {
        if (this.getObjectChangeListenerCount() > 0) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ObjectChangeListener)this.listeners.get(i)).childRemoving(object, object2);
                }
            }
        }
    }

    public void fireChildRemoved(Object object, Object object2) {
        if (this.getObjectChangeListenerCount() > 0) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ObjectChangeListener)this.listeners.get(i)).childRemoved(object, object2);
                }
            }
        }
    }

    public Object clone() {
        try {
            ObjectChangeManager objectChangeManager = (ObjectChangeManager)super.clone();
            if (this.listeners != null) {
                objectChangeManager.listeners = (ArrayList)this.listeners.clone();
            }
            ObjectChangeManager objectChangeManager2 = objectChangeManager;
            return objectChangeManager2;
        }
        catch (Exception exception) {
            throw new InternalError(EsperStrings.string(6, exception.getMessage()));
        }
    }
}

