/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.io;

import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.io.GraphOutputStream;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;

public class GraphSelection
implements Transferable,
ClipboardOwner {
    public static final DataFlavor GRAPH_FLAVOR = new DataFlavor(class$com$cisco$nm$esper$model$Graph == null ? (class$com$cisco$nm$esper$model$Graph = GraphSelection.class$("com.cisco.nm.esper.model.Graph")) : class$com$cisco$nm$esper$model$Graph, "Graph");
    public static final DataFlavor STRING_FLAVOR = DataFlavor.stringFlavor;
    public static final DataFlavor XML_FLAVOR = new DataFlavor("text/xml; charset=unicode; class=java.io.Reader", "XML");
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{STRING_FLAVOR, XML_FLAVOR, GRAPH_FLAVOR};
    private Graph graph;
    private String xml;
    static Class class$com$cisco$nm$esper$model$Graph;

    public GraphSelection(Graph graph) {
        this.graph = graph;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])FLAVORS.clone();
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < FLAVORS.length; ++i) {
            if (!FLAVORS[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
        if (GRAPH_FLAVOR.equals(dataFlavor)) {
            return this.graph;
        }
        if (STRING_FLAVOR.equals(dataFlavor)) {
            if (this.xml == null) {
                this.xml = GraphSelection.toString(this.graph);
            }
            return this.xml;
        }
        if (XML_FLAVOR.equals(dataFlavor)) {
            if (this.xml == null) {
                this.xml = GraphSelection.toString(this.graph);
            }
            return new StringReader(this.xml);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    private static String toString(Graph graph) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GraphOutputStream graphOutputStream = new GraphOutputStream(byteArrayOutputStream);
            graphOutputStream.writeGraph(graph);
            graphOutputStream.close();
            String string = byteArrayOutputStream.toString();
            return string;
        }
        catch (IOException iOException) {
            throw new InternalError("IO Exception ".concat(String.valueOf(String.valueOf(iOException.getMessage()))));
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

