/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.palette;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.lib.IDManager;

public abstract class Palette
implements Cloneable {
    public static final int MIN_PRIORITY = 0;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private String _name;
    private int uniqID;
    private int priority;

    public Palette() {
        this(null);
    }

    public Palette(String string) {
        this.setName(string);
        this.uniqID = IDManager.INSTANCE.nextID();
        this.priority = 5;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public int getObjectID() {
        return this.uniqID;
    }

    protected void setObjectID(int n) {
        this.uniqID = n;
    }

    public void setPriority(int n) {
        this.priority = Math.min(Math.max(0, n), 10);
    }

    public int getPriority() {
        return this.priority;
    }

    public Object clone() {
        try {
            Palette palette = (Palette)super.clone();
            palette.uniqID = IDManager.INSTANCE.nextID();
            Palette palette2 = palette;
            return palette2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(EsperStrings.string(6, cloneNotSupportedException.getMessage()));
        }
    }

    public int hashCode() {
        return this.getObjectID();
    }

    static {
        MIN_PRIORITY = 0;
        NORM_PRIORITY = 5;
        MAX_PRIORITY = 10;
    }
}

