/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.ui;

import com.cisco.nm.esper.lib.graphics.RectPool;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.ui.AbstractObjectPainter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;

public abstract class AbstractEdgeLabelPainter
extends AbstractObjectPainter {
    public void paint(Graphics graphics, EdgeLabel edgeLabel, Transform transform) {
        if (edgeLabel != null) {
            if (edgeLabel.isDragged()) {
                this.paintOutline(graphics, edgeLabel, transform);
            } else {
                this.paintDetail((Graphics2D)graphics, edgeLabel, transform);
            }
        }
    }

    protected abstract void paintOutline(Graphics var1, EdgeLabel var2, Transform var3);

    protected abstract void paintDetail(Graphics2D var1, EdgeLabel var2, Transform var3);

    public boolean intersects(EdgeLabel edgeLabel, Rectangle rectangle, Transform transform) {
        boolean bl = false;
        if (rectangle != null && rectangle.width > 0 && rectangle.height > 0) {
            Rectangle rectangle2 = this.getBounds(edgeLabel, transform, RectPool.INSTANCE.checkRectOut());
            bl = rectangle2.x <= rectangle.x + rectangle.width && rectangle2.x + rectangle2.width >= rectangle.x && rectangle2.y <= rectangle.y + rectangle.height && rectangle2.y + rectangle2.height >= rectangle.y;
            RectPool.INSTANCE.checkRectIn(rectangle2);
        }
        return bl;
    }

    public int getHitCode(EdgeLabel edgeLabel, int n, int n2, Transform transform) {
        Rectangle rectangle = RectPool.INSTANCE.checkRectOut();
        this.getBounds(edgeLabel, transform, rectangle);
        int n3 = rectangle.x <= n && n <= rectangle.x + rectangle.width && rectangle.y <= n2 && n2 <= rectangle.y + rectangle.height ? 12 : -1;
        RectPool.INSTANCE.checkRectIn(rectangle);
        return n3;
    }

    public Rectangle getBounds(EdgeLabel edgeLabel, Transform transform, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        if (edgeLabel == null || !edgeLabel.isVisible()) {
            rectangle.height = -1;
            rectangle.width = -1;
        } else {
            int n = 0;
            if (edgeLabel.getStrokeWidth() > 0 && edgeLabel.isStroked()) {
                n = edgeLabel.getStrokeWidth();
                if (transform.isForegroundScaled() && n > 0) {
                    n = Math.max(1, transform.widthToDevice(n));
                }
            }
            Insets insets = edgeLabel.getInsets();
            if (edgeLabel.getTextMetrics() == null) {
                rectangle.x = transform.xToDevice(edgeLabel.getLeft()) - insets.left;
                rectangle.y = transform.yToDevice(edgeLabel.getTop()) - insets.top;
                rectangle.width = transform.xToDevice(edgeLabel.getRight()) - rectangle.x + insets.right;
                rectangle.height = transform.yToDevice(edgeLabel.getBottom()) - rectangle.y + insets.bottom;
                rectangle.grow(n + 1, n + 1);
            } else {
                rectangle.width = edgeLabel.getTextMetrics().width + 2 * n + insets.left + insets.right;
                rectangle.height = edgeLabel.getTextMetrics().height + 2 * n + insets.top + insets.bottom;
                rectangle.x = transform.xToDevice(edgeLabel.getCenterX()) - rectangle.width / 2;
                rectangle.y = transform.yToDevice(edgeLabel.getCenterY()) - rectangle.height / 2;
            }
        }
        return rectangle;
    }

    public void init(BaseObject baseObject) {
        baseObject.init(baseObject);
    }

    public void paint(BaseObject baseObject, Graphics graphics, Transform transform) {
        this.paint(graphics, (EdgeLabel)baseObject, transform);
    }

    public Rectangle getBounds(BaseObject baseObject, Transform transform, Rectangle rectangle) {
        return this.getBounds((EdgeLabel)baseObject, transform, rectangle);
    }

    public boolean intersects(BaseObject baseObject, Rectangle rectangle, Transform transform) {
        return this.intersects((EdgeLabel)baseObject, rectangle, transform);
    }

    public int getHitCode(BaseObject baseObject, int n, int n2, Transform transform) {
        return this.getHitCode((EdgeLabel)baseObject, n, n2, transform);
    }

    public Rectangle getBounds(Object object, Transform transform, Rectangle rectangle) {
        return this.getBounds((EdgeLabel)object, transform, rectangle);
    }

    public void paint(Graphics graphics, Object object, Transform transform) {
        this.paint(graphics, (EdgeLabel)object, transform);
    }
}

