/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.ui;

import com.cisco.nm.esper.lib.graphics.ClipShape;
import com.cisco.nm.esper.lib.graphics.MultiClip;
import com.cisco.nm.esper.lib.graphics.MultiClipPool;
import com.cisco.nm.esper.lib.graphics.RectClip;
import com.cisco.nm.esper.lib.graphics.RectClipPool;
import com.cisco.nm.esper.lib.graphics.RectPool;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.NodeLabel;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.ui.AbstractObjectPainter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Iterator;

public abstract class AbstractNodePainter
extends AbstractObjectPainter {
    public static final int CORNER_TOLERANCE = 2;

    public void paint(Graphics graphics, Node node, Transform transform) {
        if (node != null) {
            if (node.isDragged()) {
                this.paintOutline(graphics, node, transform);
            } else {
                this.paintDetail((Graphics2D)graphics, node, transform);
            }
        }
    }

    protected void paintOutline(Graphics graphics, Node node, Transform transform) {
        Rectangle rectangle = this.getBounds(node, transform, RectPool.INSTANCE.checkRectOut());
        graphics.setColor(node.getStrokeColor());
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        RectPool.INSTANCE.checkRectIn(rectangle);
    }

    protected abstract void paintDetail(Graphics2D var1, Node var2, Transform var3);

    public void paintLabels(Graphics graphics, Node node, Transform transform) {
        Iterator iterator = node.labels().iterator();
        while (iterator.hasNext()) {
            ((NodeLabel)iterator.next()).paint(graphics, transform);
        }
    }

    protected void paintCorners(Graphics2D graphics2D, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        int n5 = Math.min(rectangle.width >> 2, rectangle.height >> 2);
        graphics2D.drawLine(n, n3, n, n3 + n5);
        graphics2D.drawLine(n, n3, n + n5, n3);
        graphics2D.drawLine(n2 - n5, n3, n2, n3);
        graphics2D.drawLine(n2, n3, n2, n3 + n5);
        graphics2D.drawLine(n, n4 - n5, n, n4);
        graphics2D.drawLine(n, n4, n + n5, n4);
        graphics2D.drawLine(n2 - n5, n4, n2, n4);
        graphics2D.drawLine(n2, n4, n2, n4 - n5);
    }

    public int getHitCode(Node node, int n, int n2, Transform transform) {
        if (node.isHidden()) {
            return -1;
        }
        Rectangle rectangle = this.getBounds(node, transform, RectPool.INSTANCE.checkRectOut());
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.x + rectangle.width;
        int n6 = rectangle.y + rectangle.height;
        int n7 = -1;
        if (n5 - n3 <= 10 && n6 - n4 <= 10) {
            if (n3 <= n && n <= n5 && n4 <= n2 && n2 <= n6) {
                n7 = 0;
            }
        } else {
            int n8;
            int n9 = 2;
            int n10 = 2;
            int n11 = n8 = Math.max(1, transform.widthToDevice(node.getStrokeWidth()));
            int n12 = (n5 - n3) / 5;
            int n13 = (n6 - n4) / 5;
            if (n3 - n10 <= n && n <= n3 + n11 && n4 - n10 <= n2 && n2 <= n4 + n12 || n3 - n10 <= n && n <= n3 + n13 && n4 - n9 <= n2 && n2 <= n4 + n8) {
                n7 = 6;
            } else if (n3 - n10 <= n && n <= n3 + n11 && n6 - n12 <= n2 && n2 <= n6 + n9 || n3 - n10 <= n && n <= n3 + n13 && n6 - n8 <= n2 && n2 <= n6 + n9) {
                n7 = 4;
            } else if (n5 - n11 <= n && n <= n5 + n10 && n6 - n12 <= n2 && n2 <= n6 + n9 || n5 - n13 <= n && n <= n5 + n10 && n6 - n8 <= n2 && n2 <= n6 + n9) {
                n7 = 5;
            } else if (n5 - n11 <= n && n <= n5 + n10 && n4 - n9 <= n2 && n2 <= n4 + n12 || n5 - n13 <= n && n <= n5 + n10 && n4 - n9 <= n2 && n2 <= n4 + n8) {
                n7 = 7;
            } else if (n3 - n10 <= n && n <= n3 + n11 && n4 <= n2 && n2 <= n6) {
                n7 = 10;
            } else if (n5 - n11 <= n && n <= n5 + n10 && n4 <= n2 && n2 <= n6) {
                n7 = 11;
            } else if (n3 <= n && n <= n5 && n4 - n9 <= n2 && n2 <= n4 + n8) {
                n7 = 8;
            } else if (n3 <= n && n <= n5 && n6 - n8 <= n2 && n2 <= n6 + n9) {
                n7 = 9;
            } else if (n3 <= n && n <= n5 && n4 <= n2 && n2 <= n6) {
                n7 = 0;
            }
        }
        RectPool.INSTANCE.checkRectIn(rectangle);
        return n7;
    }

    public Rectangle getBounds(Node node, Transform transform, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        if (transform.isForegroundScaled()) {
            rectangle.x = transform.xToDevice(node.getIconLeft());
            rectangle.y = transform.yToDevice(node.getIconTop());
            rectangle.width = transform.xToDevice(node.getIconRight()) - rectangle.x;
            rectangle.height = transform.yToDevice(node.getIconBottom()) - rectangle.y;
        } else {
            rectangle.width = (int)Math.round(node.getIconWidth());
            rectangle.height = (int)Math.round(node.getIconHeight());
            rectangle.x = transform.xToDevice(node.getIconCenterX()) - rectangle.width / 2;
            rectangle.y = transform.yToDevice(node.getIconCenterY()) - rectangle.height / 2;
        }
        return rectangle;
    }

    public ClipShape borrowClip(Node node, Transform transform) {
        ClipShape clipShape;
        Rectangle rectangle = RectPool.INSTANCE.checkRectOut();
        RectClip rectClip = RectClipPool.INSTANCE.checkRectClipOut();
        rectClip.setBounds(node.getPainter().getBounds(node, transform, rectangle));
        if (node.labels().size() <= 0) {
            clipShape = rectClip;
        } else {
            MultiClip multiClip = MultiClipPool.INSTANCE.checkMultiClipOut();
            multiClip.add(rectClip);
            Iterator iterator = node.labels().iterator();
            while (iterator.hasNext()) {
                NodeLabel nodeLabel = (NodeLabel)iterator.next();
                RectClip rectClip2 = RectClipPool.INSTANCE.checkRectClipOut();
                rectClip2.setBounds(nodeLabel.getPainter().getBounds(nodeLabel, transform, rectangle));
                multiClip.add(rectClip2);
            }
            clipShape = multiClip;
        }
        RectPool.INSTANCE.checkRectIn(rectangle);
        return clipShape;
    }

    public void returnClip(Node node, ClipShape clipShape) {
        if (node.labels().size() <= 0) {
            RectClipPool.INSTANCE.checkIn(clipShape);
        } else {
            MultiClip multiClip = (MultiClip)clipShape;
            for (int i = multiClip.getClipShapeCount() - 1; i >= 0; --i) {
                RectClipPool.INSTANCE.checkIn(multiClip.getClipShape(i));
            }
            multiClip.clear();
            MultiClipPool.INSTANCE.checkMultiClipIn(multiClip);
        }
    }

    public boolean intersects(Node node, Rectangle rectangle, Transform transform) {
        boolean bl = false;
        if (rectangle != null && rectangle.width > 0 && rectangle.height > 0) {
            Rectangle rectangle2 = this.getBounds(node, transform, RectPool.INSTANCE.checkRectOut());
            bl = rectangle2.x <= rectangle.x + rectangle.width && rectangle2.x + rectangle2.width >= rectangle.x && rectangle2.y <= rectangle.y + rectangle.height && rectangle2.y + rectangle2.height >= rectangle.y;
            RectPool.INSTANCE.checkRectIn(rectangle2);
        }
        return bl;
    }

    public void init(Node node) {
    }

    public double getMinimumWidth(Node node) {
        return 10.0;
    }

    public double getMinimumHeight(Node node) {
        return 10.0;
    }

    public void paint(BaseObject baseObject, Graphics graphics, Transform transform) {
        this.paint(graphics, (Node)baseObject, transform);
    }

    public Rectangle getBounds(BaseObject baseObject, Transform transform, Rectangle rectangle) {
        return this.getBounds((Node)baseObject, transform, rectangle);
    }

    public boolean intersects(BaseObject baseObject, Rectangle rectangle, Transform transform) {
        return this.intersects((Node)baseObject, rectangle, transform);
    }

    public void init(BaseObject baseObject) {
        this.init((Node)baseObject);
    }

    public int getHitCode(BaseObject baseObject, int n, int n2, Transform transform) {
        return this.getHitCode((Node)baseObject, n, n2, transform);
    }

    public int getOnNodeLocation(int n, int n2, Node node, Transform transform) {
        return this.getHitCode(node, n, n2, transform);
    }

    static {
        CORNER_TOLERANCE = 2;
    }
}

