/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.ui;

import com.cisco.nm.esper.lib.graphics.StrokePool;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.ui.AbstractEdgePainter;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;

public class DefaultEdgePainter
extends AbstractEdgePainter {
    public static final DefaultEdgePainter INSTANCE = new DefaultEdgePainter();
    private Polygon arrow = new Polygon();
    private GeneralPath path;

    public DefaultEdgePainter() {
        if (this.arrow.xpoints.length < 4) {
            this.arrow.xpoints = new int[4];
            this.arrow.ypoints = new int[4];
        }
        this.arrow.npoints = 4;
        this.path = new GeneralPath(0, 6);
    }

    protected void paintPath(Graphics2D graphics2D, Edge edge, Transform transform, Point[] pointArray, int n) {
        int n2;
        int n3;
        int n4;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        int n5;
        double d11;
        double d12;
        int n6;
        graphics2D.setColor(edge.getStrokeColor());
        float[] fArray = null;
        if (edge.getPattern() != null) {
            if (transform.getScaleX() == 1.0) {
                fArray = edge.getPattern();
            } else {
                fArray = new float[edge.getPattern().length];
                for (n6 = 0; n6 < edge.getPattern().length; ++n6) {
                    fArray[n6] = Math.max(1.0f, (float)transform.widthToDevice(edge.getPattern()[n6]));
                }
            }
        }
        graphics2D.setColor(edge.getStrokeColor());
        this.path.reset();
        n6 = edge.getStrokeWidth();
        if (transform.isForegroundScaled()) {
            double d13 = (double)n6 * transform.getScaleX();
            d12 = d13 + d13;
            d11 = d12 + d12;
            n6 = Math.max(1, (int)Math.round(d13));
        } else {
            d12 = n6 + n6;
            d11 = d12 + d12;
        }
        if ((edge.getArrowType() & 1) == 0 || d12 < 1.0) {
            this.path.moveTo(pointArray[0].x, pointArray[0].y);
        } else {
            int n7 = pointArray[0].x;
            n5 = pointArray[0].y;
            d10 = n7 - pointArray[1].x;
            d9 = n5 - pointArray[1].y;
            d8 = Math.sqrt(d10 * d10 + d9 * d9);
            d7 = d12 / d8;
            d6 = d11 / d8;
            d5 = d6 * d10;
            d4 = -d7 * d10;
            d3 = d6 * d9;
            d2 = d7 * d9;
            d = (n6 & 1) != 0 ? 0.0 : 0.5 / d8;
            n4 = (int)Math.round(d * d9);
            n3 = (int)Math.round(d * d10);
            this.arrow.xpoints[0] = n7 - (int)Math.round(d5 - d2);
            this.arrow.ypoints[0] = n5 - (int)Math.round(d3 - d4);
            this.arrow.xpoints[1] = n7 + n4;
            this.arrow.ypoints[1] = n5 - n3;
            this.arrow.xpoints[2] = n7 - n4;
            this.arrow.ypoints[2] = n5 + n3;
            this.arrow.xpoints[3] = n7 - (int)Math.round(d5 + d2);
            this.arrow.ypoints[3] = n5 - (int)Math.round(d3 + d4);
            this.path.moveTo(pointArray[0].x - (int)d5, pointArray[0].y - (int)d3);
            graphics2D.draw(this.arrow);
            graphics2D.fillPolygon(this.arrow);
        }
        for (n2 = 1; n2 < n - 1; ++n2) {
            this.path.lineTo(pointArray[n2].x, pointArray[n2].y);
        }
        if ((edge.getArrowType() & 2) == 0 || d12 < 1.0) {
            this.path.lineTo(pointArray[n - 1].x, pointArray[n - 1].y);
        } else {
            n2 = pointArray[n - 1].x;
            n5 = pointArray[n - 1].y;
            d10 = n2 - pointArray[n - 2].x;
            d9 = n5 - pointArray[n - 2].y;
            d8 = Math.sqrt(d10 * d10 + d9 * d9);
            d7 = d12 / d8;
            d6 = d11 / d8;
            d5 = d6 * d10;
            d4 = -d7 * d10;
            d3 = d6 * d9;
            d2 = d7 * d9;
            d = (n6 & 1) != 0 ? 0.0 : 0.5 / d8;
            n4 = (int)Math.round(d * d9);
            n3 = (int)Math.round(d * d10);
            this.arrow.xpoints[0] = n2 - (int)Math.round(d5 - d2);
            this.arrow.ypoints[0] = n5 - (int)Math.round(d3 - d4);
            this.arrow.xpoints[1] = n2 + n4;
            this.arrow.ypoints[1] = n5 - n3;
            this.arrow.xpoints[2] = n2 - n4;
            this.arrow.ypoints[2] = n5 + n3;
            this.arrow.xpoints[3] = n2 - (int)Math.round(d5 + d2);
            this.arrow.ypoints[3] = n5 - (int)Math.round(d3 + d4);
            this.path.lineTo(pointArray[n - 1].x - (int)d5, pointArray[n - 1].y - (int)d3);
            graphics2D.draw(this.arrow);
            graphics2D.fillPolygon(this.arrow);
        }
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = fArray == null ? StrokePool.INSTANCE.getStroke(n6) : new BasicStroke(n6, 0, edge.getLineJoins(), 1.0f, fArray, 0.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(this.path);
        graphics2D.setStroke(stroke);
    }
}

