/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.ui;

import com.cisco.nm.esper.lib.FontRepository;
import com.cisco.nm.esper.lib.graphics.RectPool;
import com.cisco.nm.esper.lib.graphics.StrokePool;
import com.cisco.nm.esper.model.NodeLabel;
import com.cisco.nm.esper.model.TextDecoration;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.ui.AbstractNodeLabelPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;

public class DefaultNodeLabelPainter
extends AbstractNodeLabelPainter {
    public static final DefaultNodeLabelPainter INSTANCE = new DefaultNodeLabelPainter();

    protected void paintDetail(Graphics2D graphics2D, NodeLabel nodeLabel, Transform transform) {
        Font font = nodeLabel.getFont();
        if (transform.isForegroundScaled()) {
            font = FontRepository.INSTANCE.getScaleFont(font, transform.getScaleX());
        }
        nodeLabel.updateTextMetrics(font == null ? null : graphics2D.getFontMetrics(font), transform.getScaleX());
        Stroke stroke = graphics2D.getStroke();
        Rectangle rectangle = this.getBounds(nodeLabel, transform, RectPool.INSTANCE.checkRectOut());
        if (font == null) {
            Color color = nodeLabel.getTextColor();
            graphics2D.setColor(new Color(Math.min(color.getRed() + 192, 255), Math.min(color.getGreen() + 192, 255), Math.min(color.getBlue() + 192, 255)));
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            graphics2D.setFont(font);
            int n = 0;
            if (nodeLabel.getStrokeWidth() > 0 && nodeLabel.isStroked()) {
                n = nodeLabel.getStrokeWidth();
                if (transform.isForegroundScaled() && n > 0) {
                    n = Math.max(1, transform.widthToDevice(n));
                }
            }
            if (nodeLabel.isStroked()) {
                int n2 = -(n / 2);
                rectangle.grow(n2, n2);
                graphics2D.setStroke(StrokePool.INSTANCE.getStroke(n));
                graphics2D.setColor(nodeLabel.getStrokeColor());
                graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                rectangle.grow(-n - n2, -n - n2);
            } else {
                rectangle.x += nodeLabel.getInsets().left;
                rectangle.y += nodeLabel.getInsets().top;
                rectangle.width -= nodeLabel.getInsets().left + nodeLabel.getInsets().right;
                rectangle.height -= nodeLabel.getInsets().top + nodeLabel.getInsets().bottom;
                rectangle.grow(-n, -n);
            }
            if (nodeLabel.isFilled() || nodeLabel.isSelected()) {
                graphics2D.setColor(nodeLabel.getFillColor());
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
            }
            graphics2D.setColor(nodeLabel.getTextColor());
            if (nodeLabel.isStroked()) {
                rectangle.x += nodeLabel.getInsets().left;
            }
            TextDecoration.TextMetrics textMetrics = nodeLabel.getTextMetrics();
            TextDecoration.LineMetrics[] lineMetricsArray = textMetrics.line;
            for (int i = 0; i < lineMetricsArray.length; ++i) {
                String string = nodeLabel.getFragment(i);
                int n3 = lineMetricsArray[i].width;
                int n4 = rectangle.x;
                if (nodeLabel.getTextAlignment() == 1) {
                    n4 += (rectangle.width - n3) / 2;
                } else if (nodeLabel.getTextAlignment() == 2) {
                    n4 += rectangle.width - n3;
                }
                graphics2D.drawString(string, n4, rectangle.y + textMetrics.ascent);
                rectangle.y += textMetrics.advance;
            }
        }
        RectPool.INSTANCE.checkRectIn(rectangle);
        graphics2D.setStroke(stroke);
    }
}

