/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.ui;

import com.cisco.nm.esper.shape.Bounds;
import com.cisco.nm.esper.shape.BoundsDouble;
import com.cisco.nm.esper.shape.FixedBounds;
import com.cisco.nm.esper.shape.Paintable;
import com.cisco.nm.esper.shape.Transform;
import com.cisco.nm.lib.Debug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;

public class PaintableImage
implements ImageObserver,
Paintable {
    private static final MediaTracker tracker = new MediaTracker(new Panel());
    private static final int DEFAULT_WIDTH = 24;
    private static final int DEFAULT_HEIGHT = 24;
    private Image image;
    private int imgWidth;
    private int imgHeight;
    private Object source;
    private Bounds bounds;

    public PaintableImage() {
        this((Image)null);
    }

    public PaintableImage(String string) {
        this(Toolkit.getDefaultToolkit().getImage(string));
        this.setImageSource(string);
    }

    public PaintableImage(URL uRL) {
        this(Toolkit.getDefaultToolkit().getImage(uRL));
        this.setImageSource(uRL);
    }

    public PaintableImage(Image image) {
        this.setImage(image);
    }

    public void setImage(Image image) {
        Object object;
        this.image = image;
        if (this.image != null && (object = image.getProperty("comment", this)) instanceof String) {
            this.setImageSource(object);
        }
        if ((PaintableImage.loadImage(this.image) & 8) == 0) {
            this.imgWidth = 24;
            this.imgHeight = 24;
        } else {
            this.imgWidth = this.image.getWidth(this);
            this.imgHeight = this.image.getHeight(this);
        }
        this.bounds = new BoundsDouble((double)(-this.imgWidth) / 2.0, (double)(-this.imgHeight) / 2.0, (double)this.imgWidth / 2.0, (double)this.imgHeight / 2.0);
    }

    public void setImage(String string) {
        this.setImage(Toolkit.getDefaultToolkit().getImage(string));
        this.setImageSource(string);
    }

    public void setImage(URL uRL) {
        this.setImage(Toolkit.getDefaultToolkit().getImage(uRL));
        this.setImageSource(uRL);
    }

    public Image getImage() {
        return this.image;
    }

    public int getImageWidth() {
        return this.imgWidth;
    }

    public int getImageHeight() {
        return this.imgHeight;
    }

    public Object getImageSource() {
        return this.source;
    }

    public void setImageSource(Object object) {
        this.source = object;
    }

    public void paint(Graphics graphics, Transform transform) {
        int n = transform.xToDevice(this.getBounds().getLeft());
        int n2 = transform.yToDevice(this.getBounds().getTop());
        int n3 = transform.widthToDevice(this.getBounds().getWidth());
        int n4 = transform.heightToDevice(this.getBounds().getHeight());
        Rectangle rectangle = graphics.getClipBounds();
        if (Debug.isEnabled() && rectangle != null) {
            Debug.println(String.valueOf(String.valueOf(new StringBuffer("Paint ").append(rectangle).append(" out of ").append(n).append(", ").append(n2).append(": ").append(n3).append(" x ").append(n4))));
        }
        if (this.image != null) {
            graphics.drawImage(this.image, n, n2, n3, n4, this);
        } else {
            graphics.setColor(Color.red);
            graphics.drawRect(n, n2, n3, n4);
            graphics.drawLine(n, n2, n3, n4);
            graphics.drawLine(n, n4, n3, n2);
        }
    }

    public FixedBounds getBounds() {
        return this.bounds;
    }

    protected void setCenter(double d, double d2) {
        this.bounds.setCenter(d, d2);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x20) == 0;
    }

    public static int loadImage(Image image) {
        if (image == null) {
            return 4;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace(System.err);
            }
            int n = tracker.statusID(0, false);
            tracker.removeImage(image, 0);
            int n2 = n;
            return n2;
        }
    }

    static {
        DEFAULT_WIDTH = 24;
        DEFAULT_HEIGHT = 24;
    }
}

