/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.model.ui;

import com.cisco.nm.esper.lib.FontRepository;
import com.cisco.nm.esper.lib.graphics.RectPool;
import com.cisco.nm.esper.lib.graphics.StrokePool;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.ui.AbstractNodePainter;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;

public abstract class ShapeNodePainter
extends AbstractNodePainter {
    protected abstract Shape getShape(Rectangle var1);

    protected void paintDetail(Graphics2D graphics2D, Node node, Transform transform) {
        Font font;
        String string;
        Rectangle rectangle = RectPool.INSTANCE.checkRectOut();
        Rectangle rectangle2 = RectPool.INSTANCE.checkRectOut();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.getClipBounds(rectangle);
        this.getBounds(node, transform, rectangle2);
        int n = Math.max(1, transform.widthToDevice(node.getStrokeWidth()));
        if (n > 1) {
            int n2 = -(n >> 1);
            rectangle2.grow(n2, n2);
        }
        Shape shape = this.getShape(rectangle2);
        if (node.isFilled()) {
            graphics2D.setColor(node.getFillColor());
            graphics2D.fill(shape);
        }
        graphics2D.setStroke(StrokePool.INSTANCE.getStroke(n));
        if (node.isStroked()) {
            graphics2D.setColor(node.getStrokeColor());
            graphics2D.draw(shape);
        }
        if (node.isSelected()) {
            graphics2D.setColor(node.getCornerColor());
            this.paintCorners(graphics2D, rectangle2);
        }
        if (node.isAnnotated() && (string = node.getText()) != null && string.length() > 0 && (font = FontRepository.INSTANCE.getScaleFont(node.getFont(), transform.getScaleX())) != null) {
            graphics2D.setClip(rectangle2);
            graphics2D.setFont(font);
            graphics2D.setColor(node.getTextColor());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.drawString(string, rectangle2.x + (rectangle2.width - fontMetrics.stringWidth(string)) / 2, rectangle2.y + (rectangle2.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setClip(rectangle);
        RectPool.INSTANCE.checkRectIn(rectangle2);
        RectPool.INSTANCE.checkRectIn(rectangle);
    }
}

