/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.overview;

import com.cisco.nm.esper.overview.OverviewCanvasTool;
import com.cisco.nm.esper.shape.BoundsDouble;
import com.cisco.nm.esper.tool.ToolEquipped;
import com.cisco.nm.lib.winkit.RichColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class NewViewTool
extends OverviewCanvasTool {
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private Color marqueeColor = RichColor.seagreen;

    public NewViewTool(int n, int n2, int n3, int n4) {
        this.x1 = n;
        this.y1 = n4;
        this.x2 = n3;
        this.y2 = n4;
    }

    public void setMarqueeColor(Color color) {
        this.marqueeColor = color;
    }

    public Color getMarqueeColor() {
        return this.marqueeColor;
    }

    protected void activate(ToolEquipped toolEquipped) throws Exception {
        super.activate(toolEquipped);
        this.getOverviewCanvas().setViewBoundsVisible(false);
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        this.x2 = mouseEvent.getX();
        this.y2 = mouseEvent.getY();
        this.getOverviewCanvas().repaint();
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        this.x2 = mouseEvent.getX();
        this.y2 = mouseEvent.getY();
        this.x2 = this.x2 < this.x1 ? Math.min(this.x1 - 5, this.x2) : Math.max(this.x1 + 5, this.x2);
        this.y2 = this.y2 < this.y1 ? Math.min(this.y2, this.y1 - 5) : Math.max(this.y2, this.y1 + 5);
        double d = this.getWorldX(this.x1);
        double d2 = this.getWorldX(this.x2);
        double d3 = this.getWorldY(this.y1);
        double d4 = this.getWorldY(this.y2);
        if (d == d2) {
            d2 += 1.0;
        }
        if (d3 == d4) {
            d4 += 1.0;
        }
        this.getOverviewCanvas().getGraphComponent().fitInWindow(new BoundsDouble(Math.min(d, d2), Math.min(d3, d4), Math.max(d, d2), Math.max(d3, d4)), true);
        this.getOverviewCanvas().setViewBoundsVisible(true);
        this.deactivate();
    }

    public void paint(Graphics graphics) {
        if (this.isActivated()) {
            graphics.setColor(this.getMarqueeColor());
            graphics.drawLine(this.x1, this.y1, this.x2, this.y1);
            graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
            graphics.drawLine(this.x1, this.y1, this.x1, this.y2);
            graphics.drawLine(this.x2, this.y1, this.x2, this.y2);
        }
    }
}

