/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.overview;

import com.cisco.nm.esper.GraphComponent;
import com.cisco.nm.esper.event.GraphComponentEvent;
import com.cisco.nm.esper.event.GraphComponentListener;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.palette.GridPalette;
import com.cisco.nm.esper.overview.DefaultOverviewTool;
import com.cisco.nm.esper.overview.OverviewGraphPainter;
import com.cisco.nm.esper.shape.Bounds;
import com.cisco.nm.esper.shape.BoundsDouble;
import com.cisco.nm.esper.shape.FixedBounds;
import com.cisco.nm.esper.tool.TooledComponent;
import com.cisco.nm.lib.winkit.RichColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class OverviewCanvas
extends TooledComponent
implements GraphComponentListener {
    public static final int VC_SIZE = 7;
    public static final int HC_SIZE = 7;
    public static final int CORNER_TOLERANCE = 2;
    private Transform transform;
    private GraphComponent component;
    private boolean fullRepaint;
    private Image bgImage;
    private Bounds viewBounds;
    private Color strokeColor = RichColor.steelblue;
    private Color fillColor = RichColor.lavender;
    private Color cornerColor = RichColor.seagreen;
    private boolean boundsVisible;
    private OverviewGraphPainter painter = new OverviewGraphPainter();

    public OverviewCanvas(GraphComponent graphComponent) {
        this.component = graphComponent;
        this.boundsVisible = true;
        this.viewBounds = new BoundsDouble(graphComponent.getViewBounds());
        this.setTool(new DefaultOverviewTool());
        if (graphComponent.getGraph() != null) {
            this.setBackground(graphComponent.getGraph().getFillColor());
        } else {
            this.setBackground(graphComponent.asContainer().getBackground());
        }
        graphComponent.addGraphComponentListener(this);
    }

    public GraphComponent getGraphComponent() {
        return this.component;
    }

    public Transform getTransform() {
        if (this.transform == null) {
            this.transform = new Transform();
            GridPalette gridPalette = new GridPalette();
            gridPalette.setEnabled(false);
            this.transform.setGridPalette(gridPalette);
        }
        return this.transform;
    }

    protected void fitToDevice(FixedBounds fixedBounds) {
        double d = fixedBounds.getHeight() < (double)this.getHeight() ? 1.0 : (double)this.getHeight() / fixedBounds.getHeight();
        double d2 = fixedBounds.getWidth() < (double)this.getWidth() ? 1.0 : (double)this.getWidth() / fixedBounds.getWidth();
        double d3 = d < d2 ? d : d2;
        this.getTransform().setScaleX(d3);
        this.getTransform().setScaleY(-d3);
        this.getTransform().setOffsetX(0.0 - d3 * fixedBounds.getLeft() + ((double)this.getWidth() - d3 * fixedBounds.getWidth()) / 2.0);
        this.getTransform().setOffsetY(0.0 + d3 * fixedBounds.getTop() + ((double)this.getHeight() - d3 * fixedBounds.getHeight()) / 2.0);
    }

    public void viewChanged(GraphComponentEvent graphComponentEvent) {
        this.setViewBounds(this.getGraphComponent().getViewBounds());
        this.repaint();
    }

    public void graphChanged(GraphComponentEvent graphComponentEvent) {
        this.doFullRepaint();
        this.repaint();
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public Color getCornerColor() {
        return this.cornerColor;
    }

    public void setStrokeColor(Color color) {
        this.strokeColor = color;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public void setCornerColor(Color color) {
        this.cornerColor = color;
    }

    public void setViewBounds(FixedBounds fixedBounds) {
        this.setViewBounds(fixedBounds.getLeft(), fixedBounds.getBottom(), fixedBounds.getRight(), fixedBounds.getTop());
    }

    public void setViewBounds(double d, double d2, double d3, double d4) {
        this.viewBounds.setBounds(Math.min(d, d3), Math.min(d2, d4), Math.max(d, d3), Math.max(d2, d4));
    }

    public void setViewBoundsCenter(double d, double d2) {
        this.viewBounds.setCenter(d, d2);
    }

    public FixedBounds getViewBounds() {
        return this.viewBounds;
    }

    public void setViewBoundsVisible(boolean bl) {
        if (bl != this.boundsVisible) {
            this.boundsVisible = bl;
            this.repaint();
        }
    }

    public boolean isViewBoundsVisible() {
        return this.boundsVisible;
    }

    public boolean isViewBoundsShowing() {
        if (!this.isViewBoundsVisible()) {
            return false;
        }
        return this.getTransform().widthToDevice(this.getGraphComponent().getViewBounds().getWidth()) < this.getWidth() && this.getTransform().heightToDevice(this.getGraphComponent().getViewBounds().getHeight()) < this.getHeight();
    }

    public void paint(Graphics graphics) {
        Graph graph = this.getGraphComponent().getGraph();
        if (graph != null) {
            this.fitToDevice(graph.getBounds());
            if (this.fullRepaint && this.bgImage != null) {
                int n = this.bgImage.getWidth(this);
                int n2 = this.bgImage.getHeight(this);
                Graphics graphics2 = this.bgImage.getGraphics();
                graphics2.setClip(0, 0, n, n2);
                graphics2.setColor(graph.getFillColor());
                graphics2.fillRect(0, 0, n, n2);
                this.painter.paint(graphics2, graph, this.getTransform());
                graphics2.dispose();
                this.fullRepaint = false;
            }
            if (this.bgImage != null) {
                graphics.drawImage(this.bgImage, 0, 0, this);
            }
            this.paintViewBounds(graphics);
        }
        if (this.getActiveTool() != null) {
            this.getActiveTool().paint(graphics);
        }
    }

    protected void paintViewBounds(Graphics graphics) {
        if (this.isViewBoundsShowing()) {
            graphics.setClip(0, 0, this.getWidth(), this.getHeight());
            int n = this.getTransform().xToDevice(this.getViewBounds().getLeft());
            int n2 = this.getTransform().xToDevice(this.getViewBounds().getRight());
            int n3 = this.getTransform().yToDevice(this.getViewBounds().getTop());
            int n4 = this.getTransform().yToDevice(this.getViewBounds().getBottom());
            graphics.setColor(this.getStrokeColor());
            graphics.drawRect(n - 1, n3 - 1, n2 - n + 2, n4 - n3 + 2);
            graphics.setColor(this.getFillColor());
            graphics.drawRect(n, n3, n2 - n, n4 - n3);
            graphics.setColor(this.getStrokeColor());
            graphics.drawRect(n + 1, n3 + 1, n2 - n - 2, n4 - n3 - 2);
            int n5 = Math.min(7, (n4 - n3) / 2);
            int n6 = Math.min(7, (n2 - n) / 2);
            graphics.setColor(this.getCornerColor());
            graphics.drawLine(n, n3 + n5, n, n3);
            graphics.drawLine(n, n3, n + n6, n3);
            graphics.drawLine(n, n4, n, n4 - n5);
            graphics.drawLine(n, n4, n + n6, n4);
            graphics.drawLine(n2, n4, n2, n4 - n5);
            graphics.drawLine(n2, n4, n2 - n6, n4);
            graphics.drawLine(n2, n3, n2, n3 + n5);
            graphics.drawLine(n2, n3, n2 - n6, n3);
        }
    }

    public void doFullRepaint() {
        this.fullRepaint = true;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        super.setBounds(n, n2, n3, n4);
        if (n3 > 0 && n4 > 0 && (this.bgImage == null || this.bgImage.getWidth(this) != n3 || this.bgImage.getHeight(this) != n4)) {
            if (this.bgImage != null) {
                this.bgImage.flush();
            }
            this.bgImage = this.createImage(n3, n4);
        }
        if (n3 != n5 || n4 != n6) {
            this.doFullRepaint();
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 150);
    }

    public int getCursorType(int n, int n2) {
        if (!this.isViewBoundsShowing()) {
            return 0;
        }
        int n3 = this.getTransform().xToDevice(this.getViewBounds().getLeft());
        int n4 = this.getTransform().xToDevice(this.getViewBounds().getRight());
        int n5 = this.getTransform().yToDevice(this.getViewBounds().getTop());
        int n6 = this.getTransform().yToDevice(this.getViewBounds().getBottom());
        int n7 = Math.max(1, Math.min(7, (n6 - n5) / 2));
        int n8 = Math.max(1, Math.min(7, (n4 - n3) / 2));
        if (n3 - 2 <= n && n <= n3 + 2 && n5 - 2 <= n2 && n2 <= n5 + n7 || n3 - 2 <= n && n <= n3 + n8 && n5 - 2 <= n2 && n2 <= n5 + 2) {
            return 6;
        }
        if (n3 - 2 <= n && n <= n3 + 2 && n6 - n7 <= n2 && n2 <= n6 + 2 || n3 - 2 <= n && n <= n3 + n8 && n6 - 2 <= n2 && n2 <= n6 + 2) {
            return 4;
        }
        if (n4 - 2 <= n && n <= n4 + 2 && n6 - n7 <= n2 && n2 <= n6 + 2 || n4 - n8 <= n && n <= n4 + 2 && n6 - 2 <= n2 && n2 <= n6 + 2) {
            return 5;
        }
        if (n4 - 2 <= n && n <= n4 + 2 && n5 - 2 <= n2 && n2 <= n5 + n7 || n4 - n8 <= n && n <= n4 + 2 && n5 - 2 <= n2 && n2 <= n5 + 2) {
            return 7;
        }
        if (n3 < n && n < n4 && n5 < n2 && n2 < n6) {
            return 13;
        }
        return 0;
    }

    static {
        VC_SIZE = 7;
        HC_SIZE = 7;
        CORNER_TOLERANCE = 2;
    }
}

