/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.shape;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.shape.FixedBounds;
import com.cisco.nm.esper.shape.FixedPoint2D;
import com.cisco.nm.esper.shape.Point2D;

public class FixedBoundsDouble
implements FixedBounds {
    protected double minX;
    protected double maxX;
    protected double maxY;
    protected double minY;

    public FixedBoundsDouble() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public FixedBoundsDouble(FixedBounds fixedBounds) {
        this(fixedBounds.getLeft(), fixedBounds.getBottom(), fixedBounds.getRight(), fixedBounds.getTop());
    }

    public FixedBoundsDouble(double d, double d2, double d3, double d4) {
        this.minX = d;
        this.maxX = d3;
        this.minY = d2;
        this.maxY = d4;
    }

    public Point2D getCenter() {
        return this.getCenter(null);
    }

    public Point2D getCenter(Point2D point2D) {
        if (point2D == null) {
            point2D = new Point2D.Double();
        }
        point2D.setLocation(this.getCenterX(), this.getCenterY());
        return point2D;
    }

    public double getLeft() {
        return this.minX;
    }

    public double getRight() {
        return this.maxX;
    }

    public double getBottom() {
        return this.minY;
    }

    public double getTop() {
        return this.maxY;
    }

    public double getCenterX() {
        return (this.minX + this.maxX) / 2.0;
    }

    public double getCenterY() {
        return (this.minY + this.maxY) / 2.0;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public boolean contains(FixedBounds fixedBounds) {
        return this.contains(fixedBounds.getLeft(), fixedBounds.getBottom(), fixedBounds.getRight(), fixedBounds.getTop());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.minX <= d && d3 <= this.maxX && this.minY <= d2 && d4 <= this.maxY;
    }

    public boolean contains(FixedPoint2D fixedPoint2D) {
        return this.contains(fixedPoint2D.getX(), fixedPoint2D.getY());
    }

    public boolean contains(double d, double d2) {
        return this.minX <= d && d <= this.maxX && this.minY <= d2 && d2 <= this.maxY;
    }

    public int outcode(FixedPoint2D fixedPoint2D) {
        return this.outcode(fixedPoint2D.getX(), fixedPoint2D.getY());
    }

    public int outcode(double d, double d2) {
        int n = 0;
        if (this.maxX < this.minX) {
            n |= 9;
        } else if (d < this.minX) {
            n |= 8;
        } else if (d > this.maxX) {
            n |= 1;
        }
        if (this.maxY < this.minY) {
            n |= 6;
        } else if (d2 < this.minY) {
            n |= 2;
        } else if (d2 > this.maxY) {
            n |= 4;
        }
        return n;
    }

    public boolean intersects(FixedBounds fixedBounds) {
        return this.intersects(fixedBounds.getLeft(), fixedBounds.getBottom(), fixedBounds.getRight(), fixedBounds.getTop());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (d <= d3) {
            if (d2 <= d4) {
                return d3 >= this.getLeft() && d <= this.getRight() && d2 <= this.getTop() && d4 >= this.getBottom();
            }
            return d3 >= this.getLeft() && d <= this.getRight() && d4 <= this.getTop() && d2 >= this.getBottom();
        }
        if (d2 <= d4) {
            return d >= this.getLeft() && d3 <= this.getRight() && d2 <= this.getTop() && d4 >= this.getBottom();
        }
        return d >= this.getLeft() && d3 <= this.getRight() && d4 <= this.getTop() && d2 >= this.getBottom();
    }

    public boolean intersectsLine(double d, double d2, double d3, double d4) {
        int n = this.outcode(d, d2);
        int n2 = this.outcode(d3, d4);
        while ((n & n2) == 0) {
            double d5;
            if (n == 0) {
                if (n2 == 0) {
                    return true;
                }
                d5 = d;
                d = d3;
                d3 = d5;
                d5 = d2;
                d2 = d4;
                d4 = d5;
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            if ((n & 9) != 0) {
                d5 = (n & 1) == 0 ? this.getLeft() : this.getRight();
                d2 += (d5 - d) * (d4 - d2) / (d3 - d);
                d = d5;
            } else if ((n & 6) != 0) {
                d5 = (n & 4) == 0 ? this.getBottom() : this.getTop();
                d += (d5 - d2) * (d3 - d) / (d4 - d2);
                d2 = d5;
            }
            n = this.outcode(d, d2);
        }
        return false;
    }

    public FixedPoint2D intersection(double d, double d2, double d3, double d4) {
        double d5;
        int n = this.outcode(d, d2);
        int n2 = this.outcode(d3, d4);
        if (n2 == 0 && n != 0) {
            d5 = d;
            d = d3;
            d3 = d5;
            d5 = d2;
            d2 = d4;
            d4 = d5;
            n ^= n2;
            n2 ^= n;
            n ^= n2;
        }
        while (n2 != 0) {
            if ((n & n2) != 0) {
                return null;
            }
            if ((n2 & 9) != 0) {
                d5 = (n2 & 1) == 0 ? this.getLeft() : this.getRight();
                d4 += (d5 - d3) * (d4 - d2) / (d3 - d);
                d3 = d5;
            } else if ((n2 & 6) != 0) {
                d5 = (n2 & 4) == 0 ? this.getBottom() : this.getTop();
                d3 += (d5 - d4) * (d3 - d) / (d4 - d2);
                d4 = d5;
            }
            n2 = this.outcode(d3, d4);
        }
        return new Point2D.Double(d3, d4);
    }

    public double xOfIntersection(double d, double d2, double d3, double d4) {
        double d5;
        int n = this.outcode(d, d2);
        int n2 = this.outcode(d3, d4);
        if (n2 == 0 && n != 0) {
            d5 = d;
            d = d3;
            d3 = d5;
            d5 = d2;
            d2 = d4;
            d4 = d5;
            n ^= n2;
            n2 ^= n;
            n ^= n2;
        }
        while (n2 != 0) {
            if ((n & n2) != 0) {
                return Double.NaN;
            }
            if ((n2 & 9) != 0) {
                d5 = (n2 & 1) == 0 ? this.getLeft() : this.getRight();
                d4 += (d5 - d3) * (d4 - d2) / (d3 - d);
                d3 = d5;
            } else if ((n2 & 6) != 0) {
                d5 = (n2 & 4) == 0 ? this.getBottom() : this.getTop();
                d3 += (d5 - d4) * (d3 - d) / (d4 - d2);
                d4 = d5;
            }
            n2 = this.outcode(d3, d4);
        }
        return d3;
    }

    public double yOfIntersection(double d, double d2, double d3, double d4) {
        double d5;
        int n = this.outcode(d, d2);
        int n2 = this.outcode(d3, d4);
        if (n2 == 0 && n != 0) {
            d5 = d;
            d = d3;
            d3 = d5;
            d5 = d2;
            d2 = d4;
            d4 = d5;
            n ^= n2;
            n2 ^= n;
            n ^= n2;
        }
        while (n2 != 0) {
            if ((n & n2) != 0) {
                return Double.NaN;
            }
            if ((n2 & 9) != 0) {
                d5 = (n2 & 1) == 0 ? this.getLeft() : this.getRight();
                d4 += (d5 - d3) * (d4 - d2) / (d3 - d);
                d3 = d5;
            } else if ((n2 & 6) != 0) {
                d5 = (n2 & 4) == 0 ? this.getBottom() : this.getTop();
                d3 += (d5 - d4) * (d3 - d) / (d4 - d2);
                d4 = d5;
            }
            n2 = this.outcode(d3, d4);
        }
        return d4;
    }

    public final boolean isSinglePrecision() {
        return false;
    }

    public final boolean isDoublePrecision() {
        return true;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getLeft()))).append(", ").append(this.getBottom()).append(", ").append(this.getRight()).append(", ").append(this.getTop())));
    }

    public Object clone() {
        try {
            Object object = super.clone();
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(EsperStrings.string(6, cloneNotSupportedException.getMessage()));
        }
    }
}

