/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.tool;

import com.cisco.nm.esper.command.InsertBendCommand;
import com.cisco.nm.esper.lib.OwnedArrayList;
import com.cisco.nm.esper.lib.OwnedList;
import com.cisco.nm.esper.model.Bend;
import com.cisco.nm.esper.model.DragHelper;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.GraphSubset;
import com.cisco.nm.esper.tool.GestureTool;
import com.cisco.nm.esper.tool.ToolEquipped;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Iterator;

public class BendTool
extends GestureTool {
    private Edge edge;
    private Bend bend;
    private Point point;
    private int index;
    private DragHelper mover;

    public void initialize(Object object, int n, int n2) {
        if (!(object instanceof Edge)) {
            throw new IllegalArgumentException("Expecting an edge, but got ".concat(String.valueOf(String.valueOf(object == null ? "null" : object.getClass().getName()))));
        }
        this.edge = (Edge)object;
        this.point = new Point(n, n2);
        this.setPainted(true);
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        if (this.isPainted()) {
            double d = this.xToWorld(mouseEvent.getX());
            double d2 = this.yToWorld(mouseEvent.getY());
            this.mover.onDragTo(d, d2);
            this.makeVisible(d, d2, false);
            this.getGraphComponent().asContainer().repaint();
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        if (this.isPainted()) {
            this.setPainted(false);
            this.setObjectsDragged(false);
            this.getEdge().remove(this.getVirtualBend());
            this.mover.onCancel();
            this.mover.clear();
            this.mover = null;
            this.commitChanges(this.xToWorld(mouseEvent.getX()), this.yToWorld(mouseEvent.getY()), this.getBendIndex());
            this.deactivate();
        }
    }

    public void paint(Graphics graphics) {
        if (this.isActivated() && this.isPainted()) {
            this.getEdge().paint(graphics, this.getTransform());
            Iterator iterator = this.getEdge().labels().iterator();
            while (iterator.hasNext()) {
                EdgeLabel edgeLabel = (EdgeLabel)iterator.next();
                edgeLabel.paint(graphics, this.getTransform());
            }
        }
    }

    protected synchronized void activate(ToolEquipped toolEquipped) throws Exception {
        super.activate(toolEquipped);
        this.index = this.edge.getHitCode(this.point.x, this.point.y, this.getTransform());
        if (this.index < 0) {
            this.deactivate();
        } else {
            double d = this.xToWorld(this.getHitPoint().x);
            double d2 = this.yToWorld(this.getHitPoint().y);
            this.bend = new Bend(d, d2);
            this.edge.insert(this.index, this.bend);
            this.mover = new DragHelper(this.getActiveGraph());
            this.mover.init(new BendSelection(this.bend));
            this.mover.onStartAt(d, d2);
            this.setObjectsDragged(true);
            toolEquipped.asContainer().repaint();
        }
    }

    public void abort() {
        if (this.isPainted()) {
            this.setObjectsDragged(false);
            this.getEdge().remove(this.getVirtualBend());
            this.mover.onCancel();
            this.mover.clear();
            this.mover = null;
            this.getGraphComponent().asContainer().repaint();
            this.deactivate();
        }
    }

    protected void setObjectsDragged(boolean bl) {
        this.getEdge().setDragged(bl);
        Iterator iterator = this.getEdge().labels().iterator();
        while (iterator.hasNext()) {
            ((EdgeLabel)iterator.next()).setDragged(bl);
        }
    }

    public void commitChanges(double d, double d2, int n) {
        Bend bend = this.getGraphComponent().getMemberFactory().nextBend();
        bend.setCenter(d, d2);
        this.getGraphComponent().getCommandDispatcher().dispatch(new InsertBendCommand(this.getEdge(), bend, n));
    }

    public Bend getVirtualBend() {
        return this.bend;
    }

    public Edge getEdge() {
        return this.edge;
    }

    public Point getHitPoint() {
        return this.point;
    }

    public int getBendIndex() {
        return this.index;
    }

    private static class BendSelection
    implements GraphSubset {
        private OwnedArrayList bends = new OwnedArrayList(1);

        public BendSelection(Bend bend) {
            this.bends.add(bend);
        }

        public OwnedList nodes() {
            return OwnedList.EMPTY;
        }

        public OwnedList edges() {
            return OwnedList.EMPTY;
        }

        public OwnedList graphs() {
            return OwnedList.EMPTY;
        }

        public OwnedList edgeLabels() {
            return OwnedList.EMPTY;
        }

        public OwnedList nodeLabels() {
            return OwnedList.EMPTY;
        }

        public OwnedList bends() {
            return this.bends;
        }
    }
}

