/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.tool;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.GraphComponent;
import com.cisco.nm.esper.HitTestWorker;
import com.cisco.nm.esper.SelectionWorker;
import com.cisco.nm.esper.model.Bend;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.GraphMember;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.NodeLabel;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.tool.MouseTool;
import com.cisco.nm.esper.tool.Tool;
import com.cisco.nm.esper.tool.ToolEquipped;
import com.cisco.nm.esper.tool.event.ExtraMouseListener;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public abstract class GraphComponentTool
extends MouseTool {
    public static final int DO_NOTHING = 0;
    public static final int ABORT = 1;
    private Cursor actionCursor;
    private Cursor defaultCursor;
    private Graph graph;
    private boolean lockGraph;
    private boolean wasLocked;
    private int escCode = 1;

    public GraphComponentTool() {
        this.setActionCursor(Cursor.getDefaultCursor());
        this.setDefaultCursor(Cursor.getDefaultCursor());
        this.lockGraph = false;
    }

    public GraphComponent getGraphComponent() {
        return (GraphComponent)this.getOwner();
    }

    public HitTestWorker getHitTestWorker() {
        if (this.getGraphComponent() == null) {
            return null;
        }
        return this.getGraphComponent().getHitTestWorker();
    }

    public SelectionWorker getSelection() {
        return this.getGraphComponent().getSelectionWorker();
    }

    public Graph getActiveGraph() {
        return this.graph == null ? this.getGraphComponent().getGraph() : this.graph;
    }

    public Graph getRootGraph() {
        return this.getGraphComponent().getGraph();
    }

    public Transform getTransform() {
        return this.getGraphComponent().getTransform();
    }

    public boolean isGraphLocked() {
        return this.lockGraph;
    }

    public void setGraphLocked(boolean bl) {
        this.lockGraph = bl;
    }

    protected void setActiveGraph(Graph graph) {
        this.graph = graph;
    }

    protected void setTempLockOn(boolean bl) {
        if (bl) {
            this.wasLocked = this.isGraphLocked();
            this.setGraphLocked(true);
        } else {
            this.setGraphLocked(this.wasLocked);
        }
    }

    public synchronized void deactivate() {
        if (this.getParentTool() == null) {
            this.getOwner().asContainer().setCursor(Cursor.getDefaultCursor());
        }
        super.deactivate();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        GraphMember graphMember = this.getHitTestWorker().getTopObjectAt(this.getActiveGraph(), mouseEvent.getX(), mouseEvent.getY());
        return graphMember == null ? null : graphMember.toString();
    }

    public void setDefaultEscapeOperation(int n) {
        if (n != 0 && n != 1) {
            EsperStrings.illegalArgument(3, n);
        }
        this.escCode = n;
    }

    public int getDefaultEscapeOperation() {
        return this.escCode;
    }

    public Cursor getActionCursor() {
        return this.actionCursor;
    }

    public Cursor getDefaultCursor() {
        return this.defaultCursor;
    }

    public void setActionCursor(Cursor cursor) {
        this.actionCursor = cursor;
    }

    public void setDefaultCursor(Cursor cursor) {
        this.defaultCursor = cursor;
    }

    public int getOnGraphLocation(int n, int n2) {
        Graph graph = this.getActiveGraph();
        int n3 = this.getHitTestWorker().getOnGraphLocation(graph, n, n2);
        if (n3 == -1 && graph != null && graph == this.getRootGraph() && (n3 = graph.getHitCode(n, n2, this.getTransform())) == 12) {
            n3 = -1;
        }
        if (n3 == 0) {
            return this.getActionCursor().getType();
        }
        return n3;
    }

    public int getOnNodeLocation(int n, int n2) {
        int n3 = this.getHitTestWorker().getOnNodeLocation(this.getActiveGraph(), n, n2);
        if (n3 == 0) {
            return this.getActionCursor().getType();
        }
        return n3;
    }

    public boolean isOverGraph(int n, int n2) {
        return this.getHitTestWorker().isOverGraph(this.getActiveGraph(), n, n2);
    }

    public boolean isOverEdge(int n, int n2) {
        return this.getHitTestWorker().isOverEdge(this.getActiveGraph(), n, n2);
    }

    public boolean isOverEdgeLabel(int n, int n2) {
        return this.getHitTestWorker().isOverEdgeLabel(this.getActiveGraph(), n, n2);
    }

    public boolean isOverNodeLabel(int n, int n2) {
        return this.getHitTestWorker().isOverNodeLabel(this.getActiveGraph(), n, n2);
    }

    public List getGraphsAt(int n, int n2) {
        return this.getHitTestWorker().getGraphsAt(this.getActiveGraph(), n, n2);
    }

    public Graph getTopGraphAt(int n, int n2) {
        int n3;
        Graph graph = this.getActiveGraph();
        Graph graph2 = this.getHitTestWorker().getTopGraphAt(graph, n, n2);
        if (graph2 == null && graph != null && graph == this.getRootGraph() && (n3 = graph.getHitCode(n, n2, this.getTransform())) != -1 && n3 != 12) {
            return graph;
        }
        return graph2;
    }

    public List getNodesAt(int n, int n2) {
        return this.getHitTestWorker().getNodesAt(this.getActiveGraph(), n, n2);
    }

    public Node getTopNodeAt(int n, int n2) {
        return this.getHitTestWorker().getTopNodeAt(this.getActiveGraph(), n, n2);
    }

    public NodeLabel getTopNodeLabelAt(int n, int n2) {
        return this.getHitTestWorker().getTopNodeLabelAt(this.getActiveGraph(), n, n2);
    }

    public List getNodeLabesAt(int n, int n2) {
        return this.getHitTestWorker().getNodeLabelsAt(this.getActiveGraph(), n, n2);
    }

    public List getEdgesAt(int n, int n2) {
        return this.getHitTestWorker().getEdgesAt(this.getActiveGraph(), n, n2);
    }

    public Edge getTopEdgeAt(int n, int n2) {
        return this.getHitTestWorker().getTopEdgeAt(this.getActiveGraph(), n, n2);
    }

    public List getBendsAt(int n, int n2) {
        return this.getHitTestWorker().getBendsAt(this.getActiveGraph(), n, n2);
    }

    public Bend getTopBendAt(int n, int n2) {
        return this.getHitTestWorker().getTopBendAt(this.getActiveGraph(), n, n2);
    }

    public List getEdgeLabelsAt(int n, int n2) {
        return this.getHitTestWorker().getEdgeLabelsAt(this.getActiveGraph(), n, n2);
    }

    public EdgeLabel getTopEdgeLabelAt(int n, int n2) {
        return this.getHitTestWorker().getTopEdgeLabelAt(this.getActiveGraph(), n, n2);
    }

    protected synchronized void activate(ToolEquipped toolEquipped) throws Exception {
        super.activate(toolEquipped);
        toolEquipped.asContainer().setCursor(this.getDefaultCursor());
    }

    protected synchronized void resume() {
        this.getOwner().asContainer().setCursor(this.getDefaultCursor());
        super.resume();
    }

    protected synchronized void terminate() {
        this.setActiveGraph(null);
        super.terminate();
    }

    public void setChildTool(Tool tool) {
        if (tool instanceof GraphComponentTool) {
            ((GraphComponentTool)tool).setActiveGraph(this.getActiveGraph());
        }
        super.setChildTool(tool);
    }

    public double xToWorld(int n) {
        return this.getTransform().xToWorld(n);
    }

    public double yToWorld(int n) {
        return this.getTransform().yToWorld(n);
    }

    public void makeVisible(double d, double d2, boolean bl) {
        this.getGraphComponent().makeVisible(d, d2, bl);
    }

    protected void updateActiveGraph(MouseEvent mouseEvent) {
        if (this.isActivated() && !this.isGraphLocked()) {
            Graph graph = this.getRootGraph();
            if (mouseEvent.getID() != 500) {
                this.setActiveGraph(this.getHitTestWorker().getActiveGraph(this.getRootGraph(), mouseEvent.getX(), mouseEvent.getY()));
            }
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        block27: {
            int n;
            block28: {
                MouseEvent mouseEvent;
                block29: {
                    if (!this.isActivated()) break block27;
                    n = aWTEvent.getID();
                    if (500 > n || n > 506) break block28;
                    mouseEvent = (MouseEvent)aWTEvent;
                    this.setMousePosition(mouseEvent.getX(), mouseEvent.getY());
                    this.updateActiveGraph(mouseEvent);
                    if ((mouseEvent.getModifiers() & 4) == 0) break block29;
                    ExtraMouseListener extraMouseListener = this.getExtraMouseListener();
                    if (extraMouseListener == null) {
                        extraMouseListener = this.getGraphComponent().getExtraMouseListener();
                    }
                    if (extraMouseListener == null) break block27;
                    switch (n) {
                        case 501: {
                            if (mouseEvent.getClickCount() > 1) {
                                this.abort();
                                extraMouseListener.onMultiClick(mouseEvent);
                            }
                            if (mouseEvent.isPopupTrigger()) {
                                this.abort();
                                extraMouseListener.onPopup(mouseEvent);
                                break;
                            }
                            break block27;
                        }
                        case 502: {
                            if (!mouseEvent.isPopupTrigger()) break block27;
                            this.abort();
                            extraMouseListener.onPopup(mouseEvent);
                        }
                        default: {
                            break;
                        }
                        {
                            break block27;
                        }
                    }
                    break block27;
                }
                switch (n) {
                    case 500: {
                        this.onMouseClicked(mouseEvent);
                        break;
                    }
                    case 506: {
                        this.onMouseDragged(mouseEvent);
                        break;
                    }
                    case 504: {
                        this.onMouseEntered(mouseEvent);
                        break;
                    }
                    case 505: {
                        this.onMouseExited(mouseEvent);
                        break;
                    }
                    case 503: {
                        this.onMouseMoved(mouseEvent);
                        break;
                    }
                    case 501: {
                        this.onMousePressed(mouseEvent);
                        break;
                    }
                    case 502: {
                        this.onMouseReleased(mouseEvent);
                    }
                }
                break block27;
            }
            if (400 <= n && n <= 402) {
                KeyEvent keyEvent = (KeyEvent)aWTEvent;
                switch (n) {
                    case 401: {
                        this.onKeyPressed(keyEvent);
                        break;
                    }
                    case 402: {
                        this.onKeyReleased(keyEvent);
                        break;
                    }
                    case 400: {
                        this.onKeyTyped(keyEvent);
                    }
                }
                if (this.escCode == 1 && !keyEvent.isConsumed() && keyEvent.getKeyCode() == 27 && this.isActivated()) {
                    this.abort();
                    keyEvent.consume();
                }
            } else {
                this.onOtherEvent(aWTEvent);
            }
        }
    }

    public Cursor newCursor(String string, Point point, int n) {
        try {
            int n2;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getClass().getResourceAsStream(string));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            byte[] byArray = new byte[512];
            while ((n2 = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            ((InputStream)bufferedInputStream).close();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.createImage(byteArrayOutputStream.toByteArray());
            if (image != null) {
                Cursor cursor = toolkit.createCustomCursor(image, point, string);
                return cursor;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Cursor.getPredefinedCursor(n);
    }

    static {
        DO_NOTHING = 0;
        ABORT = 1;
    }
}

