/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.tool;

import com.cisco.nm.esper.SelectionWorker;
import com.cisco.nm.esper.tool.GestureTool;
import com.cisco.nm.esper.tool.ToolEquipped;
import com.cisco.nm.lib.winkit.RichColor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class MarqueeSelectorTool
extends GestureTool {
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private static final Color marqueeColor = RichColor.steelblue;

    public void initialize(Object object, int n, int n2) {
        this.setActionCursor(Cursor.getPredefinedCursor(1));
        this.setDefaultCursor(Cursor.getPredefinedCursor(1));
        this.x1 = n;
        this.y1 = n2;
        this.setPainted(true);
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        if (this.isActivated()) {
            this.x2 = this.xToWorld(mouseEvent.getX());
            this.y2 = this.yToWorld(mouseEvent.getY());
            this.makeVisible(this.x2, this.y2, false);
            this.getGraphComponent().asContainer().repaint();
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
        if (this.isActivated()) {
            this.onMouseDragged(mouseEvent);
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        this.setPainted(false);
        if (this.isActivated() && this.getActiveGraph() != null) {
            double d;
            this.x2 = this.xToWorld(mouseEvent.getX());
            this.y2 = this.yToWorld(mouseEvent.getY());
            SelectionWorker selectionWorker = this.getGraphComponent().getSelectionWorker();
            if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                selectionWorker.removeAllFromSelected(this.getActiveGraph());
            }
            if (this.x1 > this.x2) {
                d = this.x1;
                this.x1 = this.x2;
                this.x2 = d;
            }
            if (this.y1 > this.y2) {
                d = this.y1;
                this.y1 = this.y2;
                this.y2 = d;
            }
            if (mouseEvent.isControlDown()) {
                selectionWorker.toggleSelection(this.getActiveGraph(), this.getTransform().boundsToDevice(this.x1, this.y1, this.x2, this.y2));
            } else {
                selectionWorker.addToSelection(this.getActiveGraph(), this.getTransform().boundsToDevice(this.x1, this.y1, this.x2, this.y2));
            }
            this.getGraphComponent().asContainer().repaint();
        }
        this.setTempLockOn(false);
        this.deactivate();
    }

    public void abort() {
        if (this.isPainted()) {
            this.setPainted(false);
            this.getGraphComponent().asContainer().repaint();
            this.setTempLockOn(false);
            this.deactivate();
        }
    }

    public void paint(Graphics graphics) {
        if (this.isActivated() && this.isPainted()) {
            int n = this.getTransform().xToDevice(this.x1);
            int n2 = this.getTransform().xToDevice(this.x2);
            int n3 = this.getTransform().yToDevice(this.y1);
            int n4 = this.getTransform().yToDevice(this.y2);
            graphics.setColor(marqueeColor);
            graphics.drawLine(n, n3, n2, n3);
            graphics.drawLine(n, n3, n, n4);
            graphics.drawLine(n, n4, n2, n4);
            graphics.drawLine(n2, n4, n2, n3);
        }
    }

    public String getName() {
        return "Select objects";
    }

    protected synchronized void activate(ToolEquipped toolEquipped) throws Exception {
        super.activate(toolEquipped);
        this.setTempLockOn(true);
        this.x1 = this.x2 = this.xToWorld((int)this.x1);
        this.y1 = this.y2 = this.yToWorld((int)this.y1);
    }
}

