/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.tool;

import com.cisco.nm.esper.command.ResizeNodeCommand;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.NodeLabel;
import com.cisco.nm.esper.model.ResizeControl;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.shape.Bounds;
import com.cisco.nm.esper.shape.FixedBounds;
import com.cisco.nm.esper.tool.GestureTool;
import com.cisco.nm.esper.tool.ToolEquipped;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Iterator;

public class ResizingTool
extends GestureTool {
    private Node _node;
    private ResizeControl _resizer;
    private Point _startPoint;
    private int _type;
    private NumberFormat formatter = NumberFormat.getNumberInstance();

    public void initialize(Object object, int n, int n2) {
        if (!(object instanceof Node)) {
            throw new IllegalArgumentException("Unexpected object type ".concat(String.valueOf(String.valueOf(object == null ? "null" : object.getClass().getName()))));
        }
        this._node = (Node)object;
        this._startPoint = new Point(n, n2);
        this.setPainted(true);
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        if (this.isPainted()) {
            double d = this.xToWorld(mouseEvent.getX());
            double d2 = this.yToWorld(mouseEvent.getY());
            this.getResizer().onDragTo(d, d2);
            this.setStatusText(this.newStatusText());
            this.makeVisible(d, d2, false);
            this.getGraphComponent().asContainer().repaint();
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        if (this.isPainted()) {
            double d = this.xToWorld(mouseEvent.getX());
            double d2 = this.yToWorld(mouseEvent.getY());
            this.getResizer().onDragTo(d, d2);
            Bounds bounds = this.getResizeNode().getIconBounds();
            this.setPainted(false);
            this.setStatusText(null);
            this.getResizer().onCancel();
            this.setObjectsDragged(false);
            this.commitChanges(bounds);
            this.deactivate();
        }
    }

    public void abort() {
        this.getResizer().onCancel();
        this.setObjectsDragged(false);
        this.getGraphComponent().asContainer().repaint();
        this.deactivate();
    }

    public void paint(Graphics graphics) {
        if (this.isPainted()) {
            Iterator iterator;
            BaseObject baseObject;
            Transform transform = this.getTransform();
            Node node = this.getResizeNode();
            node.paint(graphics, transform);
            Iterator iterator2 = node.labels().iterator();
            while (iterator2.hasNext()) {
                baseObject = (NodeLabel)iterator2.next();
                baseObject.paint(graphics, transform);
            }
            iterator2 = node.inedges();
            while (iterator2.hasNext()) {
                baseObject = (Edge)iterator2.next();
                baseObject.paint(graphics, transform);
                iterator = ((Edge)baseObject).labels().iterator();
                while (iterator.hasNext()) {
                    ((EdgeLabel)iterator.next()).paint(graphics, transform);
                }
            }
            iterator2 = node.outedges();
            while (iterator2.hasNext()) {
                baseObject = (Edge)iterator2.next();
                baseObject.paint(graphics, transform);
                iterator = ((Edge)baseObject).labels().iterator();
                while (iterator.hasNext()) {
                    ((EdgeLabel)iterator.next()).paint(graphics, transform);
                }
            }
        }
    }

    protected synchronized void activate(ToolEquipped toolEquipped) throws Exception {
        super.activate(toolEquipped);
        Transform transform = this.getTransform();
        this._type = this._node.getHitCode(this.getStartPoint().x, this.getStartPoint().y, transform);
        this.setDefaultCursor(Cursor.getPredefinedCursor(this._type));
        this.setActionCursor(Cursor.getPredefinedCursor(this._type));
        toolEquipped.asContainer().setCursor(this.getActionCursor());
        this.getResizer().init(this.getResizeNode(), this._type);
        this.getResizer().setMinimumSize(10.0, 10.0);
        double d = transform.xToWorld(this.getStartPoint().x);
        double d2 = transform.yToWorld(this.getStartPoint().y);
        this.getResizer().onStartAt(d, d2);
        this.setObjectsDragged(true);
    }

    public Point getStartPoint() {
        return this._startPoint;
    }

    public Node getResizeNode() {
        return this._node;
    }

    public int getResizeType() {
        return this._type;
    }

    public ResizeControl getResizer() {
        if (this._resizer == null) {
            this._resizer = new ResizeControl();
        }
        return this._resizer;
    }

    public String getName() {
        return "Resize node";
    }

    public void commitChanges(FixedBounds fixedBounds) {
        this.getGraphComponent().getCommandDispatcher().dispatch(new ResizeNodeCommand(this.getResizeNode(), fixedBounds));
    }

    protected String newStatusText() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.formatter.format(this.getResizeNode().getIconWidth())))).append(" x ").append(this.formatter.format(this.getResizeNode().getIconHeight()))));
    }

    protected void setObjectsDragged(boolean bl) {
        Iterator iterator;
        Edge edge;
        Node node = this.getResizeNode();
        node.setDragged(bl);
        Iterator iterator2 = node.labels().iterator();
        while (iterator2.hasNext()) {
            ((NodeLabel)iterator2.next()).setDragged(bl);
        }
        iterator2 = node.inedges();
        while (iterator2.hasNext()) {
            edge = (Edge)iterator2.next();
            edge.setDragged(bl);
            iterator = edge.labels().iterator();
            while (iterator.hasNext()) {
                ((EdgeLabel)iterator.next()).setDragged(bl);
            }
        }
        iterator2 = node.outedges();
        while (iterator2.hasNext()) {
            edge = (Edge)iterator2.next();
            edge.setDragged(bl);
            iterator = edge.labels().iterator();
            while (iterator.hasNext()) {
                ((EdgeLabel)iterator.next()).setDragged(bl);
            }
        }
    }
}

