/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.tool;

import com.cisco.nm.esper.SelectionWorker;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.Bend;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.GraphMember;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.NodeLabel;
import com.cisco.nm.esper.tool.BendTool;
import com.cisco.nm.esper.tool.GestureTool;
import com.cisco.nm.esper.tool.GraphComponentTool;
import com.cisco.nm.esper.tool.GraphSizeTool;
import com.cisco.nm.esper.tool.JEditTool;
import com.cisco.nm.esper.tool.MarqueeSelectorTool;
import com.cisco.nm.esper.tool.MoveTool;
import com.cisco.nm.esper.tool.ResizingTool;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

public class SelectorTool
extends GraphComponentTool {
    public static final int VOID_DRAG = 0;
    public static final int EDGE_DRAG = 1;
    public static final int OBJECT_DRAG = 2;
    public static final int BORDER_DRAG = 3;
    public static final int DOUBLE_CLICK = 4;
    protected static final int PRE_RESIZE = 1;
    protected static final int PRE_MOVE = 2;
    protected static final int PRE_EDIT = 3;
    protected static final int PRE_BEND = 4;
    protected static final int PRE_MARQUEE = 5;
    protected static final int VOID = 6;
    public static final int MOUSE_SENSITIVITY = 3;
    private int _mode;
    private int mx;
    private int my;
    private int mouseSteps;
    private BaseObject hitObject;
    private boolean ownersToo;
    private GestureTool[] tool = new GestureTool[5];

    public SelectorTool() {
        this.setMode(6);
        this.setActionCursor(Cursor.getPredefinedCursor(12));
        this.setPainted(false);
        this.setMouseSensitivity(3);
        this.setLabelOwnerSelected(true);
        this.setToolForGesture(new MarqueeSelectorTool(), 0);
        this.setToolForGesture(new ResizingTool(), 3);
        this.setToolForGesture(new MoveTool(), 2);
        this.setToolForGesture(new BendTool(), 1);
        this.setToolForGesture(new JEditTool(), 4);
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        GestureTool gestureTool;
        BaseObject baseObject;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.setMouseX(n);
        this.setMouseY(n2);
        Graph graph = this.getTopGraphAt(n, n2);
        if (graph != null) {
            int n3;
            this.setHitObject(graph);
            if (!graph.isRootGraph()) {
                this.select(graph, mouseEvent.getModifiers());
            }
            if ((n3 = graph.getHitCode(n, n2, this.getTransform())) == 12) {
                this.setMode(2);
            } else if (n3 != -1) {
                this.setMode(1);
            }
        } else {
            EdgeLabel edgeLabel = this.getTopEdgeLabelAt(n, n2);
            if (edgeLabel != null) {
                this.setHitObject(edgeLabel);
                this.select(edgeLabel, mouseEvent.getModifiers());
                this.setMode(2);
            } else {
                baseObject = this.getTopNodeLabelAt(n, n2);
                if (baseObject != null) {
                    this.setHitObject(baseObject);
                    this.select(baseObject, mouseEvent.getModifiers());
                    if (((NodeLabel)baseObject).getOwner().isSelected()) {
                        this.setMode(2);
                    } else {
                        this.setMode(6);
                    }
                } else {
                    Node node = this.getTopNodeAt(n, n2);
                    if (node != null) {
                        this.setHitObject(node);
                        this.select(node, mouseEvent.getModifiers());
                        int n4 = node.getHitCode(n, n2, this.getTransform());
                        if (n4 >= 4 && n4 <= 11) {
                            this.setMode(1);
                        } else {
                            this.setMode(2);
                            this.getGraphComponent().asContainer().setCursor(this.getActionCursor());
                        }
                    } else {
                        Bend bend = this.getTopBendAt(n, n2);
                        if (bend == null) {
                            Edge edge = this.getTopEdgeAt(n, n2);
                            if (edge == null) {
                                this.setMode(5);
                                this.setHitObject(null);
                            } else {
                                this.setHitObject(edge);
                                this.select(edge, mouseEvent.getModifiers());
                                this.setMode(4);
                            }
                        } else {
                            this.setHitObject(bend);
                            this.select(bend, mouseEvent.getModifiers());
                            this.setMode(2);
                        }
                    }
                }
            }
        }
        if (mouseEvent.getClickCount() > 1 && this.getHitObject() != null && (gestureTool = this.getToolForGesture(4)) != null && ((baseObject = this.getHitObject()).getClassCode() == 1 || baseObject.getClassCode() == 32 || baseObject.getClassCode() == 64)) {
            this.setMode(6);
            gestureTool.initialize(baseObject, n, n2);
            this.setChildTool(gestureTool);
        }
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        if (this.isIntentionalDrag(mouseEvent)) {
            GestureTool gestureTool = null;
            if (this.getMode() == 2) {
                gestureTool = this.getToolForGesture(2);
            } else if (this.getMode() == 4) {
                gestureTool = this.getToolForGesture(1);
            } else if (this.getMode() == 1) {
                gestureTool = this.getToolForGesture(3);
            } else if (this.getMode() == 5) {
                gestureTool = this.getToolForGesture(0);
            }
            if (this.getMode() == 1 && this.getHitObject() instanceof Graph) {
                GraphSizeTool graphSizeTool = new GraphSizeTool();
                graphSizeTool.initialize(this.getHitObject(), this.getMouseX(), this.getMouseY());
                this.setChildTool(graphSizeTool);
            } else if (gestureTool != null) {
                gestureTool.initialize(this.getHitObject(), this.getMouseX(), this.getMouseY());
                this.setChildTool(gestureTool);
            }
            this.setMode(6);
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        int n3 = this.getOnGraphLocation(n2, n = mouseEvent.getY());
        if (n3 != -1) {
            this.getGraphComponent().asContainer().setCursor(Cursor.getPredefinedCursor(n3));
        } else if (this.isOverEdgeLabel(n2, n) || this.isOverNodeLabel(n2, n)) {
            this.getGraphComponent().asContainer().setCursor(this.getActionCursor());
        } else {
            n3 = this.getOnNodeLocation(n2, n);
            if (n3 != -1) {
                this.getGraphComponent().asContainer().setCursor(Cursor.getPredefinedCursor(n3));
            } else if (this.isOverEdge(n2, n)) {
                this.getGraphComponent().asContainer().setCursor(this.getActionCursor());
            } else {
                this.getGraphComponent().asContainer().setCursor(this.getDefaultCursor());
            }
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        if (this.getMode() == 5 && this.getActiveGraph() != null) {
            this.select(null, mouseEvent.getModifiers());
        }
        this.setMode(6);
    }

    public void setMouseSensitivity(int n) {
        this.mouseSteps = Math.max(0, n);
    }

    public int getMouseSensitivity() {
        return this.mouseSteps;
    }

    public void setLabelOwnerSelected(boolean bl) {
        this.ownersToo = bl;
    }

    public boolean isLabelOwnerSelected() {
        return this.ownersToo;
    }

    public BaseObject getHitObject() {
        return this.hitObject;
    }

    public void setHitObject(BaseObject baseObject) {
        this.hitObject = baseObject;
    }

    protected boolean isIntentionalDrag(MouseEvent mouseEvent) {
        return Math.abs(mouseEvent.getX() - this.getMouseX()) > this.getMouseSensitivity() || Math.abs(mouseEvent.getY() - this.getMouseY()) > this.getMouseSensitivity();
    }

    protected void setMode(int n) {
        this._mode = n;
    }

    protected int getMode() {
        return this._mode;
    }

    protected int getMouseX() {
        return this.mx;
    }

    protected int getMouseY() {
        return this.my;
    }

    protected void setMouseX(int n) {
        this.mx = n;
    }

    protected void setMouseY(int n) {
        this.my = n;
    }

    protected void select(GraphMember graphMember, int n) {
        SelectionWorker selectionWorker = this.getGraphComponent().getSelectionWorker();
        boolean bl = false;
        if ((n & 2) != 0) {
            if (graphMember != null) {
                graphMember.setSelected(!graphMember.isSelected());
                bl = true;
            }
        } else if ((n & 1) != 0) {
            if (graphMember != null && !graphMember.isSelected()) {
                graphMember.setSelected(true);
                bl = true;
            }
        } else if (graphMember == null) {
            bl = selectionWorker.removeAllFromSelected(this.getRootGraph());
        } else if (!graphMember.isSelected()) {
            selectionWorker.removeAllFromSelected(this.getRootGraph());
            graphMember.setSelected(true);
            bl = true;
        }
        if (this.isLabelOwnerSelected()) {
            if (graphMember instanceof NodeLabel) {
                ((NodeLabel)graphMember).getOwner().setSelected(true);
            } else if (graphMember instanceof EdgeLabel) {
                ((EdgeLabel)graphMember).getOwner().setSelected(true);
            }
        }
        if (bl) {
            this.getGraphComponent().asContainer().repaint();
        }
    }

    public String getName() {
        return "Select objects";
    }

    public void setToolForGesture(GestureTool gestureTool, int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Illegal gesture ID ".concat(String.valueOf(String.valueOf(n))));
        }
        this.tool[n] = gestureTool;
    }

    public GestureTool getToolForGesture(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Illegal gesture ID ".concat(String.valueOf(String.valueOf(n))));
        }
        return this.tool[n];
    }

    static {
        VOID_DRAG = 0;
        EDGE_DRAG = 1;
        OBJECT_DRAG = 2;
        BORDER_DRAG = 3;
        DOUBLE_CLICK = 4;
        PRE_RESIZE = 1;
        PRE_MOVE = 2;
        PRE_EDIT = 3;
        PRE_BEND = 4;
        PRE_MARQUEE = 5;
        VOID = 6;
        MOUSE_SENSITIVITY = 3;
    }
}

