/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.tool;

import com.cisco.nm.EsperStrings;
import com.cisco.nm.esper.tool.Tool;
import com.cisco.nm.esper.tool.ToolEquipped;
import com.cisco.nm.esper.tool.event.ToolEvent;
import com.cisco.nm.esper.tool.event.ToolListener;
import com.cisco.nm.lib.Debug;
import com.cisco.nm.lib.winkit.PlainContainer;
import java.awt.Container;
import java.util.Vector;

public abstract class TooledComponent
extends PlainContainer
implements ToolEquipped {
    private Tool tool;
    private Vector _toolListeners;

    public Container asContainer() {
        return this;
    }

    public void setTool(Tool tool) {
        if (this.tool != null) {
            this.tool.abort();
            if (!this.tool.isTerminated()) {
                this.tool.terminate();
                this.fireToolEvent(this.tool, 64);
            }
        }
        this.tool = tool;
        try {
            if (this.tool != null) {
                this.tool.activate(this);
                this.fireToolEvent(this.tool, 32);
            }
        }
        catch (Exception exception) {
            Debug.println(5, String.valueOf(String.valueOf(new StringBuffer("Unable to activate ").append(tool.getName()).append(" due to ").append(exception.getMessage()))));
            this.setTool(null);
        }
    }

    public Tool getTool() {
        return this.tool;
    }

    public Tool getActiveTool() {
        return this.getTool() == null ? null : this.getTool().getActiveTool();
    }

    public void fireToolEvent(Tool tool, int n) {
        if (this.getToolListenerCount() > 0) {
            this.fireToolEvent(new ToolEvent(tool, n));
        }
    }

    protected void fireToolEvent(ToolEvent toolEvent) {
        if (this.getToolListenerCount() > 0) {
            Vector vector = this._toolListeners;
            synchronized (vector) {
                block13: for (int i = 0; i < this.getToolListenerCount(); ++i) {
                    ToolListener toolListener = this.getToolListener(i);
                    switch (toolEvent.getType()) {
                        case 32: {
                            toolListener.toolActivated(toolEvent);
                            continue block13;
                        }
                        case 33: {
                            toolListener.toolActivating(toolEvent);
                            continue block13;
                        }
                        case 64: {
                            toolListener.toolTerminated(toolEvent);
                            continue block13;
                        }
                        case 65: {
                            toolListener.toolTerminating(toolEvent);
                            continue block13;
                        }
                        case 16: {
                            toolListener.toolSuspended(toolEvent);
                            continue block13;
                        }
                        case 17: {
                            toolListener.toolSuspending(toolEvent);
                            continue block13;
                        }
                        case 48: {
                            toolListener.toolResumed(toolEvent);
                            continue block13;
                        }
                        case 49: {
                            toolListener.toolResuming(toolEvent);
                        }
                    }
                }
            }
        }
    }

    public void addToolListener(ToolListener toolListener) {
        if (toolListener != null) {
            if (this._toolListeners == null) {
                this._toolListeners = new Vector(5, 5);
            }
            this._toolListeners.addElement(toolListener);
        }
    }

    public void removeToolListener(ToolListener toolListener) {
        if (toolListener != null && this._toolListeners != null) {
            this._toolListeners.removeElement(toolListener);
            if (this._toolListeners.size() <= 0) {
                this._toolListeners = null;
            }
        }
    }

    public int getToolListenerCount() {
        return this._toolListeners == null ? 0 : this._toolListeners.size();
    }

    public ToolListener getToolListener(int n) {
        if (this._toolListeners == null) {
            throw new IndexOutOfBoundsException(EsperStrings.string(4));
        }
        return (ToolListener)this._toolListeners.elementAt(n);
    }
}

