/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.tool.event;

import com.cisco.nm.esper.tool.event.EventEnvelope;
import com.cisco.nm.esper.tool.event.EventQueue;
import com.cisco.nm.lib.Debug;
import java.awt.AWTEvent;
import java.awt.event.AWTEventListener;

public class EventDistributor
extends Thread {
    public static final EventDistributor INSTANCE = new EventDistributor();
    private EventQueue _queue = new EventQueue();
    private boolean terminated = false;
    private boolean compress = true;

    public EventDistributor() {
        super("EventDistributor");
        this.setDaemon(true);
        this.setPriority(2);
        this.start();
    }

    public synchronized void deliver(AWTEvent aWTEvent, AWTEventListener aWTEventListener) {
        this.getQueue().enqueue(new EventEnvelope(aWTEvent, aWTEventListener));
        this.notify();
    }

    protected synchronized EventEnvelope fetch() {
        while (this.getQueue().isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (!this.isTerminated()) continue;
                EventEnvelope eventEnvelope = null;
                return eventEnvelope;
            }
        }
        EventEnvelope eventEnvelope = (EventEnvelope)this.getQueue().dequeue();
        if (this.isCompressing()) {
            EventEnvelope eventEnvelope2;
            while (!this.getQueue().isEmpty() && (eventEnvelope2 = (EventEnvelope)this.getQueue().first()).getAWTEventListener() == eventEnvelope.getAWTEventListener() && eventEnvelope2.getEvent().getID() == eventEnvelope.getEvent().getID()) {
                eventEnvelope = eventEnvelope2;
                this.getQueue().dequeue();
            }
        }
        return eventEnvelope;
    }

    public synchronized void run() {
        while (!this.isTerminated()) {
            EventEnvelope eventEnvelope = this.fetch();
            if (eventEnvelope == null) continue;
            try {
                eventEnvelope.getAWTEventListener().eventDispatched(eventEnvelope.getEvent());
            }
            catch (Throwable throwable) {
                Debug.println(10, "Delivery exception in EventDistributor.");
                Debug.println(throwable);
            }
        }
    }

    public synchronized void terminate() {
        this.terminated = true;
        this.interrupt();
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean isCompressing() {
        return this.compress;
    }

    public void setCompressing(boolean bl) {
        this.compress = bl;
    }

    public EventQueue getQueue() {
        return this._queue;
    }
}

