/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.tool.event;

import com.cisco.nm.EsperStrings;
import java.util.NoSuchElementException;

public class EventQueue {
    private Cell head;
    private Cell tail;
    private int size;

    public EventQueue() {
        Cell cell = new Cell();
        Cell cell2 = new Cell();
        cell.setNext(cell2);
        cell2.setNext(cell);
        this.size = 0;
        this.setHead(cell);
        this.setTail(cell);
    }

    public synchronized void enqueue(Object object) {
        if (object != null) {
            Cell cell = this.getTail();
            cell.setObject(object);
            Cell cell2 = cell.getNext();
            if (cell2.getObject() == null) {
                this.setTail(cell2);
            } else {
                Cell cell3 = new Cell(null, cell2);
                cell.setNext(cell3);
                this.setTail(cell3);
            }
            ++this.size;
        }
    }

    public synchronized Object dequeue() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Cell cell = this.getHead();
        Object object = cell.getObject();
        cell.setObject(null);
        this.setHead(cell.getNext());
        --this.size;
        return object;
    }

    public Object first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException(EsperStrings.string(2));
        }
        return this.getHead().getObject();
    }

    public Object last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException(EsperStrings.string(2));
        }
        return this.getTail().getObject();
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    protected Cell getHead() {
        return this.head;
    }

    protected Cell getTail() {
        return this.tail;
    }

    protected Cell setHead(Cell cell) {
        this.head = cell;
        return this.head;
    }

    protected Cell setTail(Cell cell) {
        this.tail = cell;
        return this.tail;
    }

    private static class Cell
    implements Cloneable {
        private Object object;
        private transient Cell next;
        private transient Cell prev;

        public Cell() {
            this(null, null);
        }

        public Cell(Object object) {
            this(object, null);
        }

        public Cell(Object object, Cell cell) {
            this.object = object;
            this.next = cell;
        }

        public Object clone() {
            return new Cell(this.getObject());
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public String toString() {
            return String.valueOf(this.getObject());
        }

        public Cell getNext() {
            return this.next;
        }

        public Cell setNext(Cell cell) {
            this.next = cell;
            return this.next;
        }

        public Object getObject() {
            return this.object;
        }

        public Object setObject(Object object) {
            this.object = object;
            return this.object;
        }
    }
}

