/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.lib;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Debug {
    public static final int ERROR = 10;
    public static final int WARNING = 5;
    public static final int INFORMATION = 1;
    public static final int DEBUG = 0;
    static int _level;
    static PrintWriter _stream;
    static boolean longMsgStyle;
    static boolean enabled;
    static Class class$com$cisco$nm$lib$Debug;

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean bl) {
        enabled = bl;
    }

    public static void setTraceLevel(int n) {
        _level = Math.max(0, Math.min(10, n));
    }

    public static void setFullMessageStyleUsed(boolean bl) {
        longMsgStyle = bl;
    }

    public static boolean isFullMessageStyleUsed() {
        return longMsgStyle;
    }

    public static int getTraceLevel() {
        return _level;
    }

    public static void println(String string) {
        Debug.println(1, string);
    }

    public static void println(Object object) {
        Debug.println(1, object);
    }

    public static void println(int n, Object object) {
        Debug.println(n, String.valueOf(object));
    }

    public static void println(Throwable throwable) {
        Debug.println(10, throwable);
    }

    public static void println(int n, Throwable throwable) {
        Debug.println(n, Debug.getStackTrace(throwable));
    }

    public static void println(int n, String string) {
        if (Debug.isEnabled() && n >= Debug.getTraceLevel()) {
            if (Debug.isFullMessageStyleUsed()) {
                Debug.getPrintWriter().print("DEBUG at ");
                String string2 = Debug.getCallersTrace(new Throwable(), "println");
                if (string2 != null) {
                    int n2 = string2.indexOf(40);
                    String string3 = string2.substring(3, n2);
                    String string4 = string2.substring(n2 + 1, string2.length() - 1);
                    int n3 = string4.indexOf(58);
                    if (n3 != -1) {
                        Debug.getPrintWriter().print(string4.substring(0, n3));
                        Debug.getPrintWriter().print(", line ");
                        Debug.getPrintWriter().print(string4.substring(n3 + 1));
                        Debug.getPrintWriter().print(" in package ");
                    }
                    int n4 = string3.lastIndexOf(46);
                    String string5 = string3.substring(0, n4);
                    String string6 = (n4 = string5.lastIndexOf(46)) == -1 ? "default" : string5.substring(0, n4);
                    Debug.getPrintWriter().print(string6);
                    Debug.getPrintWriter().println(":");
                    Debug.getPrintWriter().print('\t');
                }
            }
            Debug.getPrintWriter().println(string);
        }
    }

    public static void setPrintWriter(PrintWriter printWriter) {
        if (printWriter != null) {
            _stream = printWriter;
        }
    }

    public static void setPrintWriter(String string) throws IOException {
        Debug.setPrintWriter(new PrintWriter(new FileWriter(string)));
    }

    public static PrintWriter getPrintWriter() {
        return _stream;
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void assert(boolean bl) throws RuntimeException {
        Debug.assert(bl, null);
    }

    public static void assert(boolean bl, String string) throws RuntimeException {
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer("Assertion failed ");
            String string2 = Debug.getCallersTrace(new Throwable(), "assert");
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            if (string != null) {
                stringBuffer.append(": ").append(string);
            }
            throw new RuntimeException(stringBuffer.toString());
        }
    }

    private static String getCallersTrace(Throwable throwable, String string) {
        String string2;
        if (throwable == null) {
            return null;
        }
        String string3 = Debug.getStackTrace(throwable);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "\n");
        String string4 = String.valueOf(String.valueOf(new StringBuffer("at ").append((class$com$cisco$nm$lib$Debug == null ? (class$com$cisco$nm$lib$Debug = Debug.class$("com.cisco.nm.lib.Debug")) : class$com$cisco$nm$lib$Debug).getName()).append(".").append(string)));
        while (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()).indexOf(string4) == -1) {
        }
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.indexOf(string4) != -1) continue;
            return string2.trim();
        }
        return null;
    }

    public static String getDefaultFileName() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer stringBuffer = new StringBuffer(17);
        stringBuffer.append("debug");
        if (calendar.get(2) < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(calendar.get(2));
        if (calendar.get(5) < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(calendar.get(5));
        if (calendar.get(11) < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(calendar.get(11));
        if (calendar.get(12) < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(calendar.get(12));
        return stringBuffer.append(".log").toString();
    }

    public static PrintWriter getDefaultFileWriter() {
        try {
            PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(Debug.getDefaultFileName())), true);
            return printWriter;
        }
        catch (IOException iOException) {
            PrintWriter printWriter = null;
            return printWriter;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ERROR = 10;
        WARNING = 5;
        INFORMATION = 1;
        DEBUG = 0;
        _level = 10;
        _stream = new PrintWriter(System.out, true);
        longMsgStyle = false;
        enabled = false;
        try {
            String string;
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkPropertyAccess("debug");
            }
            if ((string = System.getProperty("debug")) == null) {
                string = System.getProperty("DEBUG");
            }
            if (string == null) {
                string = System.getProperty("Debug");
            }
            if (string == null) {
                string = "none";
            } else if (string.length() == 0) {
                string = "on";
            }
            if ("none".equalsIgnoreCase(string) || "off".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string)) {
                enabled = false;
            } else {
                enabled = true;
                if ("dev".equalsIgnoreCase(string) || "full".equalsIgnoreCase(string)) {
                    _level = 0;
                } else if ("trace".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string)) {
                    _level = 5;
                } else {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("Unknown debug level \"").append(string).append("\""))));
                    enabled = false;
                }
            }
        }
        catch (SecurityException securityException) {
            System.err.println("Unable to read the debug property");
        }
        Debug.println("Debug on at level ".concat(String.valueOf(String.valueOf(Debug.getTraceLevel()))));
    }
}

