/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.lib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;

public class TextResources {
    private String[] text;

    public TextResources(String string) {
        this(string, Locale.getDefault());
    }

    public TextResources(String string, Locale locale) {
        String string2 = locale.getLanguage();
        String string3 = locale.getCountry();
        boolean bl = false;
        if (string2 != null && string2.length() > 0) {
            if (string3 != null && string3.length() > 0) {
                bl = this.load(string + "_" + string2 + "_" + string3);
            }
            if (!bl) {
                bl = this.load(string + "_" + string2);
            }
        }
        if (!bl) {
            bl = this.load(string);
        }
        if (!bl) {
            throw new MissingResourceException(string, this.getClass().getName(), locale.toString());
        }
    }

    private boolean load(String string) {
        String string2 = string.replace('.', '/') + ".properties";
        try {
            String string3;
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string2);
            if (inputStream == null) {
                return false;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            ArrayList<String> arrayList = new ArrayList<String>(100);
            while ((string3 = bufferedReader.readLine()) != null) {
                String string4 = string3.trim();
                if (string4.length() <= 0 || string4.charAt(0) == '#') continue;
                arrayList.add(string3);
            }
            bufferedReader.close();
            this.text = new String[arrayList.size()];
            arrayList.toArray(this.text);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String getMessage(int n) {
        return this.getMessage(n, null);
    }

    public String getMessage(int n, Object object) {
        return this.getMessage(n, new Object[]{object});
    }

    public String getMessage(int n, Object object, Object object2) {
        return this.getMessage(n, new Object[]{object, object2});
    }

    public String getMessage(int n, Object object, Object object2, Object object3) {
        return this.getMessage(n, new Object[]{object, object2, object3});
    }

    public String getMessage(int n, Object[] objectArray) throws MissingResourceException {
        return MessageFormat.format(this.text[n], objectArray);
    }
}

