/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.lib.command;

import com.cisco.nm.lib.command.Command;
import com.cisco.nm.lib.command.CommandListener;
import com.cisco.nm.lib.command.GroupCommand;
import java.util.AbstractCollection;
import java.util.ArrayList;

public class CommandDispatcher {
    private ArrayList listeners;
    private ArrayList backup;

    public void addCommandListener(CommandListener commandListener) {
        if (commandListener != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList(5);
            }
            this.listeners.add(commandListener);
        }
    }

    public void removeCommandListener(CommandListener commandListener) {
        if (this.listeners != null && this.listeners.size() > 0) {
            ((AbstractCollection)this.listeners).remove(commandListener);
            if (this.listeners.size() <= 0) {
                this.listeners = null;
            }
        }
    }

    public CommandListener getCommandListener(int n) {
        if (this.listeners == null) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return (CommandListener)this.listeners.get(n);
    }

    public int getCommandListenerCount() {
        return this.listeners == null ? 0 : this.listeners.size();
    }

    public void dispatch(Command command) {
        if (command != null && this.listeners != null) {
            GroupCommand groupCommand;
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                if (this.backup == null) {
                    this.backup = new ArrayList(this.listeners.size());
                } else {
                    this.backup.clear();
                    this.backup.ensureCapacity(this.listeners.size());
                }
                this.backup.addAll(this.listeners);
            }
            if (command instanceof GroupCommand && (groupCommand = (GroupCommand)command).getCommandCount() == 1) {
                command = groupCommand.getCommand(0);
            }
            for (int i = this.backup.size() - 1; i >= 0; --i) {
                ((CommandListener)this.backup.get(i)).commandDispatched(command);
            }
        }
    }
}

