/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.lib.winkit;

import com.cisco.nm.lib.winkit.BasicAction;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class ExitAction
extends BasicAction
implements WindowListener {
    public static final int TERMINATE = 0;
    public static final int DISPOSE = 0;
    public static final int HIDE = 2;
    public static final int DO_NOTHING = 3;
    public static final String EXIT_ACTION = "exit";
    int mode;

    public ExitAction() {
        this(0);
    }

    public ExitAction(int n) {
        if (n != 0 && n != 0 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Illegal action mode ".concat(String.valueOf(String.valueOf(n))));
        }
        this.mode = n;
    }

    public boolean isAbleToHandle(ActionEvent actionEvent) {
        return actionEvent != null && EXIT_ACTION.equals(actionEvent.getActionCommand());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            if (!EXIT_ACTION.equals(string)) {
                throw new IllegalArgumentException("Unknown command ".concat(String.valueOf(String.valueOf(string))));
            }
            this.execute(actionEvent.getSource());
        }
        catch (Exception exception) {
            this.fireExceptionEvent(exception);
        }
    }

    private int getMode() {
        return this.mode;
    }

    private void execute(Object object) {
        if (this.getMode() == 0) {
            System.exit(0);
        } else if (this.getMode() != 3) {
            Window window = null;
            if (object instanceof Component) {
                window = ExitAction.getParentWindow((Component)object);
            }
            if (window != null) {
                if (this.getMode() == 2) {
                    ((Component)window).setVisible(false);
                } else {
                    ((Component)window).setVisible(false);
                    window.dispose();
                }
            }
        }
    }

    private static Window getParentWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.execute(windowEvent.getWindow());
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    static {
        TERMINATE = 0;
        DISPOSE = 0;
        HIDE = 2;
        DO_NOTHING = 3;
        EXIT_ACTION = EXIT_ACTION;
    }
}

