/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.DsDef;
import org.jrobin.core.Header;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDouble;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdFile;
import org.jrobin.core.RrdLong;
import org.jrobin.core.RrdString;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Util;
import org.jrobin.core.XmlReader;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Datasource
implements RrdUpdater {
    private RrdDb parentDb;
    private RrdString dsName;
    private RrdString dsType;
    private RrdLong heartbeat;
    private RrdDouble minValue;
    private RrdDouble maxValue;
    private RrdDouble lastValue;
    private RrdLong nanSeconds;
    private RrdDouble accumValue;
    private RrdLong lastUpdateTime;
    private RrdString[] comment;
    static final int COMMENT_FIELDS = 5;

    Datasource(RrdDb parentDb, DsDef dsDef) throws IOException {
        this.parentDb = parentDb;
        this.dsName = new RrdString(dsDef.getDsName(), this);
        this.dsType = new RrdString(dsDef.getDsType(), this);
        this.heartbeat = new RrdLong(dsDef.getHeartbeat(), this);
        this.minValue = new RrdDouble(dsDef.getMinValue(), this);
        this.maxValue = new RrdDouble(dsDef.getMaxValue(), this);
        this.lastValue = new RrdDouble(Double.NaN, this);
        this.accumValue = new RrdDouble(0.0, this);
        Header header = parentDb.getHeader();
        this.nanSeconds = new RrdLong(header.getLastUpdateTime() % header.getStep(), this);
        if (parentDb.getHeader().isMultiRrd()) {
            this.lastUpdateTime = new RrdLong(header.getLastUpdateTime(), this);
            this.comment = new RrdString[5];
            String commentValue = dsDef.getComment();
            for (int i = 0; i < 5; ++i) {
                if (commentValue == null) {
                    this.comment[i] = new RrdString("", this);
                    continue;
                }
                if (this.comment.length > (i - 1) * 20) {
                    if (this.comment.length < i * 20) {
                        this.comment[i] = new RrdString(commentValue.substring(i * 20), this);
                        continue;
                    }
                    this.comment[i] = new RrdString(commentValue.substring(i * 20, i * 20 + 20), this);
                    continue;
                }
                this.comment[i] = new RrdString("", this);
            }
        }
    }

    Datasource(RrdDb parentDb) throws IOException {
        this.parentDb = parentDb;
        this.dsName = new RrdString(this);
        this.dsType = new RrdString(this);
        this.heartbeat = new RrdLong(this);
        this.minValue = new RrdDouble(this);
        this.maxValue = new RrdDouble(this);
        this.lastValue = new RrdDouble(this);
        this.accumValue = new RrdDouble(this);
        this.nanSeconds = new RrdLong(this);
        if (parentDb.getHeader().isMultiRrd()) {
            this.lastUpdateTime = new RrdLong(this);
            this.comment = new RrdString[5];
            for (int i = 0; i < 5; ++i) {
                this.comment[i] = new RrdString(this);
            }
        }
    }

    Datasource(RrdDb parentDb, XmlReader reader, int dsIndex) throws IOException, RrdException {
        this.parentDb = parentDb;
        this.dsName = new RrdString(reader.getDsName(dsIndex), this);
        this.dsType = new RrdString(reader.getDsType(dsIndex), this);
        this.heartbeat = new RrdLong(reader.getHeartbeat(dsIndex), this);
        this.minValue = new RrdDouble(reader.getMinValue(dsIndex), this);
        this.maxValue = new RrdDouble(reader.getMaxValue(dsIndex), this);
        this.lastValue = new RrdDouble(reader.getLastValue(dsIndex), this);
        this.accumValue = new RrdDouble(reader.getAccumValue(dsIndex), this);
        this.nanSeconds = new RrdLong(reader.getNanSeconds(dsIndex), this);
        if (parentDb.getHeader().isMultiRrd()) {
            this.lastUpdateTime = new RrdLong(reader.getLastUpdateTime(dsIndex), this);
            this.comment = new RrdString[5];
            for (int i = 0; i < 5; ++i) {
                this.comment[i] = new RrdString(reader.getComment(dsIndex, i), this);
            }
        }
    }

    String dump() throws IOException {
        return "== DATASOURCE ==\nDS:" + this.dsName.get() + ":" + this.dsType.get() + ":" + this.heartbeat.get() + ":" + this.minValue.get() + ":" + this.maxValue.get() + "\nlastValue:" + this.lastValue.get() + " nanSeconds:" + this.nanSeconds.get() + " accumValue:" + this.accumValue.get() + "\n";
    }

    @Override
    public RrdFile getRrdFile() {
        return this.parentDb.getRrdFile();
    }

    public String getDsName() throws IOException {
        return this.dsName.get();
    }

    public String getDsType() throws IOException {
        return this.dsType.get();
    }

    public long getHeartbeat() throws IOException {
        return this.heartbeat.get();
    }

    public double getMinValue() throws IOException {
        return this.minValue.get();
    }

    public double getMaxValue() throws IOException {
        return this.maxValue.get();
    }

    public double getLastValue() throws IOException {
        return this.lastValue.get();
    }

    public void setLastValue(double v) throws IOException {
        this.lastValue.set(v);
    }

    public void setComment(String commentValue) throws IOException {
        for (int i = 0; i < 5; ++i) {
            if (commentValue == null) {
                this.comment[i].set("");
                continue;
            }
            if (commentValue.length() > i * 20) {
                this.comment[i].set(commentValue.substring(i * 20));
                continue;
            }
            this.comment[i].set("");
        }
    }

    public void setDsType(String type) throws IOException {
        this.dsType.set(type);
    }

    void process(long newTime, double newValue) throws IOException, RrdException {
        Header header = this.parentDb.getHeader();
        long step = header.getStep();
        long oldTime = this.getLastUpdateTime();
        long startTime = Util.normalize(oldTime, step);
        long endTime = startTime + step;
        double oldValue = this.lastValue.get();
        double updateValue = this.calculateUpdateValue(oldTime, oldValue, newTime, newValue);
        if (newTime < endTime) {
            this.accumulate(oldTime, newTime, updateValue);
        } else {
            long boundaryTime = Util.normalize(newTime, step);
            this.accumulate(oldTime, boundaryTime, updateValue);
            double value = this.calculateTotal(startTime, boundaryTime);
            long numSteps = (boundaryTime - endTime) / step + 1L;
            this.parentDb.archive(this, value, numSteps);
            this.nanSeconds.set(0L);
            this.accumValue.set(0.0);
            if (!this.isAbsoluteCounter()) {
                this.accumulate(boundaryTime, newTime, updateValue);
            }
        }
    }

    private double calculateUpdateValue(long oldTime, double oldValue, long newTime, double newValue) throws IOException {
        double updateValue = Double.NaN;
        if ((double)(newTime - oldTime) <= (double)this.heartbeat.get() * 1.5) {
            String type = this.dsType.get();
            if (type.equals("GAUGE")) {
                updateValue = newValue;
            } else if (type.equals("ABSOLUTE")) {
                if (!Double.isNaN(newValue)) {
                    updateValue = newValue - oldValue;
                    double max32bit = Math.pow(2.0, 32.0);
                    double max64bit = Math.pow(2.0, 64.0);
                    if (updateValue < 0.0) {
                        updateValue += max32bit;
                    }
                    if (updateValue < 0.0) {
                        updateValue += max64bit - max32bit;
                    }
                    if (updateValue > 3.2E9) {
                        updateValue = Double.NaN;
                    }
                }
            } else if (type.equals("DERIVE")) {
                if (!Double.isNaN(newValue) && !Double.isNaN(oldValue)) {
                    updateValue = (newValue - oldValue) / (double)(newTime - oldTime);
                }
            } else if (type.equals("COUNTER") && !Double.isNaN(newValue) && !Double.isNaN(oldValue)) {
                double diff = newValue - oldValue;
                double max32bit = Math.pow(2.0, 32.0);
                double max64bit = Math.pow(2.0, 64.0);
                if (diff < 0.0) {
                    diff += max32bit;
                }
                if (diff < 0.0) {
                    diff += max64bit - max32bit;
                }
                if (diff >= 0.0 && (updateValue = diff / (double)(newTime - oldTime)) > 3.2E9) {
                    updateValue = Double.NaN;
                }
            }
            if (!Double.isNaN(updateValue)) {
                double minVal = this.minValue.get();
                double maxVal = this.maxValue.get();
                if (!Double.isNaN(minVal) && updateValue < minVal) {
                    updateValue = Double.NaN;
                }
                if (!Double.isNaN(maxVal) && updateValue > maxVal) {
                    updateValue = Double.NaN;
                }
            }
        }
        this.lastValue.set(newValue);
        return updateValue;
    }

    public boolean isAbsoluteCounter() {
        try {
            String type = this.dsType.get();
            return type.equals("ABSOLUTE") || type.equals("GAUGE");
        }
        catch (IOException ex) {
            System.err.println("Get datasource type error : " + ex.getMessage());
            return false;
        }
    }

    private void accumulate(long oldTime, long newTime, double updateValue) throws IOException {
        if (Double.isNaN(updateValue)) {
            this.nanSeconds.set(this.nanSeconds.get() + (newTime - oldTime));
        } else if (this.isAbsoluteCounter()) {
            this.accumValue.set(this.accumValue.get() + updateValue);
        } else {
            this.accumValue.set(this.accumValue.get() + updateValue * (double)(newTime - oldTime));
        }
    }

    private double calculateTotal(long startTime, long boundaryTime) throws IOException {
        double totalValue = Double.NaN;
        long validSeconds = boundaryTime - startTime - this.nanSeconds.get();
        if (this.nanSeconds.get() <= this.heartbeat.get() && validSeconds > 0L) {
            totalValue = this.isAbsoluteCounter() ? this.accumValue.get() : this.accumValue.get() / (double)validSeconds;
        }
        return totalValue;
    }

    void appendXml(Element parent) throws IOException {
        Document doc = parent.getOwnerDocument();
        Element dsElem = doc.createElement("ds");
        Element nameElem = doc.createElement("name");
        nameElem.appendChild(doc.createTextNode(this.dsName.get()));
        Element typeElem = doc.createElement("type");
        typeElem.appendChild(doc.createTextNode(this.dsType.get()));
        Element hearbeatElem = doc.createElement("minimal_heartbeat");
        hearbeatElem.appendChild(doc.createTextNode("" + this.heartbeat.get()));
        Element minElem = doc.createElement("min");
        minElem.appendChild(doc.createTextNode(Util.formatDoubleXml(this.minValue.get())));
        Element maxElem = doc.createElement("max");
        maxElem.appendChild(doc.createTextNode(Util.formatDoubleXml(this.maxValue.get())));
        Comment stateComment = doc.createComment("PDP Status");
        Element lastDsElem = doc.createElement("last_ds");
        lastDsElem.appendChild(doc.createTextNode("" + Util.formatDoubleXml(this.lastValue.get())));
        Element valueElem = doc.createElement("value");
        valueElem.appendChild(doc.createTextNode("" + Util.formatDoubleXml(this.accumValue.get())));
        Element lastElem = doc.createElement("last_updtime");
        lastElem.appendChild(doc.createTextNode("" + this.lastUpdateTime.get()));
        Element comment0Elem = doc.createElement("comment0");
        String commentVal = this.comment[0].get().length() == 0 ? " " : this.comment[0].get();
        comment0Elem.appendChild(doc.createTextNode("" + commentVal));
        Element comment1Elem = doc.createElement("comment1");
        commentVal = this.comment[1].get().length() == 0 ? " " : this.comment[1].get();
        comment1Elem.appendChild(doc.createTextNode("" + commentVal));
        Element comment2Elem = doc.createElement("comment2");
        commentVal = this.comment[2].get().length() == 0 ? " " : this.comment[2].get();
        comment2Elem.appendChild(doc.createTextNode("" + commentVal));
        Element comment3Elem = doc.createElement("comment3");
        commentVal = this.comment[3].get().length() == 0 ? " " : this.comment[3].get();
        comment3Elem.appendChild(doc.createTextNode("" + commentVal));
        Element comment4Elem = doc.createElement("comment4");
        commentVal = this.comment[4].get().length() == 0 ? " " : this.comment[4].get();
        comment4Elem.appendChild(doc.createTextNode("" + commentVal));
        Element unknownElem = doc.createElement("unknown_sec");
        unknownElem.appendChild(doc.createTextNode("" + this.nanSeconds.get()));
        parent.appendChild(dsElem);
        dsElem.appendChild(nameElem);
        dsElem.appendChild(typeElem);
        dsElem.appendChild(hearbeatElem);
        dsElem.appendChild(minElem);
        dsElem.appendChild(maxElem);
        dsElem.appendChild(stateComment);
        dsElem.appendChild(lastDsElem);
        dsElem.appendChild(valueElem);
        dsElem.appendChild(lastElem);
        dsElem.appendChild(comment0Elem);
        dsElem.appendChild(comment1Elem);
        dsElem.appendChild(comment2Elem);
        dsElem.appendChild(comment3Elem);
        dsElem.appendChild(comment4Elem);
        dsElem.appendChild(unknownElem);
    }

    public double getAccumValue() throws IOException {
        return this.accumValue.get();
    }

    public long getNanSeconds() throws IOException {
        return this.nanSeconds.get();
    }

    public long getLastUpdateTime() throws IOException {
        return this.lastUpdateTime.get();
    }

    public String getComment() throws IOException {
        if (this.comment == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 5; ++i) {
            buf.append(this.comment[i].get());
        }
        return buf.toString().trim();
    }

    public void setLastUpdateTime(long lastUpdateTimeIn) throws IOException {
        this.lastUpdateTime.set(lastUpdateTimeIn);
    }
}

