/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.Archive;
import org.jrobin.core.RrdDouble;
import org.jrobin.core.RrdFile;
import org.jrobin.core.RrdInt;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Util;

public class Robin
implements RrdUpdater {
    private Archive parentArc;
    private RrdInt pointer;
    public RrdDouble values;
    private int rows;

    Robin(Archive parentArc, int rows, boolean newRobin) throws IOException {
        this.parentArc = parentArc;
        this.rows = rows;
        this.pointer = new RrdInt(this);
        this.values = new RrdDouble(this, rows);
        if (newRobin) {
            this.pointer.set(0);
            for (int i = 0; i < rows; ++i) {
                this.values.set(i, Double.NaN);
            }
        }
    }

    public double[] getValues() throws IOException {
        int start;
        double[] result = new double[this.rows];
        int i = start = this.pointer.get();
        int j = 0;
        while (i < start + this.rows) {
            result[j] = this.values.get(i % this.rows);
            ++i;
            ++j;
        }
        return result;
    }

    void store(double newValue) throws IOException {
        int position = this.pointer.get();
        this.values.set(position, newValue);
        this.pointer.set((position + 1) % this.rows);
    }

    @Override
    public RrdFile getRrdFile() {
        return this.parentArc.getRrdFile();
    }

    public String dump() throws IOException {
        int startPos;
        StringBuffer buffer = new StringBuffer("Bucket " + this.pointer.get() + "/" + this.rows + ": ");
        for (int i = startPos = this.pointer.get(); i < startPos + this.rows; ++i) {
            buffer.append(Util.formatDouble(this.values.get(i % this.rows)) + " ");
        }
        buffer.append("\n");
        return buffer.toString();
    }

    double getValue(int index) throws IOException {
        return this.values.get((this.pointer.get() + index) % this.rows);
    }
}

