/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.io.IOException;
import org.jrobin.core.FetchPoint;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.graph.DataPoint;
import org.jrobin.graph.Source;
import org.jrobin.graph.ValueCollection;
import org.jrobin.graph.ValueExtractor;

public class Def
extends Source {
    private String rrdPath;
    private String dsName;
    private String consolFun;
    private ValueExtractor valueExtractor;

    Def(String name, String rrdPath, String dsName, String consolFun) {
        super(name);
        this.rrdPath = rrdPath;
        this.dsName = dsName;
        this.consolFun = consolFun;
    }

    @Override
    void setInterval(long start, long end) throws RrdException, IOException {
        RrdDb rrd = new RrdDb(this.rrdPath);
        int dsIndex = rrd.getDsIndex(this.dsName);
        int[] indexes = new int[]{dsIndex};
        FetchRequest request = rrd.createFetchRequest(this.consolFun, start, end, 1L, indexes);
        request.setDsPattern(this.dsName);
        FetchPoint[] fetchPoints = request.fetch();
        int numPoints = fetchPoints.length;
        DataPoint[] points = new DataPoint[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            long time = fetchPoints[i].getTime();
            double value = fetchPoints[i].getValue(0);
            points[i] = new DataPoint(time, value);
        }
        rrd.close();
        this.valueExtractor = new ValueExtractor(points);
    }

    @Override
    public double getValue(long timestamp, ValueCollection values) throws RrdException {
        if (this.valueExtractor == null) {
            throw new RrdException("Could not obtain values from graph source [" + this.name + "]");
        }
        return this.valueExtractor.getValue(timestamp);
    }

    public String getConsolFun() {
        return this.consolFun;
    }
}

