/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Color;
import org.jfree.data.time.RegularTimePeriod;
import org.jrobin.core.Util;
import org.jrobin.graph.RrdTimeSeries;
import org.jrobin.graph.Source;

class PlotDef {
    public static final float DEFAULT_LINE_WIDTH = 1.0f;
    protected Source source;
    protected Color color;
    protected String legend;
    protected PlotDef parent;
    private RrdTimeSeries totalSeries;
    private float lineWidth = 1.0f;

    PlotDef(Source source, Color color, String legend) {
        this.source = source;
        this.color = color;
        this.legend = legend;
    }

    void stack(PlotDef parent) {
        this.parent = parent;
    }

    public Color getColor() {
        return this.color;
    }

    public String getLegend() {
        return this.legend;
    }

    public void setLegend(double avg, double max, boolean isError, boolean onlyAvg, boolean onlyMax) {
        if (this.legend == null) {
            this.legend = "";
            return;
        }
        if (this.legend.startsWith("--")) {
            this.legend = this.legend.substring(2);
            return;
        }
        this.legend = onlyAvg ? this.legend + ": Avg " + Util.format(avg) : (onlyMax || isError ? this.legend + ": Max " + Util.format(max) : this.legend + ": Avg " + Util.format(avg) + " Max " + Util.format(max));
    }

    public Source getSource() {
        return this.source;
    }

    public String getSourceName() {
        return this.source.getName();
    }

    public PlotDef getParent() {
        return this.parent;
    }

    RrdTimeSeries getSeries() {
        if (this.totalSeries == null) {
            RrdTimeSeries parentSeries = null;
            if (this.parent != null) {
                parentSeries = this.parent.getSeries();
            }
            this.totalSeries = new RrdTimeSeries(this.legend);
            RrdTimeSeries realSeries = this.source.getSeries();
            for (int i = 0; i < realSeries.getItemCount(); ++i) {
                RegularTimePeriod t = realSeries.getTimePeriod(i);
                double realValue = realSeries.getValue(i).doubleValue();
                double parentValue = 0.0;
                if (parentSeries != null) {
                    parentValue = parentSeries.getValue(i).doubleValue();
                }
                this.totalSeries.add(t, realValue + parentValue);
            }
        }
        return this.totalSeries;
    }

    void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    float getLineWidth() {
        return this.lineWidth;
    }
}

