/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.ArrayList;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.ValueCollection;

class RpnCalculator {
    long timestamp;
    ValueCollection values;
    String[] tokens;
    ArrayList stack = new ArrayList();

    public RpnCalculator(long timestamp, ValueCollection values, String[] tokens) {
        this.timestamp = timestamp;
        this.values = values;
        this.tokens = tokens;
    }

    double evaluate() throws RrdException {
        for (int i = 0; i < this.tokens.length; ++i) {
            double x1;
            double x2;
            String token = this.tokens[i];
            if (this.isNumber(token)) {
                this.push(Double.parseDouble(token));
                continue;
            }
            if (this.values.contains(token)) {
                this.push(this.values.getValue(token));
                continue;
            }
            if (token.equals("+")) {
                this.push(this.pop() + this.pop());
                continue;
            }
            if (token.equals("-")) {
                x2 = this.pop();
                x1 = this.pop();
                this.push(x1 - x2);
                continue;
            }
            if (token.equals("*")) {
                this.push(this.pop() * this.pop());
                continue;
            }
            if (token.equals("/")) {
                x2 = this.pop();
                x1 = this.pop();
                this.push(x1 / x2);
                continue;
            }
            if (token.equals("%")) {
                x2 = this.pop();
                x1 = this.pop();
                this.push(x1 % x2);
                continue;
            }
            if (token.equals("SIN")) {
                this.push(Math.sin(this.pop()));
                continue;
            }
            if (token.equals("COS")) {
                this.push(Math.cos(this.pop()));
                continue;
            }
            if (token.equals("LOG")) {
                this.push(Math.log(this.pop()));
                continue;
            }
            if (token.equals("EXP")) {
                this.push(Math.exp(this.pop()));
                continue;
            }
            if (token.equals("FLOOR")) {
                this.push(Math.floor(this.pop()));
                continue;
            }
            if (token.equals("CEIL")) {
                this.push(Math.ceil(this.pop()));
                continue;
            }
            if (token.equals("ROUND")) {
                this.push(Math.round(this.pop()));
                continue;
            }
            if (token.equals("POW")) {
                x2 = this.pop();
                x1 = this.pop();
                this.push(Math.pow(x1, x2));
                continue;
            }
            if (token.equals("ABS")) {
                this.push(Math.abs(this.pop()));
                continue;
            }
            if (token.equals("SQRT")) {
                this.push(Math.sqrt(this.pop()));
                continue;
            }
            if (token.equals("RANDOM")) {
                this.push(Math.random());
                continue;
            }
            if (token.equals("LT")) {
                x2 = this.pop();
                x1 = this.pop();
                this.push(x1 < x2 ? 1.0 : 0.0);
                continue;
            }
            if (token.equals("LE")) {
                x2 = this.pop();
                x1 = this.pop();
                this.push(x1 <= x2 ? 1.0 : 0.0);
                continue;
            }
            if (token.equals("GT")) {
                x2 = this.pop();
                x1 = this.pop();
                this.push(x1 > x2 ? 1.0 : 0.0);
                continue;
            }
            if (token.equals("GE")) {
                x2 = this.pop();
                x1 = this.pop();
                this.push(x1 >= x2 ? 1.0 : 0.0);
                continue;
            }
            if (token.equals("EQ")) {
                x2 = this.pop();
                x1 = this.pop();
                this.push(x1 == x2 ? 1.0 : 0.0);
                continue;
            }
            if (token.equals("IF")) {
                double x3 = this.pop();
                double x22 = this.pop();
                double x12 = this.pop();
                this.push(x12 != 0.0 ? x22 : x3);
                continue;
            }
            if (token.equals("MIN")) {
                this.push(Math.min(this.pop(), this.pop()));
                continue;
            }
            if (token.equals("MAX")) {
                this.push(Math.max(this.pop(), this.pop()));
                continue;
            }
            if (token.equals("LIMT")) {
                double high = this.pop();
                double low = this.pop();
                double value = this.pop();
                this.push(value < low || value > high ? Double.NaN : value);
                continue;
            }
            if (token.equals("DUP")) {
                double x = this.pop();
                this.push(x);
                this.push(x);
                continue;
            }
            if (token.equals("EXC")) {
                x2 = this.pop();
                x1 = this.pop();
                this.push(x2);
                this.push(x1);
                continue;
            }
            if (token.equals("POP")) {
                this.pop();
                continue;
            }
            if (token.equals("UN")) {
                this.push(Double.isNaN(this.pop()) ? 1.0 : 0.0);
                continue;
            }
            if (token.equals("UNKN")) {
                this.push(Double.NaN);
                continue;
            }
            if (token.equals("NOW")) {
                this.push(Util.getTime());
                continue;
            }
            if (token.equals("TIME")) {
                this.push(this.timestamp);
                continue;
            }
            if (token.equals("PI")) {
                this.push(Math.PI);
                continue;
            }
            if (token.equals("E")) {
                this.push(Math.E);
                continue;
            }
            throw new RrdException("Unknown token enocuntered: " + token);
        }
        if (this.stack.size() != 1) {
            throw new RrdException("RPN error, invalid stack length");
        }
        return this.pop();
    }

    private boolean isNumber(String token) {
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private void push(double value) {
        this.stack.add(new Double(value));
    }

    private double pop() throws RrdException {
        int last = this.stack.size() - 1;
        if (last < 0) {
            throw new RrdException("POP failed, stack empty");
        }
        Double lastValue = (Double)this.stack.get(last);
        this.stack.remove(last);
        return lastValue;
    }
}

