/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

class ValueScaler {
    static final int NO_SCALE = -1;
    private static double[] VALUES = new double[]{1.0E18, 1.0E15, 1.0E12, 1.0E9, 1000000.0, 1000.0, 1.0, 0.001, 1.0E-6, 1.0E-9, 1.0E-12, 1.0E-15};
    private static String[] PREFIXES = new String[]{"E", "P", "T", "G", "M", "k", "", "m", "micro", "n", "p", "f"};
    private String prefix;
    private double scaledValue;
    private int scaleIndex;

    ValueScaler(double value) {
        this(value, -1);
    }

    ValueScaler(double value, int scaleIndex) {
        if (scaleIndex == -1) {
            this.prefix = "";
            this.scaledValue = value;
            for (int i = 0; i < VALUES.length; ++i) {
                if (!(value >= VALUES[i]) || !(value < VALUES[i] * 1000.0)) continue;
                this.prefix = PREFIXES[i];
                this.scaledValue = value / VALUES[i];
                this.scaleIndex = i;
                return;
            }
        } else {
            this.prefix = PREFIXES[scaleIndex];
            this.scaledValue = value / VALUES[scaleIndex];
            this.scaleIndex = scaleIndex;
        }
    }

    String getPrefix() {
        return this.prefix;
    }

    double getScaledValue() {
        return this.scaledValue;
    }

    public int getScaleIndex() {
        return this.scaleIndex;
    }
}

