/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install;

import com.cisco.dcbu.install.DCNMInfo;
import com.cisco.dcbu.install.DialogHelper;
import com.cisco.dcbu.install.ProgressMonitor;
import com.cisco.dcbu.install.Service;
import com.cisco.dcbu.install.Util;
import com.cisco.dcbu.install.model.Install;
import com.cisco.dcbu.install.model.SysInfo;
import com.cisco.dcbu.install.view.InstallPanel;
import com.cisco.dcbu.install.view.LocationPanel;
import com.cisco.dcbu.install.view.Wizard;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.util.ClientCache;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.Scanner;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public abstract class Installer
implements ActionListener {
    static final String USAGE = "Usage: java -Xmx512m -jar [JARFILE] ARGS\nWhere ARGS can be one of the following:\n-allusers to create shortcuts for all users on Microsoft Windows.\n-dir=DIR to specify the install directory.\n-force to force the installation of this version.\n-help to print the summary of command line arguments.\n-home=HOST where HOST could be the switch or web server address.\n-host=HOST where HOST is the switch address.\n-nocompress to download *.jar files and not *.tbz2 files.\n-text to specify a text only mode.\n-verbose to enable verbose output.\n-version=VERSION to specify the version of the software.\n-server | -standalone | -client (required)\n\t-server to install Fabric Manager Server (Licensed).  A client-server based application.\n\t\t-federated to add this server to an existing server federation.\n\t\t-https to enable HTTPS. -webstart option defaults to either port 443/8443.\n\t\t-webstart=PORT to specify web server port. Default to 80/443(HTTPS).\n\t\t-nic=IPADDR to set a preferred server bind IP address. Server binds to all available interfaces if unspecified. \n\t\t-serverport=PORT to specify a server port. Default is 9099.\n\t-standalone to install Fabric Manager Standalone. A monolithic application.\n\t-client to install Fabric Manager (client) and Device Manager.\n-fcalias to use FC Alias as fabric default.\n-installpg | -usepg | -useoracle (required)\n\t-installpg to install PostgreSQL on this machine. PostgreSQL uses port 5432.\n\t\t-pgstarter to specify a system user that can run PostgreSQL. Not applicable to Microsoft Windows platforms.\n\t\t-dbdir=DIR to specify PostgreSQL install directory.\n\t-usepg to specify that your existing database is PostgreSQL.\n\t-useoracle to specify that your existing database is Oracle.\n\t\t-dbuser=USER where USER is your database login username.\n\t\t-dbpass=PASSWORD where PASSWORD is your database login password.\n\t\t-dburl=URL to specify the URL of your database. Not required with -installpg.\n\t\t\tjdbc:postgresql://localhost:5432/dcmdb\n\t\t\tjdbc:oracle:thin:@localhost:1521:XE\n\t\t-createuser to create new account in an existing database.\n\t\t\t-adminuser to specify the admin account user that can create a new user.\n\t\t\t-adminpass to specify the admin account password.\n-props=STRING where string is a set of properties to include in server.properties file. Existing properties are updated.\n-fmuser=USER where USER is the Fabric Manager login username.\n-fmpass=PASSWORD where PASSWORD is the Fabric Manager login password.\n-authmode=MODE where MODE is [local|radius|tacacs|mds]\n\t-authurl=URL to specify the URL of the your RADIUS/TACACS server or MDS IP.  Use -authurl2 and -authurl3 to specify secondary and tertiary server, respectively. \n\t-authsecret=SECRET to specify the secret key of your RADIUS/TACACS server.  Use -authurlsecret2 and -authsecret3 to specify secondary and tertiary server secret, respectively. \n\t-authport=PORT to specify the authentication port TACACS/RADIUS. i.e. 49/1812. Use -authport2 and -authport3 to specify secondary and tertiary server port, respectively. \n\t-acctport=PORT to specify the accounting port for RADIUS. ie. 1813. Use -acctport2 and -acctport3 to specify secondary and tertiary server port, respectively. \n-disablesnmpv2 to specify the use of snmpv2 community access.\n\n\n sample command: java -Xmx512m -jar m9000-fm-3.2.1a.jar -text -dir=/usr/local/cisco -server -usepg -dburl=jdbc:postgresql://localhost:5432/dcmdb -dbuser=admin -dbpass=password -authmode=local -props=\"myipaddress=10.10.10.2; computername=MYW2K\" -webstart=80\n";
    static final String WEBPORT = "80";
    static final String FMUSER = "admin";
    static final String FMPASS = "password";
    static final String SERVICE_PACK_1 = "Service Pack 1";
    static final String SERVICE_PACK_2 = "Service Pack 2";
    static final String SERVICE_PACK_3 = "Service Pack 3";
    static final String SERVICE_PACK_4 = "Service Pack 4";
    static final String SYSREQ = "Supported Environments:\nWindows 2003 SP2, Server 2008 SP2, 7\nRedHat Linux AS5 (2.6 Kernel)\nSun Microsystems JRE 1.6.0_31 or 1.7.0.17";
    static final String FS = File.separator;
    final String serverXml = "jboss-4.2.2.GA" + FS + "server" + FS + "fm" + FS + "deploy" + FS + "jboss-web.deployer" + FS + "server.xml";
    final String persistenceXml = "jboss-4.2.2.GA" + FS + "server" + FS + "fm" + FS + "deploy" + FS + "dcm.ear" + FS + "dcm.jar" + FS + "META-INF" + FS + "persistence.xml";
    final String jmsDsXml = "jboss-4.2.2.GA" + FS + "server" + FS + "fm" + FS + "deploy" + FS + "jms" + FS + "hsqldb-jdbc2-service.xml";
    final String JBOSS_LIB = "server" + FS + "fm" + FS + "lib";
    final SwitchVersion VER32 = new SwitchVersion("3.2(0)");
    final SwitchVersion VER31 = new SwitchVersion("3.1(0)");
    final SwitchVersion VER412 = new SwitchVersion("4.1(1.59)");
    final SwitchVersion VER413 = new SwitchVersion("4.1(3)");
    final SwitchVersion VER42 = new SwitchVersion("4.2(0)");
    final SwitchVersion VER50 = new SwitchVersion("5.0(0)");
    final SwitchVersion VER60 = new SwitchVersion("6.0(0)");
    public static Logger logger = Logger.getLogger(Installer.class);
    protected boolean textMode = false;
    protected HashMap args;
    protected JFrame parent = null;
    protected Wizard wizard = null;
    protected InstallPanel progressPanel;
    protected static ProgressMonitor progressMon;
    protected static ConsoleAppender conAppender;
    protected static FileAppender logAppender;
    protected DialogHelper msgHelper;
    protected String name;
    protected String title;
    protected Object lock = new Object();
    protected Properties confProps = new Properties();
    protected boolean getWinDefaultInstallDirFail = false;
    Install iModel = new Install();
    public static final Cursor busyCursor;
    public static final Cursor origCursor;

    public Installer(HashMap args, String what) {
        String installConf;
        this.args = args;
        this.name = what;
        this.title = what + " " + this.getFullVersionString();
        if (!this.existsArg("-text")) {
            if (SysInfo.ONWINDOWS) {
                try {
                    UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
                }
                catch (Exception ex) {
                    logger.error((Object)("Unable to set look and feel: " + ex.getMessage()));
                }
            }
            this.parent = new JFrame(){

                @Override
                public void setVisible(boolean b) {
                    this.setLocationRelativeTo(null);
                    super.pack();
                    super.setVisible(b);
                    super.toFront();
                }
            };
            this.wizard = new Wizard();
            this.parent.getRootPane().setDefaultButton(this.wizard.getNavigator().getNextButton());
            this.parent.getRootPane().registerKeyboardAction(this, "Go", KeyStroke.getKeyStroke(10, 0), 2);
            this.parent.getContentPane().setLayout(new BorderLayout());
            this.parent.getContentPane().add(this.wizard);
            ClassLoader ldr = Thread.currentThread().getContextClassLoader();
            URL iconUrl = ldr.getResource("LogoIcon.gif");
            if (iconUrl == null) {
                try {
                    iconUrl = new URL("file", null, "icon" + FS + "LogoIcon.gif");
                }
                catch (MalformedURLException mex) {
                    mex.printStackTrace();
                }
            }
            Image icon = Toolkit.getDefaultToolkit().getImage(iconUrl);
            this.parent.setPreferredSize(new Dimension(570, 425));
            this.parent.setTitle(this.title);
            this.parent.setIconImage(icon);
            this.parent.setResizable(true);
            this.parent.setDefaultCloseOperation(0);
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (int)(size.getWidth() - (double)this.parent.getWidth()) / 2;
            int y = (int)(size.getHeight() - (double)this.parent.getHeight()) / 2;
            if (x < 0) {
                x = 0;
            }
            if (x > 500) {
                x = 500;
            }
            if (y < 0) {
                y = 0;
            }
            if (y > 500) {
                y = 500;
            }
            this.progressPanel = new InstallPanel();
        }
        if (progressMon == null) {
            progressMon = this.existsArg("-text") ? new ProgressMonitor() : new ProgressMonitor(this.progressPanel.getNote(), this.progressPanel.getBoard(), this.progressPanel.getProgressBar());
            progressMon.setMaximum(80);
            progressMon.trackByInputLine(true);
            progressMon.activateOptions();
            logger.addAppender((Appender)progressMon);
        }
        if (conAppender == null && this.existsArg("-verbose")) {
            conAppender = new ConsoleAppender((Layout)new PatternLayout("%d [%5p] %m%n"));
            logger.addAppender((Appender)conAppender);
        }
        if (logAppender == null) {
            try {
                PatternLayout layout = new PatternLayout("%d [%5p] %m%n");
                logAppender = new FileAppender((Layout)layout, ClientCache.getDir() + FS + "install.log", true);
                logger.addAppender((Appender)logAppender);
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
            }
        }
        this.msgHelper = new DialogHelper(this.parent, this.existsArg("-text"), logger);
        this.msgHelper.setTitle(this.title);
        if (SysInfo.ONWINDOWS && !this.existsArg("-selfstart")) {
            try {
                this.iModel.fetchAndLoadDll();
            }
            catch (IOException ioEx) {
                this.getWinDefaultInstallDirFail = true;
                this.msgHelper.showError(ioEx.getMessage());
                logger.warn((Object)("fetchAndLoadDll failed, ignore fetch 32-bit dll, ioex=" + ioEx.getMessage()));
            }
            catch (Exception ex) {
                this.getWinDefaultInstallDirFail = true;
                this.msgHelper.showError("fetchAndLoadDll failed, ignore fetch 32-bit dll:" + ex.getMessage());
                logger.warn((Object)("fetchAndLoadDll failed, ignore fetch 32-bit dll, ex=" + ex.getMessage()));
            }
            catch (Throwable th) {
                this.getWinDefaultInstallDirFail = true;
                logger.warn((Object)("fetchAndLoadDll failed, ignore fetch 32-bit dll, th=" + th));
            }
        }
        if (Util.exists(installConf = this.findInstallConf())) {
            this.confProps = Util.loadProps(installConf);
        }
    }

    public abstract void preInstall();

    public abstract void install();

    public abstract void postInstall();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pause() {
        Install install = this.iModel;
        synchronized (install) {
            try {
                this.iModel.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume() {
        Install install = this.iModel;
        synchronized (install) {
            this.iModel.notify();
        }
    }

    protected String findNMSRoot(String hintDir) {
        String defaultDir;
        String oldDir = null;
        String dir = ClientCache.getDir();
        String conf = this.findInstallConf();
        if (Util.exists(dir) && Util.exists(conf)) {
            Properties props = Util.loadProps(conf);
            String root = props.getProperty("mds.nmsRoot");
            if (root != null && this.checkInstallDir2(root)) {
                oldDir = root;
            } else if (this.checkInstallDir1(dir)) {
                oldDir = dir;
            }
        }
        if (oldDir == null && this.checkInstallDir2(defaultDir = this.getDefaultInstallDir())) {
            oldDir = defaultDir;
        }
        if (oldDir == null && dir != null && this.checkInstallDir(hintDir)) {
            oldDir = hintDir;
        }
        return oldDir;
    }

    protected String findInstallConf() {
        String dir = ClientCache.getCommonDir();
        String fp = dir + "install.conf";
        if (Util.exists(fp)) {
            return fp;
        }
        dir = ClientCache.getDir();
        String conf = dir + File.separator + "install.conf";
        return conf;
    }

    protected void createConf(String[] names, String[] values) {
        try {
            String iConf = this.iModel.getFMDir() + FS + "install.conf";
            String uConf = this.iModel.getUserDir() + FS + "install.conf";
            String aConf = ClientCache.getCommonDir() + "install.conf";
            if (Util.exists(iConf)) {
                Util.copy(iConf, iConf + "_bak");
                Util.updateProperties(iConf + "_bak", iConf, names, values, true);
                Util.delete(iConf + "_bak");
            } else {
                this.storeConf(iConf, names, values);
            }
            Util.copy(iConf, uConf);
            Util.copy(iConf, aConf);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Unable to write to configuration files.");
        }
    }

    protected String findInstallDir(String hintDir) {
        String defaultDir;
        String oldDir = null;
        String dir = ClientCache.getDir();
        String conf = this.findInstallConf();
        if (Util.exists(conf)) {
            Properties props = Util.loadProps(conf);
            String root = props.getProperty("mds.nmsRoot");
            if (root != null && this.checkInstallDir2(root)) {
                oldDir = root;
            } else if (this.checkInstallDir1(dir)) {
                oldDir = dir;
            }
            root = props.getProperty("mds.ciscoRoot");
            if (root != null && this.checkInstallDir412(root + SysInfo.FS + (SysInfo.ONWINDOWS ? "DCM" : "dcm"))) {
                oldDir = root;
            }
        }
        if (oldDir == null && this.checkInstallDir2(defaultDir = this.getDefaultInstallDir())) {
            oldDir = defaultDir;
        }
        if (oldDir == null && dir != null && this.checkInstallDir(hintDir)) {
            oldDir = hintDir;
        }
        return oldDir;
    }

    protected String getDefaultInstallDir() {
        boolean onWin = SysInfo.ONWINDOWS;
        if (onWin) {
            try {
                return Service.getProgramFiles() + "\\Cisco Systems\\";
            }
            catch (UnsatisfiedLinkError ex) {
                this.getWinDefaultInstallDirFail = true;
                logger.warn((Object)("Installer getDefaultInstallDir 64bit? ex=" + ex));
                return "C:\\Program Files\\Cisco Systems\\";
            }
        }
        String global = "/usr/local/cisco";
        if (Util.exists(global)) {
            return global;
        }
        if (Util.mkdir(global)) {
            Util.delete(global);
            return global;
        }
        return System.getProperty("user.home") + File.separator + "cisco";
    }

    protected String getDCNMDir() {
        String iDir = null;
        DCNMInfo dcnmInfo = null;
        try {
            dcnmInfo = DCNMInfo.getInstance();
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to retrieve DCNM info: " + ex.getMessage()));
        }
        if (dcnmInfo != null && dcnmInfo.getVersion() != null) {
            if (!dcnmInfo.isCompatible()) {
                return null;
            }
        } else {
            return null;
        }
        iDir = dcnmInfo.getInstallLocation();
        return iDir;
    }

    protected boolean checkInstallDir(String dir) {
        return this.checkInstallDir2(dir) || this.checkInstallDir1(dir);
    }

    protected boolean checkInstallDir1(String dir) {
        String prefix = dir + File.separator;
        return Util.exists(prefix + "jnm.jar") && Util.exists(prefix + "snmp.jar");
    }

    protected boolean checkInstallDir2(String dir) {
        String prefix = dir + File.separator;
        String libPrefix = prefix + "lib" + File.separator;
        return Util.exists(prefix + "install.conf") && Util.exists(libPrefix + "jnm.jar") && Util.exists(libPrefix + "snmp.jar");
    }

    protected boolean checkInstallDir412(String dcmRoot) {
        String prefix = dcmRoot + SysInfo.FS + "fm" + SysInfo.FS;
        String libPrefix = prefix + SysInfo.FS + "lib" + SysInfo.FS;
        return Util.exists(prefix + "install.conf") && Util.exists(libPrefix + "jnm.jar") && Util.exists(libPrefix + "snmp.jar");
    }

    protected SwitchVersion getVersion(String dir) {
        if (dir == null) {
            return new SwitchVersion(null);
        }
        String cPath = dir + File.separator + "install.conf";
        if (this.checkInstallDir2(dir) || Util.exists(cPath)) {
            return new SwitchVersion(Util.loadProps(cPath).getProperty("mds.version"));
        }
        return new SwitchVersion(Util.getJarVersion(dir + File.separator + "snmp.jar"));
    }

    protected SwitchVersion getVersion() {
        SwitchVersion ver = new SwitchVersion("unknown");
        try {
            String verStr;
            if (!this.existsArg("-version")) {
                Class<?> consClazz = Class.forName("com.cisco.dcbu.Constants");
                Field f = consClazz.getField("VERSION");
                verStr = (String)f.get(null);
            } else {
                verStr = this.getArg("-version");
            }
            ver = new SwitchVersion(verStr);
        }
        catch (Exception ex) {
            logger.info((Object)("Exception caught getting current version: " + ex.getMessage()));
        }
        return ver;
    }

    private String getFullVersionString() {
        String verStr = "unknown";
        try {
            if (!this.existsArg("-version")) {
                Class<?> consClazz = Class.forName("com.cisco.dcbu.Constants");
                Field f = consClazz.getField("VERSION");
                verStr = (String)f.get(null);
            } else {
                verStr = this.getArg("-version");
            }
        }
        catch (Exception ex) {
            logger.info((Object)("getFullVersionString() Exception caught getting current version: " + ex.getMessage()));
        }
        return verStr;
    }

    protected void storeConf(String path, String[] names, String[] values) throws IOException {
        Properties props = new Properties();
        if (Util.exists(path)) {
            props = Util.loadProps(path);
        }
        if (this.iModel.isStandalone() && this.confProps.containsKey("mds.fm.version")) {
            this.confProps.remove("mds.fm.version");
            this.confProps.remove("mds.fm.winAllUsers");
            this.confProps.remove("mds.fm.autoupgrade");
        }
        logger.info((Object)("Writing " + path));
        for (int i = 0; i < names.length; ++i) {
            props.setProperty(names[i], values[i]);
        }
        try {
            FileOutputStream fos = new FileOutputStream(path);
            props.store(fos, "Auto-generated file, don't edit");
            fos.close();
        }
        catch (IOException ex) {
            logger.error((Object)("Error: " + path + ", " + ex.getMessage()));
            ex.printStackTrace(System.err);
        }
    }

    protected void cleanUninstallShortcuts() {
        if (SysInfo.ONWINDOWS) {
            Util.delete(Service.getAllStartMenu() + FS + "Cisco Fabric Manager" + FS + "Uninstall.lnk");
            Util.delete(Service.getStartMenu() + FS + "Cisco Fabric Manager" + FS + "Uninstall.lnk");
        }
    }

    protected void cleanDMShortcuts() {
        this.cleanOldDMShortcuts();
        this.clean32DMShortcuts();
    }

    protected void cleanOldDMShortcuts() {
        if (SysInfo.ONWINDOWS) {
            try {
                Util.delete(Service.getAllDesktop() + FS + "DeviceManager.lnk");
                Util.delete(Service.getDesktop() + FS + "DeviceManager.lnk");
                Util.delete(Service.getStartMenu() + FS + "Cisco Fabric Manager" + FS + "DeviceManager.lnk");
                Util.delete(Service.getAllStartMenu() + FS + "Cisco Fabric Manager" + FS + "DeviceManager.lnk");
            }
            catch (UnsatisfiedLinkError ex) {
                logger.warn((Object)("Installer cleanOldDMShortcuts 64bit?  ex: " + ex));
            }
        }
    }

    protected void clean32DMShortcuts() {
        if (SysInfo.ONWINDOWS) {
            try {
                Util.delete(Service.getAllDesktop() + FS + "Cisco Device Manager" + ".lnk");
                Util.delete(Service.getDesktop() + FS + "Cisco Device Manager" + ".lnk");
                Util.delete(Service.getStartMenu() + FS + "Cisco Fabric Manager" + FS + "Cisco Device Manager" + ".lnk");
                Util.delete(Service.getAllStartMenu() + FS + "Cisco Fabric Manager" + FS + "Cisco Device Manager" + ".lnk");
            }
            catch (UnsatisfiedLinkError ex) {
                logger.warn((Object)("Installer clean32DMShortcuts 64bit?  ex: " + ex));
            }
        }
    }

    protected void cleanFMShortcuts() {
        this.cleanOldFMShortcuts();
        this.clean32FMSAShortcuts();
    }

    protected void cleanOldFMShortcuts() {
        if (SysInfo.ONWINDOWS) {
            Util.delete(Service.getAllDesktop() + FS + "FabricManager.lnk");
            Util.delete(Service.getDesktop() + FS + "FabricManager.lnk");
            Util.delete(Service.getStartMenu() + FS + "Cisco MDS9000" + FS + "FabricManager.lnk");
            Util.delete(Service.getAllStartMenu() + FS + "Cisco MDS9000" + FS + "FabricManager.lnk");
            Util.delete(Service.getStartMenu() + FS + "Cisco MDS9000" + FS + "ServerProperties.lnk");
            Util.delete(Service.getAllStartMenu() + FS + "Cisco MDS9000" + FS + "ServerProperties.lnk");
        }
    }

    protected void clean32FMSAShortcuts() {
        if (SysInfo.ONWINDOWS) {
            Util.delete(Service.getAllDesktop() + FS + "Cisco Fabric Manager SA" + ".lnk");
            Util.delete(Service.getDesktop() + FS + "Cisco Fabric Manager SA" + ".lnk");
            Util.delete(Service.getStartMenu() + FS + "Cisco Fabric Manager" + FS + "Cisco Fabric Manager SA" + ".lnk");
            Util.delete(Service.getAllStartMenu() + FS + "Cisco Fabric Manager" + FS + "Cisco Fabric Manager SA" + ".lnk");
            Util.delete(Service.getStartMenu() + FS + "Cisco Fabric Manager" + FS + "Server Properties.lnk");
            Util.delete(Service.getAllStartMenu() + FS + "Cisco Fabric Manager" + FS + "Server Properties.lnk");
        }
    }

    protected void cleanFMCShortcuts() {
        if (!SysInfo.ONWINDOWS) {
            return;
        }
        Util.delete(Service.getAllDesktop() + FS + "FabricManager.lnk");
        Util.delete(Service.getDesktop() + FS + "FabricManager.lnk");
        Util.delete(Service.getStartMenu() + FS + "Cisco MDS9000" + FS + "FabricManager.lnk");
        Util.delete(Service.getAllStartMenu() + FS + "Cisco MDS9000" + FS + "FabricManager.lnk");
        Util.delete(Service.getAllDesktop() + FS + "Cisco Fabric Manager.lnk");
        Util.delete(Service.getDesktop() + FS + "Cisco Fabric Manager.lnk");
        Util.delete(Service.getStartMenu() + FS + "Cisco Fabric Manager" + FS + "Cisco Fabric Manager.lnk");
        Util.delete(Service.getAllStartMenu() + FS + "Cisco Fabric Manager" + FS + "Cisco Fabric Manager.lnk");
    }

    protected void cleanShortcuts() {
        this.cleanUninstallShortcuts();
        this.cleanFMShortcuts();
        this.cleanDMShortcuts();
    }

    protected void printUsage() {
        System.out.println(USAGE);
    }

    protected String getArg(String key) {
        Object ob = this.args.get(key);
        return (String)ob;
    }

    protected String getArg(String key, String ret) {
        return this.getArg(key) == null ? ret : this.getArg(key);
    }

    protected boolean existsArg(String key) {
        return this.args.containsKey(key);
    }

    protected void runApp(String app, String[] args, String binDir) throws IOException {
        String[] cmds;
        if (SysInfo.ONWINDOWS) {
            cmds = new String[args == null ? 4 : 4 + args.length];
            int i = 0;
            cmds[i++] = "cmd";
            cmds[i++] = "/c";
            cmds[i++] = "start";
            cmds[i++] = app;
            if (args != null) {
                for (String arg : args) {
                    cmds[i++] = arg == null ? "" : arg;
                }
            }
        } else {
            cmds = new String[args == null ? 1 : 1 + args.length];
            int i = 0;
            cmds[i++] = binDir + FS + app;
            if (args != null) {
                for (String arg : args) {
                    cmds[i++] = arg == null ? "" : arg;
                }
            }
        }
        Runtime.getRuntime().exec(cmds, null, new File(binDir));
    }

    public static ActionListener createCursorController(final Component comp, final ActionListener listener) {
        ActionListener al = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    comp.setCursor(busyCursor);
                    listener.actionPerformed(e);
                }
                finally {
                    comp.setCursor(origCursor);
                }
            }
        };
        return al;
    }

    public void mkdirs(String path) throws RuntimeException {
        if (Util.exists(path)) {
            if (!new File(path).canWrite()) {
                throw new RuntimeException("Cannot write to " + path);
            }
            return;
        }
        if (!Util.mkdir(path)) {
            throw new RuntimeException("Unable to create " + path);
        }
    }

    protected boolean createInstallLocation(LocationPanel locationPanel) {
        String path = locationPanel.getInstallFolder();
        if (!Util.exists(path)) {
            int rc = locationPanel.showDialog();
            if (rc == 0) {
                if (!Util.mkdir(path)) {
                    this.msgHelper.showError("Unable to create directory.  Please check the\npathname and ensure that you have write permission.");
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public void checkEnvironment() {
        boolean OKVENDOR;
        if (this.existsArg("-force")) {
            return;
        }
        boolean OKOS = true;
        boolean OKSP = true;
        StringBuffer errMsg = new StringBuffer("<html><h5>");
        String jreVendor = System.getProperty("java.vm.vendor", "Unknown");
        boolean bl = OKVENDOR = jreVendor.toLowerCase().contains("Sun Microsystems".toLowerCase()) || jreVendor.toLowerCase().contains("Oracle Corporation".toLowerCase());
        if (SysInfo.UNKNOWN_OS || !SysInfo.OKJDK) {
            String msg = "JRE " + SysInfo.JDK + " from " + jreVendor + " " + "is not supported. Please install JRE 1.6.0_31 or JRE 1.7.0.17 from Sun Microsystems Inc. before running this installer.\n\n";
            logger.fatal((Object)msg);
            if (this.textMode) {
                System.exit(1);
            }
            this.msgHelper.beepAndDisplayParent();
            JOptionPane.showMessageDialog(this.parent, new JLabel("<html><body>" + msg.replace("\n", "<br>") + "</body></html>"), "Unsupported Environment", 0);
            System.exit(1);
        }
        String os = System.getProperty("os.name", "Unknown");
        String pl = System.getProperty("sun.os.patch.level", "Service Pack 0");
        String ver = System.getProperty("os.version", "Unknown");
        logger.info((Object)("OS: " + os));
        logger.info((Object)("Patch Level: " + pl));
        logger.info((Object)("Version: " + ver));
        logger.info((Object)("JVM Vendor: " + jreVendor));
        logger.info((Object)("JVM Version: " + SysInfo.JDK));
        String arch = System.getProperty("sun.arch.data.model", "unknown");
        if (SysInfo.ONWINDOWS) {
            if (pl != null) {
                if (os.contains("XP")) {
                    OKSP = false;
                } else if (os.contains("2003")) {
                    OKSP = pl.toLowerCase().contains(SERVICE_PACK_2.toLowerCase());
                } else if (os.toLowerCase().contains("vista")) {
                    OKSP = false;
                } else if (os.toLowerCase().contains("Server 2008".toLowerCase())) {
                    OKSP = pl.toLowerCase().contains(SERVICE_PACK_2.toLowerCase());
                    if (!OKSP) {
                        OKSP = os.toLowerCase().contains("Server 2008 R2".toLowerCase());
                    }
                } else {
                    OKSP = os.toLowerCase().contains("Server 2003".toLowerCase()) ? pl.toLowerCase().contains(SERVICE_PACK_2.toLowerCase()) : os.toLowerCase().contains("Windows 7".toLowerCase());
                }
            } else {
                OKSP = false;
            }
        } else if (SysInfo.ONSOLARIS) {
            OKOS = false;
        } else if (SysInfo.ONLINUX) {
            if (!ver.startsWith("2.6") || !this.iModel.isRH5()) {
                OKOS = false;
            }
        } else {
            OKOS = false;
        }
        if (!(OKOS && OKSP && OKVENDOR)) {
            String incompatibleItems;
            String msg = "Cisco do NOT test DCNM with this OS and/or JRE.\nYou may continue at your own risk, but Cisco recommends that you press Exit\nand use a supported environment.";
            os = os + " " + (!SysInfo.ONWINDOWS ? ver : "") + " " + (SysInfo.ONWINDOWS ? pl : "");
            String string = incompatibleItems = !OKOS || !OKSP ? os + "\n" : "";
            if (!OKVENDOR) {
                incompatibleItems = incompatibleItems + jreVendor + " JRE " + SysInfo.JDK;
            }
            if (!this.textMode) {
                errMsg.append(incompatibleItems.replace("\n", "<br>") + "<br>");
                errMsg.append("</h5>");
                errMsg.append("<br></br>" + msg.replace("\n", "<br>") + "<br><br>" + SYSREQ.replace("\n", "<br>") + "</br>");
                errMsg.append("</html>");
                logger.warn((Object)errMsg);
                Object[] options = new Object[]{"Continue", "Exit"};
                JPanel pane = new JPanel();
                pane.add(new JLabel(errMsg.toString()));
                this.msgHelper.beepAndDisplayParent();
                int rc = JOptionPane.showOptionDialog(this.parent, pane, "Unsupported Environment", 0, 2, null, options, options[0]);
                if (rc != 0) {
                    System.exit(1);
                }
            } else {
                Scanner in = new Scanner(System.in);
                while (true) {
                    Toolkit.getDefaultToolkit().beep();
                    logger.warn((Object)(incompatibleItems + "\n" + msg + "\nPress 'C' to continue, 'E' to exit.  [C/E]"));
                    String answer = in.nextLine();
                    if (answer.trim().equalsIgnoreCase("C")) break;
                    if (!answer.trim().equalsIgnoreCase("E")) continue;
                    System.exit(1);
                }
            }
        }
    }

    public ProgressMonitor getProgressMonitor() {
        return progressMon;
    }

    public boolean isWinDefaultInstallDirFail() {
        return this.getWinDefaultInstallDirFail;
    }

    static {
        busyCursor = Cursor.getPredefinedCursor(3);
        origCursor = Cursor.getDefaultCursor();
    }
}

