/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install;

import com.cisco.dcbu.install.Service;
import com.cisco.dcbu.install.Util;
import com.cisco.dcbu.install.model.SysInfo;
import java.io.File;

public class Shortcut {
    public static final String FMSAShortcut = "Cisco Fabric Manager SA";
    public static final String DMShortcut = "Cisco Device Manager";
    public static final String FMCShortcut = "Cisco Fabric Manager";
    public static final String UninstallShortcut = "Uninstall";
    public static final String ServerPropShortcut = "Server Properties";
    String desktop;
    String startMenu;
    String iDir;
    String libDir;
    String binDir;
    String launchSP;
    String icon;

    Shortcut(String desktop, String iDir, String libDir, String binDir, String startMenu) {
        this.desktop = desktop;
        this.iDir = iDir;
        this.startMenu = startMenu;
        this.libDir = libDir;
        this.binDir = binDir;
        this.launchSP = iDir + SysInfo.FS + "conf" + SysInfo.FS + "server.properties";
        this.icon = libDir + SysInfo.FS + "mds9000.ico";
    }

    public String[] getFMSALinks() {
        return new String[]{this.desktop + SysInfo.FS + FMSAShortcut + ".lnk", this.binDir + SysInfo.FS + "FabricManagerSA.bat", FMSAShortcut, this.startMenu + SysInfo.FS + FMSAShortcut + ".lnk", this.binDir + SysInfo.FS + "FabricManagerSA.bat", FMSAShortcut, this.startMenu + SysInfo.FS + "Uninstall.lnk", this.iDir + SysInfo.FS + "Uninstall.bat", UninstallShortcut};
    }

    public String[] getFMSLinks() {
        return new String[]{this.startMenu + SysInfo.FS + "Server Properties.lnk", this.launchSP, ServerPropShortcut, this.startMenu + SysInfo.FS + "Uninstall.lnk", this.iDir + SysInfo.FS + "Uninstall.bat", UninstallShortcut};
    }

    public String[] getDMLinks() {
        String[] links = new String[]{this.desktop + SysInfo.FS + DMShortcut + ".lnk", this.binDir + SysInfo.FS + "DeviceManager.bat", DMShortcut, this.startMenu + SysInfo.FS + DMShortcut + ".lnk", this.binDir + SysInfo.FS + "DeviceManager.bat", DMShortcut, this.startMenu + SysInfo.FS + "Uninstall.lnk", this.iDir + SysInfo.FS + "Uninstall.bat", UninstallShortcut};
        return links;
    }

    public void updateDMLinks() {
        String descr;
        String app;
        String linkPath;
        int i;
        String[] links = this.getDMLinks();
        if (Util.exists(links[i = 0])) {
            linkPath = links[i++];
            app = links[i++];
            descr = links[i];
            if (Util.exists(app)) {
                Service.createLink(linkPath, app, descr, this.iDir, this.icon);
            }
        }
        if (Util.exists(links[i = 3])) {
            linkPath = links[i++];
            app = links[i++];
            descr = links[i];
            if (Util.exists(app)) {
                Service.createLink(linkPath, app, descr, this.iDir, this.icon);
            }
        }
    }

    public String[] getFMLinks() {
        String[] links = new String[]{this.desktop + SysInfo.FS + FMCShortcut + ".lnk", this.binDir + SysInfo.FS + "FabricManager.bat", FMCShortcut, this.startMenu + SysInfo.FS + FMCShortcut + ".lnk", this.binDir + SysInfo.FS + "FabricManager.bat", FMCShortcut, this.startMenu + SysInfo.FS + "Uninstall.lnk", this.iDir + SysInfo.FS + "Uninstall.bat", UninstallShortcut};
        return links;
    }

    public String[] getServerPropLinks() {
        String[] links = new String[]{this.startMenu + SysInfo.FS + "Server Properties.lnk", this.launchSP, ServerPropShortcut};
        return links;
    }

    public void updateFMLinks() {
        String descr;
        String app;
        String linkPath;
        int i;
        String[] links = this.getFMLinks();
        if (Util.exists(links[i = 0])) {
            linkPath = links[i++];
            app = links[i++];
            descr = links[i];
            if (Util.exists(app)) {
                Service.createLink(linkPath, app, descr, this.iDir, this.icon);
            }
        }
        if (Util.exists(links[i = 3])) {
            linkPath = links[i++];
            app = links[i++];
            descr = links[i];
            if (Util.exists(app)) {
                Service.createLink(linkPath, app, descr, this.iDir, this.icon);
            }
        }
    }

    public void createFMSLinks() {
        String[] links = this.getFMSLinks();
        for (int i = 0; i < links.length; ++i) {
            String linkPath = links[i++];
            String app = links[i++];
            String descr = links[i];
            if (!Util.exists(app)) continue;
            Service.createLink(linkPath, app, descr, this.iDir, this.icon);
        }
    }

    public void createFMSALinks() {
        String[] links = this.getFMSALinks();
        for (int i = 0; i < links.length; ++i) {
            String linkPath = links[i++];
            String app = links[i++];
            String descr = links[i];
            if (!Util.exists(app)) continue;
            Service.createLink(linkPath, app, descr, this.iDir, this.icon);
        }
    }

    public void createDMLinks() {
        String[] links = this.getDMLinks();
        for (int i = 0; i < links.length; ++i) {
            String linkPath = links[i++];
            String app = links[i++];
            String descr = links[i];
            if (!Util.exists(app)) continue;
            Service.createLink(linkPath, app, descr, this.iDir, this.icon);
        }
    }

    public void createFMLinks() {
        String[] links = this.getFMLinks();
        for (int i = 0; i < links.length; ++i) {
            String linkPath = links[i++];
            String app = links[i++];
            String descr = links[i];
            if (!Util.exists(app)) continue;
            Service.createLink(linkPath, app, descr, this.iDir, this.icon);
        }
    }

    public void deleteFMSALinks() {
        String[] links = this.getFMSALinks();
        this.forceDelete(links);
    }

    public void deleteFMSLinks() {
        String[] links = this.getFMSLinks();
        this.forceDelete(links);
    }

    public void deleteFMLinks() {
        String[] links = this.getFMLinks();
        this.forceDelete(links);
    }

    public void deleteDMLinks() {
        String[] links = this.getDMLinks();
        this.forceDelete(links);
    }

    public void deleteServerPropLinks() {
        String[] links = this.getServerPropLinks();
        this.forceDelete(links);
    }

    private void forceDelete(String[] links) {
        for (int i = 0; i < links.length; i += 3) {
            File f = new File(links[i]);
            if (!f.exists() || f.delete()) continue;
            f.deleteOnExit();
        }
    }
}

