/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install.model;

import com.cisco.dcbu.install.DCNMInfo;
import com.cisco.dcbu.install.Service;
import com.cisco.dcbu.install.StreamReader;
import com.cisco.dcbu.install.Util;
import com.cisco.dcbu.install.model.SysInfo;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.NetUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Install {
    static final String INSTALLER_NAME = "Cisco DCNM Installer";
    public static final String FMUSER = "admin";
    public static final String FMPASSWORD = "password";
    public static final String JBOSS_DIST = "jboss-4.2.2.GA";
    public static final String FM_PROFILE = "fm";
    static final String OS = System.getProperty("os.name");
    static final SwitchVersion VER31 = new SwitchVersion("3.1(0)");
    static final String[] DBFILES = new String[]{"dbname.backup", "dbname.data", "dbname.properties", "dbname.script"};
    static final String DBSERVERFILE = "server.properties";
    public static final String SERVERPROPNAME = "server.properties";
    public static final String SMEPROPNAME = "smeserver.properties";
    static final String FAILTOINSTALLPG = "Failed to start PostgreSQL. A security software agent may be blocking PostgreSQL from installing.";
    static final String GEMSAFE = "GemSafe_Standard32_OEM_5.1.08.setup.msi";
    public static final String FLASHIMAGE = "m9000-lc1-gplug-mz.1.0.3.bin";
    boolean _noCompress;
    public boolean _allUsers = true;
    boolean _globalAlias;
    boolean _force;
    boolean _remove;
    String _iDir;
    String pgDir;
    String _host;
    String _codebase;
    String _nic;
    SwitchVersion _ver;
    int _webStartPort = -1;
    boolean _downloadFiles;
    boolean _migratePMData;
    SwitchVersion _oldVer;
    public String _oldIDir;
    String _uDir = ClientCache.getDir();
    Boolean[] _svcState;
    int _webStopPort = 8085;
    private boolean isHTTPS = false;
    private boolean isStandalone = false;
    private boolean isPostgres = false;
    Logger logger = Logger.getLogger(Install.class);
    private String dbURL;
    private String dbUser;
    private String dbPassword;
    private boolean deleteOldExec;
    private boolean noServer;
    private String pgPath = null;
    private String pgStarter = null;
    private boolean getWinDefaultInstallDirFail = false;
    static final String USAGE = "Usage: java -jar [JARFILE] ARGS\nWhere ARGS can be one of the following:\n-alias to use global device aliases.\n-allusers to create shortcuts for all users on Microsoft Windows.\n-dir=DIR to specify the install directory.\n-force to force the installation of this version.\n-help to print the summary of command line arguments.\n-home=HOST where HOST could be the switch or web server address.\n-host=HOST where HOST is the switch address.\n-main=CLASSNAME where CLASSNAME can be one of \n                com.cisco.dcbu.dm.DM to install/run DM,\n                com.cisco.dcbu.sm.client.SM to install/run FM,\n                com.cisco.dcbu.web to install/run web server.\n-nic=NIC to set a preferred network interface.\n-text to specify a text only mode.\n-version=VERSION to specify the version of the software.\n-webstart=PORT to specify web server port.\n";
    public static final String[] DMFiles = new String[]{"bitmaps", "dm", "dmdb", "portland", "installer", "jchart", "jcommon-1.0.16", "jnm", "log4j", "snmp", "dmnative", "commons-codec-1.3", "concurrent", "jboss-common-client", "jboss-jaxrpc", "jboss-jaxws", "jboss-remoting", "jboss-saaj", "jbossws-client", "jboss-xml-binding", "mail", "xercesImpl", "activation", "jbossws-common", "jbossws-spi", "fm_jcommon-0.7.2", "jide-action", "jide-common", "jide-grids"};
    public static final String[] FMCFiles = new String[]{"download", "fmnative", "log4j", "fmclient", "portland", "commons-codec-1.3"};
    public static final String[] ILOGFiles = new String[]{"jviews-diagrammer", "jviews-framework-all"};
    public static final String[] JIDEFiles = new String[]{"hssf", "jide-action", "jide-common", "jide-components", "jide-dialogs", "jide-dock", "jide-grids", "jide-pivot", "jide-shortcut"};
    public static String[] RESTFiles = new String[]{"org.restlet", "com.noelios.restlet"};
    public static String[] FLEXlmFiles = new String[]{"magellanInfo", "flexlm", "EccpressoAll"};
    String[] pFiles = new String[]{"AAA.properties", "emccallhome.properties", "server.properties"};
    private static String jbossConf = "jboss" + SysInfo.FS + "server" + SysInfo.FS + "default" + SysInfo.FS + "conf";
    public static final String FMENTRY = "fmserver";
    public static final String PGENTRY = "fmspgsql";
    public static final String CISCOSMISENTRY = "ciscosmis";

    public void setIsHTTPS(boolean b) {
        this.isHTTPS = b;
    }

    public boolean isHTTPS() {
        return this.isHTTPS;
    }

    public void setIsStandalone(boolean b) {
        this.isStandalone = b;
    }

    public boolean isStandalone() {
        return this.isStandalone;
    }

    public void setIsPostgres(boolean b) {
        this.isPostgres = b;
    }

    public boolean isPostgres() {
        return this.isPostgres;
    }

    public void setPgStarter(String starter) {
        this.pgStarter = starter;
    }

    public String getPgStarter() {
        return this.pgStarter;
    }

    public void setDBURL(String url) {
        this.dbURL = url;
    }

    public void setDBUser(String user) {
        this.dbUser = user;
    }

    public void setDBPassword(String passwd) {
        this.dbPassword = passwd;
    }

    public SwitchVersion getOldVersion() {
        return this._oldVer;
    }

    public void setOldVersion(SwitchVersion ver) {
        this._oldVer = ver;
    }

    public SwitchVersion getVersion() {
        return this._ver;
    }

    public void setVersion(SwitchVersion ver) {
        this._ver = ver;
    }

    public String getCodebase() {
        return this._codebase;
    }

    public void setCodebase(String home) {
        this._codebase = home;
    }

    public String getOldInstallDir() {
        return this._oldIDir;
    }

    public void setOldInstallDir(String oDir) {
        this._oldIDir = oDir;
    }

    public String getDCMDir() {
        return this.getInstallDir() + SysInfo.FS + "dcm";
    }

    public String getInstallDir() {
        return this._iDir;
    }

    public String getHelpDir() {
        return this.getFMDir() + SysInfo.FS + "help";
    }

    public String getJBossDir() {
        return this.getDCMDir() + SysInfo.FS + JBOSS_DIST;
    }

    public String getSMISDir() {
        return this.getDCMDir() + SysInfo.FS + "smis";
    }

    String getDeployDir() {
        return this.getDCMDir() + SysInfo.FS + JBOSS_DIST + SysInfo.FS + "server" + SysInfo.FS + FM_PROFILE + SysInfo.FS + "deploy";
    }

    public String getDBDir() {
        return this.getDCMDir() + SysInfo.FS + "db";
    }

    public String getInstallPgDir() {
        return this.pgDir;
    }

    public void setInstallPgDir(String dir) {
        this.pgDir = dir;
    }

    public String getTmpDir() {
        return this.getUserDir() + SysInfo.FS + "tmp";
    }

    public String getLogDir() {
        return this.getFMDir() + SysInfo.FS + "logs";
    }

    public String getReportDir() {
        return this.getFMDir() + SysInfo.FS + "reports";
    }

    public String getDownloadDir() {
        return this.getFMDir() + SysInfo.FS + "download";
    }

    public void setInstallDir(String dir) {
        this._iDir = dir;
    }

    public String getFMDir() {
        return this.getDCMDir() + SysInfo.FS + FM_PROFILE;
    }

    public String getLibDir() {
        return this.getFMDir() + File.separator + "lib";
    }

    public String getDMLibDir() {
        return this.getFMDir() + File.separator + "lib" + File.separator + "dm";
    }

    public String getFMLibDir() {
        return this.getFMDir() + File.separator + "lib" + File.separator + FM_PROFILE;
    }

    public String getSMISLibDir() {
        return this.getLibDir() + SysInfo.FS + "smis";
    }

    public String getVMLibDir() {
        return this.getLibDir();
    }

    public String getConfDir() {
        return Install.getConfDir(this.getFMDir());
    }

    public static String getConfDir(String fmDir) {
        return fmDir + SysInfo.FS + "conf";
    }

    public String getOldConfDir() {
        if (this._oldVer.compareTo(new SwitchVersion("3.2(0)")) < 0) {
            return this.getInstallDir();
        }
        return this.getOldInstallDir() + SysInfo.FS + "conf";
    }

    public String getBinDir() {
        return this.getFMDir() + File.separator + "bin";
    }

    String getSchemaDir() {
        return this.getInstallDir() + File.separator + "bin" + File.separator + "schema";
    }

    public String getPmDir() {
        return this.getFMDir() + File.separator + "pm";
    }

    public String getUserDir() {
        return this._uDir;
    }

    public int getWebStartPort() {
        return this._webStartPort;
    }

    public void setWebStartPort(int port) {
        this._webStartPort = port;
    }

    public int getWebStopPort() {
        return this._webStopPort;
    }

    public void setWebStopPort(int port) {
        this._webStopPort = port;
    }

    public Boolean[] getServicesState() {
        return this._svcState;
    }

    public String getNIC() {
        return this._nic == null ? "" : this._nic;
    }

    public void setNIC(String intf) {
        this._nic = intf;
    }

    public boolean getGlobalAlias() {
        return this._globalAlias;
    }

    public void setGlobalAlias(boolean b) {
        this._globalAlias = b;
    }

    public boolean getAllUsers() {
        return this._allUsers;
    }

    public void setNoServer(boolean b) {
        this.noServer = b;
    }

    public boolean isWinDefaultInstallDirFail() {
        return this.getWinDefaultInstallDirFail;
    }

    public boolean noServer() {
        return this.noServer;
    }

    public boolean isWebInstalled() {
        if (this._oldIDir == null) {
            return false;
        }
        String jbossXml = this.getJBossDir() + SysInfo.FS + "server" + SysInfo.FS + FM_PROFILE + SysInfo.FS + "deploy" + SysInfo.FS + "jboss-web.deployer" + SysInfo.FS + "server.xml";
        String tomcatXml = this.getInstallDir() + SysInfo.FS + "tomcat" + SysInfo.FS + "conf" + SysInfo.FS + "server.xml";
        return Util.exists(jbossXml) || Util.exists(tomcatXml);
    }

    public String getRemote(String name) {
        String remote = this._codebase + name + (this._noCompress ? ".jar" : ".tbz2");
        return remote;
    }

    public String getLocal(String name) {
        String local = this.getLibDir() + File.separator + name + ".jar";
        return local;
    }

    public String getDMLocal(String name) {
        String local = this.getDMLibDir() + File.separator + name + ".jar";
        this.logger.debug((Object)("local: " + local));
        return local;
    }

    public String getFMLocal(String name) {
        String local = this.getFMLibDir() + File.separator + name + ".jar";
        return local;
    }

    public SwitchVersion getVersion(String dir) {
        if (dir == null) {
            return new SwitchVersion(null);
        }
        String cPath = dir + File.separator + "install.conf";
        if (this.checkInstallDir2(dir) || Util.exists(cPath)) {
            return new SwitchVersion(Util.loadProps(cPath).getProperty("mds.version"));
        }
        return new SwitchVersion(Util.getJarVersion(dir + File.separator + "snmp.jar"));
    }

    public void setNoCompress(boolean b) {
        this._noCompress = b;
    }

    public boolean getNoCompress() {
        return this._noCompress;
    }

    public void fetchAndLoadDll() throws IOException {
        ClassLoader ldr = Thread.currentThread().getContextClassLoader();
        URL url = ldr.getResource("MDSInstall.dll");
        String dllPath = SysInfo.TMP + File.separator + "MDSInstall.dll";
        if (Util.exists(dllPath)) {
            Util.delete(dllPath);
        }
        System.err.println(System.getProperty("java.class.path"));
        System.err.println("URL is " + url);
        try {
            Util.download(url.toString(), dllPath);
        }
        catch (IOException ex) {
            this.logger.error((Object)(ex.getMessage() + "\nPlease ensure that no other instances of " + INSTALLER_NAME + " are running."));
        }
        Service.loadDll(dllPath);
    }

    public String findInstallDir(String hintDir) {
        String defaultDir;
        String oldDir = null;
        String dir = ClientCache.getDir();
        String conf = dir + File.separator + "install.conf";
        if (Util.exists(dir) && Util.exists(conf)) {
            Properties props = Util.loadProps(conf);
            String root = props.getProperty("mds.nmsRoot");
            if (root != null && this.checkInstallDir2(root)) {
                oldDir = root;
            } else if (this.checkInstallDir1(dir)) {
                oldDir = dir;
            }
        }
        if (oldDir == null && this.checkInstallDir2(defaultDir = this.getDefaultInstallDir())) {
            oldDir = defaultDir;
        }
        if (oldDir == null && dir != null && this.checkInstallDir(hintDir)) {
            oldDir = hintDir;
        }
        return oldDir;
    }

    protected boolean checkInstallDir(String dir) {
        return this.checkInstallDir2(dir) || this.checkInstallDir1(dir);
    }

    protected boolean checkInstallDir1(String dir) {
        String prefix = dir + File.separator;
        return Util.exists(prefix + "jnm.jar") && Util.exists(prefix + "snmp.jar");
    }

    public boolean checkInstallDir2(String dir) {
        String prefix = dir + File.separator;
        String libPrefix = prefix + "lib" + File.separator;
        return Util.exists(prefix + "install.conf") && Util.exists(libPrefix + "jnm.jar") && Util.exists(libPrefix + "snmp.jar");
    }

    public String getDefaultInstallDir() {
        boolean onWin = System.getProperty("os.name").startsWith("Windows");
        if (onWin) {
            try {
                return Service.getProgramFiles() + "\\Cisco Systems\\";
            }
            catch (UnsatisfiedLinkError ex) {
                this.getWinDefaultInstallDirFail = true;
                this.logger.warn((Object)("Installer getDefaultInstallDir 64bit? ex=" + ex));
                return "C:\\Program Files\\Cisco Systems\\";
            }
        }
        String global = "/usr/local/cisco";
        if (Util.exists(global)) {
            return global;
        }
        if (Util.mkdir(global)) {
            Util.delete(global);
            return global;
        }
        return System.getProperty("user.home") + File.separator + "cisco";
    }

    void readArgs(HashMap argsMap) throws Exception {
        String verString;
        this._codebase = this.getArg(argsMap, "-home");
        if (!this.existsArg(argsMap, "-version")) {
            Class<?> consClazz = Class.forName("com.cisco.dcbu.Constants");
            Field f = consClazz.getField("VERSION");
            verString = (String)f.get(null);
        } else {
            verString = this.getArg(argsMap, "-version");
        }
        this._ver = new SwitchVersion(verString);
        this._globalAlias = this.existsArg(argsMap, "-alias");
        this._noCompress = this.existsArg(argsMap, "-nocompress");
        this._host = this.getArg(argsMap, "-host");
        this._nic = this.getArg(argsMap, "-nic");
        this._iDir = this.getArg(argsMap, "-dir");
        this._remove = this.existsArg(argsMap, "-remove");
        if (this.existsArg(argsMap, "-webstart")) {
            this._webStartPort = Integer.parseInt(this.getArg(argsMap, "-webstart"));
        }
    }

    boolean existsArg(HashMap argsMap, String name) {
        return argsMap.containsKey(name);
    }

    String getArg(HashMap argsMap, String name) {
        if (argsMap.containsKey(name)) {
            return (String)argsMap.get(name);
        }
        return null;
    }

    boolean checkFinalDir() throws Exception {
        if (this._iDir.equals(this._uDir)) {
            System.out.println("Cannot install in " + this._uDir);
            System.err.println("Cannot install in " + this._uDir);
            return false;
        }
        File dir = new File(this._iDir);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                System.out.println(this._iDir + " is not a valid folder");
                System.err.println(this._iDir + " is not a valid folder");
                return false;
            }
            if (this._downloadFiles && !dir.canWrite()) {
                System.out.println("Cannot write to " + this._iDir);
                System.err.println("Cannot write to " + this._iDir);
                return false;
            }
        } else if (!(!this._downloadFiles || dir.mkdirs() && dir.canWrite())) {
            System.out.println("Failed to create/write " + this._iDir);
            System.err.println("Failed to create/write " + this._iDir);
            return false;
        }
        return true;
    }

    void checkDowngradeVersion() throws Exception {
        if (this._oldVer == null || this._oldVer.isUnknown()) {
            return;
        }
        if (this._ver != null && this._oldVer != null && this._ver.lessThan(this._oldVer)) {
            throw new Exception("Downgrade from " + this._oldVer.toString() + " to " + this._ver.toString() + " is not supported");
        }
    }

    boolean checkNic(String nic) {
        if (nic != null) {
            try {
                NetUtil.getLocalAddressByName((String)nic);
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace(System.err);
                return false;
            }
        }
        return true;
    }

    public void stopServices() throws IOException {
        this.logger.warn((Object)"Stopping Old Services");
        ClientCache.setInstallDir(this.getOldInstallDir());
        boolean stoppedSome = false;
        for (int i = Service.ALL_SERVICES.length - 1; i >= 0; --i) {
            String name = Service.ALL_SERVICES[i];
            if (!Service.isInstalled(name) || !Service.isRunning(name)) continue;
            this.logger.info((Object)("Stopping " + Service.getName(name)));
            Service.stop(name);
            stoppedSome = true;
        }
        if ((this.getVersion().isUnknown() || this.getVersion().lessThan(VER31)) && Service.isInstalled("PMCollector") && Service.isRunning("PMCollector")) {
            System.err.println("Stop Cisco MDS Performance Manager");
            Service.stop("PMCollector");
            stoppedSome = true;
        }
        if (SysInfo.ONSOLARIS && Util.exists(SysInfo.FS + "var" + SysInfo.FS + "svc" + SysInfo.FS + "manifest" + SysInfo.FS + "site" + SysInfo.FS + "application" + SysInfo.FS + "fmserver.xml")) {
            String cmd = SysInfo.FS + "usr" + SysInfo.FS + "sbin" + SysInfo.FS + "svcadm" + " disable fmserver";
            try {
                Util.exec(cmd);
            }
            catch (Exception ex) {
                this.logger.error((Object)(cmd + ": " + ex.getMessage()));
            }
        }
        if (stoppedSome) {
            this.logger.info((Object)"Waiting for services to stop");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            int tries = 0;
            while (Service.isRunning("FMPersist")) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++tries != 5) continue;
                break;
            }
        }
    }

    public void deleteServices() {
        try {
            if (Service.isInstalled("FMPersist")) {
                Service.delete("FMPersist");
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unable to delete FMPersist: " + ex.getMessage()));
        }
        try {
            if (Service.isInstalled("PMCollector")) {
                Service.delete("PMCollector");
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unable to delete PMCollector: " + ex.getMessage()));
        }
        try {
            if (Service.isInstalled("FMWebClient")) {
                Service.delete("FMWebClient");
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unable to delete FMWebClient: " + ex.getMessage()));
        }
    }

    public void stopFMS() {
        this.logger.info((Object)"Attempting to shut down SAN Server");
        if (Service.isInstalled("SAN Server")) {
            String[] cmds;
            if (SysInfo.ONWINDOWS) {
                cmds = new String[]{"net", "stop", "SAN Server"};
            } else {
                String nmsBin = ClientCache.getInstallDir() + SysInfo.FS + "bin";
                String script = nmsBin + SysInfo.FS + "SAN Server" + ".sh";
                cmds = new String[]{script, "stop"};
            }
            try {
                Runtime.getRuntime().exec(cmds);
            }
            catch (Exception ex) {
                this.logger.error((Object)"Error occur stopping SAN Server");
            }
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void downloadFiles() throws IOException {
        String remote;
        int i;
        String remote2;
        int i2;
        System.gc();
        Util.mkdir(this.getLibDir());
        this.logger.warn((Object)"Downloading Files");
        if (!this.isStandalone) {
            if (!this.isUpdater()) {
                this.logger.info((Object)"Fetching JBoss");
                Util.download(this.getCodebase() + "jboss.zip", this.getLibDir() + SysInfo.FS + "jboss.zip");
                Util.download(this.getCodebase() + "jboss-fms.zip", this.getLibDir() + SysInfo.FS + "jboss-fms.zip");
            }
            this.logger.info((Object)"Fetching dcm.ear");
            Util.download(this.getCodebase() + "dcm.ear", this.getLibDir() + SysInfo.FS + "dcm.ear");
            Util.download(this.getCodebase() + "fm-run.jar", this.getLibDir() + SysInfo.FS + "fm-run.jar");
        }
        String[] files = new String[]{"agent", "bitmaps", "dm", "dmdb", "portland", "fmhelp", "tacclient", "esper", FMENTRY, "hsqldb", "jchart", "jcommon-1.0.16", "jdbcpool", "jfreechart-1.0.13", "lucene-core-2.4", "jnm", "jradius-client", "log4j", "layout", "pm", "sm", "snmp", "sanmgr-topo", "native", "crimson", "activation", "mail", "download", "postgresql-8.1", "installer", "commons-codec-1.3"};
        for (i2 = 0; i2 < files.length; ++i2) {
            this.logger.info((Object)("Fetching " + files[i2]));
            remote2 = this.getRemote(files[i2]);
            Util.download(remote2, this.getLocal(files[i2]));
        }
        for (i2 = 0; i2 < DMFiles.length; ++i2) {
            this.logger.info((Object)("Fetching " + DMFiles[i2]));
            remote2 = this.getRemote(DMFiles[i2]);
            Util.download(remote2, this.getDownloadDir() + SysInfo.FS + DMFiles[i2] + ".jar");
        }
        Util.copy(this.getLibDir() + SysInfo.FS + "fmhelp.jar", this.getDownloadDir() + SysInfo.FS + "fmhelp.jar");
        Util.mkdir(this.getFMLibDir());
        for (i2 = 0; i2 < ILOGFiles.length; ++i2) {
            remote2 = this.getRemote(ILOGFiles[i2]);
            this.logger.info((Object)("Fetching " + ILOGFiles[i2]));
            Util.download(remote2, this.getDownloadDir() + File.separator + ILOGFiles[i2] + ".jar");
            Util.download(remote2, (this.isStandalone ? this.getLibDir() : this.getFMLibDir()) + File.separator + ILOGFiles[i2] + ".jar");
        }
        boolean noCompress = this._noCompress;
        this._noCompress = true;
        this.logger.info((Object)"Fetching boot");
        Util.download(this.getRemote("boot"), this.getDownloadDir() + File.separator + "boot.jar");
        Util.download(this.getRemote("commons-codec-1.3"), this.getDownloadDir() + File.separator + "commons-codec-1.3.jar");
        Util.mkdir(this.getFMLibDir());
        for (i = 0; i < JIDEFiles.length; ++i) {
            remote = this.getRemote(JIDEFiles[i]);
            this.logger.info((Object)("Fetching " + JIDEFiles[i]));
            Util.download(remote, this.getDownloadDir() + File.separator + JIDEFiles[i] + ".jar");
            Util.download(remote, (this.isStandalone ? this.getLibDir() : this.getFMLibDir()) + File.separator + JIDEFiles[i] + ".jar");
        }
        for (i = 0; i < FLEXlmFiles.length; ++i) {
            remote = this.getRemote(FLEXlmFiles[i]);
            this.logger.info((Object)("Fetching " + FLEXlmFiles[i]));
            Util.download(remote, this.getDownloadDir() + File.separator + FLEXlmFiles[i] + ".jar");
            Util.download(remote, (this.isStandalone ? this.getLibDir() : this.getFMLibDir()) + File.separator + FLEXlmFiles[i] + ".jar");
        }
        for (i = 0; i < RESTFiles.length; ++i) {
            remote = this.getRemote(RESTFiles[i]);
            this.logger.info((Object)("Fetching " + RESTFiles[i]));
            Util.download(remote, this.getDownloadDir() + File.separator + RESTFiles[i] + ".jar");
            Util.download(remote, (this.isStandalone ? this.getLibDir() : this.getFMLibDir()) + File.separator + RESTFiles[i] + ".jar");
        }
        if (this.isStandalone()) {
            String[] hFiles;
            for (String file : hFiles = new String[]{"antlr", "cglib", "dom4j", "hibernate3", "hibernate-annotations", "hibernate-entitymanager", "javassist", "ejb3-persistence", "commons-logging"}) {
                this.logger.info((Object)("Fetching " + file));
                Util.download(this.getRemote(file), this.getLocal(file));
            }
        }
        this.logger.info((Object)"Fetching GemSafe_Standard32_OEM_5.1.08.setup.msi");
        Util.download(this._codebase + GEMSAFE, this.getDownloadDir() + SysInfo.FS + GEMSAFE);
        this.logger.info((Object)"Fetching m9000-lc1-gplug-mz.1.0.3.bin");
        Util.download(this._codebase + FLASHIMAGE, this.getBinDir() + SysInfo.FS + FLASHIMAGE);
        String[] SMIS_JARS = new String[]{"axis", "commons-discovery-0.2", "commons-logging-1.0.4", "jaxrpc", "jbossall-client", "wsdl4j-1.5.1", "saaj", "ciscoprov", "fmwslib", "jnp-client", "jboss-common-client", "jboss-j2ee"};
        this.logger.info((Object)"Fetching SMI-S files");
        Util.mkdir(this.getSMISLibDir());
        for (String file : SMIS_JARS) {
            this.logger.info((Object)("Fetching " + file));
            Util.download(this.getRemote(file), this.getSMISLibDir() + SysInfo.FS + file + ".jar");
        }
        this.logger.info((Object)"Fetching logr.zip");
        Util.download(this._codebase + "logr.zip", this.getSMISLibDir() + SysInfo.FS + "logr.zip");
        String[] VM_JARS = new String[]{"vijava2u120091204src", "commons-lang-2.4", "dom4j-1.6.1"};
        this.logger.info((Object)"Fetching VM files");
        Util.mkdir(this.getVMLibDir());
        for (String file : VM_JARS) {
            this.logger.info((Object)("Fetching " + file));
            Util.download(this.getRemote(file), this.getVMLibDir() + SysInfo.FS + file + ".jar");
        }
        if (SysInfo.ONWINDOWS) {
            this.logger.info((Object)"Fetching ws_windows.zip");
            Util.download(this._codebase + "ws_windows.zip", this.getDownloadDir() + SysInfo.FS + "ws_windows.zip");
        }
        if (SysInfo.ONLINUX) {
            this.logger.info((Object)"Fetching ws_linux.zip");
            Util.download(this._codebase + "ws_linux.zip", this.getDownloadDir() + SysInfo.FS + "ws_linux.zip");
        }
        this.logger.warn((Object)"Finished Downloading Files");
        this._noCompress = noCompress;
    }

    public void installJServer(String iDir) throws Exception {
        this.logger.warn((Object)"Installing SMI-S JServer");
        String wszip = null;
        if (SysInfo.ONWINDOWS) {
            wszip = "ws_windows.zip";
        } else if (SysInfo.ONLINUX) {
            wszip = "ws_linux.zip";
        }
        if (wszip != null) {
            String jserverPath = iDir + SysInfo.FS + wszip;
            this.logger.info((Object)("Copying " + wszip));
            Util.copy(this.getDownloadDir() + SysInfo.FS + wszip, jserverPath);
            Util.extract(jserverPath, iDir);
            Util.delete(jserverPath);
        }
    }

    public void installSmis(String jserverRoot) throws Exception {
        String logrZip = "logr.zip";
        String logrPath = jserverRoot + SysInfo.FS + "logr.zip";
        this.logger.info((Object)"Copying logr.zip");
        Util.copy(this.getSMISLibDir() + SysInfo.FS + "logr.zip", logrPath);
        Util.delete(jserverRoot + SysInfo.FS + "logr");
        Util.extract(logrPath, jserverRoot);
        Util.delete(logrPath);
        Util.mkdir(jserverRoot + SysInfo.FS + "logs");
    }

    public void backupFiles() throws Exception {
        this.logger.info((Object)"Backing up Files");
        String tDir = this.getInstallDir();
        if (!Util.exists(tDir)) {
            Util.mkdir(tDir);
        }
        for (String file : this.pFiles) {
            file = this.getTmpDir() + File.separator + file;
            if (Util.exists(file)) {
                Util.copy(file, file + "_bak");
                continue;
            }
            this.logger.debug((Object)(file + " does not exist."));
        }
        String crPath = this.getOldInstallDir() + SysInfo.FS + "download" + SysInfo.FS + "copyright.txt";
        if (Util.exists(crPath)) {
            this.logger.info((Object)"Backing up copyright.txt");
            Util.copy(crPath, this.getTmpDir() + SysInfo.FS + "copyright.txt");
        }
    }

    public void restoreFiles() throws Exception {
        try {
            if (!Util.exists(this.getDownloadDir())) {
                Util.mkdir(this.getDownloadDir());
            }
            String cr = "copyright.txt";
            String crPath = this.getTmpDir() + SysInfo.FS + "copyright.txt";
            if (Util.exists(crPath)) {
                this.logger.info((Object)"Restoring backuped files");
                Util.copy(crPath, this.getDownloadDir() + SysInfo.FS + "copyright.txt");
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unable to restore copyright.txt: " + ex.getMessage()));
        }
    }

    public void backupCert() {
        this.logger.info((Object)"Backing up certs and keystores");
        String where = this.getOldInstallDir() + SysInfo.FS + "conf" + SysInfo.FS + "cert";
        File oldCert = new File(where);
        if (oldCert.exists()) {
            try {
                Util.copyFiles(where, where + "_bak");
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to create " + where + "_bak"));
            }
        }
        if ((oldCert = new File(where = this.getOldJBossConf())).exists()) {
            try {
                Util.copyFiles(where, where + "_bak");
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to create " + where + "_bak"));
            }
        }
    }

    private String getOldJBossConf() {
        String where = this.getOldVersion().compareTo(new SwitchVersion("4.1(3)")) < 0 ? this.getOldInstallDir() + SysInfo.FS + jbossConf : this.getJBossDir() + SysInfo.FS + "server" + SysInfo.FS + FM_PROFILE + SysInfo.FS + "conf";
        return where;
    }

    public void restoreCert() {
        this.logger.info((Object)"Restoring certs and keystores");
        String where = this.getOldInstallDir() + SysInfo.FS + "conf" + SysInfo.FS + "cert" + "_bak";
        String dest = this.getConfDir() + SysInfo.FS + "cert";
        if (Util.exists(where) && Util.isDirectory(where)) {
            try {
                File from = new File(where);
                File[] lists = from.listFiles();
                Vector names = new Vector();
                for (File f : lists) {
                    if (f.isDirectory() || !f.isFile()) continue;
                    Util.copy(where + SysInfo.FS + f.getName(), dest + SysInfo.FS + f.getName());
                }
                Util.delete(where);
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to copy certicates, please copy " + where + " to " + dest + "."));
            }
        }
    }

    public void extractFiles() throws Exception {
        String fmclient;
        this.logger.warn((Object)"Extracting files");
        this.extractNative();
        if (!this.isStandalone) {
            this.logger.warn((Object)"Setting up JBoss");
            if (!this.isUpdater()) {
                DCNMInfo dcnmInfo = null;
                String jbossDir = "";
                try {
                    dcnmInfo = DCNMInfo.getInstance();
                    if (dcnmInfo.isCompatible()) {
                        jbossDir = dcnmInfo.getInstallLocation() + SysInfo.FS + "dcm" + SysInfo.FS + JBOSS_DIST;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                File tmp1 = new File(jbossDir);
                File tmp2 = new File(this.getJBossDir());
                if (!(Util.exists(jbossDir) && Util.exists(jbossDir + SysInfo.FS + "bin") && Util.exists(jbossDir + SysInfo.FS + "lib") && Util.exists(jbossDir + SysInfo.FS + "server") && tmp1.equals(tmp2))) {
                    String jboss = this.getLibDir() + File.separator + "jboss.zip";
                    Util.extract(jboss, this.getDCMDir());
                    Util.delete(jboss);
                }
                String runJar = this.getLibDir() + SysInfo.FS + "fm-run.jar";
                Util.copy(runJar, this.getJBossDir() + SysInfo.FS + "bin" + SysInfo.FS + "fm-run.jar");
                Util.delete(runJar);
                String fms = this.getLibDir() + SysInfo.FS + "jboss-fms.zip";
                String fmsDir = this.getJBossDir() + SysInfo.FS + "server" + SysInfo.FS + FM_PROFILE;
                if (!Util.exists(fmsDir) && !Util.mkdir(fmsDir)) {
                    throw new Exception("Unable to create " + fmsDir);
                }
                Util.extract(fms, fmsDir);
            }
            String ear = this.getLibDir() + SysInfo.FS + "dcm.ear";
            String earDir = this.getDeployDir() + SysInfo.FS + "dcm.ear";
            Util.delete(earDir);
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Util.mkdir(earDir);
            Util.extract(ear, earDir, true);
            Util.delete(ear);
            Util.copy(earDir + SysInfo.FS + "dcm.jar", earDir + SysInfo.FS + "extractdcm.jar");
            Util.delete(earDir + SysInfo.FS + "dcm.jar");
            Util.mkdir(earDir + SysInfo.FS + "dcm.jar");
            Util.extract(earDir + SysInfo.FS + "extractdcm.jar", earDir + SysInfo.FS + "dcm.jar", true);
            Util.delete(earDir + SysInfo.FS + "extractdcm.jar");
        } else {
            this.logger.warn((Object)"Setting up fm files");
            fmclient = this.getLibDir() + SysInfo.FS + "download.jar";
            Util.extract(fmclient, this.getLibDir());
        }
        this.logger.warn((Object)"Setting up client files");
        fmclient = this.getLibDir() + SysInfo.FS + "download.jar";
        Util.extract(fmclient, this.getDownloadDir());
        this.logger.warn((Object)"Setting up help");
        String fmhelp = this.getLibDir() + SysInfo.FS + "fmhelp.jar";
        Util.extract(fmhelp, this.getHelpDir());
    }

    protected void extractNative() throws Exception {
        this.logger.info((Object)"Extracting native");
        String iDir = this.getFMDir();
        String[] tNames = new String[]{"MDSNMSROOT", "NMSJBOSSHOME", "NMSJBOSSDQHOME", "MDSNMSDQROOT", "MDSNMSADDR", "MDSJVMARGS", "MDSJAVACMD", "MDSJAVA", "MDSGLOBALALIAS", "MDSNMSTEMPDIR", "MDSNMSSEPARATOR", "MDSNMSUSERHOME", "SMISROOT"};
        String vmArgs = SysInfo.ONWINDOWS ? "-Xms6m -Dswing.defaultlaf=com.sun.java.swing.plaf.windows.WindowsLookAndFeel -Dmds.nmsRoot=\"" + iDir + "\"" : "-Xms6m -Dmds.nmsRoot=" + iDir;
        String bindaddress = this.getNIC();
        if (bindaddress == null) {
            bindaddress = "0.0.0.0";
        }
        String[] tValues = new String[]{iDir, this.getJBossDir(), SysInfo.ONWINDOWS ? "\"" + this.getJBossDir() + "\"" : this.getJBossDir(), SysInfo.ONWINDOWS ? "\"" + iDir + "\"" : iDir, bindaddress, vmArgs, SysInfo.JCMDEXEC, SysInfo.JEXEC, Boolean.toString(this.getGlobalAlias()), SysInfo.TMP, SysInfo.PS, SysInfo.ONWINDOWS ? "\"" + ClientCache.getDir() + "\"" : ClientCache.getDir(), SysInfo.ONWINDOWS ? "\"" + this.getSMISDir() + "\"" : this.getSMISDir()};
        Util.extract(this.getLibDir() + SysInfo.FS + "native.jar", iDir, true, tNames, tValues, null, null, false);
        if (!SysInfo.ONWINDOWS) {
            Util.createExec(this.getBinDir());
        }
        String uFile = "Uninstall" + SysInfo.ESUFFIX;
        Util.copy(this.getBinDir() + SysInfo.FS + uFile, this.getFMDir() + SysInfo.FS + uFile);
        Util.delete(this.getBinDir() + SysInfo.FS + uFile);
        Util.createExec(this.getFMDir(), uFile);
    }

    public void installDBWindows() throws Exception {
        this.logger.warn((Object)"Setting up Database");
        this.logger.info((Object)"Fetching PostgreSQL");
        Util.download(this.getCodebase() + "postgres-win.zip", this.getTmpDir() + SysInfo.FS + "postgres-win.zip");
        Thread.sleep(2000L);
        this.logger.info((Object)"Setting up PostgreSQL");
        String pgDir = this.getInstallDir() + SysInfo.FS + "postgres";
        Util.mkdir(pgDir);
        String pgData = pgDir + SysInfo.FS + "data";
        Util.extract(this.getTmpDir() + SysInfo.FS + "postgres-win.zip", this.getInstallDir());
        Thread.sleep(2000L);
        this.logger.info((Object)"Creating Cisco Fabric Manager's Windows account");
        String username = FMUSER;
        String password = FMPASSWORD;
        String computerName = System.getenv("COMPUTERNAME");
        String createUser = "cmd /c net user " + username + " " + password + " /ADD /COMMENT:\"Cisco Fabric Manager PostgreSQL account\" /EXPIRES:NEVER /FULLNAME:\"" + username + "\" /PASSWORDCHG:NO /WORKSTATION:\"" + computerName + "\"";
        this.logger.info((Object)("Creating user: " + createUser));
        Process proc = Runtime.getRuntime().exec(createUser);
        StreamReader oReader = new StreamReader(proc.getInputStream());
        StreamReader eReader = new StreamReader(proc.getErrorStream());
        oReader.start();
        eReader.start();
        int rc = proc.waitFor();
        if (rc != 0) {
            this.logger.error((Object)("Create user failed: " + rc));
        }
        Thread.sleep(2000L);
        this.logger.info((Object)"Initializing database");
        String initDB = "\"" + pgDir + SysInfo.FS + "bin\\initdb.exe\" -U admin -D \"" + pgData + "\"";
        this.logger.info((Object)("initializing DB: " + initDB));
        proc = Runtime.getRuntime().exec(initDB);
        oReader = new StreamReader(proc.getInputStream());
        eReader = new StreamReader(proc.getErrorStream());
        oReader.start();
        eReader.start();
        rc = proc.waitFor();
        if (rc != 0) {
            String message = "Initializing database failed: " + rc;
            this.logger.error((Object)message);
            throw new Exception(message);
        }
        Util.copy(pgData + SysInfo.FS + "pg_hba.conf", pgData + SysInfo.FS + "pg_hba.conf_bak");
        Util.copy(pgData + SysInfo.FS + "postgresql.conf", pgData + SysInfo.FS + "postgresql.conf_bak");
        Util.copy(pgDir + SysInfo.FS + "pg_hba.conf", pgData + SysInfo.FS + "pg_hba.conf");
        Util.delete(pgDir + SysInfo.FS + "pg_hba.conf");
        Util.copy(pgDir + SysInfo.FS + "postgresql.conf", pgData + SysInfo.FS + "postgresql.conf");
        Util.delete(pgDir + SysInfo.FS + "postgresql.conf");
        Thread.sleep(4000L);
        this.logger.info((Object)"Register Service");
        String register = "\"" + pgDir + "\\bin\\pg_ctl.exe\" register -N \"" + username + "\" -D \"" + pgData + "\"";
        this.logger.debug((Object)("creating DB " + register));
        proc = Runtime.getRuntime().exec(register);
        oReader = new StreamReader(proc.getInputStream());
        eReader = new StreamReader(proc.getErrorStream());
        rc = proc.waitFor();
        oReader.start();
        eReader.start();
        if (rc != 0) {
            String message = "Register service failed: " + rc;
            this.logger.error((Object)message);
        }
        Thread.sleep(10000L);
        this.logger.info((Object)"Start Service");
        String[] startDB = new String[]{"net", "start", "postgres"};
        this.logger.info((Object)"creating DB ");
        proc = Runtime.getRuntime().exec(startDB);
        oReader = new StreamReader(proc.getInputStream());
        eReader = new StreamReader(proc.getErrorStream());
        rc = proc.waitFor();
        oReader.start();
        eReader.start();
        if (rc != 0) {
            String message = "Start service failed: " + rc;
            this.logger.error((Object)message);
            throw new Exception(message);
        }
        Thread.sleep(10000L);
        this.logger.info((Object)"Creating database");
        String createDB = "\"" + pgDir + "\\bin\\createdb.exe\" dcmdb -U " + username;
        this.logger.info((Object)("creating DB " + createDB));
        proc = Runtime.getRuntime().exec(createDB);
        oReader = new StreamReader(proc.getInputStream());
        eReader = new StreamReader(proc.getErrorStream());
        rc = proc.waitFor();
        oReader.start();
        eReader.start();
        if (rc != 0) {
            String message = "Creating DB failed: " + rc;
            this.logger.error((Object)message);
            throw new Exception(message);
        }
    }

    public void InstallDBUnix() throws Exception {
        this.logger.warn((Object)"Setting up Database");
        String userDb = this.getInstallDir() + SysInfo.FS + ".db";
        String userBinary = this.getTmpDir();
        Util.mkdir(userDb);
        Util.mkdir(userBinary);
        this.logger.info((Object)"Fetching PostgreSQL");
        String file2fetch = SysInfo.ONSOLARIS ? "postgres-solaris.zip" : "postgres-rel-as-4.zip";
        String pgZip = userBinary + SysInfo.FS + file2fetch;
        Util.download(this.getCodebase() + file2fetch, pgZip);
        this.logger.info((Object)"Extracting PostgreSQL");
        String[] names = new String[]{"MDSNMSROOT", "MDSNMSDBUSER", "MDSNMSTMP"};
        String[] values = new String[]{this.getInstallDir(), FMUSER, this.getTmpDir()};
        Util.extract(pgZip, userBinary, true, names, values, null, null, false);
        Util.copy(userBinary + SysInfo.FS + "DB.sh", this.getBinDir() + SysInfo.FS + "DB.sh");
        Util.chmod(this.getBinDir() + SysInfo.FS + "DB.sh", "770");
        Util.chmod(userBinary + SysInfo.FS + "installDB.sh", "700");
        String cmd = userBinary + SysInfo.FS + "installDB.sh";
        Process proc = Runtime.getRuntime().exec(cmd);
        StreamReader oReader = new StreamReader(proc.getInputStream());
        StreamReader eReader = new StreamReader(proc.getErrorStream());
        int rc = proc.waitFor();
        oReader.start();
        eReader.start();
        if (rc != 0) {
            String message = "Installing DB failed: " + rc;
            this.logger.error((Object)message);
            throw new Exception(message);
        }
    }

    public void installPostgresWin(String user, String password, String servicePassword, boolean domain) throws Exception {
        String[] pgFiles;
        if (Service.isInstalled("pgsql-8.2")) {
            return;
        }
        Util.download(this.getCodebase() + "postgres-win.zip", this.getTmpDir() + SysInfo.FS + "postgres-win.zip");
        Util.mkdir(this.getUserDir() + SysInfo.FS + "postgres-win");
        Util.extract(this.getTmpDir() + SysInfo.FS + "postgres-win.zip", this.getUserDir());
        String pgf = this.getUserDir() + SysInfo.FS + "postgres-win" + SysInfo.FS;
        for (String file : pgFiles = new String[]{"postgresql-8.2.msi", "postgresql-8.2-int.msi", "upgrade.bat", "pg_hba.conf", "postgresql.conf"}) {
            if (Util.exists(pgf + file)) continue;
            this.logger.error((Object)(file + " does not exist."));
            throw new Exception(file + " does not exist.");
        }
        String computername = System.getenv(domain ? "USERDOMAIN" : "COMPUTERNAME");
        if (computername == null) {
            computername = "DOMAIN";
        }
        String installDir = this.getInstallPgDir();
        Util.delete(installDir + SysInfo.FS + "data");
        String[] deleteUserCmd = new String[]{"cmd", "/c", "net", "user", "/delete", "postgres"};
        if (Util.exec(deleteUserCmd)) {
            // empty if block
        }
        String installDBCmd = new String("msiexec /i \"" + pgf + "postgresql-8.2-int.msi\" /qb INTERNALLAUNCH=1 " + "ADDLOCAL=server,psql,pgadmin SERVICEACCOUNT=postgres SUPERUSER=" + user + " SERVICEDOMAIN=" + computername + " " + "SERVICEPASSWORD=" + servicePassword + " SUPERPASSWORD=" + password + " CREATESERVICEUSER=1 DOINITDB=1 DOSERVICE=1 PERMITREMOTE=1 " + "SERVICEOK=1 INITDBOK=1 NOSHORTCUTS=0 BASEDIR=\"" + installDir + "\"");
        this.logger.warn((Object)"Installing PostgreSQL");
        Util.exec(installDBCmd);
        if (!Service.isInstalled("pgsql-8.2")) {
            throw new Exception(FAILTOINSTALLPG);
        }
        if (!Service.isRunning("pgsql-8.2")) {
            Service.start("pgsql-8.2");
            Thread.sleep(5000L);
        }
        if (!Service.isRunning("pgsql-8.2")) {
            throw new Exception(FAILTOINSTALLPG);
        }
    }

    public void preInstall() throws Exception {
        if (this.getOldInstallDir() != null) {
            this.stopServices();
            this.backupFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getShm(String shm) {
        BufferedReader rdr = null;
        String line = null;
        try {
            if (!Util.exists(shm)) {
                throw new FileNotFoundException(shm + " does not exist");
            }
            rdr = new BufferedReader(new FileReader(shm));
            line = rdr.readLine();
            if (line != null) {
                this.logger.info((Object)("shmall = " + line));
                line = line.trim();
                if (line.startsWith("0x")) {
                    line = line.substring("0x".length());
                    long l = Integer.parseInt(line, 16);
                    return l;
                }
                long l = Long.parseLong(line);
                return l;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unable to read " + shm + ". cause: " + ex.getMessage()));
        }
        finally {
            try {
                if (rdr != null) {
                    rdr.close();
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)ex.getMessage());
            }
        }
        return -1L;
    }

    public boolean checkSolarisMemorySetting() {
        boolean dontCheck = true;
        if (dontCheck) {
            return true;
        }
        String sysFile = "/etc/system";
        if (!Util.exists("/etc/system")) {
            this.logger.error((Object)"/etc/system does not exist");
            return false;
        }
        long shmmax = this.getMemorySetting("/etc/system", "shminfo_shmmax");
        if (shmmax < 0x2000000L) {
            return false;
        }
        long shmmin = this.getMemorySetting("/etc/system", "shminfo_shmmin");
        if (shmmin < 1L) {
            return false;
        }
        long shmmni = this.getMemorySetting("/etc/system", "shminfo_shmmni");
        if (shmmni < 256L) {
            return false;
        }
        long shmseg = this.getMemorySetting("/etc/system", "shminfo_shmseg");
        if (shmseg < 256L) {
            return false;
        }
        long semmap = this.getMemorySetting("/etc/system", "seminfo_semmap");
        if (semmap < 256L) {
            return false;
        }
        long semmni = this.getMemorySetting("/etc/system", "seminfo_semmni");
        if (semmni < 512L) {
            return false;
        }
        long semmns = this.getMemorySetting("/etc/system", "seminfo_semmns");
        if (semmns < 512L) {
            return false;
        }
        long semmsl = this.getMemorySetting("/etc/system", "seminfo_semmsl");
        return semmsl >= 32L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMemorySetting(String file, String key) {
        BufferedReader rdr = null;
        String line = null;
        try {
            rdr = new BufferedReader(new FileReader(file));
            while ((line = rdr.readLine()) != null) {
                line = line.trim();
                this.logger.info((Object)line);
                if (line.startsWith("*") || !line.contains(key)) continue;
                if ((line = line.substring(line.indexOf("=") + 1)).startsWith("0x")) {
                    line = line.substring("0x".length());
                    long l = Long.parseLong(line, 16);
                    return l;
                }
                long l = Long.parseLong(line);
                return l;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unable to read " + file + ". cause: " + ex.getMessage()));
        }
        finally {
            try {
                if (rdr != null) {
                    rdr.close();
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)ex.getMessage());
            }
        }
        return -1L;
    }

    public boolean checkSharedMemory() {
        boolean dontCheck = true;
        if (dontCheck) {
            return true;
        }
        String shmmaxFile = "/proc/sys/kernel/shmmax";
        String shmallFile = "/proc/sys/kernel/shmall";
        if (Util.exists("/proc/sys/kernel/shmmax")) {
            long shmmax = this.getShm("/proc/sys/kernel/shmmax");
            if (shmmax < 0x8000000L) {
                return false;
            }
        } else {
            this.logger.error((Object)"/proc/sys/kernel/shmmax does not exist.");
        }
        if (Util.exists("/proc/sys/kernel/shmall")) {
            long shmall = this.getShm("/proc/sys/kernel/shmall");
            if (shmall < 0x200000L) {
                return false;
            }
        } else {
            this.logger.error((Object)"/proc/sys/kernel/shmall does not exist.");
        }
        return true;
    }

    public void installServerDll() {
        try {
            String jvmdll;
            String binDir = SysInfo.JHOME + SysInfo.FS + "bin" + SysInfo.FS + "server";
            if (!Util.exists(binDir)) {
                Util.mkdir(binDir);
            }
            if (Util.exists(jvmdll = binDir + SysInfo.FS + "jvm.dll")) {
                this.logger.info((Object)"jvm dll already exists.");
                return;
            }
            String orgdll = this.getBinDir() + SysInfo.FS + "jvm.dll";
            this.logger.info((Object)("installing jvm dll, copying " + orgdll + " to " + jvmdll));
            Util.copy(orgdll, jvmdll);
            Util.delete(orgdll);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Failed to install server.dll. Cause: " + ex.getMessage()));
        }
    }

    public void installJCE() {
        try {
            String[] files = new String[]{"local_policy.jar", "US_export_policy.jar"};
            String jceZip = new String("jce_policy-1_5_0.zip");
            String secFolder = SysInfo.JHOME + SysInfo.FS + "lib" + SysInfo.FS + "security";
            Util.download(this.getCodebase() + jceZip, this.getLibDir() + SysInfo.FS + jceZip);
            Util.extract(this.getLibDir() + SysInfo.FS + jceZip, secFolder);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Failed to install JCE Policy. Cause: " + ex.getMessage() + "\nSME requires JCE policy files to be installed to run properly."));
        }
    }

    public void rollBack() {
    }

    public String getCWD() {
        File cwd = new File(".");
        try {
            return cwd.getCanonicalPath();
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to get CWD: " + e.getCause()));
            return null;
        }
    }

    public boolean hasSunPgBinary() {
        if (this.pgPath != null && Util.exists(this.pgPath)) {
            return true;
        }
        String codebase = this.getCodeBaseParent();
        if (codebase == null) {
            return false;
        }
        String sunpg = new String("postgres" + SysInfo.FS + "Solaris" + SysInfo.FS + "sunpg.zip");
        return Util.exists(codebase + sunpg);
    }

    private String getCodeBaseParent() {
        if (this._codebase == null) {
            return null;
        }
        File f = new File(this._codebase);
        String codebase = f.getParent();
        return codebase.substring(codebase.lastIndexOf("jar:file:" + SysInfo.FS) + 9) + SysInfo.FS;
    }

    public void installSunPg(String user) {
        if (!SysInfo.ONSOLARIS) {
            throw new RuntimeException("Unable to install PostgreSQL. Wrong platform.");
        }
        Util.delete("/tmp/.s.PGSQL.5432");
        Util.delete("/tmp/.s.PGSQL.5432.lock");
        String pg = this.getCodeBaseParent() + "postgres" + SysInfo.FS + "Solaris" + SysInfo.FS + "sunpg.zip";
        if (this.pgPath != null) {
            pg = this.pgPath;
        }
        this.logger.warn((Object)"Installing PostgreSQL");
        try {
            Util.extract(pg, this.getInstallPgDir());
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to get PostgreSQL: " + e.getCause()));
            throw new RuntimeException("Failed to get PostgreSQL: " + e.getCause());
        }
        String dDir = this.getInstallPgDir() + SysInfo.FS + "data";
        String dbSh = this.getInstallPgDir() + SysInfo.FS + "bin" + SysInfo.FS + "DB";
        try {
            Util.chown(user, dDir);
            Util.chmod(dDir, "700");
            Util.chmod(dbSh, "a+rwx");
            Util.copy(new FileInputStream(dbSh), dbSh + "_bak");
            Util.copy(new FileInputStream(dbSh + "_bak"), dbSh, new String[]{"MDSNMSDBHOME", "MDSNMSDBSTARTER"}, new String[]{this.getInstallPgDir(), user});
            Util.delete(dbSh + "_bak");
            Util.chmod(dbSh, "755");
            Util.createExec(this.getInstallPgDir() + SysInfo.FS + "pgsql" + SysInfo.FS + "bin");
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unable to set permission for " + dDir + ": " + ex.getCause()));
            throw new RuntimeException("Unable to set permission for " + dDir + ": " + ex.getCause());
        }
    }

    public void installPostgresSolaris(String user) {
        if (!SysInfo.ONSOLARIS) {
            throw new RuntimeException("Unable to install PostgreSQL. Wrong platform.");
        }
        Util.delete("/tmp/.s.PGSQL.5432");
        Util.delete("/tmp/.s.PGSQL.5432.lock");
        this.logger.warn((Object)"Installing PostgreSQL");
        String dbDir = this.getInstallPgDir();
        try {
            Util.download(this.getCodebase() + "postgres-sol.zip", this.getUserDir() + SysInfo.FS + "postgres-sol.zip");
            Util.mkdir(this.getInstallPgDir());
            Util.mkdir(dbDir + SysInfo.FS + "bin");
            Util.extract(this.getUserDir() + SysInfo.FS + "postgres-sol.zip", this.getInstallPgDir());
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to get PostgreSQL: " + e.getMessage()));
            throw new RuntimeException("Failed to get PostgreSQL: " + e.getMessage());
        }
        String dDir = dbDir + SysInfo.FS + "data";
        String dbSh = dbDir + SysInfo.FS + "bin" + SysInfo.FS + "DB";
        try {
            Util.chown(user, dDir);
            Util.chmod(dDir, "700");
            Util.chmod(dbSh, "a+rwx");
            Util.copy(new FileInputStream(dbSh), dbSh + "_bak");
            Util.copy(new FileInputStream(dbSh + "_bak"), dbSh, new String[]{"MDSNMSDBHOME", "MDSNMSDBSTARTER"}, new String[]{dbDir, user});
            Util.delete(dbSh + "_bak");
            Util.chmod(dbSh, "755");
            Util.createExec(dbDir + SysInfo.FS + "bin");
            Util.createExec(dbDir + SysInfo.FS + "pgsql" + SysInfo.FS + "bin");
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unable to set permission for " + dDir + ": " + ex.getCause()));
            throw new RuntimeException("Unable to set permission for " + dDir + ": " + ex.getCause());
        }
    }

    public boolean enableSolarisService(String manifest, String script) throws Exception {
        String svccfg = "/usr/sbin/svccfg";
        if (!Util.exists(svccfg)) {
            throw new Exception(svccfg + " not found");
        }
        String manDir = SysInfo.FS + "var" + SysInfo.FS + "svc" + SysInfo.FS + "manifest" + SysInfo.FS + "site" + SysInfo.FS + "application";
        Util.mkdir(manDir);
        Util.copy(new FileInputStream(this.getTmpDir() + SysInfo.FS + manifest), manDir + SysInfo.FS + manifest, new String[]{"MDSNMSSCRIPT"}, new String[]{script});
        if (!Util.exec(svccfg + " validate " + manDir + SysInfo.FS + manifest)) {
            this.logger.error((Object)("Unable to validate startup manifest for " + manifest));
        }
        if (!Util.exec(svccfg + " import " + manDir + SysInfo.FS + manifest)) {
            this.logger.error((Object)("Unable to import startup manifest for " + manifest));
        }
        return true;
    }

    public void enableStartup(String script, String init) throws Exception {
        String link;
        if (!Util.exists(script)) {
            throw new Exception("Unable to locate " + script);
        }
        String initDir = SysInfo.FS + "etc" + SysInfo.FS + "init.d";
        if (SysInfo.ONLINUX && Util.exists(SysInfo.FS + "etc" + SysInfo.FS + "rc.d" + SysInfo.FS + "init.d")) {
            initDir = SysInfo.FS + "etc" + SysInfo.FS + "rc.d" + SysInfo.FS + "init.d";
        }
        if (!Util.exists(initDir)) {
            throw new Exception(initDir + " does not exist");
        }
        String initdFile = initDir + SysInfo.FS + init;
        Util.copy(new FileInputStream(script), initdFile, new String[]{"MDSNMSROOT"}, new String[]{this.getInstallDir()});
        Util.chmod(initdFile, "704");
        for (String linkDir : SysInfo.STOPDIR) {
            if (!Util.exists(linkDir)) {
                this.logger.error((Object)(linkDir + " does not exist"));
            }
            link = linkDir + SysInfo.FS + "K03" + init;
            Util.delete(link);
            Util.link(initdFile, link);
        }
        for (String linkDir : SysInfo.STARTDIR) {
            if (!Util.exists(linkDir)) {
                this.logger.error((Object)(linkDir + " does not exist"));
            }
            if (init.equals(FMENTRY)) {
                link = linkDir + SysInfo.FS + "S85" + init;
                Util.delete(link);
                Util.link(initdFile, link);
                continue;
            }
            if (init.equals(CISCOSMISENTRY)) {
                link = linkDir + SysInfo.FS + "S86" + init;
                Util.delete(link);
                Util.link(initdFile, link);
                continue;
            }
            link = linkDir + SysInfo.FS + "S84" + init;
            Util.delete(link);
            Util.link(initdFile, link);
        }
    }

    public void installPostgresLinux(String user) {
        if (!SysInfo.ONLINUX) {
            throw new RuntimeException("Unable to install PostgreSQL. Wrong platform.");
        }
        try {
            if (Util.isRoot()) {
                if (user == null) {
                    throw new RuntimeException("pgstarter is not specified. Root can not run PostgreSQL.");
                }
                if (!this.isSystemUser(user)) {
                    throw new RuntimeException(user + " is not a valid system user.");
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        Util.delete("/tmp/.s.PGSQL.5432");
        Util.delete("/tmp/.s.PGSQL.5432.lock");
        this.logger.warn((Object)"Installing PostgreSQL");
        String dbDir = this.getInstallPgDir();
        try {
            Util.download(this.getCodebase() + "postgres-linux.zip", this.getUserDir() + SysInfo.FS + "postgres-linux.zip");
            Util.mkdir(this.getInstallPgDir());
            Util.mkdir(dbDir + SysInfo.FS + "bin");
            Util.extract(this.getUserDir() + SysInfo.FS + "postgres-linux.zip", this.getInstallPgDir());
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to get PostgreSQL: " + e.getMessage()));
            throw new RuntimeException("Failed to get PostgreSQL: " + e.getMessage());
        }
        String dDir = dbDir + SysInfo.FS + "data";
        String dbSh = dbDir + SysInfo.FS + "bin" + SysInfo.FS + "DB";
        try {
            Util.chown(user, dDir);
            Util.chmod(dDir, "700");
            Util.chmod(dbSh, "a+rwx");
            Util.copy(new FileInputStream(dbSh), dbSh + "_bak");
            Util.copy(new FileInputStream(dbSh + "_bak"), dbSh, new String[]{"MDSNMSDBHOME", "MDSNMSDBSTARTER"}, new String[]{dbDir, user});
            Util.delete(dbSh + "_bak");
            Util.chmod(dbSh, "755");
            Util.createExec(dbDir + SysInfo.FS + "bin");
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unable to set permission for " + dDir + ": " + ex.getCause()));
            throw new RuntimeException("Unable to set permission for " + dDir + ": " + ex.getCause());
        }
        String dbLogDir = dbDir + SysInfo.FS + "log";
        try {
            Util.mkdir(dbLogDir);
            Util.chown(user, dbLogDir);
            Util.chmod(dbLogDir, "700");
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unable to create " + dbLogDir + ": " + ex.getMessage()));
        }
        if (this.isRH5()) {
            String[] libs;
            for (String lib : libs = new String[]{"libcrypto.so", "libssl.so", "libreadline.so"}) {
                String reDir = SysInfo.FS + "usr" + SysInfo.FS + "lib" + SysInfo.FS;
                String file = reDir + lib;
                String dbLibDir = dbDir + SysInfo.FS + "lib" + SysInfo.FS;
                if (!Util.exists(file)) continue;
                String link = dbLibDir + lib + ".4";
                try {
                    Util.link(file, link);
                }
                catch (Exception ex) {
                    this.logger.error((Object)("Unable to create " + link + ": " + ex.getMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRH5() {
        if (!SysInfo.ONLINUX) {
            return false;
        }
        String releaseFile = SysInfo.FS + "etc" + SysInfo.FS + "redhat-release";
        if (!Util.exists(releaseFile)) {
            return false;
        }
        BufferedReader rdr = null;
        try {
            String in;
            rdr = new BufferedReader(new FileReader(releaseFile));
            while ((in = rdr.readLine()) != null) {
                if (!in.toLowerCase().contains("Red Hat".toLowerCase()) || !in.toLowerCase().contains("release 5".toLowerCase())) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Error reading " + releaseFile + ": " + ex.getMessage()));
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public void startWinPgInstall(String user, String password) throws Exception {
        String installDir;
        String[] pgFiles;
        Util.download(this.getCodebase() + "postgres-win.zip", this.getTmpDir() + SysInfo.FS + "postgres-win.zip");
        Util.mkdir(this.getTmpDir() + SysInfo.FS + "postgres-win");
        Util.extract(this.getTmpDir() + SysInfo.FS + "postgres-win.zip", this.getTmpDir());
        String pgf = this.getTmpDir() + SysInfo.FS + "postgres-win" + SysInfo.FS;
        for (String file : pgFiles = new String[]{"postgresql-8.2.msi", "postgresql-8.2-int.msi", "upgrade.bat", "pg_hba.conf", "postgresql.conf"}) {
            if (Util.exists(pgf + file)) continue;
            this.logger.error((Object)(file + " does not exist."));
            throw new Exception(file + " does not exist.");
        }
        String computername = System.getenv("COMPUTERNAME");
        if (computername == null) {
            computername = "DOMAIN";
        }
        if ((installDir = System.getenv("ProgramFiles")) == null) {
            installDir = "C:" + SysInfo.FS + "Program Files";
        }
        installDir = installDir + SysInfo.FS + "PostgreSQL" + SysInfo.FS + "8.2";
        String cmd = "msiexec /i \"" + pgf + pgFiles[1] + "\" /qn INTERNALLAUNCH=1 ADDLOCAL=server,psql,pgadmin " + "SERVICEACCOUNT=postgres SUPERUSER=" + user + " SERVICEDOMAIN=" + computername + " " + "SERVICEPASSWORD=" + password + " SUPERPASSWORD=" + password + " BASEDIR=\"" + installDir + "\" PERMITREMOTE=1";
        this.logger.warn((Object)"Starting PostgreSQL Installer.");
        this.logger.info((Object)cmd);
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            new StreamReader(proc.getInputStream()).start();
            new StreamReader(proc.getErrorStream()).start();
            proc.waitFor();
        }
        catch (Exception ex) {
            this.logger.error((Object)("Failed to execute: " + ex.getMessage()));
            throw new Exception("An error has occurred starting Windows PostgreSQL Installation Program.");
        }
    }

    private void sunPg(boolean on) throws Exception {
        String script = this.getInstallPgDir() + SysInfo.FS + "bin" + SysInfo.FS + "DB";
        String[] cmds = new String[]{script, on ? "start" : "stop"};
        Process proc = Runtime.getRuntime().exec(cmds);
        StreamReader oReader = new StreamReader(proc.getInputStream());
        StreamReader eReader = new StreamReader(proc.getErrorStream());
        oReader.start();
        eReader.start();
        int rc = proc.waitFor();
        if (rc != 0) {
            String message = "Failed to start DB: " + rc + ". Check system settings and libraries.";
            this.logger.error((Object)message);
            throw new Exception(message);
        }
    }

    public void startSunPg() throws Exception {
        this.sunPg(true);
    }

    public void stopSunPg() throws Exception {
        this.sunPg(false);
    }

    public void creatUNIXUser(String userName) {
        Process proc;
        if (!Util.isRoot()) {
            throw new RuntimeException("Unable to create user. You're not root.");
        }
        String home = SysInfo.FS + "export" + SysInfo.FS + "home" + SysInfo.FS + userName;
        Util.mkdir(home);
        if (!Util.exists(home)) {
            this.logger.error((Object)("Unable to create home directory for new user " + userName));
            throw new RuntimeException("Unable to create home directory for new user " + userName);
        }
        try {
            String[] cmds = new String[]{"chown", userName, home};
            proc = Runtime.getRuntime().exec(cmds);
            StreamReader inRdr = new StreamReader(proc.getInputStream());
            StreamReader erRdr = new StreamReader(proc.getErrorStream());
            inRdr.start();
            erRdr.start();
            proc.waitFor();
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unable to set permission on " + home + ": " + ex.getMessage()));
        }
        if (!this.isSystemUser(userName)) {
            String script = this.getTmpDir() + SysInfo.FS + "adduser.sh";
            try {
                this.createAddUserScript(script, home, userName);
                proc = Runtime.getRuntime().exec(script);
                StreamReader oReader = new StreamReader(proc.getInputStream());
                StreamReader eReader = new StreamReader(proc.getErrorStream());
                oReader.start();
                eReader.start();
                int rc = proc.waitFor();
                if (rc != 0) {
                    String message = "Creating user " + userName + " failed: " + rc;
                    this.logger.error((Object)message);
                    throw new RuntimeException("rc = " + rc);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to create user. " + script + " failed: " + e.getCause()));
                throw new RuntimeException("Unable to create postgres user.  Hint: Is useradd command in your system path?");
            }
            finally {
                Util.delete(script);
            }
        }
    }

    public boolean isSystemUser(String userName) {
        String userFile = SysInfo.FS + "etc" + SysInfo.FS + "passwd";
        BufferedReader rdr = null;
        try {
            String in;
            rdr = new BufferedReader(new FileReader(userFile));
            while ((in = rdr.readLine()) != null) {
                if (!in.toLowerCase().contains(userName)) continue;
                this.logger.info((Object)("User " + userName + " exists."));
                boolean bl = true;
                return bl;
            }
        }
        catch (FileNotFoundException fe) {
            this.logger.error((Object)(userFile + " does not exist: " + fe.getCause()));
            throw new RuntimeException(userFile + " does not exist: " + fe.getCause());
        }
        catch (IOException ioe) {
            this.logger.error((Object)("Unable to read " + userFile + ": " + ioe.getCause()));
            throw new RuntimeException("Unable to read " + userFile + ": " + ioe.getCause());
        }
        finally {
            try {
                if (rdr != null) {
                    rdr.close();
                }
            }
            catch (IOException e) {}
        }
        return false;
    }

    private void createAddUserScript(String script, String home, String user) throws FileNotFoundException, Exception, IOException {
        FileOutputStream fs = new FileOutputStream(script);
        PrintStream ps = new PrintStream(new BufferedOutputStream(fs));
        ps.println("#!/bin/sh");
        ps.println("useradd -c 'PostgreSQL user' -d " + home + " -m " + user);
        ps.println("exit;");
        ps.close();
        fs.close();
        Util.chmod(script, "a+rxw");
    }

    public boolean isPgRunning() {
        return this.isPgRunning(new String[1]);
    }

    public boolean isPgRunning(String[] output) {
        String[] cmds = null;
        cmds = Util.exists("/usr/bin/ps") ? new String[]{"/usr/bin/ps", "-ef"} : (Util.exists("/usr/ucb/ps") ? new String[]{"/usr/bin/ps", "-a"} : (Util.exists("/usr/local/bin/ps") ? new String[]{"/usr/loca/bin/ps", "-ef"} : (Util.exists("/bin/ps") ? new String[]{"/bin/ps", "-ef"} : (Util.exists("/sbin/ps") ? new String[]{"/sbin/ps", "-ef"} : new String[]{"ps", "-ef"}))));
        return Util.exists("/tmp/.s.PGSQL.5432") || Util.exists("/tmp/.s.PGSQL.5432.lock");
    }

    public boolean isPgInstalled() {
        return Util.exists(this.getInstallPgDir() + SysInfo.FS + "pgsql");
    }

    public void setPgPath(String pgpath) throws Exception {
        if (pgpath == null) {
            throw new Exception("pg path cannot be null.");
        }
        if (!Util.exists(pgpath = pgpath.trim())) {
            if (!Util.exists(this.getCWD() + SysInfo.FS + pgpath)) {
                throw new Exception(pgpath + " is not valid.");
            }
            this.pgPath = this.getCWD() + SysInfo.FS + pgpath;
        } else {
            this.pgPath = pgpath;
        }
    }

    public void touchOld() {
        try {
            Util.touch(this.getLibDir() + SysInfo.FS + "jnm.jar");
            Util.touch(this.getLibDir() + SysInfo.FS + "snmp.jar");
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unable to touch old files: " + ex.getMessage()));
        }
    }

    public boolean isUpdater() {
        return false;
    }

    public void deleteOldExec() {
        if (!this.deleteOldExec) {
            return;
        }
        if (this.getOldInstallDir() != null && this.getInstallDir() != null && new File(this.getOldInstallDir()).compareTo(new File(this.getFMDir())) != 0) {
            Util.delete(this.getOldInstallDir() + SysInfo.FS + "bin");
            Util.delete(this.getOldInstallDir() + SysInfo.FS + "Uninstall" + SysInfo.ESUFFIX);
            Util.delete(this.getOldInstallDir() + SysInfo.FS + "Install.conf");
        }
    }

    public void migratePMData() {
        if (!this.getDeleteOldExec()) {
            return;
        }
        if (this.getOldInstallDir() == null) {
            return;
        }
        if (this.getInstallDir() == null) {
            return;
        }
        if (this.getFMDir() == null) {
            return;
        }
        if (new File(this.getOldInstallDir()).compareTo(new File(this.getFMDir())) != 0) {
            try {
                String oldPMDBDir = this.getOldInstallDir() + SysInfo.FS + "pm" + SysInfo.FS + "db";
                File moveFrom = new File(oldPMDBDir);
                if (moveFrom.exists() && moveFrom.isDirectory()) {
                    String[] fromFiles = moveFrom.list();
                    if (fromFiles == null || fromFiles.length <= 0) {
                        return;
                    }
                    this.logger.info((Object)"Copying Performance Management Data");
                    File moveTo = new File(this.getFMDir() + SysInfo.FS + "pm" + SysInfo.FS + "db");
                    String[] files = moveTo.list();
                    if (files != null && files.length > 0) {
                        this.logger.info((Object)"Operation abort, current PM data exist or directory is not empty.");
                        return;
                    }
                    moveTo.delete();
                    this.logger.info((Object)("Copying files from " + moveFrom.getAbsolutePath() + " to " + moveTo.getAbsolutePath()));
                    Util.copyFiles(moveFrom.getAbsolutePath(), moveTo.getAbsolutePath());
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)("Unable to copy Performance Manager data: " + ex.getMessage()));
            }
        }
    }

    public boolean getDeleteOldExec() {
        return this.deleteOldExec;
    }

    public void setDeleteOldExec(boolean b) {
        this.deleteOldExec = b;
    }

    public static void main(String[] args) {
        Install helper = new Install();
        try {
            String pgDir = "c:\\Program Files\\Cisco Systems\\DCM\\postgres";
            String createDB = "\"" + pgDir + "\\bin\\createdb.exe\" dcmdb -U admin";
            System.out.println("creating DB " + createDB);
            Process proc = Runtime.getRuntime().exec(createDB);
            StreamReader oReader = new StreamReader(proc.getInputStream());
            StreamReader eReader = new StreamReader(proc.getErrorStream());
            int rc = proc.waitFor();
            oReader.start();
            eReader.start();
            if (rc != 0) {
                String message = "Creating DB failed: " + rc;
                System.out.println(message);
                throw new Exception(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

