/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install.model;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V1CertificateGenerator;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;

public class TrustTool {
    private static Logger logger = Logger.getLogger(TrustTool.class);
    public static final String FMCA_ALIAS = "fmca";
    public static final String SME_ALIAS = "sme";
    private static final String PASSWORD = "fmserver_1_2_3";
    private static final Provider PROV = new BouncyCastleProvider();
    private static final String HASH_ALG = "MD5";
    private static final String KEY_ALG = "RSA";
    private static final String STORE_TYPE = "JKS";
    private static final String STORE_PASSWD = "fmserver_1_2_3";
    private static final String KEY_PASSWD = "fmserver_1_2_3";
    private static final int KEY_SIZE = 2048;
    private static final long DAY_IN_MILLIS = 86400000L;
    private static final long EXPIRE_YEAR_IN_SECS = 946080000L;
    private static final long EXPIRE_YEAR_IN_MILLIS = 946080000000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importX509Cert(String store, String certFile, String alias) {
        KeyStore keystore = null;
        FileInputStream fis = null;
        try {
            keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            try {
                fis = new FileInputStream(store);
            }
            catch (Exception ex) {
                logger.error((Object)("Unable to load " + store));
            }
            keystore.load(fis == null ? null : fis, "fmserver_1_2_3".toCharArray());
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(certFile));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            int certNum = 0;
            while (bis.available() > 0) {
                Certificate cert = cf.generateCertificate(bis);
                String aliasCert = certNum == 0 ? alias : alias + certNum;
                keystore.setCertificateEntry(aliasCert, cert);
                ++certNum;
            }
            FileOutputStream keyStoreOutputStream = new FileOutputStream(store);
            keystore.store(keyStoreOutputStream, "fmserver_1_2_3".toCharArray());
            keyStoreOutputStream.close();
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to import cert with alias " + alias + " into keystore " + store + ": " + ex.getMessage()));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception ex) {
                    logger.error((Object)("Unable to close file " + store + ": " + ex.getMessage()));
                }
            }
        }
    }

    public static void export(Certificate cert, File file, boolean binary) {
        try {
            byte[] buf = cert.getEncoded();
            FileOutputStream os = new FileOutputStream(file);
            if (binary) {
                os.write(buf);
            } else {
                OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os, Charset.forName("UTF-8"));
                wr.write("-----BEGIN CERTIFICATE-----\n");
                String bin = new String(Base64.encodeBase64((byte[])buf));
                wr.write(bin);
                wr.write("\n-----END CERTIFICATE-----\n");
                ((Writer)wr).flush();
            }
            os.close();
        }
        catch (CertificateEncodingException e) {
            logger.error((Object)("Encoding error: " + e.getMessage()));
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public static X509Certificate getCert(byte[] data) throws Exception {
        if (data == null) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        CertificateFactory fact = CertificateFactory.getInstance("X.509", "SUN");
        X509Certificate cert = (X509Certificate)fact.generateCertificate(in);
        return cert;
    }

    public static PrivateKey getPrivateKey(byte[] data, String alg) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(alg);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(data);
        PrivateKey key = keyFactory.generatePrivate(privateKeySpec);
        return key;
    }

    public static Certificate generateSSKS(String CN, File ksFile) throws Exception {
        Date startDate = new Date(System.currentTimeMillis() - 86400000L);
        Date expiryDate = new Date(System.currentTimeMillis() + 946080000000L);
        BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
        KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance(KEY_ALG, PROV);
        keyGenerator.initialize(2048);
        KeyPair keyPair = keyGenerator.generateKeyPair();
        X509V1CertificateGenerator certGen = new X509V1CertificateGenerator();
        X500Principal dnName = new X500Principal("CN=" + CN + ", " + "OU=Data Center, O=Cisco Systems, L=San Jose, ST=CA, C=US");
        certGen.setSerialNumber(serialNumber);
        certGen.setIssuerDN(dnName);
        certGen.setNotBefore(startDate);
        certGen.setNotAfter(expiryDate);
        certGen.setSubjectDN(dnName);
        certGen.setPublicKey(keyPair.getPublic());
        certGen.setSignatureAlgorithm("MD5WithRSA");
        Security.addProvider((Provider)new BouncyCastleProvider());
        X509Certificate certificate = certGen.generate(keyPair.getPrivate(), "BC");
        certificate.checkValidity();
        certificate.verify(keyPair.getPublic());
        logger.info((Object)("Issuer DN: " + certificate.getIssuerDN()));
        logger.info((Object)("Subject DN: " + certificate.getSubjectDN()));
        logger.info((Object)("Not after: " + certificate.getNotAfter()));
        logger.info((Object)("Not before: " + certificate.getNotBefore()));
        logger.info((Object)("Serial No: " + certificate.getSerialNumber()));
        logger.info((Object)("Signature Alg: " + certificate.getSigAlgName()));
        logger.info((Object)("Signature Alg OID: " + certificate.getSigAlgOID()));
        KeyStore keyStore = null;
        String storeType = STORE_TYPE;
        keyStore = KeyStore.getInstance(STORE_TYPE);
        keyStore.load(null, "fmserver_1_2_3".toCharArray());
        Certificate[] chain = new X509Certificate[]{certificate};
        keyStore.setKeyEntry(SME_ALIAS, keyPair.getPrivate(), "fmserver_1_2_3".toCharArray(), chain);
        FileOutputStream keyStoreOutputStream = new FileOutputStream(ksFile);
        keyStore.store(keyStoreOutputStream, "fmserver_1_2_3".toCharArray());
        keyStoreOutputStream.close();
        return certificate;
    }

    public static KeyStore getCertStoreFromPemFile(FileInputStream trustedServerCertsFile, String alias) throws Exception {
        KeyStore trustedServerCerts = null;
        trustedServerCerts = KeyStore.getInstance(KeyStore.getDefaultType());
        trustedServerCerts.load(null, null);
        BufferedInputStream bis = new BufferedInputStream(trustedServerCertsFile);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        int certNum = 0;
        while (bis.available() > 0) {
            Certificate cert = cf.generateCertificate(bis);
            String aliasCert = certNum == 0 ? alias : alias + certNum;
            trustedServerCerts.setCertificateEntry(aliasCert, cert);
            ++certNum;
        }
        return trustedServerCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore(String certFileName) {
        KeyStore keystore;
        block15: {
            keystore = null;
            FileInputStream ksHandle = null;
            try {
                if (certFileName == null) break block15;
                ksHandle = new FileInputStream(certFileName);
                if (certFileName.endsWith(".jks")) {
                    keystore = KeyStore.getInstance(STORE_TYPE);
                    keystore.load(ksHandle, null);
                    break block15;
                }
                if (certFileName.endsWith(".p12")) {
                    keystore = KeyStore.getInstance("PKCS12");
                    keystore.load(ksHandle, null);
                    break block15;
                }
                if (certFileName.endsWith(".der") || certFileName.endsWith(".pem")) {
                    keystore = TrustTool.getCertStoreFromPemFile(ksHandle, SME_ALIAS);
                    break block15;
                }
                throw new Exception("Unrecognizable file format.");
            }
            catch (Exception e) {
                logger.error((Object)("Error loading file: " + e.getMessage()));
            }
            finally {
                try {
                    if (ksHandle != null) {
                        ksHandle.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Error closing handle: " + e.getMessage()));
                }
            }
        }
        return keystore;
    }

    public static KeyPair getPrivateKey(KeyStore keystore, String alias, char[] password) {
        try {
            Key key = keystore.getKey(alias, password);
            if (key instanceof PrivateKey) {
                Certificate cert = keystore.getCertificate(alias);
                PublicKey publicKey = cert.getPublicKey();
                return new KeyPair(publicKey, (PrivateKey)key);
            }
        }
        catch (UnrecoverableKeyException e) {
            logger.error((Object)e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage());
        }
        catch (KeyStoreException e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public static Key getPrivateKey(String ks, String alias, String password) {
        KeyStore store = TrustTool.loadKeyStore(ks);
        if (store == null) {
            return null;
        }
        Key privateKey = null;
        try {
            if (store.isKeyEntry(alias)) {
                privateKey = store.getKey(alias, password.toCharArray());
                if (privateKey instanceof PrivateKey) {
                    return privateKey;
                }
            } else {
                logger.error((Object)(alias + " is not a key entry of " + ks));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to get private key from " + ks));
        }
        return null;
    }

    public static Certificate getCert(String ks, String alias, String password) {
        KeyStore store = TrustTool.loadKeyStore(ks);
        if (store == null) {
            return null;
        }
        try {
            Certificate cert = store.getCertificate(alias);
            return cert;
        }
        catch (KeyStoreException e) {
            logger.error((Object)("Unable to get certificate " + alias + " from " + ks));
            return null;
        }
    }

    public static void createKS(Certificate cert, Key privateKey, String outFile, String alias, String password) throws Exception {
        if (!(cert instanceof X509Certificate)) {
            throw new IllegalArgumentException("Cannot create keystore, not a X509 certificate.");
        }
        if (!(privateKey instanceof PrivateKey)) {
            throw new IllegalArgumentException("Cannot create keystore, not a private key");
        }
        KeyStore keyStore = KeyStore.getInstance(STORE_TYPE);
        keyStore.load(null, "fmserver_1_2_3".toCharArray());
        Security.addProvider((Provider)new BouncyCastleProvider());
        Certificate[] chain = new X509Certificate[]{(X509Certificate)cert};
        keyStore.setEntry(alias, new KeyStore.PrivateKeyEntry((PrivateKey)privateKey, chain), new KeyStore.PasswordProtection("fmserver_1_2_3".toCharArray()));
        FileOutputStream keyStoreOutputStream = new FileOutputStream(outFile);
        keyStore.store(keyStoreOutputStream, password.toCharArray());
        keyStoreOutputStream.close();
    }

    public static void createKSWithCA(String caKs, String subCN, File newKS) throws Exception {
        KeyStore ks = TrustTool.loadKeyStore(caKs);
        if (ks == null) {
            throw new RuntimeException("Failed to load CA " + caKs + ",cannot create keystore.");
        }
        if (!ks.isKeyEntry(SME_ALIAS)) {
            logger.warn((Object)"sme is not key entry");
        }
        X509Certificate caCert = (X509Certificate)ks.getCertificate(SME_ALIAS);
        Key caPrivateKey = ks.getKey(SME_ALIAS, "fmserver_1_2_3".toCharArray());
        if (!(caPrivateKey instanceof PrivateKey)) {
            logger.error((Object)"sme is not a private key");
            throw new RuntimeException("Not a private key");
        }
        PrivateKey caPrivKey = (PrivateKey)caPrivateKey;
        PublicKey caPubKey = caCert.getPublicKey();
        KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance(KEY_ALG, PROV);
        keyGenerator.initialize(2048);
        KeyPair key = keyGenerator.generateKeyPair();
        PublicKey publicKey = key.getPublic();
        PrivateKey privateKey = key.getPrivate();
        KeyStore keyStore = null;
        keyStore = KeyStore.getInstance(STORE_TYPE);
        keyStore.load(null, "fmserver_1_2_3".toCharArray());
        Security.addProvider((Provider)new BouncyCastleProvider());
        Certificate[] chain = new X509Certificate[2];
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        X500Principal subjectName = new X500Principal("CN=" + subCN + ", " + "OU=Data Center, O=Cisco Systems, L=San Jose, ST=CA, C=US");
        certGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        certGen.setIssuerDN(caCert.getSubjectX500Principal());
        certGen.setNotBefore(new Date(System.currentTimeMillis() - 86400000L));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + 946080000000L));
        certGen.setSubjectDN(subjectName);
        certGen.setPublicKey(publicKey);
        certGen.setSignatureAlgorithm("MD5WithRSA");
        certGen.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)new AuthorityKeyIdentifierStructure(caPubKey));
        certGen.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)new SubjectKeyIdentifierStructure(publicKey));
        X509Certificate certificate = certGen.generateX509Certificate(caPrivKey, "BC");
        certificate.verify(caPubKey);
        certificate.checkValidity();
        logger.info((Object)("Issuer DN: " + certificate.getIssuerDN()));
        logger.info((Object)("Subject DN: " + certificate.getSubjectDN()));
        logger.info((Object)("Not after: " + certificate.getNotAfter()));
        logger.info((Object)("Not before: " + certificate.getNotBefore()));
        logger.info((Object)("Serial No: " + certificate.getSerialNumber()));
        logger.info((Object)("Signature Alg: " + certificate.getSigAlgName()));
        logger.info((Object)("Signature Alg OID: " + certificate.getSigAlgOID()));
        PKCS12BagAttributeCarrier bagAttr = (PKCS12BagAttributeCarrier)certificate;
        bagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (DEREncodable)new DERBMPString(SME_ALIAS));
        bagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (DEREncodable)new SubjectKeyIdentifierStructure(publicKey));
        chain[1] = caCert;
        chain[0] = certificate;
        PKCS12BagAttributeCarrier bAttr = (PKCS12BagAttributeCarrier)privateKey;
        bAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (DEREncodable)new DERBMPString(SME_ALIAS));
        bAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (DEREncodable)new SubjectKeyIdentifierStructure(publicKey));
        keyStore.setKeyEntry(SME_ALIAS, privateKey, "fmserver_1_2_3".toCharArray(), chain);
        keyStore.setCertificateEntry(FMCA_ALIAS, caCert);
        FileOutputStream keyStoreOutputStream = new FileOutputStream(newKS);
        keyStore.store(keyStoreOutputStream, "fmserver_1_2_3".toCharArray());
        keyStoreOutputStream.close();
    }
}

