/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install.view;

import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.tree.DefaultMutableTreeNode;

class CheckTreeNode
extends DefaultMutableTreeNode {
    protected int selectionMode;
    protected boolean isSelected = false;
    protected boolean isActive = true;
    protected int checkedChildren = 0;
    private boolean isPrevSelected = false;
    private boolean isPrevActive = this.isActive;
    private boolean isVisible = true;

    public CheckTreeNode(Object userObject) {
        this(userObject, true, false);
    }

    public CheckTreeNode(Object userObject, boolean allowsChildren, boolean isSelected) {
        super(userObject, allowsChildren);
        this.isSelected = isSelected;
    }

    public void setSelected(boolean isSelected) {
        if (this.isSelected != isSelected) {
            this.isPrevSelected = this.isSelected;
            this.addCheckedChildren((CheckTreeNode)this.parent, isSelected ? 1 : -1);
            if (this.parent != null) {
                ((CheckTreeNode)this.parent).revalidate();
            }
        }
        this.isSelected = isSelected;
    }

    public void setAllChildren(boolean isSelected) {
        if (this.children != null) {
            Enumeration eChild = this.children.elements();
            while (eChild.hasMoreElements()) {
                CheckTreeNode node = (CheckTreeNode)eChild.nextElement();
                node.setSelected(isSelected);
                node.setAllChildren(isSelected);
            }
        }
    }

    public void revalidate() {
        if (this.isLeaf()) {
            ((CheckTreeNode)this.parent).revalidate();
            this.setActive(true);
            return;
        }
        Enumeration eChild = this.children.elements();
        if (this.children.size() == this.checkedChildren) {
            if (!this.isSelected()) {
                this.setSelected(true);
                if (this.parent != null) {
                    ((CheckTreeNode)this.parent).revalidate();
                }
            }
            this.setActive(true);
            while (eChild.hasMoreElements()) {
                if (((CheckTreeNode)eChild.nextElement()).isActive()) continue;
                this.setActive(false);
            }
        } else if (this.checkedChildren == 0) {
            if (this.isSelected()) {
                this.setSelected(false);
                if (this.parent != null) {
                    ((CheckTreeNode)this.parent).revalidate();
                }
            }
            this.setActive(true);
        } else if (this.checkedChildren < this.children.size()) {
            if (!this.isSelected()) {
                this.setSelected(true);
                if (this.parent != null) {
                    ((CheckTreeNode)this.parent).revalidate();
                }
            }
            this.setActive(false);
        } else {
            System.err.println("Error: Exceptional case");
        }
    }

    public void setActive(boolean active) {
        if (this.isActive != active) {
            this.isPrevActive = this.isActive;
        }
        this.isActive = active;
    }

    public boolean isActive() {
        return this.isActive;
    }

    private void addCheckedChildren(CheckTreeNode parent, int num) {
        if (parent == null) {
            return;
        }
        parent.checkedChildren += num;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void undoSelected() {
        this.setSelected(this.isPrevSelected);
        this.isActive = this.isPrevActive;
    }

    public void saveSelection() {
        this.isPrevSelected = this.isSelected;
        this.isPrevActive = this.isActive;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public Dimension getPreferredSize() {
        JCheckBox tmp = new JCheckBox();
        Dimension retDimension = tmp.getPreferredSize();
        retDimension = new Dimension(retDimension.width, retDimension.height + 3);
        return retDimension;
    }
}

