/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install.view;

import com.cisco.dcbu.install.view.CheckTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;

class CheckTreeNodeRenderer
extends JPanel
implements TreeCellRenderer,
Accessible {
    protected JCheckBox checkbox;

    public CheckTreeNodeRenderer() {
        this.setLayout(null);
        this.checkbox = new JCheckBox();
        this.add(this.checkbox);
        this.checkbox.setBackground(UIManager.getColor("Tree.textBackground"));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String strValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
        this.setEnabled(tree.isEnabled());
        this.checkbox.setSelected(((CheckTreeNode)value).isSelected());
        this.checkbox.setEnabled(((CheckTreeNode)value).isActive());
        this.checkbox.setVisible(((CheckTreeNode)value).isVisible());
        this.checkbox.setText(strValue);
        this.checkbox.setFocusTraversalKeysEnabled(true);
        this.checkbox.setFocusable(true);
        if (leaf || expanded) {
            // empty if block
        }
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.checkbox.getPreferredSize();
    }

    @Override
    public void doLayout() {
        Dimension d_check = this.checkbox.getPreferredSize();
        boolean y_check = false;
        boolean y_label = false;
        this.checkbox.setLocation(0, 0);
        this.checkbox.setBounds(0, 0, d_check.width, d_check.height - 5);
        this.checkbox.setFocusable(true);
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public class CheckNodeLabel
    extends JLabel {
        boolean isSelected;
        boolean hasFocus;

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        @Override
        public void paint(Graphics g) {
            String str = this.getText();
            if (str != null && 0 < str.length()) {
                if (this.isSelected) {
                    g.setColor(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    g.setColor(UIManager.getColor("Tree.textBackground"));
                }
                Dimension d = this.getPreferredSize();
                int imageOffset = 0;
                Icon currentIcon = this.getIcon();
                if (currentIcon != null) {
                    imageOffset = currentIcon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
                if (this.hasFocus) {
                    g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                    g.drawRect(imageOffset, 0, d.width - 1 - imageOffset, d.height - 1);
                }
            }
            super.paint(g);
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public void setFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension retDimension = super.getPreferredSize();
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 3, retDimension.height + 2);
            }
            return retDimension;
        }
    }
}

