/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install.view;

import com.cisco.dcbu.install.view.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class InstallPanel
extends WizardPanel {
    public static final String NAME = "Installing";
    JScrollPane scrollPane = null;
    private JProgressBar pbar = new JProgressBar(0, 100);
    private JTextArea board = new JTextArea();
    private JLabel note = new JLabel("Installing...");

    public InstallPanel() {
        super(InstallPanel.createBanner(NAME, "Installation is in progress"), 0, false);
        this.pbar.setIndeterminate(false);
        this.setContent();
    }

    public void setProgress(final int percent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.pbar.setValue(percent);
            }
        });
    }

    public void appendLine2Panel(final String text) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.board.append(text);
            }
        });
    }

    public void setTextOnBoard(final String text) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.board.setText(text);
            }
        });
    }

    public void setContent() {
        JPanel content = new JPanel();
        this.scrollPane = new JScrollPane(this.board, 20, 30);
        this.scrollPane.setPreferredSize(new Dimension(100, 100));
        this.scrollPane.setWheelScrollingEnabled(true);
        this.board.setFont(this.note.getFont());
        content.setLayout(new BorderLayout());
        this.note.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        content.add((Component)this.note, "North");
        content.add(this.scrollPane);
        content.add((Component)this.pbar, "South");
        this.setContent(content);
    }

    public JLabel getNote() {
        return this.note;
    }

    public JTextArea getBoard() {
        return this.board;
    }

    public JProgressBar getProgressBar() {
        return this.pbar;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        InstallPanel panel = new InstallPanel();
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
        JProgressBar bar = panel.getProgressBar();
        bar.setValue(10);
    }

    public void setIndeterminate(boolean b) {
        this.pbar.setIndeterminate(b);
    }

    public void setDetailVisible(boolean b) {
        this.scrollPane.setVisible(b);
        this.board.setVisible(b);
    }
}

