/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.jnm.WwnVendor;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;

public class Fc4Decoder {
    public static final String VIRTUAL_TYPE = "virtual";
    public static final int NS_FC4_TYPE_IS8802 = 4;
    public static final int NS_FC4_TYPE_IPFC = 5;
    public static final int NS_FC4_TYPE_SCSI_FCP = 8;
    public static final int NS_FC4_TYPE_SCSI_GPP = 9;
    public static final int NS_FC4_TYPE_IPI3_MASTER = 17;
    public static final int NS_FC4_TYPE_IPI3_SLAVE = 18;
    public static final int NS_FC4_TYPE_IPI3_PEER = 19;
    public static final int NS_FC4_TYPE_SBCCS = 24;
    public static final int NS_FC4_TYPE_SBCCS_CH = 25;
    public static final int NS_FC4_TYPE_SBCCS_CU = 26;
    public static final int NS_FC4_TYPE_FCSB2_CH_CU = 27;
    public static final int NS_FC4_TYPE_FCSB2_CU_CH = 28;
    public static final int NS_FC4_TYPE_FC_GS = 32;
    public static final int NS_FC4_TYPE_FC_SW = 34;
    public static final int NS_FC4_TYPE_FC_AL = 35;
    public static final int NS_FC4_TYPE_SNMP = 36;
    public static final int NS_FC4_TYPE_HIPPI_FP = 64;
    public static final int NS_FC4_TYPE_BBL_CTRL = 80;
    public static final int NS_FC4_TYPE_BBL_FDDI = 81;
    public static final int NS_FC4_TYPE_BBL_802_3 = 82;
    public static final int NS_FC4_TYPE_FC_VI = 88;
    public static final int NS_FC4_TYPE_FC_AV = 96;
    public static final int NS_FC4_TYPE_SLOTTED_LOOP = 104;
    public static final int NS_FC4_TYPE_VIRTUALIZATION = 224;
    public static final int NS_FC4_TYPE_ANDIAMO_ISCSI_GW = 225;
    public static final int NS_FC4_TYPE_ANDIAMO_AVANTI = 226;
    public static final int NS_FC4_TYPE_SAN_EXT_TUNER = 227;
    public static final int NS_FC4_TYPE_SDV = 228;
    public static final int NS_FC4_TYPE_NPV = 229;
    public static final int NS_FC4_FEATURE_SCSI_TARGET = 1;
    public static final int NS_FC4_FEATURE_SCSI_INIT = 2;
    public static final int NS_FC4_FEATURE_SCSI_BOTH = 3;
    public static final int NS_FC4_FEATURE_ANDIAMO_AVANTI_INITATORS = 1;
    public static final int NS_FC4_FEATURE_ANDIAMO_AVANTI_TARGETS = 2;
    public static final int NS_FC4_FEATURE_ANDIAMO_AVANTI_PEERS = 3;
    public static final int NS_FC4_FEATURE_VIRT_TRAP_PORT = 1;
    public static final int NS_FC4_FEATURE_VIRT_VEP = 2;
    public static final int NS_FC4_FEATURE_VIRT_VOLUME_OWNER = 3;
    public static final int NS_FC4_FEATURE_VIRT_IPFC_PORT = 4;
    public static final int NS_FC4_FEATURE_VIRT_INTERNAL_PORT = 5;
    public static final int NS_FC4_FEATURE_VIRT_INTERNAL_CPP_PORT = 6;
    public static final int NS_FC4_FEATURE_VIRT_INTERNAL_REDIRECT = 7;
    public static final int NS_FC4_FEATURE_FICON_CU = 1;
    public static final int NS_FC4_FEATURE_FICON_CH = 2;
    public static final int NS_FC4_FEATURE_FICON_CUP = 4;
    public static final int[] FC4_TYPES = new int[]{4, 5, 8, 9, 17, 18, 19, 24, 25, 26, 27, 28, 32, 34, 35, 36, 64, 80, 81, 82, 88, 96, 104, 224, 225, 226, 227, 228, 229};

    public static String getFc4TypeString(int fc4Type) {
        switch (fc4Type) {
            case 4: {
                return "is8802";
            }
            case 5: {
                return "ipfc";
            }
            case 8: {
                return "scsi-fcp";
            }
            case 9: {
                return "scsi-gpp";
            }
            case 17: {
                return "ipi3-master";
            }
            case 18: {
                return "ipi3-slave";
            }
            case 19: {
                return "ipi3-peer";
            }
            case 24: {
                return "FICON";
            }
            case 25: {
                return "sbccs-ch";
            }
            case 26: {
                return "sbccs-cu";
            }
            case 27: {
                return "fcsb2-ch-cu";
            }
            case 28: {
                return "fcsb2-cu-ch";
            }
            case 32: {
                return "fc-gs";
            }
            case 34: {
                return "fc-sw";
            }
            case 35: {
                return "fc-al";
            }
            case 36: {
                return "snmp";
            }
            case 64: {
                return "hippi-fp";
            }
            case 80: {
                return "bbl-ctrl";
            }
            case 81: {
                return "bbl-fddi";
            }
            case 82: {
                return "bbl-802-3";
            }
            case 88: {
                return "fc-vi";
            }
            case 96: {
                return "fc-av";
            }
            case 104: {
                return "slotted-loop";
            }
            case 224: {
                return VIRTUAL_TYPE;
            }
            case 225: {
                return "iscsi-gw";
            }
            case 226: {
                return "";
            }
            case 227: {
                return "san-ext-tuner";
            }
            case 228: {
                return "sdv";
            }
            case 229: {
                return "npv";
            }
        }
        return "unknown";
    }

    public static String getFc4TypeFeature(int fc4Type, int fc4Feature) {
        switch (fc4Type) {
            case 226: {
                return "svc";
            }
            case 224: {
                switch (fc4Feature) {
                    case 1: {
                        return "trap";
                    }
                    case 2: {
                        return "vep";
                    }
                    case 3: {
                        return "volume";
                    }
                    case 4: {
                        return "ipfc";
                    }
                    case 5: {
                        return "internalPort";
                    }
                    case 6: {
                        return "VI-CPP";
                    }
                }
                break;
            }
            case 24: {
                if (fc4Feature == 2) {
                    return "CH";
                }
                if (fc4Feature == 1) {
                    return "CU";
                }
                if (fc4Feature == 4) {
                    return "CUP";
                }
            }
            default: {
                if (fc4Feature == 1) {
                    return "target";
                }
                if (fc4Feature == 2) {
                    return "init";
                }
                if (fc4Feature != 3) break;
                return "both";
            }
        }
        return "";
    }

    public static Object fcNameServerFC4Type(SnmpVar value) {
        int byteNum;
        SnmpString s = (SnmpString)value;
        int[] type = SnmpIntList.valueOf(s.getValue());
        if (null == type) {
            return "unknown";
        }
        StringBuffer sb = new StringBuffer();
        int max = FC4_TYPES.length;
        for (int j = 0; j < max && (byteNum = FC4_TYPES[j] >> 5) < type.length; ++j) {
            if ((type[byteNum] & 1 << (FC4_TYPES[j] & 0x1F)) <= 0 || FC4_TYPES[j] == 226) continue;
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(Fc4Decoder.getFc4TypeString(FC4_TYPES[j]));
        }
        return sb.toString();
    }

    public static String getVirtualized(byte[] fc4Type, byte[] fc4Feature) {
        return Fc4Decoder.getVirtualized(SnmpIntList.valueOf(fc4Type), fc4Feature);
    }

    public static String getVirtualized(int[] fc4Type, byte[] fc4Feature) {
        for (int j = 0; j < FC4_TYPES.length; ++j) {
            int byteNum = FC4_TYPES[j] >> 5;
            if (fc4Type == null) {
                return null;
            }
            if (byteNum >= fc4Type.length) break;
            if ((fc4Type[byteNum] & 1 << (FC4_TYPES[j] & 0x1F)) <= 0 || FC4_TYPES[j] != 224) continue;
            if (fc4Feature.length == 0) {
                return VIRTUAL_TYPE;
            }
            return Fc4Decoder.getFc4TypeFeature(224, fc4Feature[fc4Feature.length - 1]);
        }
        return null;
    }

    public static Object fcNameServerFC4Features(SnmpString fc4type, SnmpString fc4feature) {
        int byteNum;
        int[] type = SnmpIntList.valueOf(fc4type.getValue());
        if (null == type) {
            return "unknown";
        }
        byte[] b = fc4feature.getValue();
        byte feature = 0;
        byte scsifeature = 0;
        if (null != b && b.length > 0) {
            if (b.length >= 8) {
                scsifeature = b[7];
            }
            feature = b[b.length - 1];
        }
        StringBuffer sbType = new StringBuffer();
        StringBuffer sbFeature = new StringBuffer();
        int max = FC4_TYPES.length;
        for (int j = 0; j < max && (byteNum = FC4_TYPES[j] >> 5) < type.length; ++j) {
            if ((type[byteNum] & 1 << (FC4_TYPES[j] & 0x1F)) <= 0) continue;
            if (0 != sbType.length()) {
                sbType.append(',');
            }
            if (0 != sbFeature.length()) {
                sbFeature.append(',');
            }
            sbType.append(Fc4Decoder.getFc4TypeString(FC4_TYPES[j]));
            if (FC4_TYPES[j] != 226 && FC4_TYPES[j] != 224 && FC4_TYPES[j] != 24) {
                sbFeature.append(Fc4Decoder.getFc4TypeFeature(FC4_TYPES[j], scsifeature));
                continue;
            }
            sbFeature.append(Fc4Decoder.getFc4TypeFeature(FC4_TYPES[j], feature));
        }
        if (0 != sbType.length() && 0 != sbFeature.length()) {
            if (sbType.charAt(sbType.length() - 1) == ',') {
                sbType.setLength(sbType.length() - 1);
            }
            sbType.append(":");
        }
        sbType.append(sbFeature.toString());
        return sbType.toString();
    }

    public static boolean isFc4TypeSet(int[] fc4types, int type) {
        int wdpos = type >> 5;
        return fc4types == null || fc4types.length <= wdpos ? false : (fc4types[wdpos] & 1 << (type & 0x1F)) > 0;
    }

    public static int getFc4TypeFeature(int fc4type, byte[] fc4features) {
        int bytepos = ((fc4type >> 3) + 1 << 2) + (fc4type & 7) - 1;
        if (fc4features == null || bytepos < 0 || bytepos >= fc4features.length) {
            return 0;
        }
        return fc4features[bytepos];
    }

    public static boolean isFc4FeatureSet(byte[] fc4features, int fc4type, int feature) {
        return Fc4Decoder.getFc4TypeFeature(fc4type, fc4features) == feature;
    }

    public static String getFc4TypesString(int[] fc4Types) {
        int wdpos;
        if (fc4Types == null || fc4Types.length == 0) {
            return "unknown";
        }
        StringBuffer sb = new StringBuffer();
        int max = FC4_TYPES.length;
        for (int i = 0; i < max && (wdpos = FC4_TYPES[i] >> 5) < fc4Types.length; ++i) {
            if ((fc4Types[wdpos] & 1 << (FC4_TYPES[i] & 0x1F)) <= 0 || FC4_TYPES[i] == 226) continue;
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(Fc4Decoder.getFc4TypeString(FC4_TYPES[i]));
        }
        return sb.toString();
    }

    public static int getNPortSCSIType(SnmpString fc4type, SnmpString fc4feature, SnmpString pWWN) {
        if (fc4type != null && fc4feature != null && pWWN != null) {
            byte ntype;
            byte[] b = fc4feature.getValue();
            if (b.length >= 8 && ((ntype = b[7]) == 2 || ntype == 1)) {
                return ntype;
            }
            WwnVendor vndr = WwnDictionary.getWwnVendor(pWWN.getValue());
            if (vndr != null) {
                if (vndr.isTypeAmbiguous()) {
                    return 3;
                }
                if (vndr.isStorage()) {
                    return 1;
                }
                return 2;
            }
        }
        return 0;
    }
}

