/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.sm.common.type.MacAddress;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;

public class IfIndexUtil {
    public static final int IFTYPE_FC = 56;
    public static final int IFTYPE_GE = 117;
    public static final int IFTYPE_NON_IPS_ETH = 6;
    public static final int IFTYPE_NON_IPS_ETH_PCHANNEL = 53;
    public static final int IFTYPE_FAST_ETH = 62;
    public static final int IFTYPE_L2VLAN = 135;
    public static final int UNKNOWN_TYPE = -1;
    public static final int TYPE_MASK = 127;
    public static final int FC_TYPE = 1;
    public static final int ETH_TYPE = 2;
    public static final int PCHANNEL_TYPE = 4;
    public static final int MGMT_TYPE = 5;
    public static final int INBAND_TYPE = 6;
    public static final int VSAN_TYPE = 8;
    public static final int VLAN_TYPE = 9;
    public static final int FCIP_TYPE = 10;
    public static final int ISCSI_TYPE = 11;
    public static final int SVC_TYPE = 12;
    public static final int FV_TYPE = 14;
    public static final int FCTUNNEL_TYPE = 15;
    public static final int IVR_TYPE = 16;
    public static final int SME_TYPE = 18;
    public static final int SDM_TYPE = 19;
    public static final int LOOPBACK_TYPE = 20;
    public static final int ETH_PCHANNEL_TYPE = 22;
    public static final int ETHTUNNEL_TYPE = 24;
    public static final int NON_IPS_ETH_TYPE = 26;
    public static final int VETH_TYPE = 28;
    public static final int VFC_TYPE = 30;
    public static final int SAT_ETH_TYPE = 31;
    public static final int IOA_TYPE = 33;
    public static final int VEM_ETH_TYPE = 37;
    public static final int QUAIL_TYPE = 0;
    public static final int IFWWN_TYPE = 0;
    public static final int BLADESERVER_EXT_TYPE = 152;
    public static final int BLADESERVER_BAY_TYPE = 153;
    public static final int OLD_VETH_TYPE = 29;
    public static final int EXPLICIT_VFC_ID_BITS = 13;
    public static final int IMPLICIT_VFC_ID_BITS = 24;
    public static final int VIGLESS_VETH_ID_BITS = 20;
    public static final int EXPLICIT_VFC_ID_MASK = (int)Math.pow(2.0, 13.0) - 1;
    public static final int IMPLICIT_VFC_ID_MASK = (int)Math.pow(2.0, 24.0) - 1;
    public static final int VIGLESS_VETH_ID_MASK = (int)Math.pow(2.0, 20.0) - 1;
    public static final int FC_VSIF_WWN_ID_63 = 63;
    public static final int FC_VSIF_WWN_ID_62 = 62;
    public static final int ETH_SIF_ID_MASK = 1048575;
    public static final int FC_SIF_ID_MASK = 65535;
    public static final int MAX_NUM_VFC = 61440;
    public static final int ETHCHANNEL_NUM_LOW_BYTE = 4095;
    public static final int ETHCHANNEL_NUM_MAX = 4096;
    public static final int VFC_SUBTYPE_MASK = 15;
    public static final int VFC_SUBTYPE_OFFSET = 20;
    public static final int VFC_PORTCHANNEL_NUM_MASK = 4095;
    public static final int VFC_PORTCHANNEL_NUM_MAX = 4096;
    public static final int VFC_PORTCHANNEL_OFFSET = 8;
    public static final int VFC_SLOTPORT_MASK = 4095;
    public static final int VFC_SLOTPORT_SLOT_MASK = 31;
    public static final int VFC_SLOTPORT_SLOT_OFFSET = 15;
    public static final int VFC_SLOTPORT_PORT_MASK = 127;
    public static final int VFC_SLOTPORT_PORT_OFFSET = 8;
    public static final int VFC_FEXPORT_MASK = 12287;
    public static final int VFC_FEXPORT_CHASSIS_OFFSET = 12;
    public static final int VFC_FEXPORT_CHASSIS_MASK = 255;
    public static final int VFC_FEXPORT_SLOT_OFFSET = 8;
    public static final int VFC_FEXPORT_SLOT_MASK = 15;
    public static final int VFC_FEXPORT_PORT_OFFSET = 2;
    public static final int VFC_FEXPORT_PORT_MASK = 63;
    public static final int FC_IFINDEX = 0x1000000;
    public static final int ETH_IFINDEX = 0x2000000;
    public static final int CHANNEL_IFINDEX = 0x4000000;
    public static final int MGMT_IFINDEX = 0x5000000;
    public static final int INBAND_IFINDEX = 0x6000000;
    public static final int VSAN_IFINDEX = 0x8F80000;
    public static final int VSAN_CPP_IFINDEX = 0x8000000;
    public static final int VLAN_IFINDEX = 0x9000000;
    public static final int FCIP_IFINDEX = 0xA000000;
    public static final int ISCSI_IFINDEX = 0xB000000;
    public static final int LOOPBACK_IFINDEX = 0x14000000;
    public static final int SVC_IFINDEX = 0xC000000;
    public static final int FV_IFINDEX = 0xE000000;
    public static final int FCTUNNEL_IFINDEX = 0xF000000;
    public static final int IVR_IFINDEX = 0x10000000;
    public static final int SME_IFINDEX = 0x12000000;
    public static final int SDM_IFINDEX = 0x13000000;
    public static final int IOA_IFINDEX = 0x21000000;
    public static final int VFC_IFINDEX = 0x1E000000;
    public static final int VETH_IFINDEX = 0x1C000000;
    public static final int ETH_PCHANNEL_IFINDEX = 0x16000000;
    public static final int NON_IPS_ETH_IFINDEX = 0x1A000000;
    public static final int SAT_ETH_IFINDEX = 0x1F000000;
    public static final int VEM_ETH_IFINDEX = 0x25000000;
    public static final int VFC_SUBTYPE_DEFAULT = 0;
    public static final int VFC_SUBTYPE_PORT_CHANNEL = 1;
    public static final int VFC_SUBTYPE_SLOT_PORT = 2;
    public static final int VFC_SUBTYPE_FEX_PORT = 4;
    public static final String FC_NAME = "fc";
    public static final String ETH_NAME = "gigE";
    public static final String NON_IPS_ETH_NAME = "Ethernet";
    public static final String ETH_NAME_IPSTORAGE = "IPStorage";
    public static final String PCHANNEL_NAME = "channel";
    public static final String MGMT_NAME = "mgmt";
    public static final String INBAND_NAME = "sup-fc0";
    public static final String VSAN_NAME = "vsan";
    public static final String VSAN_NAME_CPP = "cpp";
    public static final String VLAN_NAME = "Vlan";
    public static final String FCIP_NAME = "fcip";
    public static final String ISCSI_NAME = "iscsi";
    public static final String SVC_NAME = "svc";
    public static final String FV_NAME = "fv";
    public static final String FCTUNNEL_NAME = "fc-tunnel";
    public static final String IVR_NAME = "ivr ";
    public static final String BLADESERVER_EXT_NAME = "ext";
    public static final String BLADESERVER_BAY_NAME = "bay";
    public static final String SME_NAME = "sme";
    public static final String IOA_NAME = "ioa";
    public static final String LOOPBACK_NAME = "loopback";
    public static final String ETH_PCHANNEL_NAME = "eth-channel";
    public static final String VFC_NAME = "vfc";
    public static final String VFC_PCHANNEL_NAME = "vfc-po";
    public static final String VETH_NAME = "veth";
    public static final String SAT_ETH_NAME = "eth";
    public static final String IFWWN_NAME = "ifwwn";
    public static final String ETHTUNNEL_NAME = "Tunnel";
    public static final int FSPF_IF_TYPE_RESERVED = 0;
    public static final int FSPF_IF_TYPE_PHY_FC_PORT = 1;
    public static final int FSPF_IF_TYPE_PORT_CHANNEL = 4;
    public static final int FSPF_IF_TYPE_FCIP_INTF = 10;
    public static final int FSPF_IF_TYPE_IVR_VXE_INTF = 16;
    public static final int FSPF_IF_TYPE_SDM_VXE_INTF = 19;
    public static final int FSPF_IF_TYPE_FC_SIF = 30;
    public static final int FSPF_IF_TYPE_VFC_INTF = 30;
    public static final int FSPF_IF_VFC_SUBTYPE_DEFAULT = 30;
    public static final int FSPF_IF_VFC_SUBTYPE_PORT_CHANNEL = 251;
    public static final int FSPF_IF_VFC_SUBTYPE_SLOT_PORT = 250;
    public static final int FSPF_IF_VFC_SUBTYPE_VETH = 249;
    public static final int FSPF_IF_VFC_SUBTYPE_FEX = 248;
    public static final int MAX_CARD = 16;
    public static final int WWNM_FORMAT1 = 1;
    public static final int WWNM_FORMAT2 = 2;
    public static final int WWNM_FORMAT5 = 5;
    public static final int WWNM_MAC_ADDRESS_LENGTH = 6;
    public static final int WWNM_MAX_PORT_CHANNELS = 256;
    public static final int WWNM_MAX_VFC_PORT_CHANNELS = 256;
    public static final int WWNM_MAX_PORTS_PER_SLOT = 64;
    public static final int WWNM_MAX_SLOTS = 16;
    public static final int WWNM_MAX_VFCS = 8192;
    public static final int WWNM_MAX_WKA_WWNS = 16;
    public static final int WWNM_MAX_LOCAL_CNTRL = 1;
    public static final int WWNM_BASE_PORT_CHANNEL_SEQ_NO = 1025;
    public static final int WWNM_BASE_WKA_SEQ_NO = 1281;
    public static final int WWNM_LOCAL_CNTRL = 1297;
    public static final int WWNM_BASE_VFC_PORT_CHANNEL_SEQ_NO = 1298;
    public static final int AUTO_40_BREAKOUT_FACTOR = 4;
    public static final int AUTO_100_BREAKOUT_FACTOR = 10;
    public static final int AUTO_40_BKOUT_SHIFT = 64;
    public static final int AUTO_100_BKOUT_SHIFT = 100;
    public static final int AUTO_40_FP_SHIFT = 90;
    public static final int AUTO_40_FP_END = 95;
    public static final int AUTO_100_FP_SHIFT = 120;
    public static final int AUTO_100_FP_END = 121;
    public static final int AUTO_40_BKOUT_END_N5K = 111;
    public static final int AUTO_40_FP_SHIFT_N5K = 112;
    public static final int AUTO_40_FP_END_N5K = 123;
    public static final int IF_INDEX_TYPE_PHY_ETHERNET_BO_TYPEBASE = 55;
    public static final int PHY_ETHERNET_BO_1_TYPE = 56;
    public static final int PHY_ETHERNET_BO_2_TYPE = 57;
    public static final int PHY_ETHERNET_BO_3_TYPE = 58;
    public static final int PHY_ETHERNET_BO_4_RESERVED_TYPE = 59;
    public static final int PHY_ETHERNET_BO_5_RESERVED_TYPE = 60;
    public static final int IF_INDEX_TYPE_PHY_ETHERNET_EFP_BO_TYPEBASE = 60;
    public static final int PHY_ETHERNET_EFP_BO_1_TYPE = 61;
    public static final int PHY_ETHERNET_EFP_BO_2_TYPE = 62;
    public static final int PHY_ETHERNET_EFP_BO_3_TYPE = 63;
    public static final int PHY_ETHERNET_EFP_BO_4_RESERVED_TYPE = 64;
    public static final int PHY_ETHERNET_EFP_BO_5_RESERVED_TYPE = 65;
    public static final int IF_INDEX_TYPE_PHY_ETHERNET_VSI_BO_TYPEBASE = 65;
    public static final int PHY_ETHERNET_VSI_BO_1_TYPE = 66;
    public static final int PHY_ETHERNET_VSI_BO_2_TYPE = 67;
    public static final int PHY_ETHERNET_VSI_BO_3_TYPE = 68;
    public static final int PHY_ETHERNET_VSI_BO_4_RESERVED_TYPE = 69;
    public static final int PHY_ETHERNET_VSI_BO_5_RESERVED_TYPE = 70;
    public static final int V3_BREAKOUT_MAX_BO_FACTOR = 10;
    public static final int V3_BREAKOUT_MAX_PORT_FACTOR = 64;
    public static final int V3_BREAKOUT_MAX_VSP_FACTOR = 4096;
    public static final int[] INAGUA_PORTMAP = new int[]{18, 19, 16, 17, 15, 12, 11, 13, 9, 6, 2, 3, 4, 7, 8, 20, 14, 10, 5, 1};
    public static final int[] CHESTER_PORTMAP_EXTERNAL = new int[]{-1, 10, 14, 18, 20, 24, 23, 5, 1};
    public static final int[] CHESTER_PORTMAP_BAY = new int[]{-1, 16, 15, 11, 9, 4, 2, 8, 22, 19, 17, 12, 13, 3, 6, 7, 21};
    public static final int[] CASSINO_PORTMAP_EXTERNAL = new int[]{-1, 21, 22, 23, 24, 20, 19, 18, 17};
    public static final int[] CASSINO_PORTMAP_BAY = new int[]{-1, 13, 15, 12, 10, 5, 7, 4, 2, 14, 16, 11, 9, 6, 8, 3, 1};
    public static final int FMIF_TYPE_BASE = 192;
    public static final int FMIF_TYPE_MASK = 207;
    public static final int FMIF_MASK = 0xFFFFFF;
    public static final int FMIF_ETH_TYPE = 193;
    public static final int FMIF_GE_TYPE = 194;
    public static final int FMIF_TE_TYPE = 195;
    public static final int FMIF_FE_TYPE = 196;
    public static final int FMIF_VLAN_TYPE = 197;
    public static final int FMIF_PO_TYPE = 198;
    public static final int FMIF_FI_TYPE = 199;
    public static final int FMIF_FEX_TYPE = 200;
    public static final int FMIF_SATETH_TYPE = 201;
    public static final char SLASH = '/';
    public static final char DASH = '-';
    public static final char SPACE = ' ';

    public static int getFirstValidIfIndexFor(int ifType) {
        return ifType << 24;
    }

    public static int getLastValidIfIndexFor(int ifType) {
        return (ifType + 1 << 24) - 1;
    }

    public static int name2IfIndex(String ifName) {
        try {
            return IfIndexUtil.nameToIfIndex(ifName);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static String ifIndexToName(int ifIndex) {
        int iftype = IfIndexUtil.getType(ifIndex);
        if (IfIndexUtil.isFmIfType(iftype)) {
            return IfIndexUtil.fmIfIndex2IfName(ifIndex);
        }
        switch (iftype) {
            case 1: {
                int card = (ifIndex >> 19 & 0x1F) + 1;
                int port = (ifIndex >> 12 & 0x7F) + 1;
                return FC_NAME + card + '/' + port;
            }
            case 2: 
            case 26: {
                int port;
                int card = (ifIndex >> 19 & 0x1F) + 1;
                int breakoutPort = 0;
                int vport = ifIndex >> 12 & 0x7F;
                if (vport >= 64 && vport <= 121) {
                    int[] cliport = IfIndexUtil.getCliPort4VirtualPort(vport);
                    port = cliport[0];
                    breakoutPort = cliport[1];
                } else {
                    port = vport + 1;
                }
                int subIf = ifIndex & 0xFFF;
                if (subIf == 0) {
                    if (breakoutPort == 0) {
                        return IfIndexUtil.ifTypeToifName(iftype) + card + '/' + port;
                    }
                    return IfIndexUtil.ifTypeToifName(iftype) + card + '/' + port + '/' + breakoutPort;
                }
                return IfIndexUtil.ifTypeToifName(iftype) + card + '/' + port + '.' + subIf;
            }
            case 56: 
            case 57: 
            case 58: {
                return IfIndexUtil.ifIndexToNameForV3Breakout(ifIndex, 55);
            }
            case 18: {
                int card = (ifIndex >> 19 & 0x1F) + 1;
                int port = (ifIndex >> 12 & 0x7F) + 1;
                return SME_NAME + card + '/' + port;
            }
            case 33: {
                int card = (ifIndex >> 19 & 0x1F) + 1;
                int port = (ifIndex >> 12 & 0x7F) + 1;
                return IOA_NAME + card + '/' + port;
            }
            case 4: {
                int subIf = ifIndex >> 8 & 0xFFF;
                if (subIf == 0) {
                    return PCHANNEL_NAME + ((ifIndex & 0xFF) + 1);
                }
                return PCHANNEL_NAME + ((ifIndex & 0xFF) + 1) + '.' + subIf;
            }
            case 22: {
                int subIf = ifIndex >> 12 & 0xFFF;
                if (subIf == 0) {
                    return ETH_PCHANNEL_NAME + ((ifIndex & 0xFFF) + 1);
                }
                return ETH_PCHANNEL_NAME + ((ifIndex & 0xFFF) + 1) + '.' + subIf;
            }
            case 5: {
                return MGMT_NAME + (ifIndex & 0xFF);
            }
            case 6: {
                return INBAND_NAME;
            }
            case 8: {
                int card = (ifIndex >> 19 & 0x1F) + 1;
                if (card == 32) {
                    return VSAN_NAME + (ifIndex & 0xFFF);
                }
                int port = (ifIndex >> 12 & 0x7F) + 1;
                return VSAN_NAME_CPP + card + '/' + port + '/' + (ifIndex & 0xFFF);
            }
            case 9: {
                return VLAN_NAME + (ifIndex & 0xFFF);
            }
            case 10: {
                return FCIP_NAME + ((ifIndex & 0xFFF) + 1);
            }
            case 11: {
                int card = (ifIndex >> 19 & 0x1F) + 1;
                int port = (ifIndex >> 12 & 0x7F) + 1;
                return ISCSI_NAME + card + '/' + port;
            }
            case 12: {
                int card = (ifIndex >> 19 & 0x1F) + 1;
                int port = (ifIndex >> 12 & 0x7F) + 1;
                return SVC_NAME + card + '/' + port;
            }
            case 14: {
                int card = (ifIndex >> 19 & 0x1F) + 1;
                int dpp = (ifIndex >> 14 & 0x1F) + 1;
                int port = (ifIndex & 0x3FFF) + 1;
                return FV_NAME + card + '/' + dpp + '/' + port;
            }
            case 15: {
                return FCTUNNEL_NAME + ((ifIndex & 0xFFF) + 1);
            }
            case 16: {
                int destDmId = ifIndex & 0xFF;
                int srcDmId = ifIndex >> 8 & 0xFF;
                return IVR_NAME + srcDmId + ':' + destDmId;
            }
            case 30: {
                int subType = IfIndexUtil.getSubType(ifIndex);
                switch (subType) {
                    case 2: {
                        int card = (ifIndex >> 15 & 0x1F) + 1;
                        int port = (ifIndex >> 8 & 0x7F) + 1;
                        return IfIndexUtil.ifTypeToifName(iftype) + card + "/" + port;
                    }
                    case 1: {
                        int channelId = (ifIndex & 0xFFF) + 1;
                        return VFC_PCHANNEL_NAME + channelId;
                    }
                    case 4: {
                        int chassis = (ifIndex >> 12 & 0xFF) + 1;
                        int card = (ifIndex >> 8 & 0xF) + 1;
                        int port = (ifIndex >> 2 & 0x3F) + 1;
                        return IfIndexUtil.ifTypeToifName(iftype) + chassis + "/" + card + "/" + port;
                    }
                }
                int vsifId = IfIndexUtil.ifindexToVfcIndex(ifIndex);
                return IfIndexUtil.ifTypeToifName(iftype) + vsifId;
            }
            case 28: {
                int vsifId = IfIndexUtil.ifindexToVfcIndex(ifIndex);
                return IfIndexUtil.ifTypeToifName(iftype) + vsifId;
            }
            case 31: {
                int satSwitchId = IfIndexUtil.ifIndex2SatSwitchId(ifIndex) + 1;
                int card = IfIndexUtil.ifIndex2Card(ifIndex) + 1;
                int port = IfIndexUtil.ifIndex2Port(ifIndex) + 1;
                return IfIndexUtil.ifTypeToifName(iftype) + satSwitchId + '/' + card + '/' + port;
            }
            case 20: {
                return LOOPBACK_NAME + (ifIndex & 0xFFFF);
            }
            case 24: {
                return ETHTUNNEL_NAME + (ifIndex & 0xFFFF);
            }
        }
        return IfIndexUtil.getIfNameOfInteger(ifIndex, false);
    }

    public static String getIfNameOfInteger(int ifindex, boolean isIfWwn) {
        if (isIfWwn) {
            return IFWWN_NAME + ifindex;
        }
        return String.valueOf(ifindex);
    }

    public static int nameToIfIndex(int card, int port, int type) {
        if (IfIndexUtil.isFmIfType(type)) {
            return IfIndexUtil.fmIfName2IfIndex(IfType.getType(type), card, port, 0);
        }
        if (type == 30) {
            if (IfIndexUtil.isSatSwitchId(card)) {
                return IfIndexUtil.getVfcIfIndex(4, 0, card - 1, port - 1, 0);
            }
            return IfIndexUtil.getVfcIfIndex(2, 0, card - 1, port - 1, 0);
        }
        return (type << 24) + (card - 1 << 19) + (port - 1 << 12);
    }

    public static int nameToIfIndexFex(int fexId, int card, int port) {
        return 0x1F000000 + (fexId - 1 << 16) + (card - 1 << 12) + (port - 1 << 6);
    }

    public static String generateVFCNameFromInterfaceName(String interfaceName) {
        int interfaceType = IfIndexUtil.ifNameToifType(interfaceName);
        String vfcIdStr = null;
        switch (interfaceType) {
            case 22: {
                int id = IfIndexUtil.getNum(interfaceName.substring(ETH_PCHANNEL_NAME.length()));
                vfcIdStr = VFC_PCHANNEL_NAME + id;
                break;
            }
            case 26: 
            case 31: {
                char c;
                int index = 3;
                String longName = "ethernet";
                if (interfaceName.toLowerCase().startsWith(longName)) {
                    index = longName.length();
                }
                if (!Character.isDigit(c = interfaceName.charAt(index))) break;
                int fexOrBreakoutSlot = -1;
                int pos = interfaceName.indexOf(47);
                int pos2 = interfaceName.indexOf(47, pos + 1);
                if (pos2 >= 0) {
                    fexOrBreakoutSlot = IfIndexUtil.getNum(interfaceName.substring(index, pos));
                    index = pos + 1;
                    pos = pos2;
                }
                String cardPortStr = interfaceName.substring(index);
                vfcIdStr = fexOrBreakoutSlot == -1 ? VFC_NAME + cardPortStr : VFC_NAME + fexOrBreakoutSlot + "/" + cardPortStr;
            }
        }
        return vfcIdStr;
    }

    public static int ifIndex2SatSwitchId(int ifIndex) {
        if (IfIndexUtil.getType(ifIndex) == 31) {
            return ifIndex >> 16 & 0xFF;
        }
        return -1;
    }

    public static int ifIndex2Card(int ifIndex) {
        int type = IfIndexUtil.getType(ifIndex);
        if (type == 31) {
            return ifIndex >> 12 & 0xF;
        }
        if (type == 30) {
            int subType = IfIndexUtil.getSubType(ifIndex);
            switch (subType) {
                case 2: {
                    int card = ifIndex >> 15 & 0x1F;
                    return card;
                }
                case 4: {
                    int card = ifIndex >> 12 & 0xFF;
                    return card;
                }
            }
        }
        return ifIndex >> 19 & 0x1F;
    }

    public static int ifIndex2Port(int ifIndex) {
        int type = IfIndexUtil.getType(ifIndex);
        if (type == 31) {
            return ifIndex >> 6 & 0x3F;
        }
        if (type == 30) {
            int subType = IfIndexUtil.getSubType(ifIndex);
            switch (subType) {
                case 2: {
                    int port = ifIndex >> 8 & 0x7F;
                    return port;
                }
                case 4: {
                    int port = ifIndex >> 2 & 0x3F;
                    return port;
                }
            }
        }
        return ifIndex >> 12 & 0x7F;
    }

    public static int ifIndex2Subif(int ifIndex) {
        return ifIndex & 0xFFF;
    }

    public static int getTypeForN5kLT503(int ifIndex) {
        int type = IfIndexUtil.getType(ifIndex);
        type = IfIndexUtil.convertN5KType(type, true);
        return type;
    }

    public static int getActualN5KType(int type) {
        return IfIndexUtil.convertN5KType(type, false);
    }

    public static int convertN5KType(int type, boolean lt503ToNew) {
        if (lt503ToNew) {
            switch (type) {
                case 29: {
                    return 28;
                }
            }
        } else {
            switch (type) {
                case 28: {
                    return 29;
                }
            }
        }
        return type;
    }

    private static int convertN5kIfIndex(int ifIndex, boolean lt503ToNew) {
        int type = IfIndexUtil.convertN5KType(IfIndexUtil.getType(ifIndex), lt503ToNew);
        return (type << 24) + (ifIndex & 0xFFFFFF);
    }

    public static int getType(int ifIndex) {
        return ifIndex >> 24 & 0xFF;
    }

    public static int getSubType(int ifIndex) {
        return ifIndex >> 20 & 0xF;
    }

    public static int ifIndex2PortChannel(int ifIndex) {
        return ifIndex & 0xFF;
    }

    public static int ifIndex2Fcip(int ifIndex) {
        return ifIndex & 0xFFF;
    }

    public static byte[] ifIndex2wwn(int ifIndex, byte[] swWwn, boolean isN5K) {
        int ifType = IfIndexUtil.getType(ifIndex);
        if (ifType == 1) {
            int card = IfIndexUtil.ifIndex2Card(ifIndex);
            int port = IfIndexUtil.ifIndex2Port(ifIndex) + 1;
            return IfIndexUtil.ifIndex2wwn(card, port, swWwn);
        }
        if (ifType == 4) {
            byte[] wwn = new byte[8];
            System.arraycopy(swWwn, 2, wwn, 2, 6);
            wwn[0] = 36;
            wwn[1] = (byte)((ifIndex & 0xFF) + 1);
            return wwn;
        }
        if (ifType == 30) {
            if (isN5K) {
                byte[] wwn = new byte[8];
                System.arraycopy(swWwn, 0, wwn, 0, 8);
                int vsifNum = ifIndex & 0xFFFF;
                wwn[0] = (byte)(wwn[0] & 0xF0);
                wwn[1] = 0;
                wwn[7] = (byte)(wwn[7] & 0xFFFFFFC0);
                BigInteger bi = new BigInteger(wwn);
                bi = bi.or(BigInteger.valueOf(vsifNum).shiftLeft(48));
                bi = bi.add(BigInteger.valueOf(63L));
                bi = bi.subtract(BigInteger.valueOf(vsifNum).shiftRight(12));
                wwn = bi.toByteArray();
                return wwn;
            }
            int subType = IfIndexUtil.getSubType(ifIndex);
            if (subType == 0) {
                int vfcId;
                int seqNo = vfcId = ifIndex & 0xFFFF;
                int oui = WwnDictionary.getVendorId(swWwn);
                int mac = WwnDictionary.getMacBase(swWwn) + 63;
                byte[] wwn = new byte[8];
                if (vfcId <= 4096) {
                    wwn[0] = (byte)(0x20 | seqNo >> 8 & 0xF);
                    wwn[1] = (byte)(seqNo & 0xFF);
                    wwn[2] = (byte)(oui >> 16 & 0xFF);
                    wwn[3] = (byte)(oui >> 8 & 0xFF);
                    wwn[4] = (byte)(oui & 0xFF);
                    wwn[5] = (byte)(mac >> 16 & 0xFF);
                    wwn[6] = (byte)(mac >> 8 & 0xFF);
                    wwn[7] = (byte)(mac & 0xFF);
                    return wwn;
                }
                seqNo = vfcId - 4096;
                wwn[0] = (byte)(0x50 | oui >> 20 & 0xF);
                wwn[1] = (byte)(oui >> 12 & 0xFF);
                wwn[2] = (byte)(oui >> 4 & 0xFF);
                wwn[3] = (byte)((oui & 0xF) << 4 | mac >> 20 & 0xF);
                wwn[4] = (byte)(mac >> 12 & 0xFF);
                wwn[5] = (byte)(mac >> 4 & 0xFF);
                wwn[6] = (byte)((mac & 0xF) << 4 | seqNo >> 8 & 0xF);
                wwn[7] = (byte)(seqNo & 0xFF);
                return wwn;
            }
            if (subType == 1) {
                int pcId = ifIndex & 0xFFF;
                int seqNo = 1298 + pcId;
                byte[] wwn = new byte[8];
                System.arraycopy(swWwn, 2, wwn, 2, 6);
                wwn[0] = (byte)(0x20 | seqNo >> 8 & 0xF);
                wwn[1] = (byte)(seqNo & 0xFF);
                return wwn;
            }
            if (subType == 2) {
                int card = ifIndex >> 15 & 0x1F;
                int port = (ifIndex >> 8 & 0x7F) + 1;
                return IfIndexUtil.ifIndex2wwn(card, port, swWwn);
            }
            if (subType == 4) {
                int satId = (ifIndex >> 12 & 0xFF) + 1;
                int port = (ifIndex >> 2 & 0x3F) + 1;
                return IfIndexUtil.vfcFexIfIndex2wwn(satId, port, swWwn);
            }
        } else if (IfIndexUtil.isFmIfType(ifType)) {
            return IfIndexUtil.fmIfIndex2Fwwm(ifIndex, swWwn);
        }
        return null;
    }

    public static byte[] ifIndex2wwn(int card, int port, byte[] swWwn) {
        byte[] wwn = new byte[8];
        System.arraycopy(swWwn, 2, wwn, 2, 6);
        if (card <= 16) {
            wwn[0] = 32;
            byte bCard = (byte)card;
            wwn[0] = (byte)(wwn[0] | bCard >> 2);
            wwn[1] = (byte)(wwn[1] | bCard << 6);
            wwn[1] = (byte)(wwn[1] | port);
        }
        return wwn;
    }

    public static byte[] vfcFexIfIndex2wwn(int satSwitchId, int port, byte[] swWwn) {
        byte[] wwn = new byte[8];
        int ssId = satSwitchId - 101;
        MacAddress switchMacAddress = new MacAddress(WwnDictionary.convertWwnBytes2MacBytes(swWwn));
        Long newMacAddrValue = new Long(switchMacAddress.value() + 62L);
        byte[] tempMacAddrByte = ByteBuffer.allocate(8).putLong(newMacAddrValue).array();
        byte[] newMacAddrByte = Arrays.copyOfRange(tempMacAddrByte, 2, 8);
        int wwnSeqNum = ssId << 8 | port;
        wwn = ssId <= 64 ? WwnDictionary.convertMacBytes2WwnBytes(newMacAddrByte, 2, wwnSeqNum, 0) : WwnDictionary.convertMacBytes2WwnBytes(newMacAddrByte, 5, wwnSeqNum, 0);
        return wwn;
    }

    public static int fWwn2IscsiIfIndex(byte[] fWwn) {
        int card = IfIndexUtil.ifWwn2Card(fWwn);
        int port = (fWwn[1] & 0x3F) / 4;
        return 0xB000000 + (card << 19) + (port << 12);
    }

    public static int fWwn2IscsiIfIndex14K9(byte[] fWwn) {
        int card = IfIndexUtil.ifWwn2Card(fWwn);
        int port = ((fWwn[1] & 0x3F) - 15) / 4;
        return 0xB000000 + (card << 19) + (port << 12);
    }

    public static int fWwn2IscsiIfIndex18K9(byte[] fWwn) {
        int card = IfIndexUtil.ifWwn2Card(fWwn);
        int port = ((fWwn[1] & 0x3F) - 19) / 4;
        return 0xB000000 + (card << 19) + (port << 12);
    }

    public static int fWwn2SvcIfIndex(byte[] fWwn) {
        int card = IfIndexUtil.ifWwn2Card(fWwn);
        int port = (fWwn[1] & 0x3F) - 1;
        return 0xC000000 + (card << 19) + (port << 12);
    }

    public static int fWwn2PortChannelIfIndex(byte[] fWwn) {
        return 0x4000000 + (fWwn[1] & 0xFF) - 1;
    }

    public static int fWwn2InbandIfIndex(byte[] fWwn) {
        return 101191680;
    }

    public static byte[] ifWwn2SwWwn(byte[] fWwn) {
        byte[] wwn = new byte[8];
        wwn[0] = 32;
        System.arraycopy(fWwn, 2, wwn, 2, 6);
        return wwn;
    }

    public static int ifWwn2Card(byte[] fWwn) {
        return (fWwn[0] & 7) << 2 | fWwn[1] >> 6 & 3;
    }

    public static int ifWwn2Port(byte[] fWwn) {
        return fWwn[1] & 0x3F;
    }

    public static int fspfPortIndexToIfIndex(int fspfIndex) {
        int fspfIfType = (fspfIndex & 0xFF0000) >> 16;
        switch (fspfIfType) {
            case 1: {
                int card = (fspfIndex & 0xFF00) >> 8;
                int port = fspfIndex & 0xFF;
                return 0x1000000 | card << 19 | port << 12;
            }
            case 4: {
                int channel = fspfIndex & 0xFF;
                return 0x4000000 | channel;
            }
            case 10: {
                int tunnel = fspfIndex & 0xFF;
                return 0xA000000 | tunnel;
            }
            case 16: {
                int ivr = fspfIndex & 0xFFFF;
                return 0x10000000 | ivr;
            }
            case 19: {
                int sdm = fspfIndex & 0xFFFF;
                return 0x13000000 | sdm;
            }
            case 30: {
                int vfcId = fspfIndex & 0xFFFF;
                return IfIndexUtil.getVfcIfIndex(0, vfcId, -1, -1, -1);
            }
            case 250: {
                int vcard = (fspfIndex & 0xFF00) >> 8;
                int vport = fspfIndex & 0xFF;
                return IfIndexUtil.getVfcIfIndex(2, -1, vcard, vport, -1);
            }
            case 251: {
                int vchannel = fspfIndex & 0xFFFF;
                return IfIndexUtil.getVfcIfIndex(1, -1, -1, -1, vchannel);
            }
        }
        return fspfIndex;
    }

    public static int getVfcIfIndex(int vfcSubType, int vfcId, int card, int port, int channelNum) {
        int vfcIfindex = -1;
        switch (vfcSubType) {
            case 2: {
                vfcIfindex = 0x1E200000 | card << 15 | port << 8;
                return vfcIfindex;
            }
            case 1: {
                vfcIfindex = 0x1E100000 | channelNum & 0xFFF;
                return vfcIfindex;
            }
            case 4: {
                int fexCard = 0;
                vfcIfindex = 0x1E400000 | card << 12 | fexCard << 8 | port << 2;
                return vfcIfindex;
            }
        }
        vfcIfindex = 0x1E000000 | vfcId & 0xFFFF;
        return vfcIfindex;
    }

    public static int getVlanIfIndex(int vdid, int vlanid) {
        return 0x9000000 | vdid << 16 | vlanid;
    }

    public static int getLoopbackIfIndex(int port) {
        return 0x14000000 | port;
    }

    public static boolean isIvrFspfPort(int portIndex) {
        return portIndex >> 16 == 16;
    }

    public static int ifIndexToFiconPort(int ifIndex) {
        int card = ifIndex >> 19 & 0x1F;
        int port = (ifIndex >> 12 & 0x7F) + 1;
        return card * 32 + port;
    }

    private static int getFexChassis(String ifName) throws SnmpException {
        int chassis = IfIndexUtil.getNum(ifName);
        return chassis;
    }

    private static int getCard(String ifName) throws SnmpException {
        int card = IfIndexUtil.getNum(ifName);
        if (card > 24) {
            throw new SnmpException("bad interface " + ifName);
        }
        return card;
    }

    private static int getPort(String ifName) throws SnmpException {
        int port = IfIndexUtil.getNum(ifName);
        if (port > 128) {
            throw new SnmpException("bad interface " + ifName);
        }
        return port;
    }

    private static int getSubInterface(String ifName) throws SnmpException {
        int sub = IfIndexUtil.getNum(ifName);
        if (sub > 4096) {
            throw new SnmpException("bad interface " + ifName);
        }
        return sub;
    }

    private static int getSatSwitchId(String ifName) throws SnmpException {
        int satSwitchId = IfIndexUtil.getNum(ifName);
        if (satSwitchId < 100 || satSwitchId > 199) {
            throw new SnmpException("bad interface " + ifName);
        }
        return satSwitchId;
    }

    public static boolean isSatSwitchId(int chassisId) {
        return chassisId >= 100 && chassisId <= 199;
    }

    private static int getNum(String numStr) throws IllegalArgumentException {
        if (numStr.startsWith("0x")) {
            return Integer.parseInt(numStr.substring(2), 16);
        }
        int ifIndex = Integer.parseInt(numStr);
        if (ifIndex < 0) {
            throw new IllegalArgumentException("bad interface " + numStr);
        }
        return ifIndex;
    }

    public static String convertIfName4IPStorage(String ifName) {
        if (ifName.indexOf(ETH_NAME) != -1) {
            return ifName.replaceFirst(ETH_NAME, ETH_NAME_IPSTORAGE);
        }
        return ifName;
    }

    public static String convertIfName4ChassisType(int ifType, int chassisType) {
        switch (ifType &= 0xFF) {
            case 2: {
                return FRUConstants.isIPStorageCapablePlatform(chassisType) ? ETH_NAME_IPSTORAGE : ETH_NAME;
            }
        }
        return IfIndexUtil.ifTypeToifName(ifType);
    }

    public static String ifTypeToifName(int ifType) {
        switch (ifType &= 0xFF) {
            case 1: {
                return FC_NAME;
            }
            case 2: {
                return ETH_NAME;
            }
            case 4: {
                return PCHANNEL_NAME;
            }
            case 5: {
                return MGMT_NAME;
            }
            case 6: {
                return INBAND_NAME;
            }
            case 8: {
                return VSAN_NAME;
            }
            case 10: {
                return FCIP_NAME;
            }
            case 11: {
                return ISCSI_NAME;
            }
            case 12: {
                return SVC_NAME;
            }
            case 14: {
                return FV_NAME;
            }
            case 15: {
                return FCTUNNEL_NAME;
            }
            case 16: {
                return IVR_NAME;
            }
            case 152: {
                return BLADESERVER_EXT_NAME;
            }
            case 153: {
                return BLADESERVER_BAY_NAME;
            }
            case 30: {
                return VFC_NAME;
            }
            case 28: 
            case 29: {
                return VETH_NAME;
            }
            case 26: 
            case 56: 
            case 57: 
            case 58: {
                return NON_IPS_ETH_NAME;
            }
            case 31: {
                return SAT_ETH_NAME;
            }
            case 22: {
                return ETH_PCHANNEL_NAME;
            }
        }
        if (IfIndexUtil.isFmIfType(ifType)) {
            IfType.getType(ifType);
            return IfType.getType(ifType).getName();
        }
        return FC_NAME;
    }

    public static int ifNameToifType(String ifName) {
        return IfIndexUtil.ifNameToifType(ifName, false);
    }

    public static int ifNameToifType(String ifName, boolean isCAT) {
        if (isCAT) {
            return IfType.getType(ifName, true).getValue();
        }
        if (ifName != null && ifName.length() >= 2) {
            char c = ifName.charAt(0);
            switch (Character.toLowerCase(c)) {
                case 'f': {
                    if (Character.toLowerCase(ifName.charAt(1)) == 'c') {
                        if (ifName.length() > 2 && Character.toLowerCase(ifName.charAt(2)) == 'i') {
                            return 10;
                        }
                        if (ifName.length() > 2 && Character.toLowerCase(ifName.charAt(2)) == '-') {
                            return 15;
                        }
                        return 1;
                    }
                    if (Character.toLowerCase(ifName.charAt(1)) == 'v') {
                        return 14;
                    }
                    if (Character.toLowerCase(ifName.charAt(1)) == 'm') {
                        return 199;
                    }
                }
                case 'g': {
                    return 2;
                }
                case 'c': {
                    return 4;
                }
                case 'm': {
                    return 5;
                }
                case 'v': {
                    if (Character.toLowerCase(ifName.charAt(1)) == 'e') {
                        return 28;
                    }
                    if (Character.toLowerCase(ifName.charAt(1)) == 'f') {
                        return 30;
                    }
                    return 8;
                }
                case 'i': {
                    if (Character.toLowerCase(ifName.charAt(1)) == 'v') {
                        return 16;
                    }
                    if (Character.toLowerCase(ifName.charAt(1)) == 'f') {
                        return 0;
                    }
                    return 11;
                }
                case 's': {
                    if (Character.toLowerCase(ifName.charAt(1)) == 'v') {
                        return 12;
                    }
                    return 6;
                }
                case 'b': {
                    return 153;
                }
                case 'e': {
                    if (Character.toLowerCase(ifName.charAt(1)) == 't') {
                        if (Character.toLowerCase(ifName.charAt(4)) == 'c') {
                            return 22;
                        }
                        StringTokenizer strTok = new StringTokenizer(ifName, "/");
                        if (strTok.countTokens() == 3) {
                            return 31;
                        }
                        return 26;
                    }
                    return 152;
                }
            }
        }
        return 1;
    }

    public static int getCppIfIndex(int card, int port, int vsan) {
        return 0x8000000 + (card - 1 << 19) + (port - 1 << 12) + vsan;
    }

    public static int getVsanIfIndex(int vsan) {
        return 0x8F80000 + vsan;
    }

    public static int getIfIndexCard(int ifIndex) {
        return IfIndexUtil.ifIndex2Card(ifIndex) + 1;
    }

    public static int getIfIndexPort(int ifIndex) {
        return IfIndexUtil.ifIndex2Port(ifIndex) + 1;
    }

    public static int nameToIfIndexForV3BO(int slot, int port, int boPort, int subInt, int boTypeBase) {
        int sysVsp = (slot - 1) * 10 * 64 + (port - 1) * 10 + (boPort - 1);
        int vsp = sysVsp % 4096;
        int boOrdinal = 1 + sysVsp / 4096;
        return (boTypeBase + boOrdinal << 24) + (vsp << 12) + subInt;
    }

    public static String ifIndexToNameForV3Breakout(int ifIndex, int boTypeBase) {
        int iftype = IfIndexUtil.getType(ifIndex);
        int vsp = IfIndexUtil.getVSP(ifIndex);
        int subint = ifIndex & 0xFFF;
        int boOrdinal = iftype - boTypeBase;
        int sysVsp = (boOrdinal - 1) * 4096 + vsp;
        int slot = 1 + sysVsp / 640;
        int port = 1 + sysVsp % 640 / 10;
        int boPort = 1 + sysVsp % 640 % 10;
        if (subint == 0) {
            return IfIndexUtil.ifTypeToifName(iftype) + slot + '/' + port + '/' + boPort;
        }
        return IfIndexUtil.ifTypeToifName(iftype) + slot + '/' + port + '/' + boPort + '.' + subint;
    }

    public static int getV3BreakoutSlot(int ifIndex, int boTypeBase) {
        int iftype = IfIndexUtil.getType(ifIndex);
        int vsp = IfIndexUtil.getVSP(ifIndex);
        int boOrdinal = iftype - boTypeBase;
        int sysVsp = (boOrdinal - 1) * 4096 + vsp;
        int slot = 1 + sysVsp / 640;
        return slot;
    }

    public static int getV3BreakoutPort(int ifIndex, int boTypeBase) {
        int iftype = IfIndexUtil.getType(ifIndex);
        int vsp = IfIndexUtil.getVSP(ifIndex);
        int boOrdinal = iftype - boTypeBase;
        int sysVsp = (boOrdinal - 1) * 4096 + vsp;
        int port = 1 + sysVsp % 640 / 10;
        return port;
    }

    public static int getV3BreakoutVirtualPort(int ifIndex, int boTypeBase) {
        int iftype = IfIndexUtil.getType(ifIndex);
        int vsp = IfIndexUtil.getVSP(ifIndex);
        int subint = ifIndex & 0xFFF;
        int boOrdinal = iftype - boTypeBase;
        int sysVsp = (boOrdinal - 1) * 4096 + vsp;
        int boPort = 1 + sysVsp % 640 % 10;
        return boPort;
    }

    public static int getBOIfType(int ifIndex) {
        return ifIndex >> 24 & 0x7F;
    }

    public static int getVSP(int ifIndex) {
        return ifIndex >> 12 & 0xFFF;
    }

    public static int getPhyPort(int cliPort, int breakoutPort, int bfactor) {
        if (breakoutPort == 0) {
            return (cliPort - 1) * bfactor;
        }
        return (cliPort - 1) * bfactor + breakoutPort - 1;
    }

    public static int getVirtualPort4FPPort(int phyPort, int bfactor, int offset) {
        return phyPort / bfactor + offset;
    }

    public static int getVirtualPort4BreakoutPort(int phyPort, int offset) {
        return phyPort + offset;
    }

    public static int getVirtualPortForN5K(int phyPort, boolean breakoutStatus, int breakoutFactor, int breakOutOffset) {
        if (breakoutFactor == 4) {
            if (breakoutStatus) {
                return 64 + (phyPort - 1) - breakOutOffset;
            }
            return 112 + (phyPort - 1) - breakOutOffset;
        }
        return 0;
    }

    public static int[] getCliPort4VirtualPort(int virtualPort) {
        int[] cliport = new int[2];
        if (virtualPort >= 64 && virtualPort < 90) {
            cliport[0] = (virtualPort - 64) / 4 + 1;
            cliport[1] = (virtualPort - 64) % 4 + 1;
        } else if (virtualPort >= 90 && virtualPort <= 95) {
            cliport[0] = virtualPort - 90 + 1;
            cliport[1] = 0;
        } else if (virtualPort >= 100 && virtualPort < 120) {
            cliport[0] = (virtualPort - 100) / 10 + 1;
            cliport[1] = (virtualPort - 100) % 10 + 1;
        } else if (virtualPort >= 120 && virtualPort <= 121) {
            cliport[0] = virtualPort - 120 + 1;
            cliport[1] = 0;
        } else {
            cliport[0] = virtualPort + 1;
            cliport[1] = 0;
        }
        return cliport;
    }

    public static int nameToIfIndexForAutodromo(String ifName, int bfactor) throws IllegalArgumentException {
        try {
            String longName = "ethernet";
            if (ifName == null || !ifName.toLowerCase().startsWith(SAT_ETH_NAME)) {
                return 0;
            }
            int index = 3;
            char c = Character.toLowerCase(ifName.charAt(index));
            if (c == '-') {
                int id = IfIndexUtil.getNum(ifName.substring(ETH_PCHANNEL_NAME.length()));
                return 0x16000000 + (id - 1);
            }
            if (ifName.toLowerCase().startsWith(longName)) {
                index = longName.length();
            }
            if (Character.isDigit(c = ifName.charAt(index))) {
                int offset = bfactor == 10 ? 120 : 90;
                int cliPort = 0;
                int breakoutPort = 0;
                int virtualPort = -1;
                int phyPort = -1;
                int satSwitchId = -1;
                int pos = ifName.indexOf(47);
                int pos2 = ifName.indexOf(47, pos + 1);
                if (pos2 >= 0) {
                    int slot = Integer.parseInt(ifName.substring(index, pos));
                    if (IfIndexUtil.isSatSwitchId(slot)) {
                        satSwitchId = slot;
                        index = pos + 1;
                        pos = pos2;
                        int pos3 = ifName.indexOf(47, pos + 1);
                        if (pos3 >= 0) {
                            cliPort = IfIndexUtil.getPort(ifName.substring(pos2 + 1, pos3));
                            breakoutPort = IfIndexUtil.getPort(ifName.substring(pos3 + 1, ifName.length()));
                            phyPort = IfIndexUtil.getPhyPort(cliPort, breakoutPort, bfactor);
                            offset = bfactor == 10 ? 100 : 64;
                            virtualPort = IfIndexUtil.getVirtualPort4BreakoutPort(phyPort, offset);
                        } else {
                            cliPort = IfIndexUtil.getPort(ifName.substring(pos + 1, ifName.length()));
                            phyPort = IfIndexUtil.getPhyPort(cliPort, breakoutPort, bfactor);
                            virtualPort = IfIndexUtil.getVirtualPort4FPPort(phyPort, bfactor, offset);
                        }
                    } else {
                        cliPort = IfIndexUtil.getPort(ifName.substring(pos + 1, pos2));
                        breakoutPort = IfIndexUtil.getPort(ifName.substring(pos2 + 1, ifName.length()));
                        phyPort = IfIndexUtil.getPhyPort(cliPort, breakoutPort, bfactor);
                        offset = bfactor == 10 ? 100 : 64;
                        virtualPort = IfIndexUtil.getVirtualPort4BreakoutPort(phyPort, offset);
                    }
                } else {
                    cliPort = IfIndexUtil.getPort(ifName.substring(pos + 1, ifName.length()));
                    phyPort = IfIndexUtil.getPhyPort(cliPort, breakoutPort, bfactor);
                    virtualPort = IfIndexUtil.getVirtualPort4FPPort(phyPort, bfactor, offset);
                }
                int card = IfIndexUtil.getCard(ifName.substring(index, pos));
                int subIf = 0;
                if (satSwitchId > 0) {
                    return IfIndexUtil.nameToIfIndexFex(satSwitchId, card, virtualPort);
                }
                System.out.println(" virtualPort is " + virtualPort);
                return 0x1A000000 + (card - 1 << 19) + (virtualPort << 12) + subIf;
            }
            return 0;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("bad interface " + ifName, ex);
        }
    }

    public static int nameToIfIndexN1KV(String ifName) throws IllegalArgumentException {
        String tmpifName = ifName.toLowerCase();
        try {
            if (tmpifName.startsWith(SAT_ETH_NAME) && tmpifName.indexOf(45) < 0) {
                char c;
                int index = 3;
                String longName = "ethernet";
                if (ifName.toLowerCase().startsWith(longName)) {
                    index = longName.length();
                }
                if (Character.isDigit(c = ifName.charAt(index))) {
                    int pos = ifName.indexOf(47);
                    int dote = ifName.indexOf(46);
                    int card = IfIndexUtil.getCard(ifName.substring(index, pos));
                    int port = IfIndexUtil.getPort(ifName.substring(pos + 1, dote == -1 ? ifName.length() : dote));
                    int subIf = 0;
                    if (dote != -1) {
                        subIf = IfIndexUtil.getNum(ifName.substring(dote + 1));
                    }
                    return 0x25000000 + (card - 1 << 14) + (port - 1 << 6) + subIf;
                }
            } else if (tmpifName.startsWith(VETH_NAME)) {
                int vsifId = IfIndexUtil.getNum(ifName.substring(VETH_NAME.length()));
                return 0x1C000000 + (vsifId - 1 << 4);
            }
            return IfIndexUtil.nameToIfIndex(ifName);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("bad interface " + ifName, ex);
        }
    }

    public static int nameToIfIndexForN5K(String ifName, int[] cardTypes) {
        try {
            char c = ifName.charAt(0);
            switch (Character.toLowerCase(c)) {
                case 'e': {
                    int index = 3;
                    c = Character.toLowerCase(ifName.charAt(index));
                    if (c == '-') {
                        int id = IfIndexUtil.getNum(ifName.substring(ETH_PCHANNEL_NAME.length()));
                        return 0x16000000 + (id - 1);
                    }
                    String longName = "ethernet";
                    if (ifName.toLowerCase().startsWith(longName)) {
                        index = longName.length();
                    }
                    if (Character.isDigit(c = ifName.charAt(index))) {
                        int card;
                        int pos = ifName.indexOf(47);
                        try {
                            card = IfIndexUtil.getCard(ifName.substring(index, pos));
                        }
                        catch (Exception ex) {
                            return IfIndexUtil.nameToIfIndex(ifName);
                        }
                        if (cardTypes == null) {
                            return -1;
                        }
                        boolean isBreakoutCard = FRUConstants.isBreakoutCapable(cardTypes[card - 1]);
                        if (isBreakoutCard) {
                            int breakoutFactor = FRUConstants.getBreakoutFactor(cardTypes[card - 1]);
                            int breakOutOffset = FRUConstants.getBreakoutOffset(cardTypes[card - 1]);
                            int pos2 = ifName.indexOf(47, pos + 1);
                            int frontPort = 0;
                            int breakoutPort = 0;
                            int phyPort = 0;
                            int dote = ifName.indexOf(46);
                            int subIf = 0;
                            if (dote != -1) {
                                subIf = IfIndexUtil.getNum(ifName.substring(dote + 1));
                            }
                            boolean breakoutStatus = false;
                            if (pos2 != -1) {
                                frontPort = IfIndexUtil.getPort(ifName.substring(pos + 1, pos2));
                                breakoutPort = IfIndexUtil.getNum(ifName.substring(pos2 + 1, dote == -1 ? ifName.length() : dote));
                                breakoutStatus = true;
                                phyPort = breakoutFactor * (frontPort - 1) + breakoutPort;
                            } else {
                                phyPort = frontPort = IfIndexUtil.getPort(ifName.substring(pos + 1, dote == -1 ? ifName.length() : dote));
                            }
                            int virtualPort = IfIndexUtil.getVirtualPortForN5K(phyPort, breakoutStatus, breakoutFactor, breakOutOffset);
                            return 0x1A000000 + (card - 1 << 19) + (virtualPort << 12) + subIf;
                        }
                        return IfIndexUtil.nameToIfIndex(ifName);
                    }
                    throw new IllegalArgumentException("");
                }
            }
            return IfIndexUtil.nameToIfIndex(ifName);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("bad interface " + ifName, ex);
        }
    }

    public static int nameToIfIndexForN5KLT503(String ifName) throws IllegalArgumentException {
        int ifIndex = IfIndexUtil.nameToIfIndex(ifName);
        return IfIndexUtil.convertN5kIfIndex(ifIndex, false);
    }

    public static int nameToIfIndex(String ifName) throws IllegalArgumentException {
        return IfIndexUtil.nameToIfIndex(ifName, false, 1);
    }

    public static int nameToIfIndex(String ifName, boolean isCAT, int vdcId) throws IllegalArgumentException {
        if (isCAT) {
            return IfIndexUtil.fmIfName2IfIndex(ifName);
        }
        try {
            char c = ifName.charAt(0);
            if (Character.isDigit(c)) {
                int pos = ifName.indexOf(47);
                int card = IfIndexUtil.getCard(ifName.substring(0, pos));
                int port = IfIndexUtil.getPort(ifName.substring(pos + 1));
                return 0x1000000 + (card - 1 << 19) + (port - 1 << 12);
            }
            switch (Character.toLowerCase(c)) {
                case 'f': {
                    char secondChar = Character.toLowerCase(ifName.charAt(1));
                    if (secondChar == 'c') {
                        c = Character.toLowerCase(ifName.charAt(2));
                        if (c == 'i') {
                            return 0xA000000 + IfIndexUtil.getNum(ifName.substring(4)) - 1;
                        }
                        if (c == '-' && Character.toLowerCase(ifName.charAt(3)) == 't') {
                            return 0xF000000 + IfIndexUtil.getNum(ifName.substring(9)) - 1;
                        }
                        if (!Character.isDigit(c)) break;
                        int pos = ifName.indexOf(47);
                        int card = IfIndexUtil.getCard(ifName.substring(2, pos));
                        int port = IfIndexUtil.getPort(ifName.substring(pos + 1));
                        return 0x1000000 + (card - 1 << 19) + (port - 1 << 12);
                    }
                    if (secondChar == 'v') {
                        int pos = ifName.indexOf(47);
                        int card = IfIndexUtil.getCard(ifName.substring(2, pos));
                        int pos2 = ifName.indexOf(47, pos + 1);
                        int dpp = IfIndexUtil.getNum(ifName.substring(pos + 1, pos2));
                        int port = IfIndexUtil.getPort(ifName.substring(pos2 + 1));
                        return 0xE000000 + (card - 1 << 19) + (dpp - 1 << 14) + (port - 1);
                    }
                    if (secondChar == 'm') {
                        return IfIndexUtil.fmIfName2IfIndex(ifName);
                    }
                    if (secondChar != 'e') break;
                    return IfIndexUtil.fmIfName2IfIndex(ifName);
                }
                case 'g': {
                    int index = 4;
                    if (ifName.toLowerCase().startsWith("gigabitethernet")) {
                        index = 15;
                    }
                    return IfIndexUtil.getIfIndexForIPSEth(ifName, index);
                }
                case 'e': {
                    int index = 3;
                    c = Character.toLowerCase(ifName.charAt(index));
                    if (c == '-') {
                        int subIf = 0;
                        int pos = ifName.indexOf(46);
                        if (pos != -1) {
                            subIf = IfIndexUtil.getNum(ifName.substring(pos + 1));
                        }
                        int id = IfIndexUtil.getNum(ifName.substring(ETH_PCHANNEL_NAME.length(), pos == -1 ? ifName.length() : pos));
                        return 0x16000000 + (subIf << 12) + (id - 1);
                    }
                    String longName = "ethernet";
                    if (ifName.toLowerCase().startsWith(longName)) {
                        index = longName.length();
                    }
                    if (!Character.isDigit(c = ifName.charAt(index))) break;
                    int fexOrBreakoutSlot = -1;
                    int pos = ifName.indexOf(47);
                    int pos2 = ifName.indexOf(47, pos + 1);
                    if (pos2 >= 0) {
                        fexOrBreakoutSlot = IfIndexUtil.getNum(ifName.substring(index, pos));
                        index = pos + 1;
                        pos = pos2;
                    }
                    int dote = ifName.indexOf(46);
                    int card = IfIndexUtil.getCard(ifName.substring(index, pos));
                    int port = IfIndexUtil.getPort(ifName.substring(pos + 1, dote == -1 ? ifName.length() : dote));
                    int subIf = 0;
                    if (dote != -1) {
                        subIf = IfIndexUtil.getNum(ifName.substring(dote + 1));
                    }
                    if (fexOrBreakoutSlot > -1) {
                        if (IfIndexUtil.isSatSwitchId(fexOrBreakoutSlot)) {
                            return IfIndexUtil.nameToIfIndexFex(fexOrBreakoutSlot, card, port);
                        }
                        return IfIndexUtil.nameToIfIndexForV3BO(fexOrBreakoutSlot, card, port, subIf, 55);
                    }
                    return 0x1A000000 + (card - 1 << 19) + (port - 1 << 12) + subIf;
                }
                case 'c': {
                    if (Character.toLowerCase(ifName.charAt(1)) == 'p') {
                        int pos = ifName.indexOf(47);
                        int card = IfIndexUtil.getCard(ifName.substring(3, pos));
                        int pos2 = ifName.indexOf(47, pos + 1);
                        int port = IfIndexUtil.getNum(ifName.substring(pos + 1, pos2));
                        int cpp = IfIndexUtil.getNum(ifName.substring(pos2 + 1));
                        return 0x8000000 + (card - 1 << 19) + (port - 1 << 12) + cpp;
                    }
                    int subIf = 0;
                    int pos = ifName.indexOf(46);
                    if (pos != -1) {
                        subIf = IfIndexUtil.getNum(ifName.substring(pos + 1));
                    }
                    return 0x4000000 + (subIf << 8) + IfIndexUtil.getNum(ifName.substring(7, pos == -1 ? ifName.length() : pos)) - 1;
                }
                case 'v': {
                    if (Character.toLowerCase(ifName.charAt(1)) == 'f') {
                        if (ifName.contains("/")) {
                            int pos = ifName.indexOf(47);
                            if (ifName.substring(pos + 1).contains("/")) {
                                int chassis = IfIndexUtil.getFexChassis(ifName.substring(VFC_NAME.length(), pos));
                                int pos2 = ifName.substring(pos + 1).indexOf(47) + pos + 1;
                                int card = IfIndexUtil.getCard(ifName.substring(pos + 1, pos2));
                                int port = IfIndexUtil.getPort(ifName.substring(pos2 + 1));
                                return IfIndexUtil.getVfcIfIndex(4, -1, chassis - 1, port - 1, -1);
                            }
                            int card = IfIndexUtil.getCard(ifName.substring(VFC_NAME.length(), pos));
                            int port = IfIndexUtil.getPort(ifName.substring(pos + 1));
                            return IfIndexUtil.getVfcIfIndex(2, -1, card - 1, port - 1, -1);
                        }
                        if (ifName.contains(VFC_PCHANNEL_NAME)) {
                            int pos = ifName.indexOf(111);
                            int channelNum = IfIndexUtil.getNum(ifName.substring(pos + 1));
                            return IfIndexUtil.getVfcIfIndex(1, -1, -1, -1, channelNum - 1);
                        }
                        int vsifId = IfIndexUtil.getNum(ifName.substring(VFC_NAME.length()));
                        return IfIndexUtil.getVfcIfIndex(0, vsifId - 1, -1, -1, -1);
                    }
                    if (Character.toLowerCase(ifName.charAt(1)) == 'e') {
                        int vsifId = IfIndexUtil.getNum(ifName.substring(VETH_NAME.length()));
                        return IfIndexUtil.vfcIndexToIfIndex(vsifId, 28);
                    }
                    if (Character.toLowerCase(ifName.charAt(1)) == 's') {
                        return 0x8F80000 + IfIndexUtil.getNum(ifName.substring(4));
                    }
                    if (Character.toLowerCase(ifName.charAt(1)) != 'l') break;
                    return IfIndexUtil.getVlanIfIndex(vdcId, IfIndexUtil.getNum(ifName.substring(4)));
                }
                case 'm': {
                    int port = IfIndexUtil.getNum(ifName.substring(4));
                    return 0x5000000 + (port << 12);
                }
                case 'i': {
                    if (Character.toLowerCase(ifName.charAt(1)) == 'v') {
                        int pos = ifName.indexOf(58);
                        int srcDmId = IfIndexUtil.getNum(ifName.substring(3, pos));
                        int destDmId = IfIndexUtil.getNum(ifName.substring(pos + 1));
                        return 0x10000000 + (srcDmId << 8) + destDmId;
                    }
                    if (Character.toLowerCase(ifName.charAt(1)) == 'f') {
                        if (ifName.length() > 5) {
                            int port = IfIndexUtil.getNum(ifName.substring(5));
                            return port;
                        }
                    } else if (Character.toLowerCase(ifName.charAt(1)) == 'p' && ifName.toLowerCase().startsWith(ETH_NAME_IPSTORAGE.toLowerCase())) {
                        int index = 9;
                        return IfIndexUtil.getIfIndexForIPSEth(ifName, index);
                    }
                    int pos = ifName.indexOf(47);
                    int card = IfIndexUtil.getCard(ifName.substring(5, pos));
                    int port = IfIndexUtil.getPort(ifName.substring(pos + 1));
                    return 0xB000000 + (card - 1 << 19) + (port - 1 << 12);
                }
                case 'l': {
                    int port = IfIndexUtil.getNum(ifName.substring(8));
                    return IfIndexUtil.getLoopbackIfIndex(port);
                }
                case 's': {
                    if (Character.toLowerCase(ifName.charAt(1)) == 'v') {
                        int pos = ifName.indexOf(47);
                        int card = IfIndexUtil.getCard(ifName.substring(3, pos));
                        int port = IfIndexUtil.getPort(ifName.substring(pos + 1));
                        return 0xC000000 + (card - 1 << 19) + (port - 1 << 12);
                    }
                    if (Character.toLowerCase(ifName.charAt(1)) == 'm') {
                        int pos = ifName.indexOf(47);
                        int card = IfIndexUtil.getCard(ifName.substring(3, pos));
                        int port = IfIndexUtil.getPort(ifName.substring(pos + 1));
                        return 0x12000000 + (card - 1 << 19) + (port - 1 << 12);
                    }
                    return 101191680;
                }
            }
            return IfIndexUtil.fmIfName2IfIndex(ifName);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("bad interface " + ifName, ex);
        }
    }

    private static int getIfIndexForIPSEth(String ifName, int index) throws SnmpException {
        int pos = ifName.indexOf(47);
        int subpos = ifName.indexOf(46, pos + 1);
        int card = IfIndexUtil.getCard(ifName.substring(index, pos));
        int port = IfIndexUtil.getPort(subpos > -1 ? ifName.substring(pos + 1, subpos) : ifName.substring(pos + 1));
        int subIf = 0;
        if (subpos == -1) {
            subpos = ifName.indexOf(47, pos + 1);
        }
        if (subpos != -1) {
            subIf = IfIndexUtil.getSubInterface(ifName.substring(subpos + 1));
        }
        if (card > 0) {
            --card;
        }
        if (port > 0) {
            --port;
        }
        return 0x2000000 + (card << 19) + (port << 12) + subIf;
    }

    public static int getPortEntity2If(int portEntityBase, int cardType) {
        if ((cardType == 22 || cardType == 27) && portEntityBase > 14) {
            return portEntityBase - 14;
        }
        if ((cardType == 39 || cardType == 41) && portEntityBase > 18) {
            return portEntityBase - 18;
        }
        if (cardType == 68) {
            if (portEntityBase >= 40) {
                return portEntityBase - 40;
            }
            if (portEntityBase >= 48) {
                return portEntityBase - 48;
            }
        }
        return portEntityBase;
    }

    public static int getPortIf2Entity(int portIfBase, int cardType, int portType) {
        if ((cardType == 22 || cardType == 27) && portType == 2) {
            return portIfBase + 14;
        }
        if ((cardType == 39 || cardType == 41) && portType == 2) {
            return portIfBase + 18;
        }
        if (cardType == 68) {
            if (portType == 26) {
                return portIfBase + 40;
            }
            if (portType == 2) {
                return portIfBase + 48;
            }
        }
        return portIfBase;
    }

    public static boolean isSupportIPStorageType(int chassisType) {
        return chassisType == 1326;
    }

    public static int getInaguaPortIfIndex(int port) {
        try {
            int inaguaPort = INAGUA_PORTMAP[port];
            int card = 1;
            return 0x1000000 + (card - 1 << 19) + (inaguaPort - 1 << 12);
        }
        catch (Exception ex) {
            System.err.println("IfIndexUtil: Inagua bad interface " + port);
            return 0;
        }
    }

    public static boolean isExternalPort4Inagua(int portId) {
        return portId == 0 || portId >= 15 && portId <= 19;
    }

    public static String ifIndexToNameInagua(int ifIndex) {
        if (IfIndexUtil.getType(ifIndex) != 1) {
            return IfIndexUtil.ifIndexToName(ifIndex);
        }
        int portId = IfIndexUtil.ifIndex2PortInagua(ifIndex);
        StringBuffer sb = new StringBuffer();
        sb.append(IfIndexUtil.isExternalPort4Inagua(portId) ? BLADESERVER_EXT_NAME : BLADESERVER_BAY_NAME);
        sb.append(portId);
        return sb.toString();
    }

    public static int ifIndex2PortInagua(int ifIndex) {
        int port = IfIndexUtil.ifIndex2Port(ifIndex) + 1;
        for (int i = 0; i < INAGUA_PORTMAP.length; ++i) {
            if (INAGUA_PORTMAP[i] != port) continue;
            return i;
        }
        System.err.println("IfIndexUtil: Inagua port not found (" + ifIndex + ") " + port);
        return 0;
    }

    public static int nameToIfIndexInagua(String ifName) throws IllegalArgumentException {
        if (ifName.toLowerCase().startsWith(BLADESERVER_EXT_NAME) || ifName.toLowerCase().startsWith(BLADESERVER_BAY_NAME)) {
            int port = IfIndexUtil.getNum(ifName.substring(3, ifName.length()));
            return IfIndexUtil.getInaguaPortIfIndex(port);
        }
        return IfIndexUtil.nameToIfIndex(ifName);
    }

    public static int nameToIfIndexInagua(int card, int port) {
        return IfIndexUtil.getInaguaPortIfIndex(port);
    }

    public static String getInaguaDefaultPortTypeName(int port) {
        return IfIndexUtil.isExternalPort4Inagua(port) ? BLADESERVER_EXT_NAME : BLADESERVER_BAY_NAME;
    }

    public static int getChesterPortIfIndex(int port, int type) {
        try {
            int chesterPort = type == 153 ? CHESTER_PORTMAP_BAY[port] : CHESTER_PORTMAP_EXTERNAL[port];
            int card = 1;
            return 0x1000000 + (card - 1 << 19) + (chesterPort - 1 << 12);
        }
        catch (Exception ex) {
            System.err.println("IfIndexUtil: Chester bad interface " + port);
            return 0;
        }
    }

    public static String ifIndexToNameForN5KLT503(int ifIndex) {
        int newIfIndex = IfIndexUtil.convertN5kIfIndex(ifIndex, true);
        int iftype = IfIndexUtil.getType(newIfIndex);
        if (iftype == 28) {
            int vethId = IfIndexUtil.ifindexToUCSVethIndex(newIfIndex);
            return IfIndexUtil.ifTypeToifName(iftype) + vethId;
        }
        return IfIndexUtil.ifIndexToName(newIfIndex);
    }

    public static int[] getCliPort4VirtualPortN5K(int virtualPort, int breakOutOffset) {
        int[] cliport = new int[]{(virtualPort - 64) / 4 + 1 + breakOutOffset, (virtualPort - 64) % 4 + 1};
        return cliport;
    }

    public static String ifIndexToNameForN5K(int ifIndex, int switchType) {
        int iftype = IfIndexUtil.getType(ifIndex);
        switch (iftype) {
            case 26: {
                int card = (ifIndex >> 19 & 0x1F) + 1;
                int port = -1;
                int breakoutPort = 0;
                int vport = ifIndex >> 12 & 0x7F;
                int breakOutOffset = 0;
                if (FRUConstants.isNC128(switchType)) {
                    breakOutOffset = card == 1 ? 48 : 24;
                }
                if (vport >= 64 && vport <= 111) {
                    int[] cliport = IfIndexUtil.getCliPort4VirtualPortN5K(vport, breakOutOffset);
                    port = cliport[0];
                    breakoutPort = cliport[1];
                } else {
                    port = vport >= 112 && vport <= 123 ? vport - 112 + 1 + breakOutOffset : vport + 1;
                }
                int subIf = ifIndex & 0xFFF;
                if (subIf == 0) {
                    if (breakoutPort == 0) {
                        return IfIndexUtil.ifTypeToifName(iftype) + card + '/' + port;
                    }
                    return IfIndexUtil.ifTypeToifName(iftype) + card + '/' + port + '/' + breakoutPort;
                }
                if (breakoutPort == 0) {
                    return IfIndexUtil.ifTypeToifName(iftype) + card + '/' + port + '.' + subIf;
                }
                return IfIndexUtil.ifTypeToifName(iftype) + card + '/' + port + '/' + breakoutPort + '.' + subIf;
            }
        }
        return IfIndexUtil.ifIndexToName(ifIndex);
    }

    private static int ifindexToUCSVethIndex(int ifIndex) {
        return (ifIndex & 0xFFFFF) + 1;
    }

    public static String ifIndexToNameChester(int ifIndex) {
        int i;
        if (IfIndexUtil.getType(ifIndex) != 1) {
            return IfIndexUtil.ifIndexToName(ifIndex);
        }
        int port = IfIndexUtil.ifIndex2Port(ifIndex) + 1;
        for (i = 0; i < CHESTER_PORTMAP_EXTERNAL.length; ++i) {
            if (CHESTER_PORTMAP_EXTERNAL[i] != port) continue;
            return BLADESERVER_EXT_NAME + i;
        }
        for (i = 0; i < CHESTER_PORTMAP_BAY.length; ++i) {
            if (CHESTER_PORTMAP_BAY[i] != port) continue;
            return BLADESERVER_BAY_NAME + i;
        }
        return IfIndexUtil.getIfNameOfInteger(ifIndex, false);
    }

    public static int ifIndex2PortChester(int ifIndex) {
        int i;
        int port = IfIndexUtil.ifIndex2Port(ifIndex) + 1;
        for (i = 0; i < CHESTER_PORTMAP_EXTERNAL.length; ++i) {
            if (CHESTER_PORTMAP_EXTERNAL[i] != port) continue;
            return i;
        }
        for (i = 0; i < CHESTER_PORTMAP_BAY.length; ++i) {
            if (CHESTER_PORTMAP_BAY[i] != port) continue;
            return i;
        }
        System.err.println("IfIndexUtil: Chester port not found (" + ifIndex + ") " + port);
        return 0;
    }

    public static int nameToIfIndexChester(int card, int port, int type) {
        return IfIndexUtil.getChesterPortIfIndex(port, type);
    }

    public static int nameToIfIndexChester(String ifName) throws IllegalArgumentException {
        if (ifName.toLowerCase().startsWith(BLADESERVER_EXT_NAME) || ifName.toLowerCase().startsWith(BLADESERVER_BAY_NAME)) {
            int port = IfIndexUtil.getNum(ifName.substring(3, ifName.length()));
            int type = ifName.toLowerCase().startsWith(BLADESERVER_EXT_NAME) ? 152 : 153;
            return IfIndexUtil.getChesterPortIfIndex(port, type);
        }
        return IfIndexUtil.nameToIfIndex(ifName);
    }

    public static boolean isExternalPort4Chester(int ifIndex) {
        int port = IfIndexUtil.ifIndex2Port(ifIndex) + 1;
        for (int i = 0; i < CHESTER_PORTMAP_EXTERNAL.length; ++i) {
            if (CHESTER_PORTMAP_EXTERNAL[i] != port) continue;
            return true;
        }
        return false;
    }

    public static int getCassinoPortIfIndex(int port, int type) {
        try {
            int cassinoPort = type == 153 ? CASSINO_PORTMAP_BAY[port] : CASSINO_PORTMAP_EXTERNAL[port];
            int card = 1;
            return 0x1000000 + (card - 1 << 19) + (cassinoPort - 1 << 12);
        }
        catch (Exception ex) {
            System.err.println("IfIndexUtil: Cassino bad interface " + port);
            return 0;
        }
    }

    public static String ifIndexToNameCassino(int ifIndex) {
        int i;
        if (IfIndexUtil.getType(ifIndex) != 1) {
            return IfIndexUtil.ifIndexToName(ifIndex);
        }
        int port = IfIndexUtil.ifIndex2Port(ifIndex) + 1;
        for (i = 0; i < CASSINO_PORTMAP_EXTERNAL.length; ++i) {
            if (CASSINO_PORTMAP_EXTERNAL[i] != port) continue;
            return BLADESERVER_EXT_NAME + i;
        }
        for (i = 0; i < CASSINO_PORTMAP_BAY.length; ++i) {
            if (CASSINO_PORTMAP_BAY[i] != port) continue;
            return BLADESERVER_BAY_NAME + i;
        }
        return IfIndexUtil.getIfNameOfInteger(ifIndex, false);
    }

    public static int ifIndex2PortCassino(int ifIndex) {
        int i;
        int port = IfIndexUtil.ifIndex2Port(ifIndex) + 1;
        for (i = 0; i < CASSINO_PORTMAP_EXTERNAL.length; ++i) {
            if (CASSINO_PORTMAP_EXTERNAL[i] != port) continue;
            return i;
        }
        for (i = 0; i < CASSINO_PORTMAP_BAY.length; ++i) {
            if (CASSINO_PORTMAP_BAY[i] != port) continue;
            return i;
        }
        System.err.println("IfIndexUtil: Cassno port not found (" + ifIndex + ") " + port);
        return 0;
    }

    public static int nameToIfIndexCassino(int card, int port, int type) {
        if (IfIndexUtil.isFmIfType(type)) {
            return IfIndexUtil.fmIfName2IfIndex(IfType.getType(type), card, port, 0);
        }
        return IfIndexUtil.getCassinoPortIfIndex(port, type);
    }

    public static int nameToIfIndexCassino(String ifName) throws IllegalArgumentException {
        if (ifName.toLowerCase().startsWith(BLADESERVER_EXT_NAME) || ifName.toLowerCase().startsWith(BLADESERVER_BAY_NAME)) {
            int port = IfIndexUtil.getNum(ifName.substring(3, ifName.length()));
            int type = ifName.toLowerCase().startsWith(BLADESERVER_EXT_NAME) ? 152 : 153;
            return IfIndexUtil.getCassinoPortIfIndex(port, type);
        }
        return IfIndexUtil.nameToIfIndex(ifName);
    }

    public static boolean isExternalPort4Cassino(int ifIndex) {
        int port = IfIndexUtil.ifIndex2Port(ifIndex) + 1;
        for (int i = 0; i < CASSINO_PORTMAP_EXTERNAL.length; ++i) {
            if (CASSINO_PORTMAP_EXTERNAL[i] != port) continue;
            return true;
        }
        return false;
    }

    public static int nonMdsIfWwn2Port(byte[] ifwwn) {
        int ifIndex;
        if (ifwwn == null || ifwwn.length != 8) {
            return 0;
        }
        if (WwnDictionary.getVendorId(ifwwn) == 1775) {
            ifIndex = ifwwn[4] << 24 | ifwwn[5] << 16 | ifwwn[6] << 8 | ifwwn[7];
        } else {
            ifIndex = (ifwwn[0] & 0xF) << 8 | ifwwn[1] & 0xFF;
            int offset = 0;
            if (WwnDictionary.isQuailWwn(ifwwn)) {
                offset = -1;
            } else {
                String key = "ifwwn2port.offset.0x" + SnmpString.toHexString((byte[])ifwwn, (int)2, (int)5, (boolean)false);
                offset = Integer.getInteger(key, 0);
            }
            ifIndex -= offset;
        }
        return ifIndex;
    }

    public static String nonMdsIfWwn2IfName(byte[] fwwn) {
        int ifindex = IfIndexUtil.nonMdsIfWwn2Port(fwwn);
        if (WwnDictionary.isMcDataWwn(fwwn)) {
            return "ifwwn " + ifindex;
        }
        return String.valueOf(ifindex);
    }

    public static boolean isVfcIfIndex(int ifindex) {
        int type = IfIndexUtil.getType(ifindex);
        return type == 30;
    }

    public static boolean isFvIfIndex(int ifindex) {
        return IfIndexUtil.getType(ifindex) == 14;
    }

    public static boolean isSatEthIfIndex(int ifindex) {
        return ifindex >= 526581760 && IfIndexUtil.getType(ifindex) == 31;
    }

    public static int dot1Index2IfIndex(byte[] dot1, int offset) {
        int ifindex = -1;
        if (dot1 == null || dot1.length < offset + 2) {
            return ifindex;
        }
        int cardFrom1 = ((dot1[offset] & 0xFF) << 8 | dot1[offset + 1] & 0xFF) >> 7;
        int portFrom1 = dot1[offset + 1] & 0x7F;
        if (IfIndexUtil.isSatSwitchId(cardFrom1)) {
            int fexId = IfIndexUtil.getFexId(cardFrom1);
            ifindex = IfIndexUtil.nameToIfIndexFex(fexId, 1, portFrom1);
        } else {
            ifindex = IfIndexUtil.nameToIfIndex(cardFrom1, portFrom1, 26);
        }
        return ifindex;
    }

    public static int getFexId(int ifIndexSlot) {
        int fexId = 0;
        if (ifIndexSlot >= 33) {
            fexId = 100 + (ifIndexSlot - 33);
        }
        return fexId;
    }

    public static int[] dot1Indexes2IfIndexes(byte[] dot1) {
        if (dot1 == null || dot1.length < 2) {
            return null;
        }
        int len = (dot1[0] << 8 & 0x7F) + dot1[1];
        if (dot1.length != len * 2 + 2) {
            System.err.print("Invalid eth port channel dot1 array:" + SnmpString.toHexString((byte[])dot1));
            return new int[0];
        }
        int[] ifindexes = new int[len];
        for (int i = 0; i < len; ++i) {
            int cardFrom1 = ((dot1[i * 2 + 2] & 0xFF) << 8 | dot1[i * 2 + 3] & 0xFF) >> 7;
            int portFrom1 = dot1[i * 2 + 3] & 0x7F;
            if (IfIndexUtil.isSatSwitchId(cardFrom1)) {
                int fexId = IfIndexUtil.getFexId(cardFrom1);
                ifindexes[i] = IfIndexUtil.nameToIfIndexFex(fexId, 1, portFrom1);
                continue;
            }
            ifindexes[i] = IfIndexUtil.nameToIfIndex(cardFrom1, portFrom1, 26);
        }
        return ifindexes;
    }

    public static int[] interfaceIndexList2ifIndexes(byte[] b) {
        int j = 0;
        int[] ifindexes = new int[b.length / 4];
        for (int i = 0; i < b.length && i <= b.length - 4; i += 4) {
            int ifIndex = ((b[i] & 0xFF) << 24) + ((b[i + 1] & 0xFF) << 16) + ((b[i + 2] & 0xFF) << 8) + (b[i + 3] & 0xFF);
            ifindexes[j++] = ifIndex;
        }
        return ifindexes;
    }

    public static int[] getVsanVlanMappingIndex(int vsanId, int vlanId) {
        return new int[]{1, 1, vlanId, vsanId};
    }

    public static int getVfcId(int ifindex) {
        int ifType = IfIndexUtil.getType(ifindex);
        if (ifType == 30) {
            int subType = IfIndexUtil.getSubType(ifindex);
            if (subType == 0) {
                return (ifindex & 0xFFFF) + 1;
            }
            if (subType == 1) {
                int channelId = (ifindex & 0xFFF) + 1;
                return channelId;
            }
        }
        System.err.println("Invalid ifindex for getVfcId():" + ifindex);
        return -1;
    }

    public static int ifindexToVfcIndex(int ifindex) {
        int ifType = IfIndexUtil.getType(ifindex);
        if (ifType == 30) {
            int subType = IfIndexUtil.getSubType(ifindex);
            if (subType == 0) {
                return (ifindex & 0xFFFF) + 1;
            }
            return ifindex & 0xFFFFFF;
        }
        if (ifType == 28) {
            return (ifindex >> 4 & 0xFFFFF) + 1;
        }
        System.err.println("Invalid ifindex for ifindexToVfcIndex():" + ifindex);
        return -1;
    }

    public static int vfcIndexToIfIndex(int vfcIndex, int ifType) {
        boolean explicitBind;
        boolean bl = explicitBind = (vfcIndex & 0xF00000) == 0;
        if (ifType == 30) {
            return 0x1E000000 + (explicitBind ? vfcIndex - 1 : vfcIndex);
        }
        if (ifType == 28 || ifType == 29) {
            return 0x1C000000 + (vfcIndex - 1 << 4);
        }
        System.err.println("Invalid ifType for vsifIdToIfIndex():" + ifType);
        return -1;
    }

    public static int[] ifIndexToVfcTableIndex(int ifindex, IfIndexIf switchIf) {
        int vfcIndex = IfIndexUtil.ifindexToVfcIndex(ifindex);
        int ifType = switchIf.getType(ifindex);
        if (ifType == 30) {
            return IfIndexUtil.vfcIndexToVfcTableIndex(vfcIndex);
        }
        if (ifType == 28 || ifType == 29) {
            return new int[]{vfcIndex, 6};
        }
        System.err.println("Invalid ifindex for ifIndexToVfcTableIndex():" + ifindex);
        return new int[0];
    }

    public static int[] vfcIndexToVfcTableIndex(int vfcIndex) {
        return new int[]{1, 1, vfcIndex};
    }

    public static int vfcTableIndexToIfIndex(int[] tableIndex, IfIndexIf switchIf) {
        if (switchIf == null || tableIndex == null || tableIndex.length < 2) {
            System.err.println("Invalid parameter for ivfcTableIndexToIfIndex()" + switchIf + "," + Arrays.toString(tableIndex));
            return -1;
        }
        if (tableIndex[1] == 6) {
            return IfIndexUtil.vfcIndexToIfIndex(tableIndex[0], 28);
        }
        if (tableIndex.length == 3) {
            return IfIndexUtil.vfcIndexToIfIndex(tableIndex[2], switchIf.getActualType(30));
        }
        System.err.println("Invalid tableIndex for vsifTableIndexToIfIndex():" + Arrays.toString(tableIndex));
        return -1;
    }

    public static String formatIfName(String ifname, boolean isInternal) {
        int i;
        if (ifname == null || ifname.length() == 0) {
            return ifname;
        }
        if (Character.isDigit(ifname.charAt(0))) {
            return ifname;
        }
        IfType iftype = IfType.getType(ifname, isInternal);
        if (iftype == null) {
            return ifname;
        }
        if (ifname.indexOf(iftype.getName()) == 0) {
            return ifname;
        }
        for (i = ifname.length() - 1; i > 0 && !Character.isLetter(ifname.charAt(i)); --i) {
        }
        if (i + 1 < ifname.length()) {
            return iftype.getName() + ifname.substring(i + 1, ifname.length()).trim();
        }
        return ifname;
    }

    public static IfType fmIfName2IfType(String ifname, boolean isInternal) {
        return IfType.getType(ifname, isInternal);
    }

    public static int fmIfName2FexId(String ifname) {
        if (ifname == null) {
            return 0;
        }
        IfType type = IfType.getType(ifname, true);
        if (type != IfType.FMSATETH) {
            return -1;
        }
        int sIdx = ifname.indexOf(47);
        if (sIdx < 0) {
            return 0;
        }
        int tIdx = ifname.indexOf(47, sIdx + 1);
        if (tIdx > 0) {
            int cIdx;
            for (cIdx = 0; cIdx < sIdx && !Character.isDigit(ifname.charAt(cIdx)); ++cIdx) {
            }
            if (cIdx < 0 || cIdx >= sIdx) {
                return 0;
            }
            try {
                return Integer.parseInt(ifname.substring(cIdx, sIdx));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        System.err.println("IfIndexUtil: fmif cannot get fexId from " + ifname);
        return 0;
    }

    public static int fmIfName2Card(String ifname) {
        int cIdx;
        int tIdx;
        if (ifname == null) {
            return 0;
        }
        IfType type = IfType.getType(ifname, true);
        int sIdx = ifname.indexOf(47);
        if (sIdx < 0) {
            return 0;
        }
        if (type == IfType.FMSATETH && (tIdx = ifname.indexOf(47, sIdx + 1)) > 0) {
            try {
                int card = Integer.parseInt(ifname.substring(sIdx + 1, tIdx));
                return card;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (cIdx = 0; cIdx < sIdx && !Character.isDigit(ifname.charAt(cIdx)); ++cIdx) {
        }
        if (cIdx < 0 || cIdx >= sIdx) {
            return 0;
        }
        try {
            int card = Integer.parseInt(ifname.substring(cIdx, sIdx));
            return card;
        }
        catch (Exception e) {
            System.err.println("IfIndexUtil: fmif cannot get if card from " + ifname);
            return 0;
        }
    }

    public static int fmIfName2Port(String ifname) {
        if (ifname == null) {
            return 0;
        }
        int sIdx = ifname.indexOf(47);
        if (sIdx < 0) {
            sIdx = ifname.indexOf(45);
        }
        if (sIdx < 0) {
            int dIdx;
            for (dIdx = 0; dIdx < ifname.length() && !Character.isDigit(ifname.charAt(dIdx)); ++dIdx) {
            }
            if (dIdx < ifname.length()) {
                try {
                    int port = Integer.parseInt(ifname.substring(dIdx, ifname.length()));
                    return port;
                }
                catch (Exception e) {
                    System.err.println("IfIndexUtil: fmif  cannot get if port " + ifname);
                }
            }
            return 0;
        }
        int tIdx = ifname.indexOf(47, sIdx + 1);
        if (tIdx < 0) {
            tIdx = ifname.indexOf(45, sIdx + 1);
        }
        if (tIdx < 0) {
            if (sIdx + 1 < ifname.length()) {
                try {
                    int port = Integer.parseInt(ifname.substring(sIdx + 1, ifname.length()));
                    return port;
                }
                catch (Exception e) {
                    System.err.println("IfIndexUtil: fmif  cannot get if port " + ifname);
                }
            }
            return 0;
        }
        IfType type = IfType.getType(ifname, true);
        if (type == IfType.FMSATETH) {
            if (tIdx + 1 < ifname.length()) {
                try {
                    int port = Integer.parseInt(ifname.substring(tIdx + 1, ifname.length()));
                    return port;
                }
                catch (Exception e) {
                    System.err.println("IfIndexUtil: fmif cannot get if port " + ifname);
                }
            }
            return 0;
        }
        if (sIdx + 1 < tIdx) {
            try {
                int port = Integer.parseInt(ifname.substring(sIdx + 1, tIdx));
                return port;
            }
            catch (Exception e) {
                System.err.println("IfIndexUtil: fmif cannot get if port " + ifname);
            }
        }
        return 0;
    }

    public static int fmIfName2IfIndex(String ifname) {
        IfType type;
        if (Character.isDigit(ifname.charAt(0))) {
            int pos = ifname.indexOf(47);
            if (pos < 0) {
                try {
                    int i;
                    for (i = 0; i < ifname.length() && !Character.isDigit(ifname.charAt(i)); ++i) {
                    }
                    return Integer.parseInt(ifname.substring(i));
                }
                catch (Exception e) {
                    System.err.println("IfIndexUtil: fmif cannot parse ifname to ifindex:" + ifname);
                    return 0;
                }
            }
            ifname = IfType.FMETH.getName() + ifname;
        }
        if ((type = IfType.getType(ifname, true)) == null || !type.isInternal()) {
            System.err.println("IfIndexUtil: fmif cannot parse ifname to ifindex:" + ifname);
            return 0;
        }
        switch (type) {
            case FMFEX: 
            case FMFI: 
            case FMVLAN: 
            case FMPO: 
            case FMETHPORTONLY: {
                int dIdx;
                for (dIdx = 0; dIdx < ifname.length() && !Character.isDigit(ifname.charAt(dIdx)); ++dIdx) {
                }
                if (dIdx < ifname.length()) {
                    try {
                        int portId = Integer.parseInt(ifname.substring(dIdx, ifname.length()));
                        if (type == IfType.FMETHPORTONLY) {
                            return IfIndexUtil.fmIfName2IfIndex(type, 0, portId, 0);
                        }
                        return IfIndexUtil.fmIfName2IfIndex(type, 0, 0, portId);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                System.err.println("IfIndexUtil: fmif cannot parse ifname to ifindex:" + ifname);
                return 0;
            }
            case FMETH: 
            case FMFASTETH: 
            case FMGIGETH: 
            case FMTGIGETH: 
            case FMSATETH: {
                int d1 = -1;
                int d2 = -1;
                int d3 = -1;
                int t1 = -1;
                int t2 = -1;
                int t3 = -1;
                for (int i = 0; i < ifname.length(); ++i) {
                    char c = ifname.charAt(i);
                    if (!Character.isDigit(c)) continue;
                    if (d1 == -1) {
                        d1 = i;
                    } else if (d2 == -1) {
                        d2 = i;
                    } else if (d3 == -1) {
                        d3 = i;
                    }
                    int k = i + 1;
                    while (k < ifname.length()) {
                        c = ifname.charAt(k);
                        i = k++;
                        if (Character.isDigit(c)) continue;
                        if (t1 == -1) {
                            t1 = k;
                            break;
                        }
                        if (t2 == -1) {
                            t2 = k;
                            break;
                        }
                        if (t3 != -1) break;
                        t3 = k;
                        break;
                    }
                    if (t3 != -1) break;
                }
                int card = -1;
                int port = -1;
                int subif = -1;
                if (d1 >= 0) {
                    try {
                        card = Integer.parseInt(ifname.substring(d1, t1 > 0 ? t1 : ifname.length()));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (d2 >= 0) {
                    try {
                        port = Integer.parseInt(ifname.substring(d2, t2 > 0 ? t2 : ifname.length()));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (d3 >= 0) {
                    try {
                        subif = Integer.parseInt(ifname.substring(d3, t3 > 0 ? t3 : ifname.length()));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (type == IfType.FMSATETH) {
                    return IfIndexUtil.fmIfNameToIfIndexSat(card, port, subif);
                }
                if (card != -1 && port == -1 && subif == -1) {
                    return IfIndexUtil.fmIfName2IfIndex(type, 0, card, 0);
                }
                if (card != -1 || port != -1 || subif != -1) {
                    return IfIndexUtil.fmIfName2IfIndex(type, card, port, subif);
                }
                System.err.println("IfIndexUtil: fmif cannot parse ifname to ifindex:" + ifname);
                return 0;
            }
        }
        System.err.println("IfIndexUtil: fmif cannot parse ifname to ifindex:" + ifname);
        return 0;
    }

    public static int fmIfName2IfIndex(IfType type, int card, int port, int subif) {
        if (type == null || !type.isInternal()) {
            try {
                throw new Exception("IfIndexUtil: invalid fm derived interface arguments:" + (Object)((Object)type) + "," + card + "," + port + "," + (Object)((Object)type) + "," + subif);
            }
            catch (Exception e) {
                System.err.println(e);
                return 0;
            }
        }
        int offset = type.getOffset();
        if (card < 1) {
            card = 1;
        }
        if (port < 1) {
            port = 1;
        }
        if (subif < 1) {
            subif = 1;
        }
        if (subif > 0) {
            return offset | card - 1 << 19 | port - 1 << 12 | subif - 1;
        }
        return offset | card - 1 << 19 | port - 1 << 12;
    }

    public static int fmIfNameToIfIndexSat(int fexId, int card, int port) {
        return IfType.FMSATETH.getOffset() + (fexId - 1 << 16) + (card - 1 << 12) + (port - 1 << 6);
    }

    public static int[] fmIfIndexToNameSat(int ifindex) {
        int fexId = ifindex >> 16 & 0xFF;
        int card = ifindex >> 12 & 0xF;
        int port = ifindex >> 6 & 0x3F;
        return new int[]{fexId, card, port};
    }

    public static boolean isFmIfIndex(int ifindex) {
        int type = IfIndexUtil.getType(ifindex);
        return IfIndexUtil.isFmIfType(type);
    }

    public static boolean isFmIfType(int iftype) {
        return (iftype & 0xC0) == 192;
    }

    public static boolean isFmWwnPidIdx(int ifindex) {
        return IfIndexUtil.getType(ifindex) == IfType.FMFI.getValue();
    }

    public boolean isFmFexIfindex(int ifindex) {
        return IfIndexUtil.getType(ifindex) == IfType.FMFEX.getValue();
    }

    public static boolean isFmWwnPidIfName(String ifname) {
        return ifname != null && ifname.length() >= 0 && (ifname.charAt(0) == 'w' || ifname.charAt(0) == 'W');
    }

    public static String fmIfType2IfName(int ifType) {
        IfType type = IfType.getType(ifType);
        if (type == null) {
            // empty if block
        }
        return type.getName();
    }

    public static String fmIfIndex2IfName(int ifindex) {
        if (!IfIndexUtil.isFmIfIndex(ifindex)) {
            try {
                throw new Exception("IfIndexUtil: invalid internal derived interface index:" + ifindex + ", 0x" + Integer.toHexString(ifindex));
            }
            catch (Exception e) {
                System.err.println(e);
                return String.valueOf(ifindex);
            }
        }
        IfType type = IfType.getTypeFromIfIndex(ifindex);
        if (type == null || !type.isInternal()) {
            try {
                throw new Exception("IfIndexUtil: invalid internal derived interface index:" + ifindex + ", 0x" + Integer.toHexString(ifindex));
            }
            catch (Exception e) {
                System.err.println(e);
                return String.valueOf(ifindex);
            }
        }
        switch (type) {
            case FMFEX: 
            case FMFI: 
            case FMVLAN: 
            case FMPO: {
                int portId = IfIndexUtil.ifIndex2Subif(ifindex);
                return type.getName() + String.valueOf(portId + 1);
            }
            case FMETHPORTONLY: {
                int port1 = IfIndexUtil.ifIndex2Port(ifindex);
                if (port1 < 0) {
                    port1 = 0;
                }
                return type.getName() + String.valueOf(port1 + 1);
            }
            case FMETH: 
            case FMFASTETH: 
            case FMGIGETH: 
            case FMTGIGETH: {
                int subif;
                int port;
                int card = IfIndexUtil.ifIndex2Card(ifindex);
                if (card < 0) {
                    card = 0;
                }
                if ((port = IfIndexUtil.ifIndex2Port(ifindex)) < 0) {
                    port = 0;
                }
                if ((subif = IfIndexUtil.ifIndex2Subif(ifindex)) < 0) {
                    subif = 0;
                }
                if (subif > 0) {
                    return type.getName() + (card + 1) + '/' + (port + 1) + '/' + (subif + 1);
                }
                return type.getName() + (card + 1) + '/' + (port + 1);
            }
            case FMSATETH: {
                int[] ids = IfIndexUtil.fmIfIndexToNameSat(ifindex);
                return type.getName() + (ids[0] + 1) + '/' + (ids[1] + 1) + '/' + (ids[2] + 1);
            }
        }
        System.err.println("IfIndexUtil: fmif cannot get ifname from ifindex:" + ifindex);
        return String.valueOf(ifindex);
    }

    public static int fmFwwn2IfIndex(byte[] wwn) {
        if (wwn == null || wwn.length != 8) {
            try {
                throw new Exception("IfIndexUtil: fmif invalid arguments to convert fwwn to fm derived ifindex:" + Arrays.toString(wwn));
            }
            catch (Exception e) {
                System.err.println(e);
                return -1;
            }
        }
        return IfType.FMFI.getOffset() + ((wwn[0] & 0xFF) << 16) + ((wwn[1] & 0xFF) << 8) + (wwn[7] & 0xFF);
    }

    public static byte[] fmIfIndex2Fwwm(int ifindex, byte[] swwn) {
        if (!IfIndexUtil.isFmWwnPidIdx(ifindex) || swwn == null || swwn.length != 8) {
            try {
                throw new Exception("IfIndexUtil: fmif invalid arguments to convert fm derived ifindex to fwwn:" + ifindex + "," + swwn);
            }
            catch (Exception e) {
                System.err.println(e);
                return null;
            }
        }
        byte[] fwwn = new byte[8];
        System.arraycopy(swwn, 0, fwwn, 0, 8);
        fwwn[0] = (byte)(ifindex >> 16 & 0xFF);
        fwwn[1] = (byte)(ifindex >> 8 & 0xFF);
        fwwn[7] = (byte)(ifindex & 0xFF);
        return fwwn;
    }

    public static boolean isAutodromoN7K(int ifIndex) {
        int vport;
        int type = IfIndexUtil.getType(ifIndex);
        return type == 26 && (vport = ifIndex >> 12 & 0x7F) >= 64 && vport <= 121;
    }

    public static int ifIndex2PortForAutodromoN7K(int ifIndex) {
        int type = IfIndexUtil.getType(ifIndex);
        if (type == 26) {
            int vport = ifIndex >> 12 & 0x7F;
            if (vport >= 64 && vport <= 121) {
                int[] cliport = IfIndexUtil.getCliPort4VirtualPort(vport);
                return cliport[0] - 1;
            }
            return vport;
        }
        return -1;
    }

    public static int ifIndex2PortForN5K(int ifIndex, int[] cardTypes) {
        int type;
        int card = IfIndexUtil.ifIndex2Card(ifIndex);
        boolean isBreakoutCard = FRUConstants.isBreakoutCapable(cardTypes[card]);
        int breakOutOffset = 0;
        if (isBreakoutCard) {
            breakOutOffset = FRUConstants.getBreakoutOffset(cardTypes[card]);
        }
        if ((type = IfIndexUtil.getType(ifIndex)) == 26) {
            int vport = ifIndex >> 12 & 0x7F;
            if (vport >= 64 && vport <= 111) {
                int[] cliport = IfIndexUtil.getCliPort4VirtualPortN5K(vport, breakOutOffset);
                return cliport[0] - 1;
            }
            if (vport >= 112 && vport <= 123) {
                return vport - 112 + breakOutOffset;
            }
            return vport;
        }
        return IfIndexUtil.ifIndex2Port(ifIndex);
    }

    public static void main(String[] args) throws Exception {
        String swWWNstr = "20:00:00:26:98:0d:60:80";
        byte[] swWwn = SnmpString.fromHexString((String)swWWNstr, (boolean)true);
        int ifIndex = 507920412;
        byte[] portWwn = IfIndexUtil.ifIndex2wwn(ifIndex, swWwn, false);
        String pWwn = SnmpString.toHexString((byte[])portWwn);
        System.out.println(pWwn);
    }

    public static enum IfType {
        FC(1, false, "fc", "fc"),
        IPSETH(2, false, "gigE", "gigabitethernet"),
        FCCHANNEL(4, false, "port-channel", "port-channel"),
        MGMT(5, false, "mgmt", "mgmt"),
        INBAND(6, false, "sup-fc0", "sup-fc0"),
        VSAN(8, false, "vsan", "vsan"),
        VLAN(9, false, "Vlan", "vlan"),
        FCIP(10, false, "fcip", "fcip"),
        ISCSI(11, false, "iscsi", "iscsi"),
        SVC(12, false, "svc", "svc"),
        FV(14, false, "fv", "fv"),
        FCTUNNEL(15, false, "fc-tunnel", "fc-tunnel"),
        IVR(16, false, "ivr", "ivr"),
        SME(18, false, "sme", "sme"),
        LOOPBACK(20, false, "Loopback", "loopback"),
        ETHCHANNEL(22, false, "eth-channel", "eth-channel"),
        ETHTUNNEL(24, false, "Tunnel", "tunnel"),
        ETH(26, false, "Ethernet", "ethernet"),
        VETH(28, false, "veth", "veth"),
        VFC(30, false, "vfc", "vfc"),
        SATETH(31, false, "Ethernet", "ethernet"),
        IOA(33, false, "ioa", "ioa"),
        BLADEEXT(152, false, "ext", "ext"),
        BLADEBAY(153, false, "bay", "bay"),
        IFWWN(0, false, "ifwwn", "ifwwn"),
        PORTID(0, false, "", ""),
        FMETH(193, true, "Ethernet", "ethernet"),
        FMGIGETH(194, true, "GigabitEthernet", "gigabitethernet"),
        FMTGIGETH(195, true, "TenGigabitEthernet", "tengigabitethernet"),
        FMFASTETH(196, true, "FastEthernet", "fastethernet"),
        FMVLAN(197, true, "Vlan", "vlan"),
        FMPO(198, true, "Port-channel", "po"),
        FMFI(199, true, "fminternal", "fminternal"),
        FMFEX(200, true, "upl", "upl"),
        FMSATETH(201, true, "Ethernet", "ethernet"),
        FMETHPORTONLY(202, true, "eth", "eth");

        static IfType[] _AllTypes;
        static HashMap<Integer, IfType> _TypeMap;
        private int _value;
        private boolean _internal = true;
        private int _offset;
        private String _name;
        private String _lowName;
        private String _lowFullName;

        private IfType(int value, boolean internal, String name, String lowFullName) {
            this._value = value;
            this._internal = internal;
            this._offset = this._value << 24;
            this._name = name;
            this._lowName = name.toLowerCase();
            this._lowFullName = lowFullName;
        }

        public String getName() {
            return this._name;
        }

        public int getValue() {
            return this._value;
        }

        public int getOffset() {
            return this._offset;
        }

        public boolean isInternal() {
            return this._internal;
        }

        public String getLowFullName() {
            return this._lowFullName;
        }

        public String getLowName() {
            return this._lowName;
        }

        public String toString() {
            return this._name;
        }

        public static IfType getType(int iftype) {
            IfType type;
            if (iftype == 0) {
                return IFWWN;
            }
            if (_TypeMap.size() == 0) {
                for (IfType t : _AllTypes) {
                    if (t.getValue() == 0) continue;
                    _TypeMap.put(t.getValue(), t);
                }
            }
            if ((type = _TypeMap.get(iftype)) == null) {
                System.err.println("IfIndexUtil: fmif cannot get if type from " + iftype + ", default to Internal Ethernet");
                type = FMETH;
            }
            return type;
        }

        public static IfType getTypeFromIfIndex(int ifindex) {
            int type = IfIndexUtil.getType(ifindex);
            return IfType.getType(type);
        }

        public static IfType getType(String ifname, boolean isInternal) {
            if (ifname == null || ifname.length() < 1) {
                return null;
            }
            char c0 = Character.toLowerCase(ifname.charAt(0));
            if (Character.isDigit(c0)) {
                return PORTID;
            }
            if (ifname.length() < 2) {
                return null;
            }
            char c1 = Character.toLowerCase(ifname.charAt(1));
            switch (c0) {
                case 'f': {
                    if (c1 == 'v') {
                        return FV;
                    }
                    if (c1 == 'c') {
                        if (ifname.length() > 2 && ifname.charAt(2) == '-') {
                            return FCTUNNEL;
                        }
                        if (ifname.length() > 2 && Character.toLowerCase(ifname.charAt(2)) == 'i') {
                            return FCIP;
                        }
                        return FC;
                    }
                    if (c1 == 'm') {
                        return FMFI;
                    }
                    if (c1 != 'a') break;
                    return FMFASTETH;
                }
                case 'e': {
                    if (c1 == 'x') {
                        return BLADEEXT;
                    }
                    if (c1 != 't') break;
                    if (ifname.length() > 3 && ifname.charAt(3) == '-') {
                        return ETHCHANNEL;
                    }
                    int splash = ifname.indexOf(47);
                    if (splash > 0 && ifname.indexOf(47, splash + 1) > 0) {
                        return isInternal ? FMSATETH : SATETH;
                    }
                    if (ifname.length() < 6) {
                        return FMETHPORTONLY;
                    }
                    return isInternal ? FMETH : ETH;
                }
                case 'g': {
                    if (c1 != 'i') break;
                    return isInternal ? FMGIGETH : IPSETH;
                }
                case 'p': {
                    if (c1 != 'o') break;
                    if (ifname.length() > 5 && ifname.charAt(5) == '-') {
                        return FCCHANNEL;
                    }
                    return FMPO;
                }
                case 'v': {
                    if (c1 == 's') {
                        return VSAN;
                    }
                    if (c1 == 'l') {
                        return isInternal ? FMVLAN : VLAN;
                    }
                    if (c1 == 'e') {
                        return VETH;
                    }
                    if (c1 != 'f') break;
                    return VFC;
                }
                case 'm': {
                    if (c1 != 'g') break;
                    return MGMT;
                }
                case 's': {
                    if (c1 == 'm') {
                        return SME;
                    }
                    if (c1 == 'u') {
                        return INBAND;
                    }
                    if (c1 != 'v') break;
                    return SVC;
                }
                case 'i': {
                    if (c1 == 's') {
                        return ISCSI;
                    }
                    if (c1 == 'v') {
                        return IVR;
                    }
                    if (c1 == 'o') {
                        return IOA;
                    }
                    if (c1 == 'f') {
                        return IFWWN;
                    }
                    if (c1 != 'p') break;
                    return IPSETH;
                }
                case 'u': {
                    if (c1 != 'p') break;
                    return FMFEX;
                }
                case 'b': {
                    if (c1 != 'a') break;
                    return BLADEBAY;
                }
                case 'l': {
                    if (c1 != 'o') break;
                    return LOOPBACK;
                }
                case 't': {
                    if (c1 == 'e') {
                        return FMTGIGETH;
                    }
                    if (c1 != 'u') break;
                    return ETHTUNNEL;
                }
            }
            System.err.println("IfIndexUtil: fmif cannot get if type from " + ifname + ", default to Ethernet");
            return isInternal ? FMETH : ETH;
        }

        static {
            _AllTypes = IfType.values();
            _TypeMap = new HashMap();
        }
    }
}

