/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpString;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class SnmpInetAddress
extends SnmpString {
    public SnmpInetAddress(byte[] b) {
        super(b);
    }

    public SnmpInetAddress(String ip) throws SnmpException {
        super(SnmpInetAddress.parse(ip));
    }

    public SnmpInetAddress(String ip, boolean isSupportIpV4DNS) throws SnmpException {
        super(SnmpInetAddress.parse(ip, isSupportIpV4DNS));
    }

    public static byte[] parse(String ip) throws SnmpException {
        if (ip == null || ip.length() == 0) {
            return new byte[0];
        }
        return SnmpIpAddress.parse((String)ip);
    }

    public static byte[] parse(String ip, boolean isSupportIpV4DNS) throws SnmpException {
        if (ip == null || ip.length() == 0) {
            return new byte[0];
        }
        if (isSupportIpV4DNS) {
            try {
                SnmpIpAddress.parse((String)ip);
            }
            catch (SnmpException ex) {
                return ip.getBytes();
            }
        }
        return SnmpIpAddress.parse((String)ip);
    }

    public String toString() {
        if (this._value == null) {
            this._value = SnmpIpAddress.toString((byte[])this._byteValue);
        }
        return this._value;
    }

    public static InetAddress getInetAddressFrom(int addrType, byte[] addr) throws UnknownHostException {
        InetAddress inetAddr = null;
        if (addrType == 16) {
            SnmpString snmpStr = new SnmpString(addr);
            String ipAddress = snmpStr.toString();
            inetAddr = InetAddress.getByName(ipAddress);
        } else {
            inetAddr = InetAddress.getByAddress(addr);
        }
        return inetAddr;
    }

    public int getAddressType(InetAddress address) {
        String addrStr = address.toString();
        if (addrStr.indexOf(46) != -1 && addrStr.indexOf(58) != -1) {
            return 16;
        }
        byte[] addrByteArray = address.getAddress();
        if (addrByteArray.length == 16) {
            return 2;
        }
        if (addrByteArray.length == 4) {
            return 1;
        }
        return 0;
    }
}

