/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.Bits;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.InterfaceIndex;
import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.jnm.SnmpDateAndTime;
import com.cisco.dcbu.lib.jnm.SnmpFcAddressId;
import com.cisco.dcbu.lib.jnm.SnmpInetAddress;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpLongList;
import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.jnm.SysUpTimeIf;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.ficon.FiconPortList;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class SnmpTableModel
extends KTableModel {
    public MibNode[] _mibNodes;
    public String[] _mibVars;
    protected boolean _isEditable;
    public static HashMap _MibVariableFormatMethods;
    public static Class _MibVariableFormatClass;
    public static HashMap _MibVariableSetMethods;
    public static Class _MibVariableSetClass;
    public static SysUpTimeIf _SysUpTimeIf;
    public static IfIndexIf _IfIndexIf;
    public static SnmpPeer _peer;
    public static int[] _slotMembers;
    public static int[][] _ifNameTypes;
    public static HashMap _Aliases;
    public static HashMap _Units;
    protected int _offset;
    protected String[] _prefixes;
    private Array _noSuchInstanceArray = new Array();

    public String get1stPrefix() {
        return this._prefixes == null || this._prefixes.length == 0 ? null : this._prefixes[0];
    }

    public void build(String indexTitle, String[] mibVars, String[] prefixes) {
        this.build(mibVars, prefixes, 1);
        this.setHeader(0, indexTitle);
    }

    public void build(String[] mibVars, String[] prefixes, int offset) {
        this._offset = offset;
        this._mibVars = mibVars;
        String[] headers = new String[mibVars.length + offset];
        boolean[] editable = new boolean[headers.length];
        this._mibNodes = new MibNode[headers.length];
        this._prefixes = prefixes;
        for (int i = offset; i < headers.length; ++i) {
            if (mibVars[i - offset] == null) continue;
            this._mibNodes[i] = MibNode.get((String)mibVars[i - offset]);
            editable[i] = this._mibNodes[i].isEditable();
            if (editable[i] && !this._isEditable) {
                this._isEditable = true;
            }
            String units = "";
            if (_Units.get(mibVars[i - offset]) != null) {
                units = (String)_Units.get(mibVars[i - offset]);
            }
            headers[i] = SnmpTableModel.trim(mibVars[i - offset], prefixes) + " " + units;
        }
        this.setHeaders(headers);
        this.setEditable(editable);
        this.setData(new Array());
        this._noSuchInstanceArray = new Array();
    }

    public int getModelColumnIndex(String mibVar) {
        int modelColumnIndex = -1;
        if (mibVar != null && this._mibVars != null) {
            for (int i = 0; i < this._mibVars.length; ++i) {
                if (!this._mibVars[i].equals(mibVar)) continue;
                modelColumnIndex = i + this._offset;
                break;
            }
        }
        return modelColumnIndex;
    }

    public int getModelColumnIndex(int mibVarIndex) {
        int modelColumnIndex = -1;
        if (mibVarIndex >= 0 && this._mibVars != null && mibVarIndex < this._mibVars.length) {
            modelColumnIndex = mibVarIndex + this._offset;
        }
        return modelColumnIndex;
    }

    public final boolean isEditable() {
        return this._isEditable;
    }

    public void setIsEditable(boolean isEditable) {
        this._isEditable = isEditable;
    }

    public String trim(String mibVar) {
        return SnmpTableModel.trim(mibVar, this._prefixes);
    }

    public static String trim(String mibVar, String[] prefixes) {
        String alias = (String)_Aliases.get(mibVar);
        if (alias != null) {
            return alias;
        }
        if (prefixes != null) {
            for (int i = 0; i < prefixes.length; ++i) {
                if (!mibVar.startsWith(prefixes[i])) continue;
                return mibVar.substring(prefixes[i].length());
            }
        }
        return mibVar;
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
        aValue = this.getSetValueAt(aValue, row, col);
        super.setValueAt(aValue, row, col);
    }

    public Object getSetValueAt(Object aValue, int row, int col) {
        if (row == -1 || col == -1) {
            return aValue;
        }
        Object[] data = (Object[])this.getData().elementAt(row);
        Object target = data[col];
        if (target instanceof JnmMibEnum && !(aValue instanceof JnmMibEnum)) {
            MibEnum[] enums = ((JnmMibEnum)((Object)target)).getEnums();
            int value = MibEnum.getValue((MibEnum[])enums, (String)aValue.toString());
            if (value != -1) {
                aValue = new JnmMibEnum(aValue.toString(), value, enums);
            }
        } else if (target instanceof FiconPortList) {
            try {
                aValue = new FiconPortList(aValue.toString(), this.getIfIndexIf(row), this.getRowPeer(row));
            }
            catch (SnmpException ex) {
                Util.errorMessage(this.getErrorComponent(), (Exception)((Object)ex));
            }
        } else if (target instanceof SnmpIntList) {
            try {
                aValue = new SnmpIntList(aValue.toString(), this.getIfIndexIf(row), this.getSlotMembers(row), this.getIfNameTypes(row));
            }
            catch (SnmpException ex) {
                Util.errorMessage(this.getErrorComponent(), (Exception)((Object)ex));
            }
        } else if (target instanceof InterfaceIndex) {
            try {
                aValue = new InterfaceIndex(aValue.toString(), this.getIfIndexIf(row));
            }
            catch (Exception ex) {
                Util.errorMessage(this.getErrorComponent(), ex);
            }
        } else if (target instanceof SnmpLongList) {
            aValue = new SnmpLongList(aValue.toString());
        }
        return aValue;
    }

    protected IfIndexIf getIfIndexIf(int row) {
        return _IfIndexIf;
    }

    protected SnmpPeer getRowPeer(int row) {
        return _peer;
    }

    protected int[] getSlotMembers(int row) {
        return _slotMembers;
    }

    protected int[][] getIfNameTypes(int row) {
        return _ifNameTypes;
    }

    protected SysUpTimeIf getSysUpTimeIf(int row) {
        return _SysUpTimeIf;
    }

    public void setNoSuchInstance(int row, int col, boolean isNoSuchInstance) {
        Array noSuchInstanceRow;
        if (this._noSuchInstanceArray.size() <= row) {
            for (int i = this._noSuchInstanceArray.size(); i <= row; ++i) {
                this._noSuchInstanceArray.addElement((Object)new Array());
            }
        }
        if ((noSuchInstanceRow = (Array)this._noSuchInstanceArray.elementAt(row)) == null) {
            noSuchInstanceRow = new Array();
        }
        if (noSuchInstanceRow.size() <= col) {
            for (int i = noSuchInstanceRow.size(); i <= col; ++i) {
                noSuchInstanceRow.addElement((Object)new Boolean(false));
            }
        }
        noSuchInstanceRow.setElementAt((Object)new Boolean(isNoSuchInstance), col);
    }

    @Override
    public boolean isNoSuchInstance(int row, int col) {
        Array noSuchInstanceRow;
        if (this._noSuchInstanceArray.size() > row && (noSuchInstanceRow = (Array)this._noSuchInstanceArray.elementAt(row)).size() > col) {
            return (Boolean)noSuchInstanceRow.elementAt(col);
        }
        return super.isNoSuchInstance(row, col);
    }

    public Object toCell(MibNode mibNode, SnmpVar v, String var, int row) {
        String tc = mibNode.getTCLabel();
        if (v.getType() == 5) {
            return this.getValueForNoSuchInstance(mibNode, tc, v, var, row);
        }
        Object o = SnmpTableModel.getMibVariableFormat(var, v, _MibVariableFormatMethods, _MibVariableFormatClass);
        if (o != null) {
            return o;
        }
        if (tc != null && !(v instanceof SnmpNull) && (o = this.getTextConventionFormat(mibNode, tc, v, row)) != null) {
            return o;
        }
        MibEnum[] enums = mibNode.getEnums();
        if (enums != null) {
            if (v.getType() == 2) {
                int value = ((SnmpInt)v).getValue();
                if (mibNode.isEditable()) {
                    for (int i = 0; i < enums.length; ++i) {
                        if (enums[i].getValue() != value) continue;
                        return new JnmMibEnum(enums[i].getLabel(), value, enums);
                    }
                    return new JnmMibEnum("Unknown: " + value, value, enums);
                }
                return MibEnum.getLabel((MibEnum[])enums, (int)value);
            }
            if (v.getType() == 4) {
                return new Bits(enums, ((SnmpString)v).getValue());
            }
        }
        return v;
    }

    public static Object getMibVariableFormat(String var, SnmpVar value, HashMap methods, Class mibFormat) {
        SnmpVar[] values = new SnmpVar[]{value};
        return SnmpTableModel.getMibVariableFormat(var, values, methods, mibFormat);
    }

    public static Object getMibVariableFormat(String var, SnmpVar[] values, HashMap methods, Class mibFormat) {
        Method m;
        if (methods != null && (m = (Method)methods.get(var)) != null) {
            try {
                Object[] args = new Object[values.length];
                args = values;
                return m.invoke((Object)mibFormat, args);
            }
            catch (InvocationTargetException ex) {
                Exception realEx = (Exception)ex.getTargetException();
                if (realEx == null) {
                    realEx = ex;
                }
                System.err.println(var + " getMibVariableFormat: " + realEx);
            }
            catch (IllegalArgumentException ex) {
                Class<MibVariableFormat> c = MibVariableFormat.class;
                Class[] types = new Class[values.length];
                for (int i = 0; i < values.length; ++i) {
                    types[i] = SnmpVar.class;
                }
                try {
                    Method m1 = c.getMethod(var, types);
                    Object[] args = new Object[values.length];
                    args = values;
                    return m1.invoke((Object)mibFormat, args);
                }
                catch (Exception ex1) {
                    throw new IllegalArgumentException(ex);
                }
            }
            catch (Exception ex) {
                System.err.println(var + " getMibVariableFormat: " + ex);
            }
        }
        return null;
    }

    public static SnmpVar getMibVariableSet(String var, Object value, HashMap methods, Class mibFormat) throws Exception {
        Method m;
        if (methods != null && (m = (Method)methods.get(var)) != null) {
            try {
                Object[] args = new Object[]{value};
                return (SnmpVar)m.invoke((Object)mibFormat, args);
            }
            catch (InvocationTargetException ex) {
                Exception realEx = (Exception)ex.getTargetException();
                System.err.println(var + " getMibVariableSet: " + realEx);
                throw new Exception(ex.getTargetException().getMessage());
            }
            catch (Exception ex) {
                System.err.println(var + " getMibVariableSet: " + ex);
            }
        }
        return null;
    }

    protected Object getTextConventionFormat(MibNode mibNode, String tc, SnmpVar v, int row) {
        switch (tc.charAt(0)) {
            case 'A': {
                if (!tc.equals("Action") || !mibNode.isEditable()) break;
                if (v.getType() == 2) {
                    return ((SnmpInt)v).getValue() == 1 ? Boolean.TRUE : Boolean.FALSE;
                }
                return Boolean.FALSE;
            }
            case 'B': {
                if (!tc.equals("Bitmap")) break;
                return new SnmpBitmap(((SnmpString)v).getValue());
            }
            case 'I': {
                if (tc.startsWith("InterfaceIndex") && v.getType() == 2) {
                    try {
                        return new InterfaceIndex((SnmpInt)v, this.getIfIndexIf(row));
                    }
                    catch (SnmpException ex) {
                        return null;
                    }
                }
                if (!tc.equals("InetAddress") || v.getType() != 4) break;
                return new SnmpInetAddress(((SnmpString)v).getValue());
            }
            case 'F': {
                if (tc.equals("FcAddressId") && v.getType() == 4) {
                    return new SnmpFcAddressId(((SnmpString)v).getValue());
                }
                if (!tc.equals("FcNameId") && !tc.equals("FcNameIdOrZero") || v.getType() != 4) break;
                return new SnmpWWN(((SnmpString)v).getValue());
            }
            case 'P': {
                if (!tc.equals("PortMemberList") || v.getType() != 4) break;
                return new SnmpIntList(((SnmpString)v).getValue(), this.getIfIndexIf(row));
            }
            case 'L': {
                if (!tc.equals("LongList") || v.getType() != 4) break;
                return new SnmpLongList(((SnmpString)v).getValue());
            }
            case 'T': {
                if (tc.equals("TruthValue") && mibNode.isEditable()) {
                    if (v.getType() == 2) {
                        return ((SnmpInt)v).getValue() == 1 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    return Boolean.FALSE;
                }
                if (!tc.equals("TimeStamp") || v.getType() != 67) break;
                SnmpTimeticks tt = (SnmpTimeticks)v;
                long value = tt.getValue();
                if (value == 0L) {
                    return "n/a";
                }
                long sysUptime = this.getSysUpTimeIf(row) != null ? this.getSysUpTimeIf(row).getSysUpTime() : _SysUpTimeIf.getSysUpTime();
                if (value >= sysUptime) {
                    if (value - sysUptime < 100L) {
                        value = sysUptime - 1L;
                    } else {
                        return "n/a";
                    }
                }
                return tt.toString(sysUptime - value);
            }
            case 'D': 
            case 'S': {
                if (v.getType() == 4 && (tc.equals("DisplayString") || tc.equals("SnmpAdminString"))) {
                    ((SnmpString)v).cacheString(true);
                    return v;
                }
                if (v.getType() != 4 || !tc.equals("DateAndTime")) break;
                return new SnmpDateAndTime(((SnmpString)v).getValue());
            }
            case 'M': {
                if (v.getType() != 4 || !tc.equals("MacAddress")) break;
                ((SnmpString)v).cacheString(false);
                return v;
            }
        }
        return null;
    }

    public Object getValueForNoSuchInstance(MibNode mibNode, String tc, SnmpVar v, String var, int row) {
        if (!mibNode.isEditable()) {
            return v;
        }
        MibEnum[] enums = mibNode.getEnums();
        if (enums != null && (tc == null || tc != null && !tc.equals("TruthValue") && !tc.equals("Action"))) {
            if (mibNode.getType() == 2) {
                int value = mibNode.getDefVal();
                for (int i = 0; i < enums.length; ++i) {
                    if (enums[i].getValue() != value) continue;
                    return new JnmMibEnum(enums[i].getLabel(), value, enums);
                }
                return new JnmMibEnum(enums[0].getLabel(), enums[0].getValue(), enums);
            }
            if (mibNode.getType() == 4) {
                int maxbitPos = enums[enums.length - 1].getValue();
                byte[] byteValue = new byte[maxbitPos / 8 + 1];
                return new Bits(enums, byteValue);
            }
        }
        if (mibNode.getType() == 4) {
            return new SnmpString("n/a");
        }
        if (mibNode.getType() == 2) {
            if (tc == null) {
                return new SnmpInt(mibNode.getDefVal());
            }
            switch (tc.charAt(0)) {
                case 'A': {
                    if (!tc.equals("Action")) break;
                    return Boolean.FALSE;
                }
                case 'T': {
                    if (!tc.equals("TruthValue")) break;
                    return Boolean.FALSE;
                }
                default: {
                    return new SnmpInt(mibNode.getDefVal());
                }
            }
        }
        if (mibNode.getType() == 66) {
            return new SnmpGauge(mibNode.getDefVal() == -1 ? 0L : (long)mibNode.getDefVal());
        }
        return v;
    }

    public int[] getIndex(int row) {
        if (this.getValueAt(row, 0) == null) {
            return null;
        }
        return ((SnmpOID)this.getValueAt(row, 0)).getValue();
    }

    public int[] getIndex(int row, int cell) {
        return this.getIndex(row);
    }

    public SnmpPDU setChangedCells() throws Exception {
        Array cells = this.getChanged();
        if (cells == null || cells.size() == 0) {
            return null;
        }
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(cells.size()));
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            int[] index = this.getIndex(cell._row, cell._col);
            SnmpOID oid = new SnmpOID(this._mibNodes[this.getMibNodeCol(cell._col)].getOid(), index);
            this.addChangedCell(pdu, oid, cell);
        }
        return pdu;
    }

    protected int getMibNodeCol(int col) {
        return col;
    }

    protected void addChangedCell(SnmpPDU pdu, SnmpOID oid, Cell cell) throws Exception {
        pdu.addVar(oid, this.getChangedCell(cell._row, cell._col));
    }

    protected SnmpVar getChangedCell(int row, int col) throws Exception {
        return this.getChangedCell(row, col, this._mibNodes);
    }

    protected SnmpVar getChangedCell(int row, int col, MibNode[] mibNodes) throws Exception {
        String textConvention = mibNodes[this.getMibNodeCol(col)].getTCLabel();
        Object o = this.getValueAt(row, col);
        SnmpVar d = this.getMibVariableSet(col, o);
        if (d != null) {
            return this.checkCell(d, mibNodes[this.getMibNodeCol(col)], this.getHeaders()[col], row, col);
        }
        if (o instanceof SnmpVar) {
            try {
                if (textConvention != null) {
                    if (textConvention.equals("InetAddress")) {
                        return new SnmpInetAddress(o.toString());
                    }
                    if (textConvention.startsWith("InterfaceIndex")) {
                        return new SnmpInt(_IfIndexIf.nameToIfIndex(o.toString()));
                    }
                }
            }
            catch (SnmpException ex) {
                throw new Exception(this.getHeaders()[col] + ":" + ex.getMessage());
            }
            return this.checkCell((SnmpVar)o, mibNodes[this.getMibNodeCol(col)], this.getHeaders()[col], row, col);
        }
        if (o instanceof MibEnum) {
            return new SnmpInt(((MibEnum)o).getValue());
        }
        if (o instanceof Boolean) {
            return new SnmpInt((Boolean)o != false ? 1 : 2);
        }
        if (o instanceof String) {
            if (textConvention != null && textConvention.equals("BitmapBase0")) {
                return new SnmpBitmap((String)o, true);
            }
            return new SnmpBitmap((String)o);
        }
        throw new Exception("unknown value: " + o);
    }

    protected SnmpVar getMibVariableSet(int col, Object o) throws Exception {
        if (col >= this._offset && this._mibVars != null && this._mibVars.length > col - this._offset) {
            return SnmpTableModel.getMibVariableSet(this._mibVars[col - this._offset], o, _MibVariableSetMethods, _MibVariableSetClass);
        }
        return null;
    }

    protected SnmpVar checkCell(SnmpVar v, MibNode mibNode, String name, int row, int col) throws Exception {
        if (mibNode.getHi() != 0) {
            if (v.getType() == 2) {
                int value = ((SnmpInt)v).getValue();
                if (value < mibNode.getLo() || value > mibNode.getHi()) {
                    throw new Exception(name + " should be in range " + mibNode.getLo() + ".." + mibNode.getHi());
                }
            } else if (v.getType() == 66) {
                long value = ((SnmpUnsignedInt)v).getValue();
                if (value < (long)mibNode.getLo() || value > (long)mibNode.getHi()) {
                    throw new Exception(name + " should be in range " + mibNode.getLo() + ".." + mibNode.getHi());
                }
            } else if (v.getType() == 4) {
                if (mibNode.getMaxWidth() < ((SnmpString)v).getValue().length) {
                    throw new Exception(name + " maximum length is " + mibNode.getMaxWidth());
                }
                if (mibNode.getMinWidth() > ((SnmpString)v).getValue().length) {
                    throw new Exception(name + " minimum length is " + mibNode.getMinWidth());
                }
            }
        }
        return v;
    }

    @Override
    public int compare(Object first, Object second) {
        if (first instanceof SnmpInt && second instanceof SnmpInt) {
            return ((SnmpInt)first).getValue() - ((SnmpInt)second).getValue();
        }
        if (first instanceof SnmpUnsignedInt && second instanceof SnmpUnsignedInt) {
            long diff = ((SnmpUnsignedInt)first).getValue() - ((SnmpUnsignedInt)second).getValue();
            return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
        }
        if (first instanceof SnmpString && second instanceof SnmpString) {
            if (first.toString().equals(second.toString())) {
                return 0;
            }
            if (first.toString() == null) {
                return -1;
            }
            if (second.toString() == null) {
                return 1;
            }
            return first.toString().compareToIgnoreCase(second.toString());
        }
        if (first instanceof SnmpOID && second instanceof SnmpOID) {
            return MibNode.equals((int[])((SnmpOID)first).getValue(), (int[])((SnmpOID)second).getValue());
        }
        if (first instanceof SnmpNull || second instanceof SnmpNull) {
            return super.compare(first.toString(), second.toString());
        }
        if (first instanceof SnmpPeer || second instanceof SnmpPeer) {
            if (first.toString().equals(second.toString())) {
                return 0;
            }
            if (first.toString() == null) {
                return -1;
            }
            if (second.toString() == null) {
                return 1;
            }
            return first.toString().compareToIgnoreCase(second.toString());
        }
        return super.compare(first, second);
    }

    static {
        _Aliases = new HashMap();
        _Units = new HashMap();
    }
}

