/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class VendorPanel
extends JPanel
implements ActionListener {
    String vendorURL = null;
    String deviceName = null;
    Properties vendorLinksProperties = null;

    public VendorPanel(String deviceName, Component component, Properties vendorLinksProperties) {
        super(new BorderLayout());
        this.deviceName = deviceName;
        this.vendorURL = "http://" + deviceName;
        this.vendorLinksProperties = vendorLinksProperties;
        this.add(component, "North");
        FlowLayout flowLayout = new FlowLayout(0, 0, 0);
        JPanel flowPanel = new JPanel(flowLayout);
        flowPanel.add(new JLabel("Download Provider: "));
        JComboBox<Object> vendorComboBox = null;
        if (vendorLinksProperties != null && !vendorLinksProperties.isEmpty()) {
            vendorComboBox = new JComboBox();
            String vendorName = null;
            Object[] vendorNames = new String[vendorLinksProperties.size()];
            int i = 0;
            Enumeration<Object> keys = vendorLinksProperties.keys();
            while (keys.hasMoreElements()) {
                vendorName = (String)keys.nextElement();
                vendorNames[i++] = vendorName;
            }
            Arrays.sort(vendorNames);
            vendorComboBox = new JComboBox<Object>(vendorNames);
            flowPanel.add(vendorComboBox);
        } else {
            vendorComboBox = new JComboBox<String>(new String[]{"Cisco", "EMC", "IBM", "HP", "HDS", "SUN"});
            flowPanel.add(vendorComboBox);
        }
        vendorComboBox.addActionListener(this);
        vendorComboBox.setSelectedIndex(0);
        this.add((Component)flowPanel, "West");
        this.add((Component)new JLabel("<html><br>Do you want to upgrade?</html>"), "South");
    }

    public String getVendorURL() {
        return this.vendorURL;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        String vendorName = (String)cb.getSelectedItem();
        if (this.vendorLinksProperties != null && !this.vendorLinksProperties.isEmpty()) {
            this.vendorURL = (String)this.vendorLinksProperties.get(vendorName);
            if (this.vendorURL != null) {
                return;
            }
        }
        if ("Cisco".equals(vendorName)) {
            this.vendorURL = "http://www.cisco.com/public/sw-center/";
        } else if ("EMC".equals(vendorName)) {
            this.vendorURL = "http://powerlink.emc.com/km/appmanager/km/secureDesktop?internalId=0b014066800d2990";
        } else if ("IBM".equals(vendorName)) {
            this.vendorURL = "http://www.cisco.com/public/sw-center/";
        } else if ("HP".equals(vendorName)) {
            this.vendorURL = "http://www2.itrc.hp.com/service/sum/home.do";
        } else if ("SUN".equals(vendorName)) {
            this.vendorURL = "http://sun.com";
        }
    }
}

