/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.IfVshStatus;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FindDialog;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.ClientCache;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class VshLog
extends JDialog
implements ActionListener {
    static final String[] CMDS = new String[]{"Clear", "Next Page", "Last Page", "Refresh", "Find...", "Export...", "Help", "Close"};
    protected static final int CLEAR = 0;
    static final int NEXT_PAGE = 1;
    static final int LAST_PAGE = 2;
    protected static final int REFRESH = 3;
    static final int FIND = 4;
    static final int EXPORT = 5;
    static final int HELP = 6;
    static final int CLOSE = 7;
    static final String SLEEP_CMD = "sleep";
    protected String[] _cmds;
    protected SnmpKTable _table;
    protected SnmpTableModel _model;
    Array _data;
    JScrollPane _sp;
    protected JPanel _statusPanel;
    protected SnmpPeer _peer;
    protected JFrame _parent;
    VshThread _thread;
    protected JButton[] _btns;
    JLabel _status;
    String _helpTopic;
    boolean _pageMode = true;
    boolean _findMode = true;
    boolean _clearMode = false;
    FindDialog _findDialog;
    String _filename;
    protected SwitchVersion _version;
    boolean _needConfirm = false;
    boolean _isConfigCmd = false;

    public VshLog(JFrame parent, String cmd, SnmpPeer peer) throws IOException {
        this(parent, peer + " - " + cmd.substring(0, cmd.length() - 1).trim(), new String[]{cmd}, peer);
    }

    public VshLog(JFrame parent, String title, String[] cmds, SnmpPeer peer) throws IOException {
        super((Frame)parent, title);
        this._parent = parent;
        this._peer = peer;
        this._cmds = cmds;
        this.init();
        this._btns[3].setVisible(false);
        this._btns[0].setVisible(false);
    }

    public VshLog(JFrame parent, String title, String filename) {
        super((Frame)parent, title);
        this._parent = parent;
        this._filename = filename;
        this._pageMode = false;
        this.init();
        this._btns[3].setVisible(true);
        this._btns[0].setVisible(false);
    }

    protected int getTableWidth() {
        return 600;
    }

    protected void init() {
        this._model = new SnmpTableModel();
        this._data = new Array();
        this._model.setData(this._data);
        this._model.setHeaders(this.getHeaders());
        this._table = new SnmpKTable(this._model);
        this._table.getTableHeader().addMouseListener(new HeaderListener());
        this._table.setSortable(true);
        this._table.addPopupMenu();
        this._table.setAutoResizeMode(0);
        this._table.setCellSelectionEnabled(true);
        this._sp = new JScrollPane(this._table);
        this._status = new JLabel("");
        this._sp.setPreferredSize(new Dimension(this.getTableWidth(), 250));
        this._btns = DialogUtil.buildButtons(CMDS, (ActionListener)this);
        this.getRootPane().setDefaultButton(this._btns[1]);
        this._statusPanel = DialogUtil.buildStatusPanel(this._btns, this._status);
        DialogUtil.buildDialog((JDialog)this, (Container)this._parent, (Container)this._sp, this._statusPanel);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
    }

    public void setHelpTopic(String helpTopic) {
        this._helpTopic = helpTopic;
    }

    public void setPageMode(boolean pageMode) {
        this._pageMode = pageMode;
    }

    public void setFindMode(boolean findMode) {
        this._findMode = findMode;
    }

    public void setClearMode(boolean clearMode) {
        this._clearMode = clearMode;
    }

    public void setVersion(SwitchVersion version) {
        this._version = version;
    }

    public void setCmds(String[] cmds) {
        this._cmds = cmds;
    }

    public void setConfirm(boolean needConfirm) {
        this._needConfirm = needConfirm;
    }

    public void setIsConfigCmd(boolean isConfigCmd) {
        if (isConfigCmd) {
            this.setClearMode(false);
        }
        this._isConfigCmd = isConfigCmd;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            if (this._helpTopic == null) {
                this._btns[6].setVisible(false);
            }
            if (!this._findMode) {
                this._btns[4].setVisible(false);
            }
            if (!this._pageMode) {
                this._btns[1].setVisible(false);
                this._btns[2].setVisible(false);
            }
        }
        this._btns[0].setVisible(this._clearMode);
        this._btns[3].setVisible(this._clearMode);
        if (b) {
            this.fetch();
            super.setVisible(b);
        }
    }

    @Override
    public void dispose() {
        if (this._thread != null && !this._thread.isDone()) {
            this._thread.cancel();
        }
        super.dispose();
    }

    protected void enableButtons(boolean b) {
        this._btns[1].setEnabled(b);
        this._btns[2].setEnabled(b);
        this._btns[3].setEnabled(b || this._clearMode);
    }

    protected boolean isFileMode() {
        return this._filename != null;
    }

    protected void fetch() {
        if (this.isFileMode()) {
            this._data.clear();
            try {
                String line;
                FileReader reader = new FileReader(this._filename);
                BufferedReader breader = new BufferedReader(reader);
                while ((line = breader.readLine()) != null) {
                    String[] tokens;
                    int prefix = line.indexOf(">:");
                    if (prefix != -1) {
                        line = line.substring(prefix + 3);
                    }
                    if ((tokens = this.tokenize(line)) == null) continue;
                    this._data.addElement((Object)tokens);
                }
                reader.close();
                this._status.setText("Last updated " + DateFormat.getInstance().format(new Date()));
                this.tableChanged(true);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this._parent, ex);
            }
        } else {
            this.enableButtons(false);
            try {
                this._thread = new VshThread(this);
                this._thread.start();
            }
            catch (IOException ex) {
                Util.errorMessage((Component)this, ex);
            }
        }
    }

    protected String[] getHeaders() {
        String[] COLS = new String[]{"CLI Output"};
        return COLS;
    }

    protected String[] tokenize(String line) {
        return new String[]{line};
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = ((JButton)e.getSource()).getText();
        switch (cmd.charAt(0)) {
            case 'N': {
                this.enableButtons(false);
                this._thread.more();
                break;
            }
            case 'L': {
                this.enableButtons(false);
                this._thread.end();
                break;
            }
            case 'R': {
                if (this._thread != null && !this._thread.isDone()) {
                    this._thread.abort();
                }
                this.clear();
                if (this._model != null) {
                    this.tableChanged(true);
                }
                this.fetch();
                break;
            }
            case 'E': {
                String fName = Util.getFileName(Util.getFrameAncestor(this), "*.txt", 1);
                if (fName == null) break;
                this._table.export(fName);
                break;
            }
            case 'C': {
                this.dispose();
                break;
            }
            case 'H': {
                try {
                    if (this._helpTopic == null || this._helpTopic.equals("")) {
                        Util.errorMessage((Component)this, "Help on topic " + this._helpTopic + " can't be found");
                        return;
                    }
                    String htmlFile = this._helpTopic + ".html";
                    ExternalTools.openURL("\"" + ClientCache.getInstallLocation() + "\\help\\fmhelp\\" + htmlFile + "\"");
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this._parent, ex.getMessage());
                }
                break;
            }
            case 'F': {
                if (this._findDialog == null) {
                    this._findDialog = new FindDialog(this, null, (KTable)this._table);
                    int dash = this.getTitle().indexOf("-");
                    this._findDialog.setTitle(this.getTitle().substring(dash + 1) + " Find");
                }
                this._findDialog.setVisible(true);
            }
        }
    }

    protected void clear() {
        this._data.clear();
    }

    protected void tableChanged(boolean recalc) {
        this._model.fireTableDataChanged();
        if (recalc) {
            Dimension dm = this._table.calcPreferredSize();
            dm = new Dimension(this.getTableWidth(), this._table.getRowHeight() * 18);
            this._sp.setPreferredSize(dm);
            this.pack();
        }
    }

    void addElement(String[] line) {
        this._data.addElement((Object)line);
    }

    class VshPrintWriter
    extends PrintWriter {
        int _line;
        String _prompt;
        boolean _abort;
        boolean _done;
        int _buffPos;
        int _viewPos;
        String[][] _buff;
        Object _lock;
        boolean _wait;
        boolean _end;
        String _cmd;

        VshPrintWriter(OutputStream os, String prompt) {
            super(os);
            this._buff = new String[60][];
            this._lock = new Object();
            this._prompt = prompt;
        }

        void setCmd(String cmd) {
            this._cmd = cmd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void abort() {
            this._abort = true;
            Object object = this._lock;
            synchronized (object) {
                this._lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void more() {
            int len = 15;
            if (this._viewPos + 15 > this._buffPos) {
                len = this._buffPos - this._viewPos;
            }
            for (int i = this._viewPos; i < this._viewPos + len; ++i) {
                VshLog.this.addElement(this._buff[i]);
            }
            this._viewPos += len;
            VshLog.this.tableChanged(false);
            if (this._viewPos == 60) {
                if (!this._done) {
                    this._wait = false;
                    Object object = this._lock;
                    synchronized (object) {
                        this._lock.notify();
                    }
                }
                this._viewPos = 0;
            }
            VshLog.this._table.see(VshLog.this._data.size() - 1, 0);
            VshLog.this._status.setText(VshLog.this._data.size() + " row(s)");
            VshLog.this.enableButtons(true);
            VshLog.this._btns[1].setEnabled(!this._done || this._viewPos != this._buffPos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void end() {
            this._end = true;
            Object object = this._lock;
            synchronized (object) {
                this._lock.notify();
            }
            if (this._done) {
                this.scrollToEnd();
            }
            VshLog.this.tableChanged(true);
        }

        void scrollToEnd() {
            while (this._viewPos < this._buffPos) {
                VshLog.this.addElement(this._buff[this._viewPos++]);
            }
            VshLog.this.tableChanged(false);
            if (this._buffPos == 60) {
                this._buffPos = 0;
            }
            if (this._viewPos == 60) {
                this._viewPos = 0;
            }
            if (this._done) {
                VshLog.this._table.invalidate();
                VshLog.this._table.see(VshLog.this._data.size() - 1, 0);
                VshLog.this._status.setText(VshLog.this._data.size() + " row(s)");
                VshLog.this.pack();
                VshLog.this.enableButtons(true);
                VshLog.this._btns[1].setEnabled(false);
                VshLog.this._btns[2].setEnabled(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(String line) {
            Object toks;
            if (this._abort) {
                return;
            }
            if (line.length() == 0) {
                return;
            }
            if (this._buffPos == 60) {
                this._buffPos = 0;
            }
            if (this._line > 0 && !line.equals(this._prompt) && !line.startsWith(this._cmd.substring(0, this._cmd.length() - 1))) {
                toks = VshLog.this.tokenize(line);
                if (toks == null) {
                    return;
                }
                if (!VshLog.this._pageMode) {
                    VshLog.this.addElement((String[])toks);
                } else {
                    this._buff[this._buffPos++] = toks;
                }
            }
            ++this._line;
            if (!VshLog.this._pageMode) {
                VshLog.this.enableButtons(true);
                return;
            }
            this._done = line.equals(this._prompt);
            if (this._line == 16 || this._line < 16 && this._done) {
                this.more();
                VshLog.this._status.setText(VshLog.this._data.size() + " row(s)");
                VshLog.this.tableChanged(true);
            }
            if (!this._done && this._buffPos == 60 && !this._end) {
                this._wait = true;
                while (this._wait && !this._abort && !this._end) {
                    try {
                        toks = this._lock;
                        synchronized (toks) {
                            this._lock.wait(10000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
            VshLog.this._btns[1].setEnabled(!this._done || this._viewPos != this._buffPos);
            VshLog.this._btns[2].setEnabled(!this._done || this._viewPos != this._buffPos);
            if (this._end) {
                this.scrollToEnd();
            }
        }
    }

    class VshWriter
    extends OutputStream {
        VshWriter() {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b, int offset, int length) {
        }
    }

    class VshThread
    extends Thread
    implements IfVshStatus {
        JDialog _dlg;
        boolean _abort;
        boolean _done;
        Vsh _vsh;
        VshPrintWriter _writer;

        VshThread(JDialog dlg) throws IOException {
            this._dlg = dlg;
        }

        void cancel() {
            this._abort = true;
            if (this._writer != null) {
                this._writer.abort();
            }
            if (this._vsh != null) {
                Vsh.close();
            }
            this._vsh = null;
        }

        void abort() {
            this._abort = true;
            if (this._writer != null) {
                this._writer.abort();
            }
            if (this._vsh != null) {
                this._vsh.disconnect();
            }
        }

        void more() {
            if (this._writer != null) {
                this._writer.more();
            }
        }

        void end() {
            if (this._writer != null) {
                this._writer.end();
            }
        }

        boolean isDone() {
            return this._done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this._vsh = Vsh.get(VshLog.this._parent, VshLog.this._peer, ExternalTools.isUseSSH(), (IfVshStatus)this);
                if (this._vsh != null) {
                    this._writer = new VshPrintWriter(new VshWriter(), this._vsh.getPrompt());
                    if (VshLog.this._isConfigCmd) {
                        if (!this._abort) {
                            this._vsh.send("conf t\n");
                            this._writer.setCmd("conf t\n");
                            this._vsh.learn();
                            this._vsh.readPrompt(this._writer);
                        } else {
                            VshLog.this._status.setText("Aborted");
                            return;
                        }
                    }
                    for (int i = 0; i < VshLog.this._cmds.length; ++i) {
                        if (VshLog.this._cmds[i].startsWith(VshLog.SLEEP_CMD)) {
                            try {
                                Thread.sleep(Integer.parseInt(VshLog.this._cmds[i].substring(VshLog.this._cmds[i].indexOf(" "))));
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (this._vsh == null) continue;
                        this._vsh.send(VshLog.this._cmds[i]);
                        this._writer.setCmd(VshLog.this._cmds[i]);
                        if (VshLog.this._needConfirm) {
                            this._vsh.send("y\n");
                        }
                        this._vsh.readPrompt(this._writer);
                    }
                }
            }
            catch (Exception ex) {
                if (!this._abort) {
                    Util.errorMessage((Component)this._dlg, ex);
                    ex.printStackTrace(System.err);
                }
            }
            finally {
                if (this._vsh != null) {
                    Vsh.put(this._vsh);
                }
            }
            this._done = true;
        }

        @Override
        public void setStatus(String status) {
            VshLog.this._status.setText(status);
        }
    }
}

